/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.TypeSymbol;

abstract class ElementValue {
    static final byte EV_NONE = 0;
    static final byte EV_DEFAULTVALUE = 1;
    static final byte EV_ARRAYELEMENT = 2;
    Identifier elementName;
    TypeSymbol typeSymbol;
    int pos;
    short nameIndex;
    byte tag;
    byte flags;

    ElementValue(Identifier elementName, int pos, boolean defaultValue, boolean arrayElement) {
        this.elementName = elementName;
        this.pos = pos;
        if (defaultValue) {
            this.flags = (byte)(this.flags | 1);
        }
        if (arrayElement) {
            this.flags = (byte)(this.flags | 2);
        }
    }

    ElementValue resolveAndCheck(Parser parser, Annotation annotation) {
        if (annotation.annotationType.isErroneous()) {
            this.typeSymbol = TypeSymbol.errorSymbol;
        } else {
            RawClassSymbol annotationType = ((ClassSymbol)annotation.annotationType).getClassSymbol();
            MethodSymbol methodSymbol = (MethodSymbol)annotationType.classScope.lookupSpecificSymbolInScope(this.elementName, 8, true);
            if (methodSymbol == null) {
                this.typeSymbol = TypeSymbol.errorSymbol;
                parser.error(Message.errorNotFound, this.pos, annotationType.isErroneous(), Message.memberString + " " + this.elementName.toString(), annotationType.errorName());
                annotationType.flags = (short)(annotationType.flags | 0x10);
            } else {
                this.typeSymbol = methodSymbol.resultType.resolveType(parser, this.pos, false, true, false);
                if ((this.flags & 2) != 0) {
                    this.typeSymbol = ((ArraySymbol)this.typeSymbol).baseType;
                }
            }
        }
        return this;
    }

    int getAttributeLength() {
        return (this.flags & 3) != 0 ? 1 : 3;
    }

    void write(ClassFileWriter cfw) throws IOException {
        if ((this.flags & 3) != 0) {
            int wbIdx = cfw.ensureWriteBufferCapacity(1);
            byte[] wb = cfw.writeBuffer;
            wb[wbIdx] = this.tag;
            cfw.writeBufferIndex = wbIdx + 1;
        } else {
            int wbIdx = cfw.ensureWriteBufferCapacity(3);
            byte[] wb = cfw.writeBuffer;
            wb[wbIdx + 2] = this.tag;
            wb[wbIdx + 1] = (byte)this.nameIndex;
            wb[wbIdx] = (byte)(this.nameIndex >> 8);
            cfw.writeBufferIndex = wbIdx + 3;
        }
    }

    void generateConstantPoolEntries(ClassFileWriter cfw, ConstantPool cp) {
        if ((this.flags & 3) == 0) {
            this.nameIndex = cp.enterConstantPoolUtf8(this.elementName.name);
        }
    }
}

