/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.ArrayExpression;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.AutoBoxingExpression;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LoopStatement;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SwitchLoopList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;

final class EnhancedForStatement
extends LoopStatement {
    MethodVariableSymbol localVar;
    Expression expr;
    TypeSymbol elementType;
    private short arrayVar;
    private boolean prologueGenerated;
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    EnhancedForStatement(StatementList parent, int pos, int bodyPos, MethodVariableSymbol localVar, Expression expr, StatementList bodyStatements) {
        super(parent, pos, bodyPos, (byte)11, bodyStatements);
        this.localVar = localVar;
        this.expr = expr;
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = EnhancedForStatement.class$("oracle.ojc.compiler.EnhancedForStatement");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    void resolveAndCheck(Parser parser) {
        SwitchLoopList outerSwitchLoop = parser.innerSwitchLoop;
        this.loopRec = new SwitchLoopList(outerSwitchLoop, null, this, parser.defSet, parser.posSet, parser.useSet);
        try {
            parser.innerSwitchLoop = this.loopRec;
            this.expr = this.expr.resolveAndCheck(parser);
            TypeSymbol exprType = this.expr.getType();
            if ((exprType.typeClass & 0xFFFFFFC0) == 0) {
                parser.error(Message.errorTypeNotAllowed, this.expr.pos, false, exprType.errorName());
            } else if (!exprType.isErroneous()) {
                TypeSymbol localVarType = this.localVar.type;
                if (exprType.isClass()) {
                    ClassSymbol exprClass = (ClassSymbol)exprType;
                    if (!exprClass.equalTo(parser.javaLangIterableSymbol) && !exprClass.implementsInterface(parser.javaLangIterableSymbol)) {
                        parser.error(Message.errorTypeNotAllowed, this.expr.pos, false, exprType.errorName());
                        exprType = localVarType = TypeSymbol.intSymbol;
                    } else {
                        if (!exprClass.equalTo(parser.javaLangIterableSymbol)) {
                            exprClass = exprClass.getInterface(parser.javaLangIterableSymbol);
                        }
                        if (!$a && exprClass == null) {
                            throw new AssertionError();
                        }
                        if (!exprClass.isParameterizedClass()) {
                            exprType = parser.javaLangObjectPcs;
                        } else {
                            ParameterizedClassSymbol pcs = (ParameterizedClassSymbol)exprClass;
                            if (pcs.typeVariableList == null || pcs.typeVariableList.typeVariable == null) {
                                exprType = parser.javaLangObjectPcs;
                            } else {
                                exprType = pcs.typeVariableList.typeVariable.refSymbol;
                                if (exprType == null) {
                                    exprType = parser.javaLangObjectPcs;
                                }
                            }
                        }
                    }
                } else {
                    if (!$a && !exprType.isArrayType()) {
                        throw new AssertionError();
                    }
                    ArraySymbol arraySymbol = (ArraySymbol)exprType;
                    exprType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                }
                this.elementType = exprType;
                if (this.elementType.isTypeParameter()) {
                    this.elementType = ((TypeParameterSymbol)exprType).bound;
                }
                if (localVarType.isPrimitiveType() && !localVarType.isErroneous()) {
                    TypeSymbol primitiveType;
                    if (exprType.isReferenceType() && (primitiveType = BoxingExpression.getPrimitiveType(parser, exprType)) != null) {
                        exprType = primitiveType;
                    }
                    if (!(localVarType == exprType || TypeSymbol.isWider(localVarType.typeKind, exprType.typeKind) && localVarType != TypeSymbol.charSymbol && localVarType.isNumericType())) {
                        parser.error(Message.errorIncompatibleTypes, this.expr.pos, false, exprType.errorName(), localVarType.errorName());
                    }
                } else if (localVarType.isReferenceType()) {
                    if (BoxingExpression.isBoxableType(exprType)) {
                        exprType = BoxingExpression.getBoxedType(parser, exprType);
                    }
                    if (!exprType.isReferenceType()) {
                        parser.error(Message.errorIncompatibleTypes, this.expr.pos, false, exprType.errorName(), localVarType.errorName());
                    } else {
                        ReferenceTypeSymbol exprRef = (ReferenceTypeSymbol)exprType;
                        ReferenceTypeSymbol localVarRef = (ReferenceTypeSymbol)localVarType;
                        if (!exprRef.isAssignmentCompatible(parser, localVarRef)) {
                            parser.error(Message.errorIncompatibleTypes, this.expr.pos, false, exprType.errorName(), localVarType.errorName());
                        } else {
                            localVarType.checkForUncheckedConversion(parser, this.pos, exprType, false);
                        }
                    }
                }
            }
            BitSet defSet = (BitSet)parser.defSet.clone();
            parser.defSet.set(parser.currentClassSymbol.cd.fieldCount + this.localVar.varStackIndex);
            this.localVar.flags = (byte)(this.localVar.flags | 2);
            if (this.bodyStatements != null) {
                this.bodyStatements.resolveAndCheck(parser);
            }
            this.loopRec.insertLabels();
            parser.defSet = defSet;
            if (this.resultPosSet != null) {
                parser.posSet.or(this.resultPosSet);
            }
            if (this.resultUseSet != null) {
                parser.useSet.or(this.resultUseSet);
            }
            this.checkPosibleReinitializations(parser);
            Object var13_12 = null;
            parser.innerSwitchLoop = outerSwitchLoop;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            parser.innerSwitchLoop = outerSwitchLoop;
            throw throwable;
        }
        ++parser.estimatedLineCount;
    }

    void generateByteCodePrologue(ByteCodeGenerator byteCodeGenerator) {
        this.prologueGenerated = true;
        TypeSymbol exprType = this.expr.getType();
        if (exprType.typeKind == 11) {
            short s = byteCodeGenerator.methodSymbol.localVarCount;
            byteCodeGenerator.methodSymbol.localVarCount = (short)(s + 1);
            this.arrayVar = s;
            byteCodeGenerator.methodSymbol.cmd.localVariables.add(null);
            this.expr.generateByteCode(byteCodeGenerator);
            byteCodeGenerator.storeLocalVariable(exprType, this.arrayVar);
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        if (!this.prologueGenerated) {
            this.generateByteCodePrologue(byteCodeGenerator);
        }
        this.prologueGenerated = false;
        TypeSymbol localVarType = this.localVar.type;
        TypeSymbol exprType = this.expr.getType();
        short s = byteCodeGenerator.methodSymbol.localVarCount;
        byteCodeGenerator.methodSymbol.localVarCount = (short)(s + 1);
        short indexVar = s;
        byteCodeGenerator.methodSymbol.cmd.localVariables.add(null);
        if (exprType.typeKind == 11) {
            byteCodeGenerator.generate_8((byte)3);
            byteCodeGenerator.incOpStackHeight(1);
            byteCodeGenerator.storeLocalVariable(TypeSymbol.intSymbol, indexVar);
            Label testLabel = new Label();
            Label bodyLabel = new Label();
            byteCodeGenerator.generateBranch_goto(testLabel);
            byteCodeGenerator.setLabel(bodyLabel);
            SwitchLoopList outerSwitchLoop = byteCodeGenerator.parser.innerSwitchLoop;
            byteCodeGenerator.parser.innerSwitchLoop = this.loopRec;
            if (this.loopRec.continueSymbol != null) {
                this.loopRec.continueSymbol.label = new Label();
            }
            if (this.loopRec.breakSymbol != null) {
                this.loopRec.breakSymbol.label = new Label();
            }
            byteCodeGenerator.loadLocalVariable(exprType, this.arrayVar);
            byteCodeGenerator.loadLocalVariable(TypeSymbol.intSymbol, indexVar);
            byteCodeGenerator.generate_8(ArrayExpression.aload_opcode[this.elementType.typeKind]);
            if (localVarType.isPrimitiveType() && this.elementType.isReferenceType()) {
                AutoUnboxingExpression.generateByteCode(byteCodeGenerator, this.elementType, localVarType);
            } else if (localVarType.isReferenceType() && BoxingExpression.isBoxableType(this.elementType)) {
                AutoBoxingExpression.generateByteCode(byteCodeGenerator, this.elementType, localVarType);
            }
            if ((this.elementType.typeClass & 0x28) == 0) {
                byteCodeGenerator.decOpStackHeight(1);
            }
            if (localVarType.typeClass != this.elementType.typeClass) {
                byteCodeGenerator.generateWideningPrimitiveConversion(this.elementType.typeClass, localVarType.typeClass);
            }
            byteCodeGenerator.storeLocalVariable(localVarType, this.localVar.varStackIndex);
            int pc = byteCodeGenerator.generateGetPC() & 0xFFFF;
            if (pc < (this.localVar.startPC & 0xFFFF)) {
                this.localVar.startPC = (short)pc;
            }
            if (this.bodyStatements != null) {
                this.bodyStatements.generateByteCode(byteCodeGenerator);
            }
            byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.pos));
            if (indexVar <= 255) {
                byteCodeGenerator.generate_8_8_8((byte)-124, (byte)indexVar, (byte)1);
            } else {
                byteCodeGenerator.generate_8_8((byte)-60, (byte)-124);
                byteCodeGenerator.generate_16_16(indexVar, (short)1);
            }
            byteCodeGenerator.parser.innerSwitchLoop = outerSwitchLoop;
            byteCodeGenerator.setLabel(testLabel);
            byteCodeGenerator.loadLocalVariable(TypeSymbol.intSymbol, indexVar);
            byteCodeGenerator.loadLocalVariable(exprType, this.arrayVar);
            byteCodeGenerator.generate_8((byte)-66);
            byteCodeGenerator.generateBranch_if_icmplt(bodyLabel);
            byteCodeGenerator.decOpStackHeight(2);
        } else {
            short index;
            this.expr.generateByteCode(byteCodeGenerator);
            ClassSymbol exprClass = (ClassSymbol)exprType;
            if (exprClass.isInterface()) {
                index = byteCodeGenerator.constantPool.enterConstantPoolInterfaceMethodRef(exprClass.getInternalName(), Identifier.iteratorIdentifier.name, Identifier.javaUtilIteratorMethodSignature.name);
                byteCodeGenerator.generate_8_16((byte)-71, index);
                byteCodeGenerator.generate_8_8((byte)1, (byte)0);
            } else {
                index = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(exprClass.getInternalName(), Identifier.iteratorIdentifier.name, Identifier.javaUtilIteratorMethodSignature.name);
                byteCodeGenerator.generate_8_16((byte)-74, index);
            }
            byteCodeGenerator.storeLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, indexVar);
            Label testLabel = new Label();
            Label bodyLabel = new Label();
            byteCodeGenerator.generateBranch_goto(testLabel);
            byteCodeGenerator.setLabel(bodyLabel);
            SwitchLoopList outerSwitchLoop = byteCodeGenerator.parser.innerSwitchLoop;
            byteCodeGenerator.parser.innerSwitchLoop = this.loopRec;
            if (this.loopRec.continueSymbol != null) {
                this.loopRec.continueSymbol.label = new Label();
            }
            if (this.loopRec.breakSymbol != null) {
                this.loopRec.breakSymbol.label = new Label();
            }
            byteCodeGenerator.loadLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, indexVar);
            index = byteCodeGenerator.constantPool.enterConstantPoolInterfaceMethodRef(Identifier.javaUtilIteratorInternal.name, Identifier.nextIdentifier.name, Identifier.javaLangObjectMethodSignature.name);
            byteCodeGenerator.generate_8_16((byte)-71, index);
            byteCodeGenerator.generate_8_8((byte)1, (byte)0);
            index = byteCodeGenerator.constantPool.enterConstantPoolClass(this.elementType.getInternalName());
            byteCodeGenerator.generate_8_16((byte)-64, index);
            if (localVarType.isPrimitiveType()) {
                AutoUnboxingExpression.generateByteCode(byteCodeGenerator, this.elementType, localVarType);
            }
            byteCodeGenerator.storeLocalVariable(localVarType, this.localVar.varStackIndex);
            int pc = byteCodeGenerator.generateGetPC() & 0xFFFF;
            if (pc < (this.localVar.startPC & 0xFFFF)) {
                this.localVar.startPC = (short)pc;
            }
            if (this.bodyStatements != null) {
                this.bodyStatements.generateByteCode(byteCodeGenerator);
            }
            byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.pos));
            byteCodeGenerator.parser.innerSwitchLoop = outerSwitchLoop;
            byteCodeGenerator.setLabel(testLabel);
            byteCodeGenerator.loadLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, indexVar);
            index = byteCodeGenerator.constantPool.enterConstantPoolInterfaceMethodRef(Identifier.javaUtilIteratorInternal.name, Identifier.hasNextIdentifier.name, Identifier.booleanMethodSignature.name);
            byteCodeGenerator.generate_8_16((byte)-71, index);
            byteCodeGenerator.generate_8_8((byte)1, (byte)0);
            byteCodeGenerator.generateBranch_ifne(bodyLabel);
            byteCodeGenerator.decOpStackHeight(1);
        }
    }

    boolean canReachNextStatement(boolean strict) {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

