/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.DoubleConstantExpression;
import oracle.ojc.compiler.EqualityExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FloatConstantExpression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.ReferenceTypeSymbol;

final class EqualExpression
extends EqualityExpression {
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    EqualExpression(int pos, Expression leftOperand, Expression rightOperand) {
        super((byte)22, pos, leftOperand, rightOperand);
    }

    strictfp Expression foldExpression() {
        Expression leftOp = this.leftOperand;
        Expression rightOp = this.rightOperand;
        if (leftOp.kind == 2 && rightOp.kind == 2) {
            switch (leftOp.getType().typeClass) {
                case 2: {
                    return new BooleanConstantExpression(this.pos, ((BooleanConstantExpression)leftOp).bval == ((BooleanConstantExpression)rightOp).bval);
                }
                case 4: {
                    return new BooleanConstantExpression(this.pos, ((ConstantExpression)leftOp).getIntConstValue() == ((ConstantExpression)rightOp).getIntConstValue());
                }
                case 8: {
                    return new BooleanConstantExpression(this.pos, ((LongConstantExpression)leftOp).lval == ((LongConstantExpression)rightOp).lval);
                }
                case 16: {
                    return new BooleanConstantExpression(this.pos, ((FloatConstantExpression)leftOp).fval == ((FloatConstantExpression)rightOp).fval);
                }
                case 32: {
                    return new BooleanConstantExpression(this.pos, ((DoubleConstantExpression)leftOp).dval == ((DoubleConstantExpression)rightOp).dval);
                }
            }
        }
        return this;
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = EqualExpression.class$("oracle.ojc.compiler.EqualExpression");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        byte opcode;
        Expression leftOp = this.leftOperand;
        Expression rightOp = this.rightOperand;
        byte typeClass = leftOp.getType().typeClass;
        if ((typeClass & 0xFFFFFFC0) != 0) {
            if (leftOp.getType() == ReferenceTypeSymbol.nullTypeSymbol) {
                this.rightOperand.generateByteCode(byteCodeGenerator);
                byteCodeGenerator.generate_8_16((byte)-57, (short)7);
                byteCodeGenerator.generate_8((byte)4);
                byteCodeGenerator.generate_8_16((byte)-89, (short)4);
                byteCodeGenerator.generate_8((byte)3);
                return;
            }
            if (rightOp.getType() == ReferenceTypeSymbol.nullTypeSymbol) {
                this.leftOperand.generateByteCode(byteCodeGenerator);
                byteCodeGenerator.generate_8_16((byte)-57, (short)7);
                byteCodeGenerator.generate_8((byte)4);
                byteCodeGenerator.generate_8_16((byte)-89, (short)4);
                byteCodeGenerator.generate_8((byte)3);
                return;
            }
        } else if ((typeClass & 4) != 0) {
            if (leftOp.kind == 2 && ((ConstantExpression)leftOp).getIntConstValue() == 0) {
                this.rightOperand.generateByteCode(byteCodeGenerator);
                byteCodeGenerator.generate_8_16((byte)-102, (short)7);
                byteCodeGenerator.generate_8((byte)4);
                byteCodeGenerator.generate_8_16((byte)-89, (short)4);
                byteCodeGenerator.generate_8((byte)3);
                return;
            }
            if (rightOp.kind == 2 && ((ConstantExpression)rightOp).getIntConstValue() == 0) {
                this.leftOperand.generateByteCode(byteCodeGenerator);
                byteCodeGenerator.generate_8_16((byte)-102, (short)7);
                byteCodeGenerator.generate_8((byte)4);
                byteCodeGenerator.generate_8_16((byte)-89, (short)4);
                byteCodeGenerator.generate_8((byte)3);
                return;
            }
        }
        leftOp.generateByteCode(byteCodeGenerator);
        rightOp.generateByteCode(byteCodeGenerator);
        switch (typeClass) {
            default: {
                if (!$a) {
                    throw new AssertionError();
                }
            }
            case -128: 
            case 64: {
                opcode = -90;
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 2: 
            case 4: {
                opcode = -96;
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 16: {
                byteCodeGenerator.generate_8((byte)-107);
                opcode = -102;
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 8: {
                byteCodeGenerator.generate_8((byte)-108);
                opcode = -102;
                byteCodeGenerator.decOpStackHeight(3);
                break;
            }
            case 32: {
                byteCodeGenerator.generate_8((byte)-105);
                opcode = -102;
                byteCodeGenerator.decOpStackHeight(3);
                break;
            }
        }
        byteCodeGenerator.generate_8_16(opcode, (short)7);
        byteCodeGenerator.generate_8((byte)4);
        byteCodeGenerator.generate_8_16((byte)-89, (short)4);
        byteCodeGenerator.generate_8((byte)3);
    }

    void generateByteCodeBranch(ByteCodeGenerator byteCodeGenerator, Label label, boolean branchIfFalse) {
        Expression leftOp = this.leftOperand;
        Expression rightOp = this.rightOperand;
        byte typeClass = leftOp.getType().typeClass;
        if ((typeClass & 0xFFFFFFC0) != 0) {
            if (leftOp.getType() == ReferenceTypeSymbol.nullTypeSymbol) {
                this.rightOperand.generateByteCode(byteCodeGenerator);
                if (branchIfFalse) {
                    byteCodeGenerator.generateBranch_ifnonnull(label);
                } else {
                    byteCodeGenerator.generateBranch_ifnull(label);
                }
                byteCodeGenerator.decOpStackHeight(1);
                return;
            }
            if (rightOp.getType() == ReferenceTypeSymbol.nullTypeSymbol) {
                this.leftOperand.generateByteCode(byteCodeGenerator);
                if (branchIfFalse) {
                    byteCodeGenerator.generateBranch_ifnonnull(label);
                } else {
                    byteCodeGenerator.generateBranch_ifnull(label);
                }
                byteCodeGenerator.decOpStackHeight(1);
                return;
            }
        } else if ((typeClass & 4) != 0) {
            if (leftOp.kind == 2 && ((ConstantExpression)leftOp).getIntConstValue() == 0) {
                this.rightOperand.generateByteCode(byteCodeGenerator);
                if (branchIfFalse) {
                    byteCodeGenerator.generateBranch_ifne(label);
                } else {
                    byteCodeGenerator.generateBranch_ifeq(label);
                }
                byteCodeGenerator.decOpStackHeight(1);
                return;
            }
            if (rightOp.kind == 2 && ((ConstantExpression)rightOp).getIntConstValue() == 0) {
                this.leftOperand.generateByteCode(byteCodeGenerator);
                if (branchIfFalse) {
                    byteCodeGenerator.generateBranch_ifne(label);
                } else {
                    byteCodeGenerator.generateBranch_ifeq(label);
                }
                byteCodeGenerator.decOpStackHeight(1);
                return;
            }
        }
        leftOp.generateByteCode(byteCodeGenerator);
        rightOp.generateByteCode(byteCodeGenerator);
        switch (typeClass) {
            default: {
                if (!$a) {
                    throw new AssertionError();
                }
            }
            case -128: 
            case 64: {
                if (branchIfFalse) {
                    byteCodeGenerator.generateBranch_if_acmpne(label);
                } else {
                    byteCodeGenerator.generateBranch_if_acmpeq(label);
                }
                byteCodeGenerator.decOpStackHeight(2);
                break;
            }
            case 2: 
            case 4: {
                if (branchIfFalse) {
                    byteCodeGenerator.generateBranch_if_icmpne(label);
                } else {
                    byteCodeGenerator.generateBranch_if_icmpeq(label);
                }
                byteCodeGenerator.decOpStackHeight(2);
                break;
            }
            case 16: {
                byteCodeGenerator.generate_8((byte)-107);
                if (branchIfFalse) {
                    byteCodeGenerator.generateBranch_ifne(label);
                } else {
                    byteCodeGenerator.generateBranch_ifeq(label);
                }
                byteCodeGenerator.decOpStackHeight(2);
                break;
            }
            case 8: {
                byteCodeGenerator.generate_8((byte)-108);
                if (branchIfFalse) {
                    byteCodeGenerator.generateBranch_ifne(label);
                } else {
                    byteCodeGenerator.generateBranch_ifeq(label);
                }
                byteCodeGenerator.decOpStackHeight(4);
                break;
            }
            case 32: {
                byteCodeGenerator.generate_8((byte)-105);
                if (branchIfFalse) {
                    byteCodeGenerator.generateBranch_ifne(label);
                } else {
                    byteCodeGenerator.generateBranch_ifeq(label);
                }
                byteCodeGenerator.decOpStackHeight(4);
                break;
            }
        }
    }

    public String toString() {
        return "==";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

