/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BinaryExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.TypeSymbol;

abstract class EqualityExpression
extends BinaryExpression {
    EqualityExpression(byte kind, int pos, Expression leftOperand, Expression rightOperand) {
        super(kind, pos, leftOperand, rightOperand);
    }

    /*
     * Enabled aggressive block sorting
     */
    Expression resolveAndCheck(Parser parser) {
        block18: {
            Expression leftOp = this.leftOperand.resolveAndCheck(parser);
            Expression rightOp = this.rightOperand.resolveAndCheck(parser);
            TypeSymbol leftOpType = leftOp.getType();
            TypeSymbol rightOpType = rightOp.getType();
            if (leftOpType.isErroneous() || rightOpType.isErroneous()) {
                return ErrorExpression.errorExpression;
            }
            if (leftOpType.isReferenceType()) {
                if (!rightOpType.isReferenceType()) {
                    TypeSymbol primitiveType;
                    if (parser.options.sourceJDKVersion >= 150 && rightOpType.isPrimitiveType() && (primitiveType = BoxingExpression.getPrimitiveType(parser, leftOpType)) != null) {
                        TypeSymbol commonType;
                        if (primitiveType.typeKind == rightOpType.typeKind) {
                            commonType = rightOpType;
                        } else {
                            commonType = TypeSymbol.binaryNumericPromotion(parser, primitiveType, rightOpType);
                            if (commonType.isErroneous()) {
                                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, false, this.toString(), leftOpType.errorName() + " " + Message.andString + " " + rightOpType.errorName());
                                return new ErrorExpression(error);
                            }
                        }
                        this.leftOperand = leftOp.promoteType(parser, commonType);
                        this.rightOperand = rightOp.promoteType(parser, commonType);
                        break block18;
                    } else {
                        Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, false, this.toString(), leftOpType.errorName() + " " + Message.andString + " " + rightOpType.errorName());
                        return new ErrorExpression(error);
                    }
                }
                ReferenceTypeSymbol rRefSymbol = (ReferenceTypeSymbol)rightOpType;
                ReferenceTypeSymbol lRefSymbol = (ReferenceTypeSymbol)leftOpType;
                if (rRefSymbol.isCastCompatible(parser, lRefSymbol)) {
                    this.leftOperand = leftOp;
                    this.rightOperand = rightOp.promoteType(parser, leftOpType);
                } else {
                    if (!lRefSymbol.isCastCompatible(parser, rRefSymbol)) {
                        Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, rightOpType.errorName(), leftOpType.errorName());
                        return new ErrorExpression(error);
                    }
                    this.rightOperand = rightOp;
                    this.leftOperand = leftOp.promoteType(parser, rightOpType);
                }
            } else if ((leftOpType.typeClass & 2) != 0) {
                if ((rightOpType.typeClass & 2) == 0) {
                    if (parser.options.sourceJDKVersion >= 150 && rightOpType.equalTo(parser.javaLangBooleanSymbol)) {
                        rightOp = rightOp.promoteType(parser, leftOpType);
                    } else {
                        Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, false, this.toString(), leftOpType.errorName() + " " + Message.andString + " " + rightOpType.errorName());
                        return new ErrorExpression(error);
                    }
                }
                this.leftOperand = leftOp;
                this.rightOperand = rightOp;
            } else {
                TypeSymbol commonType = TypeSymbol.binaryNumericPromotion(parser, leftOpType, rightOpType);
                if (commonType.isErroneous()) {
                    Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, false, this.toString(), leftOpType.errorName() + " " + Message.andString + " " + rightOpType.errorName());
                    return new ErrorExpression(error);
                }
                this.leftOperand = leftOp.promoteType(parser, commonType);
                this.rightOperand = rightOp.promoteType(parser, commonType);
            }
        }
        this.setType(TypeSymbol.booleanSymbol);
        return this.foldExpression();
    }
}

