/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.AutoBoxingExpression;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.CastExpression;
import oracle.ojc.compiler.CharConstantExpression;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.FieldExpression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.TypeSymbol;

abstract class Expression {
    static final byte EK_ERROR = 0;
    static final byte EK_IDENTIFIER = 1;
    static final byte EK_CONSTANT = 2;
    static final byte EK_ARRAY = 3;
    static final byte EK_INVOKE = 4;
    static final byte EK_ASSIGNMENT = 5;
    static final byte EK_ASSIGNMENT_PLUS = 6;
    static final byte EK_ASSIGNMENT_MINUS = 7;
    static final byte EK_ASSIGNMENT_MULTIPLY = 8;
    static final byte EK_ASSIGNMENT_DIVIDE = 9;
    static final byte EK_ASSIGNMENT_MODULO = 10;
    static final byte EK_ASSIGNMENT_BIT_OR = 11;
    static final byte EK_ASSIGNMENT_BIT_XOR = 12;
    static final byte EK_ASSIGNMENT_BIT_AND = 13;
    static final byte EK_ASSIGNMENT_SHIFT_LEFT = 14;
    static final byte EK_ASSIGNMENT_SHIFT_RIGHT = 15;
    static final byte EK_ASSIGNMENT_UNSIGNED_SHIFT_RIGHT = 16;
    static final byte EK_LOGICAL_OR = 17;
    static final byte EK_LOGICAL_AND = 18;
    static final byte EK_BIT_OR = 19;
    static final byte EK_BIT_XOR = 20;
    static final byte EK_BIT_AND = 21;
    static final byte EK_EQUAL = 22;
    static final byte EK_NOT_EQUAL = 23;
    static final byte EK_LESS = 24;
    static final byte EK_GREATER = 25;
    static final byte EK_LESS_OR_EQUAL = 26;
    static final byte EK_GREATER_OR_EQUAL = 27;
    static final byte EK_INSTANCEOF = 28;
    static final byte EK_CONDITIONAL = 29;
    static final byte EK_SHIFT_LEFT = 30;
    static final byte EK_SHIFT_RIGHT = 31;
    static final byte EK_UNSIGNED_SHIFT_RIGHT = 32;
    static final byte EK_PLUS = 33;
    static final byte EK_MINUS = 34;
    static final byte EK_MULTIPLY = 35;
    static final byte EK_DIVIDE = 36;
    static final byte EK_MODULO = 37;
    static final byte EK_UNARYPLUS = 38;
    static final byte EK_NEGATE = 39;
    static final byte EK_BIN_COMPLEMENT = 40;
    static final byte EK_POST_INCREMENT = 41;
    static final byte EK_POST_DECREMENT = 42;
    static final byte EK_PRE_INCREMENT = 43;
    static final byte EK_PRE_DECREMENT = 44;
    static final byte EK_LOGICAL_NOT = 45;
    static final byte EK_CAST = 46;
    static final byte EK_NEW = 47;
    static final byte EK_CLASS = 48;
    static final byte EK_ARRAY_LENGTH = 49;
    static final byte EK_ARRAY_INITIALIZER = 50;
    static final byte EK_APPENDSTRING = 51;
    static final byte EK_AUTOBOXING = 53;
    static final byte EK_AUTOUNBOXING = 54;
    static final byte EK_MAX = 55;
    private static boolean[] isStatementExpressionMap;
    final byte kind;
    final int pos;
    private TypeSymbol type;
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = Expression.class$("oracle.ojc.compiler.Expression");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
        isStatementExpressionMap = new boolean[55];
        Expression.isStatementExpressionMap[4] = true;
        Expression.isStatementExpressionMap[5] = true;
        Expression.isStatementExpressionMap[6] = true;
        Expression.isStatementExpressionMap[7] = true;
        Expression.isStatementExpressionMap[8] = true;
        Expression.isStatementExpressionMap[9] = true;
        Expression.isStatementExpressionMap[10] = true;
        Expression.isStatementExpressionMap[11] = true;
        Expression.isStatementExpressionMap[12] = true;
        Expression.isStatementExpressionMap[13] = true;
        Expression.isStatementExpressionMap[14] = true;
        Expression.isStatementExpressionMap[15] = true;
        Expression.isStatementExpressionMap[16] = true;
        Expression.isStatementExpressionMap[41] = true;
        Expression.isStatementExpressionMap[42] = true;
        Expression.isStatementExpressionMap[43] = true;
        Expression.isStatementExpressionMap[44] = true;
    }

    Expression(byte kind, int pos) {
        this.kind = kind;
        this.pos = pos;
    }

    static void initializeExpressions() {
        ErrorExpression.initializeStatics();
    }

    static void releaseExpressions() {
        ErrorExpression.releaseStatics();
    }

    short getAccess() {
        if (!$a) {
            throw new AssertionError();
        }
        return 0;
    }

    String errorName() {
        if (!$a) {
            throw new AssertionError();
        }
        return null;
    }

    final TypeSymbol getType() {
        return this.type;
    }

    void setType(TypeSymbol type) {
        this.type = type;
    }

    boolean isConstantBooleanExpression() {
        return false;
    }

    boolean getConstantBooleanExpressionValue() {
        if (!$a && !this.isConstantBooleanExpression()) {
            throw new AssertionError();
        }
        return false;
    }

    boolean isLogicalExpression() {
        return false;
    }

    BitSet getLogicalExpressionTrueDefSet() {
        if (!$a && !this.isLogicalExpression()) {
            throw new AssertionError();
        }
        return null;
    }

    BitSet getLogicalExpressionFalseDefSet() {
        if (!$a && !this.isLogicalExpression()) {
            throw new AssertionError();
        }
        return null;
    }

    static boolean isStatementExpression(byte exprKind) {
        return isStatementExpressionMap[exprKind];
    }

    Expression foldExpression() {
        return this;
    }

    Expression constantFolding(Parser parser) {
        return this;
    }

    abstract Expression resolveAndCheck(Parser var1);

    Expression resolveAndCheckReadBeforeWrite(Parser parser) {
        return this.resolveAndCheck(parser);
    }

    Expression resolveAndCheckWrite(Parser parser) {
        return this.resolveAndCheck(parser);
    }

    void markDefined(Parser parser) {
    }

    void markUsed(Parser parser) {
    }

    boolean takeAssignmentContext() {
        return false;
    }

    private static int getClassHierarchyDepth(ClassSymbol classSymbol) {
        int depth = 0;
        while (classSymbol != null) {
            ++depth;
            classSymbol = classSymbol.getSuperClassSymbol();
        }
        return depth;
    }

    static TypeSymbol findCommonSuperclass(Parser parser, TypeSymbol type1, TypeSymbol type2) {
        if (!type1.isClass() || !type2.isClass()) {
            return parser.javaLangObjectPcs;
        }
        ClassSymbol class1 = (ClassSymbol)type1;
        int depth1 = Expression.getClassHierarchyDepth(class1);
        ClassSymbol class2 = (ClassSymbol)type2;
        int depth2 = Expression.getClassHierarchyDepth(class2);
        if (depth2 > depth1) {
            int h = depth1;
            depth1 = depth2;
            depth2 = h;
            class1 = (ClassSymbol)type2;
            class2 = (ClassSymbol)type1;
        }
        while (depth1 > depth2) {
            --depth1;
            class1 = class1.getSuperClassSymbol();
        }
        while (true) {
            if (class1.equalTo(class2)) {
                return class1;
            }
            if (class2.equalTo(class1)) break;
            class1 = class1.getSuperClassSymbol();
            class2 = class2.getSuperClassSymbol();
        }
        return class2;
    }

    private static int getInterfaceHierarchyDepth(ClassSymbol classSymbol) {
        int depth = 1;
        while (classSymbol.getImplementationList() != null) {
            classSymbol = classSymbol.getImplementationList().interfaceSymbol;
        }
        return depth;
    }

    static TypeSymbol findCommonSuperInterface(Parser parser, TypeSymbol type1, TypeSymbol type2) {
        if (!type1.isInterface() || !type2.isInterface()) {
            return parser.javaLangObjectPcs;
        }
        ClassSymbol class1 = (ClassSymbol)type1;
        int depth1 = Expression.getInterfaceHierarchyDepth(class1);
        ClassSymbol class2 = (ClassSymbol)type2;
        int depth2 = Expression.getInterfaceHierarchyDepth(class2);
        if (depth2 > depth1) {
            int h = depth1;
            depth1 = depth2;
            depth2 = h;
            class1 = (ClassSymbol)type2;
            class2 = (ClassSymbol)type1;
        }
        while (depth1 > depth2) {
            --depth1;
            class1 = class1.getImplementationList().interfaceSymbol;
        }
        while (true) {
            if (class1.equalTo(class2)) {
                return class1;
            }
            if (class2.equalTo(class1)) break;
            class1 = class1.getImplementationList() != null ? class1.getImplementationList().interfaceSymbol : class1.getSuperClassSymbol();
            if (class2.getImplementationList() != null) {
                class2 = class2.getImplementationList().interfaceSymbol;
                continue;
            }
            class2 = class2.getSuperClassSymbol();
        }
        return class2;
    }

    Expression promoteType(Parser parser, TypeSymbol toType) {
        Expression expr2;
        TypeSymbol fromType = this.type;
        if (fromType.equalTo(toType)) {
            return this;
        }
        byte toTypeKind = toType.typeKind;
        byte fromTypeKind = fromType.typeKind;
        if (toType.isErroneous() || fromType.isErroneous()) {
            return this;
        }
        TypeSymbol unboxedType = null;
        if (parser.options.sourceJDKVersion >= 150) {
            boolean giveError = false;
            if (BoxingExpression.isBoxableType(fromType) && toType.isClass()) {
                if (fromTypeKind == 4 && toType.equalTo(parser.javaLangNumberSymbol)) {
                    giveError = true;
                } else if (toType.equalTo(parser.javaLangComparableSymbol)) {
                    ParameterizedClassSymbol boxedType = BoxingExpression.getBoxedType(parser, fromType);
                    if (boxedType.implementsInterface((ClassSymbol)toType)) {
                        unboxedType = fromType;
                    } else {
                        giveError = true;
                    }
                } else {
                    unboxedType = toType.equalTo(parser.javaLangNumberSymbol) || toType.equalTo(parser.javaIoSerializableSymbol) || toType.equalTo(parser.javaLangComparableSymbol) || toType.equalTo(parser.javaLangObjectSymbol) ? fromType : BoxingExpression.getPrimitiveType(parser, toType);
                }
                if (giveError) {
                    Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, fromType.errorName(), toType.errorName());
                    return new ErrorExpression(error);
                }
            } else if (toType.isPrimitiveType() && fromType.isReferenceType()) {
                unboxedType = BoxingExpression.getPrimitiveType(parser, fromType);
            }
        }
        switch (fromTypeKind) {
            default: {
                if (!$a) {
                    throw new AssertionError();
                }
            }
            case 1: {
                Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, fromType.errorName(), toType.errorName());
                return new ErrorExpression(error);
            }
            case 10: {
                if (unboxedType != null) {
                    if (unboxedType.typeKind != toTypeKind) {
                        boolean giveError = false;
                        switch (unboxedType.typeKind) {
                            case 5: {
                                if (toTypeKind != 4) break;
                                giveError = true;
                                break;
                            }
                            case 4: {
                                if (toTypeKind != 5) break;
                                giveError = true;
                                break;
                            }
                        }
                        switch (unboxedType.typeKind) {
                            default: {
                                if (!TypeSymbol.isWider(unboxedType.typeKind, toTypeKind)) break;
                                giveError = true;
                                break;
                            }
                            case 2: {
                                giveError = true;
                                break;
                            }
                            case 3: {
                                if (toTypeKind != 4) break;
                                giveError = true;
                                break;
                            }
                        }
                        if (giveError) {
                            Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, fromType.errorName(), toType.errorName());
                            return new ErrorExpression(error);
                        }
                    }
                    return new AutoUnboxingExpression(this, toType);
                }
            }
            case 11: {
                if (fromType == ReferenceTypeSymbol.nullTypeSymbol || toType == ReferenceTypeSymbol.nullTypeSymbol) {
                    return this;
                }
                if (toType.equalTo(parser.javaLangObjectSymbol)) {
                    return this;
                }
                if (!(toType instanceof ReferenceTypeSymbol)) {
                    Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, fromType.errorName(), toType.errorName());
                    return new ErrorExpression(error);
                }
                ReferenceTypeSymbol fRefSymbol = (ReferenceTypeSymbol)fromType;
                ReferenceTypeSymbol tRefSymbol = (ReferenceTypeSymbol)toType;
                if (!fRefSymbol.isCastCompatible(parser, tRefSymbol)) {
                    Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, fromType.errorName(), toType.errorName());
                    return new ErrorExpression(error);
                }
                return this;
            }
            case 2: {
                if (unboxedType != null && fromTypeKind == unboxedType.typeKind) {
                    return new AutoBoxingExpression(this, toType);
                }
                Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, fromType.errorName(), toType.errorName());
                return new ErrorExpression(error);
            }
            case 3: {
                if (unboxedType != null && unboxedType.isNumericType()) {
                    toTypeKind = unboxedType.typeKind;
                } else if (!toType.isNumericType()) {
                    Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, fromType.errorName(), toType.errorName());
                    return new ErrorExpression(error);
                }
                if (TypeSymbol.isWider(fromTypeKind, toTypeKind) || toTypeKind == 4) {
                    IntConstantExpression iconstExpr = null;
                    int ival = 0;
                    if (toTypeKind == 4) {
                        if (this.kind == 2) {
                            iconstExpr = (IntConstantExpression)this;
                            ival = iconstExpr.ival;
                        } else {
                            ConstantExpression constExpr = this.getConstInitExpressionIfFinal();
                            if (constExpr instanceof IntConstantExpression) {
                                iconstExpr = (IntConstantExpression)constExpr;
                                ival = iconstExpr.ival;
                            }
                        }
                    }
                    if (iconstExpr != null && 0 <= ival && ival <= 127) {
                        Expression expr2 = new CharConstantExpression(this.pos, (char)ival);
                        if (unboxedType != null) {
                            expr2 = new AutoBoxingExpression(expr2, toType);
                        }
                        return expr2;
                    }
                    Error error = parser.error(Message.errorLossOfPrecision, this.pos, false, fromType.errorName(), toType.errorName());
                    return new ErrorExpression(error);
                }
                if (unboxedType == null) break;
                return this.getBoxedPromotion(parser, unboxedType, fromType, toType, this.pos);
            }
            case 4: {
                if (unboxedType != null && unboxedType.isNumericType()) {
                    toTypeKind = unboxedType.typeKind;
                } else if (!toType.isNumericType()) {
                    Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, fromType.errorName(), toType.errorName());
                    return new ErrorExpression(error);
                }
                if (fromTypeKind != toTypeKind && TypeSymbol.isWiderOrSame(fromTypeKind, toTypeKind)) {
                    IntConstantExpression iconstExpr = null;
                    CharConstantExpression cconstExpr = null;
                    int ival = 0;
                    char cval = '\u0000';
                    if (this.kind == 2) {
                        cconstExpr = (CharConstantExpression)this;
                        cval = cconstExpr.cval;
                    } else {
                        ConstantExpression constExpr = this.getConstInitExpressionIfFinal();
                        if (constExpr instanceof CharConstantExpression) {
                            cconstExpr = (CharConstantExpression)constExpr;
                            cval = cconstExpr.cval;
                        } else if (constExpr instanceof IntConstantExpression) {
                            iconstExpr = (IntConstantExpression)constExpr;
                            ival = iconstExpr.ival;
                        }
                    }
                    if (cconstExpr != null) {
                        boolean fitsInToType = false;
                        switch (toTypeKind) {
                            default: {
                                break;
                            }
                            case 3: {
                                fitsInToType = cval <= '\u007f';
                                break;
                            }
                            case 5: {
                                fitsInToType = cval <= Short.MAX_VALUE;
                                break;
                            }
                        }
                        if (fitsInToType) {
                            if (unboxedType != null) {
                                iconstExpr = new IntConstantExpression(this.pos, unboxedType, cval);
                                return new AutoBoxingExpression(iconstExpr, toType);
                            }
                            return new IntConstantExpression(this.pos, toType, cval);
                        }
                    } else if (iconstExpr != null) {
                        boolean fitsInToType = false;
                        switch (toTypeKind) {
                            default: {
                                break;
                            }
                            case 3: {
                                fitsInToType = ival <= 127;
                                break;
                            }
                            case 5: {
                                fitsInToType = ival <= Short.MAX_VALUE;
                                break;
                            }
                        }
                        if (fitsInToType) {
                            if (unboxedType != null) {
                                return new AutoBoxingExpression(iconstExpr, toType);
                            }
                            return iconstExpr;
                        }
                    }
                    Error error = parser.error(Message.errorLossOfPrecision, this.pos, false, fromType.errorName(), toType.errorName());
                    return new ErrorExpression(error);
                }
                if (unboxedType == null) break;
                return this.getBoxedPromotion(parser, unboxedType, fromType, toType, this.pos);
            }
            case 5: {
                if (unboxedType != null && unboxedType.isNumericType()) {
                    toTypeKind = unboxedType.typeKind;
                } else if (!toType.isNumericType()) {
                    Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, fromType.errorName(), toType.errorName());
                    return new ErrorExpression(error);
                }
                if (fromTypeKind != toTypeKind && TypeSymbol.isWiderOrSame(fromTypeKind, toTypeKind)) {
                    IntConstantExpression iconstExpr = null;
                    int ival = 0;
                    if (this.kind == 2) {
                        iconstExpr = (IntConstantExpression)this;
                        ival = iconstExpr.ival;
                    } else {
                        ConstantExpression constExpr = this.getConstInitExpressionIfFinal();
                        if (constExpr instanceof IntConstantExpression) {
                            iconstExpr = (IntConstantExpression)constExpr;
                            ival = iconstExpr.ival;
                        }
                    }
                    if (iconstExpr != null) {
                        switch (toTypeKind) {
                            default: {
                                break;
                            }
                            case 3: {
                                if (-128 > ival || ival > 127) break;
                                iconstExpr.setTypeExempt(TypeSymbol.byteSymbol);
                                if (unboxedType != null) {
                                    return new AutoBoxingExpression(iconstExpr, toType);
                                }
                                return iconstExpr;
                            }
                            case 4: {
                                if (0 > ival || ival > Short.MAX_VALUE) break;
                                Expression expr2 = new CharConstantExpression(iconstExpr.pos, (char)ival);
                                if (unboxedType != null) {
                                    expr2 = new AutoBoxingExpression(expr2, toType);
                                }
                                return expr2;
                            }
                        }
                    }
                    Error error = parser.error(Message.errorLossOfPrecision, this.pos, false, fromType.errorName(), toType.errorName());
                    return new ErrorExpression(error);
                }
                if (unboxedType == null) break;
                return this.getBoxedPromotion(parser, unboxedType, fromType, toType, this.pos);
            }
            case 6: {
                if (unboxedType != null && unboxedType.isNumericType()) {
                    toTypeKind = unboxedType.typeKind;
                } else if (!toType.isNumericType()) {
                    Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, fromType.errorName(), toType.errorName());
                    return new ErrorExpression(error);
                }
                if (TypeSymbol.isWider(fromTypeKind, toTypeKind)) {
                    IntConstantExpression iconstExpr = null;
                    int ival = 0;
                    if (this.kind == 2) {
                        iconstExpr = (IntConstantExpression)this;
                        ival = iconstExpr.ival;
                    } else {
                        ConstantExpression constExpr = this.getConstInitExpressionIfFinal();
                        if (constExpr instanceof IntConstantExpression) {
                            iconstExpr = (IntConstantExpression)constExpr;
                            ival = iconstExpr.ival;
                        }
                    }
                    if (iconstExpr != null) {
                        switch (toTypeKind) {
                            default: {
                                break;
                            }
                            case 3: {
                                if (-128 > ival || ival > 127) break;
                                iconstExpr.setTypeExempt(TypeSymbol.byteSymbol);
                                if (unboxedType != null) {
                                    return new AutoBoxingExpression(iconstExpr, toType);
                                }
                                return iconstExpr;
                            }
                            case 4: {
                                if (0 > ival || ival > 65535) break;
                                Expression expr2 = new CharConstantExpression(iconstExpr.pos, (char)ival);
                                if (unboxedType != null) {
                                    expr2 = new AutoBoxingExpression(expr2, toType);
                                }
                                return expr2;
                            }
                            case 5: {
                                if (Short.MIN_VALUE > ival || ival > Short.MAX_VALUE) break;
                                iconstExpr.setTypeExempt(TypeSymbol.shortSymbol);
                                if (unboxedType != null) {
                                    return new AutoBoxingExpression(iconstExpr, toType);
                                }
                                return iconstExpr;
                            }
                        }
                    }
                    Error error = parser.error(Message.errorLossOfPrecision, this.pos, false, fromType.errorName(), toType.errorName());
                    return new ErrorExpression(error);
                }
                if (unboxedType == null) break;
                return this.getBoxedPromotion(parser, unboxedType, fromType, toType, this.pos);
            }
            case 7: {
                if (unboxedType != null && unboxedType.isNumericType()) {
                    toTypeKind = unboxedType.typeKind;
                } else if (!toType.isNumericType()) {
                    Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, fromType.errorName(), toType.errorName());
                    return new ErrorExpression(error);
                }
                if (TypeSymbol.isWider(fromTypeKind, toTypeKind)) {
                    Error error = parser.error(Message.errorLossOfPrecision, this.pos, false, fromType.errorName(), toType.errorName());
                    return new ErrorExpression(error);
                }
                if (unboxedType == null) break;
                return this.getBoxedPromotion(parser, unboxedType, fromType, toType, this.pos);
            }
            case 8: {
                if (unboxedType != null && unboxedType.isNumericType()) {
                    toTypeKind = unboxedType.typeKind;
                } else if (!toType.isNumericType()) {
                    Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, fromType.errorName(), toType.errorName());
                    return new ErrorExpression(error);
                }
                if (TypeSymbol.isWider(fromTypeKind, toTypeKind)) {
                    Error error = parser.error(Message.errorLossOfPrecision, this.pos, false, fromType.errorName(), toType.errorName());
                    return new ErrorExpression(error);
                }
                if (unboxedType == null) break;
                return this.getBoxedPromotion(parser, unboxedType, fromType, toType, this.pos);
            }
            case 9: {
                if (unboxedType != null && fromTypeKind == unboxedType.typeKind) {
                    return new AutoBoxingExpression(this, toType);
                }
                Error error = !toType.isNumericType() ? parser.error(Message.errorIncompatibleTypes, this.pos, false, fromType.errorName(), toType.errorName()) : parser.error(Message.errorLossOfPrecision, this.pos, false, fromType.errorName(), toType.errorName());
                return new ErrorExpression(error);
            }
        }
        if (this.kind == 2 && fromType.isNumericType()) {
            expr2 = CastExpression.castNumericConstant(this, toType, false);
        } else {
            expr2 = new CastExpression(this.pos, this, toType);
            expr2.type = toType;
        }
        return expr2;
    }

    private Expression getBoxedPromotion(Parser parser, TypeSymbol unboxedType, TypeSymbol fromType, TypeSymbol toType, int pos) {
        if (unboxedType.typeKind == fromType.typeKind) {
            return new AutoBoxingExpression(this, toType);
        }
        Error error = parser.error(Message.errorIncompatibleTypes, pos, false, fromType.errorName(), toType.errorName());
        return new ErrorExpression(error);
    }

    private ConstantExpression getConstInitExpressionIfFinal() {
        if (this.kind == 1 && this instanceof FieldExpression) {
            FieldExpression fieldExpression = (FieldExpression)this;
            if (fieldExpression.field.kind == 2) {
                FieldSymbol fieldSymbol = (FieldSymbol)fieldExpression.field;
                if ((fieldSymbol.access & 0x10) != 0 && fieldSymbol.initializer instanceof ConstantExpression) {
                    return (ConstantExpression)fieldSymbol.initializer;
                }
            }
        }
        return null;
    }

    abstract void generateByteCode(ByteCodeGenerator var1);

    void generateByteCodeReadBeforeWrite(ByteCodeGenerator byteCodeGenerator, boolean x1) {
        if (!$a) {
            throw new AssertionError();
        }
    }

    void generateByteCodeWrite(ByteCodeGenerator byteCodeGenerator) {
        if (!$a) {
            throw new AssertionError();
        }
    }

    void generateByteCodeBranch(ByteCodeGenerator byteCodeGenerator, Label label, boolean branchIfFalse) {
        if (!$a && this.type.typeKind != 2) {
            throw new AssertionError();
        }
        this.generateByteCode(byteCodeGenerator);
        if (branchIfFalse) {
            byteCodeGenerator.generateBranch_ifeq(label);
        } else {
            byteCodeGenerator.generateBranch_ifne(label);
        }
        byteCodeGenerator.decOpStackHeight(1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

