/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LoopStatement;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SwitchLoopList;

final class ForStatement
extends LoopStatement {
    StatementList initStatements;
    Expression condition;
    StatementList updateStatements;
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    ForStatement(StatementList parent, int pos, int bodyPos, Expression condition, StatementList initStatements, StatementList bodyStatements, StatementList updateStatements) {
        super(parent, pos, bodyPos, (byte)11, bodyStatements);
        if (condition == null) {
            condition = new BooleanConstantExpression(pos, true);
        }
        this.initStatements = initStatements;
        this.condition = condition;
        this.updateStatements = updateStatements;
        if (initStatements != null) {
            initStatements.parent = this;
        }
        if (updateStatements != null) {
            updateStatements.parent = this;
        }
    }

    void resolveAndCheck(Parser parser) {
        StatementList initStatements = this.initStatements;
        if (initStatements != null) {
            initStatements.resolveAndCheck(parser);
        }
        SwitchLoopList outerSwitchLoop = parser.innerSwitchLoop;
        this.loopRec = new SwitchLoopList(outerSwitchLoop, null, this, parser.defSet, parser.posSet, parser.useSet);
        try {
            StatementList updateStatements;
            parser.innerSwitchLoop = this.loopRec;
            StatementList bodyStatements = this.bodyStatements;
            parser.resolvingForCondition = true;
            boolean forEver = false;
            Expression expr = this.condition.resolveAndCheck(parser);
            parser.resolvingForCondition = false;
            expr = this.checkForBooleanExpression(parser, expr);
            if (expr.isConstantBooleanExpression()) {
                if (!expr.getConstantBooleanExpressionValue()) {
                    if (this.condition.kind == 2) {
                        parser.error(Message.errorUnreachableStatement, bodyStatements.first == null ? this.pos : bodyStatements.first.pos, false);
                    }
                } else {
                    forEver = true;
                }
            } else {
                ++parser.estimatedLineCount;
            }
            BitSet defSetAfterCondition = (BitSet)parser.defSet.clone();
            this.condition = expr;
            if (bodyStatements != null) {
                if (expr.isLogicalExpression()) {
                    parser.defSet = expr.getLogicalExpressionTrueDefSet();
                }
                bodyStatements.resolveAndCheck(parser);
                if (forEver && this.loopRec.breakSymbol == null && this.next != null && this.next.isCodeStatement()) {
                    parser.error(Message.errorUnreachableStatement, this.next.pos, false);
                }
            } else if (forEver && this.next != null && this.next.isCodeStatement()) {
                parser.error(Message.errorUnreachableStatement, this.next.pos, false);
            }
            if (this.continueDefSet != null) {
                parser.defSet.and(this.continueDefSet);
            }
            if ((updateStatements = this.updateStatements) != null) {
                updateStatements.resolveAndCheck(parser);
            }
            this.loopRec.insertLabels();
            if (this.resultDefSet != null) {
                if (forEver) {
                    parser.defSet = this.resultDefSet;
                } else if (expr.isLogicalExpression()) {
                    parser.defSet = this.resultDefSet;
                    parser.defSet.and(expr.getLogicalExpressionFalseDefSet());
                } else {
                    parser.defSet = defSetAfterCondition;
                }
            } else {
                parser.defSet = expr.isLogicalExpression() ? expr.getLogicalExpressionFalseDefSet() : defSetAfterCondition;
            }
            if (this.resultPosSet != null) {
                parser.posSet.or(this.resultPosSet);
            }
            if (this.resultUseSet != null) {
                parser.useSet.or(this.resultUseSet);
            }
            this.checkPosibleReinitializations(parser);
            Object var10_9 = null;
            parser.innerSwitchLoop = outerSwitchLoop;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            parser.innerSwitchLoop = outerSwitchLoop;
            throw throwable;
        }
        if (!this.canReachNextStatement(true)) {
            this.setLastStatement();
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        StatementList updateStatements;
        StatementList bodyStatements;
        StatementList initStatements = this.initStatements;
        if (initStatements != null) {
            initStatements.generateByteCode(byteCodeGenerator);
        }
        Label testLabel = new Label();
        Label bodyLabel = new Label();
        byteCodeGenerator.generateBranch_goto(testLabel);
        byteCodeGenerator.setLabel(bodyLabel);
        SwitchLoopList outerSwitchLoop = byteCodeGenerator.parser.innerSwitchLoop;
        byteCodeGenerator.parser.innerSwitchLoop = this.loopRec;
        if (this.loopRec.continueSymbol != null) {
            this.loopRec.continueSymbol.label = new Label();
        }
        if (this.loopRec.breakSymbol != null) {
            this.loopRec.breakSymbol.label = new Label();
        }
        if ((bodyStatements = this.bodyStatements) != null) {
            bodyStatements.generateByteCode(byteCodeGenerator);
        }
        if ((updateStatements = this.updateStatements) != null) {
            updateStatements.generateByteCode(byteCodeGenerator);
        }
        byteCodeGenerator.parser.innerSwitchLoop = outerSwitchLoop;
        byteCodeGenerator.setLabel(testLabel);
        Expression expr = this.condition;
        if (expr.isConstantBooleanExpression()) {
            if (expr.getConstantBooleanExpressionValue()) {
                byteCodeGenerator.generateBranch_goto(bodyLabel);
            }
        } else {
            byteCodeGenerator.generateLineNumber(Scanner.positionToLine(expr.pos));
            expr.generateByteCodeBranch(byteCodeGenerator, bodyLabel, false);
        }
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = ForStatement.class$("oracle.ojc.compiler.ForStatement");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    boolean canReachNextStatement(boolean strict) {
        Expression expr = this.condition;
        boolean forEver = false;
        if (expr.isConstantBooleanExpression()) {
            forEver = expr.getConstantBooleanExpressionValue();
        }
        if (!$a && this.loopRec == null) {
            throw new AssertionError();
        }
        if (this.loopRec.breakSymbol != null) {
            forEver = false;
        }
        return forEver ^ true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

