/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.DoubleConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FloatConstantExpression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.RelationalExpression;

final class GreaterOrEqualExpression
extends RelationalExpression {
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    GreaterOrEqualExpression(int pos, Expression leftOperand, Expression rightOperand) {
        super((byte)27, pos, leftOperand, rightOperand);
    }

    strictfp Expression foldExpression() {
        Expression leftOp = this.leftOperand;
        Expression rightOp = this.rightOperand;
        if (leftOp.kind == 2 && rightOp.kind == 2) {
            switch (leftOp.getType().typeClass) {
                case 4: {
                    return new BooleanConstantExpression(this.pos, ((ConstantExpression)leftOp).getIntConstValue() >= ((ConstantExpression)rightOp).getIntConstValue());
                }
                case 8: {
                    return new BooleanConstantExpression(this.pos, ((LongConstantExpression)leftOp).lval >= ((LongConstantExpression)rightOp).lval);
                }
                case 16: {
                    return new BooleanConstantExpression(this.pos, ((FloatConstantExpression)leftOp).fval >= ((FloatConstantExpression)rightOp).fval);
                }
                case 32: {
                    return new BooleanConstantExpression(this.pos, ((DoubleConstantExpression)leftOp).dval >= ((DoubleConstantExpression)rightOp).dval);
                }
            }
        }
        return this;
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = GreaterOrEqualExpression.class$("oracle.ojc.compiler.GreaterOrEqualExpression");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        byte opcode;
        this.leftOperand.generateByteCode(byteCodeGenerator);
        this.rightOperand.generateByteCode(byteCodeGenerator);
        switch (this.leftOperand.getType().typeClass) {
            default: {
                if (!$a) {
                    throw new AssertionError();
                }
            }
            case 4: {
                opcode = -95;
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 16: {
                byteCodeGenerator.generate_8((byte)-107);
                opcode = -101;
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 8: {
                byteCodeGenerator.generate_8((byte)-108);
                opcode = -101;
                byteCodeGenerator.decOpStackHeight(3);
                break;
            }
            case 32: {
                byteCodeGenerator.generate_8((byte)-105);
                opcode = -101;
                byteCodeGenerator.decOpStackHeight(3);
                break;
            }
        }
        byteCodeGenerator.generate_8_16(opcode, (short)7);
        byteCodeGenerator.generate_8((byte)4);
        byteCodeGenerator.generate_8_16((byte)-89, (short)4);
        byteCodeGenerator.generate_8((byte)3);
    }

    void generateByteCodeBranch(ByteCodeGenerator byteCodeGenerator, Label label, boolean branchIfFalse) {
        this.leftOperand.generateByteCode(byteCodeGenerator);
        this.rightOperand.generateByteCode(byteCodeGenerator);
        switch (this.leftOperand.getType().typeClass) {
            default: {
                if (!$a) {
                    throw new AssertionError();
                }
            }
            case 4: {
                if (branchIfFalse) {
                    byteCodeGenerator.generateBranch_if_icmplt(label);
                } else {
                    byteCodeGenerator.generateBranch_if_icmpge(label);
                }
                byteCodeGenerator.decOpStackHeight(2);
                break;
            }
            case 16: {
                byteCodeGenerator.generate_8((byte)-107);
                if (branchIfFalse) {
                    byteCodeGenerator.generateBranch_iflt(label);
                } else {
                    byteCodeGenerator.generateBranch_ifge(label);
                }
                byteCodeGenerator.decOpStackHeight(2);
                break;
            }
            case 8: {
                byteCodeGenerator.generate_8((byte)-108);
                if (branchIfFalse) {
                    byteCodeGenerator.generateBranch_iflt(label);
                } else {
                    byteCodeGenerator.generateBranch_ifge(label);
                }
                byteCodeGenerator.decOpStackHeight(4);
                break;
            }
            case 32: {
                byteCodeGenerator.generate_8((byte)-105);
                if (branchIfFalse) {
                    byteCodeGenerator.generateBranch_iflt(label);
                } else {
                    byteCodeGenerator.generateBranch_ifge(label);
                }
                byteCodeGenerator.decOpStackHeight(4);
                break;
            }
        }
    }

    public String toString() {
        return ">=";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

