/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

final class Identifier {
    static int[] hashIdentifierMap;
    private static int seed;
    private static Identifier[] discreteIdentifierMap;
    private static int discreteIdentifierMapCount;
    static Identifier thisIdentifier;
    static Identifier valueIdentifier;
    static Identifier nextIdentifier;
    static Identifier hasNextIdentifier;
    static Identifier initializerIdentifier;
    static Identifier classInitializerIdentifier;
    static Identifier dynamicInitializerIdentifier;
    static Identifier serialVersionUIDIdentifier;
    static Identifier lengthIdentifier;
    static Identifier valueOfIdentifier;
    static Identifier valuesIdentifier;
    static Identifier forNameIdentifier;
    static Identifier appendIdentifier;
    static Identifier toStringIdentifier;
    static Identifier finalizeIdentifier;
    static Identifier cloneIdentifier;
    static Identifier nameIdentifier;
    static Identifier equalsIdentifier;
    static Identifier ordinalIdentifier;
    static Identifier iteratorIdentifier;
    static Identifier booleanValueIdentifier;
    static Identifier byteValueIdentifier;
    static Identifier charValueIdentifier;
    static Identifier shortValueIdentifier;
    static Identifier intValueIdentifier;
    static Identifier longValueIdentifier;
    static Identifier floatValueIdentifier;
    static Identifier doubleValueIdentifier;
    static Identifier desiredAssertionStatusIdentifier;
    static Identifier getMessageIdentifier;
    static Identifier getClassIdentifier;
    static Identifier typeIdentifier;
    static Identifier stringIdentifier;
    static Identifier cloneNotSupportedExceptionIdentifier;
    static Identifier stringBufferIdentifier;
    static Identifier enumIdentifier;
    static Identifier assertIdentifier;
    static Identifier javaLangObjectInternal;
    static Identifier javaLangClassInternal;
    static Identifier javaLangErrorInternal;
    static Identifier javaLangStringBufferInternal;
    static Identifier javaLangIllegalArgumentExceptionInternal;
    static Identifier javaLangStringBuilderInternal;
    static Identifier javaUtilIteratorInternal;
    static Identifier javaLangStringInternal;
    static Identifier javaLangAssertionErrorInternal;
    static Identifier javaLangNoClassDefFoundErrorInternal;
    static Identifier javaLangClassNotFoundExceptionInternal;
    static Identifier javaLangNoSuchFieldErrorInternal;
    static Identifier javaLangClassSignature;
    static Identifier javaLangObjectSignature;
    static Identifier booleanSignature;
    static Identifier voidMethodSignature;
    static Identifier voidMethodStringSignature;
    static Identifier voidMethodObjectSignature;
    static Identifier voidMethodBooleanSignature;
    static Identifier voidMethodCharSignature;
    static Identifier voidMethodIntSignature;
    static Identifier voidMethodLongSignature;
    static Identifier voidMethodFloatSignature;
    static Identifier voidMethodDoubleSignature;
    static Identifier booleanMethodSignature;
    static Identifier byteMethodSignature;
    static Identifier charMethodSignature;
    static Identifier shortMethodSignature;
    static Identifier intMethodSignature;
    static Identifier longMethodSignature;
    static Identifier floatMethodSignature;
    static Identifier doubleMethodSignature;
    static Identifier javaLangObjectMethodSignature;
    static Identifier javaLangClassMethodSignature;
    static Identifier javaLangClassMethodStringSignature;
    static Identifier javaLangStringMethodSignature;
    static Identifier javaLangStringBufferMethodBooleanSignature;
    static Identifier javaLangStringBufferMethodCharSignature;
    static Identifier javaLangStringBufferMethodIntSignature;
    static Identifier javaLangStringBufferMethodLongSignature;
    static Identifier javaLangStringBufferMethodFloatSignature;
    static Identifier javaLangStringBufferMethodDoubleSignature;
    static Identifier javaLangStringBufferMethodObjectSignature;
    static Identifier javaLangStringBufferMethodStringSignature;
    static Identifier javaLangStringBuilderMethodBooleanSignature;
    static Identifier javaLangStringBuilderMethodCharSignature;
    static Identifier javaLangStringBuilderMethodIntSignature;
    static Identifier javaLangStringBuilderMethodLongSignature;
    static Identifier javaLangStringBuilderMethodFloatSignature;
    static Identifier javaLangStringBuilderMethodDoubleSignature;
    static Identifier javaLangStringBuilderMethodObjectSignature;
    static Identifier javaLangStringBuilderMethodStringSignature;
    static Identifier javaLangEnumMethodClassStringSignature;
    static Identifier javaUtilIteratorMethodSignature;
    static Identifier booleanMethodObjectSignature;
    static Identifier javaLangBooleanMethodBooleanSignature;
    static Identifier javaLangByteMethodByteSignature;
    static Identifier javaLangCharacterMethodCharSignature;
    static Identifier javaLangShortMethodShortSignature;
    static Identifier javaLangIntegerMethodIntSignature;
    static Identifier javaLangLongMethodLongSignature;
    static Identifier javaLangFloatMethodFloatSignature;
    static Identifier javaLangDoubleMethodDoubleSignature;
    static Identifier intArraySignature;
    static Identifier enumValuesInternal;
    static Identifier assertionsDisabledInternal;
    static Identifier classObjectInternal;
    static Identifier syntheticAttribute;
    static Identifier constantValueAttribute;
    static Identifier codeAttribute;
    static Identifier lineNumberTableAttribute;
    static Identifier localVarsTableAttribute;
    static Identifier localVarsTypeTableAttribute;
    static Identifier deprecatedAttribute;
    static Identifier exceptionsAttribute;
    static Identifier sourceFileAttribute;
    static Identifier innerClassesAttribute;
    static Identifier runtimeVisibleAnnotationAttribute;
    static Identifier runtimeInvisibleAnnotationAttribute;
    static Identifier runtimeVisibleParameterAnnotationAttribute;
    static Identifier runtimeInvisibleParameterAnnotationAttribute;
    static Identifier annotationDefaultAttribute;
    static Identifier signatureAttribute;
    static Identifier enclosingMethodAttribute;
    static Identifier ojcAttribute;
    static Identifier packageInfoIdentifier;
    static String dollarString;
    static char dollarCharacter;
    private Identifier nextHashed;
    char[] name;
    int hash;

    static {
        seed = 1;
        hashIdentifierMap = new int[65536];
        int i = 0;
        while (i <= 65535) {
            if (Character.isJavaIdentifierPart((char)i)) {
                Identifier.hashIdentifierMap[i] = Identifier.Random();
            }
            ++i;
        }
        Identifier.hashIdentifierMap[64] = 0;
    }

    private Identifier(char[] name, int hash) {
        this.name = name;
        this.hash = hash;
    }

    static void initializeIdentifiers(int jdkVersion) {
        if (discreteIdentifierMap == null) {
            discreteIdentifierMap = new Identifier[1024];
            discreteIdentifierMapCount = 0;
        }
        thisIdentifier = Identifier.getIdentifier("this");
        initializerIdentifier = Identifier.getIdentifier("<init>");
        classInitializerIdentifier = Identifier.getIdentifier("<clinit>");
        serialVersionUIDIdentifier = Identifier.getIdentifier("serialVersionUID");
        lengthIdentifier = Identifier.getIdentifier("length");
        valueOfIdentifier = Identifier.getIdentifier("valueOf");
        forNameIdentifier = Identifier.getIdentifier("forName");
        appendIdentifier = Identifier.getIdentifier("append");
        toStringIdentifier = Identifier.getIdentifier("toString");
        cloneNotSupportedExceptionIdentifier = Identifier.getIdentifier("CloneNotSupportedException");
        finalizeIdentifier = Identifier.getIdentifier("finalize");
        desiredAssertionStatusIdentifier = Identifier.getIdentifier("desiredAssertionStatus");
        getMessageIdentifier = Identifier.getIdentifier("getMessage");
        getClassIdentifier = Identifier.getIdentifier("getClass");
        typeIdentifier = Identifier.getIdentifier("TYPE");
        stringIdentifier = Identifier.getIdentifier("String");
        stringBufferIdentifier = Identifier.getIdentifier("StringBuffer");
        enumIdentifier = Identifier.getIdentifier("enum");
        assertIdentifier = Identifier.getIdentifier("assert");
        javaLangObjectInternal = Identifier.getIdentifier("java/lang/Object");
        javaLangClassInternal = Identifier.getIdentifier("java/lang/Class");
        javaLangErrorInternal = Identifier.getIdentifier("java/lang/Error");
        javaLangAssertionErrorInternal = Identifier.getIdentifier("java/lang/AssertionError");
        javaLangNoClassDefFoundErrorInternal = Identifier.getIdentifier("java/lang/NoClassDefFoundError");
        javaLangClassNotFoundExceptionInternal = Identifier.getIdentifier("java/lang/ClassNotFoundException");
        javaLangClassSignature = Identifier.getIdentifier("Ljava/lang/Class;");
        javaLangObjectSignature = Identifier.getIdentifier("Ljava/lang/Object;");
        booleanSignature = Identifier.getIdentifier("Z");
        voidMethodSignature = Identifier.getIdentifier("()V");
        voidMethodStringSignature = Identifier.getIdentifier("(Ljava/lang/String;)V");
        voidMethodObjectSignature = Identifier.getIdentifier("(Ljava/lang/Object;)V");
        voidMethodBooleanSignature = Identifier.getIdentifier("(Z)V");
        voidMethodCharSignature = Identifier.getIdentifier("(C)V");
        voidMethodIntSignature = Identifier.getIdentifier("(I)V");
        voidMethodLongSignature = Identifier.getIdentifier("(J)V");
        voidMethodFloatSignature = Identifier.getIdentifier("(F)V");
        voidMethodDoubleSignature = Identifier.getIdentifier("(D)V");
        booleanMethodSignature = Identifier.getIdentifier("()Z");
        byteMethodSignature = Identifier.getIdentifier("()B");
        charMethodSignature = Identifier.getIdentifier("()C");
        shortMethodSignature = Identifier.getIdentifier("()S");
        intMethodSignature = Identifier.getIdentifier("()I");
        longMethodSignature = Identifier.getIdentifier("()J");
        floatMethodSignature = Identifier.getIdentifier("()F");
        doubleMethodSignature = Identifier.getIdentifier("()D");
        javaLangObjectMethodSignature = Identifier.getIdentifier("()Ljava/lang/Object;");
        javaLangClassMethodSignature = Identifier.getIdentifier("()Ljava/lang/Class;");
        javaLangClassMethodStringSignature = Identifier.getIdentifier("(Ljava/lang/String;)Ljava/lang/Class;");
        javaLangStringMethodSignature = Identifier.getIdentifier("()Ljava/lang/String;");
        syntheticAttribute = Identifier.getIdentifier("Synthetic");
        constantValueAttribute = Identifier.getIdentifier("ConstantValue");
        codeAttribute = Identifier.getIdentifier("Code");
        lineNumberTableAttribute = Identifier.getIdentifier("LineNumberTable");
        localVarsTableAttribute = Identifier.getIdentifier("LocalVariableTable");
        deprecatedAttribute = Identifier.getIdentifier("Deprecated");
        exceptionsAttribute = Identifier.getIdentifier("Exceptions");
        sourceFileAttribute = Identifier.getIdentifier("SourceFile");
        innerClassesAttribute = Identifier.getIdentifier("InnerClasses");
        ojcAttribute = Identifier.getIdentifier("OJC");
        packageInfoIdentifier = Identifier.getIdentifier("package-info");
        dollarString = "$";
        dollarCharacter = (char)36;
        if (jdkVersion < 150) {
            javaLangStringBufferInternal = Identifier.getIdentifier("java/lang/StringBuffer");
            javaLangStringBufferMethodBooleanSignature = Identifier.getIdentifier("(Z)Ljava/lang/StringBuffer;");
            javaLangStringBufferMethodCharSignature = Identifier.getIdentifier("(C)Ljava/lang/StringBuffer;");
            javaLangStringBufferMethodIntSignature = Identifier.getIdentifier("(I)Ljava/lang/StringBuffer;");
            javaLangStringBufferMethodLongSignature = Identifier.getIdentifier("(J)Ljava/lang/StringBuffer;");
            javaLangStringBufferMethodFloatSignature = Identifier.getIdentifier("(F)Ljava/lang/StringBuffer;");
            javaLangStringBufferMethodDoubleSignature = Identifier.getIdentifier("(D)Ljava/lang/StringBuffer;");
            javaLangStringBufferMethodObjectSignature = Identifier.getIdentifier("(Ljava/lang/Object;)Ljava/lang/StringBuffer;");
            javaLangStringBufferMethodStringSignature = Identifier.getIdentifier("(Ljava/lang/String;)Ljava/lang/StringBuffer;");
        } else {
            valueIdentifier = Identifier.getIdentifier("value");
            valuesIdentifier = Identifier.getIdentifier("values");
            cloneIdentifier = Identifier.getIdentifier("clone");
            nameIdentifier = Identifier.getIdentifier("name");
            equalsIdentifier = Identifier.getIdentifier("equals");
            ordinalIdentifier = Identifier.getIdentifier("ordinal");
            iteratorIdentifier = Identifier.getIdentifier("iterator");
            nextIdentifier = Identifier.getIdentifier("next");
            hasNextIdentifier = Identifier.getIdentifier("hasNext");
            booleanValueIdentifier = Identifier.getIdentifier("booleanValue");
            byteValueIdentifier = Identifier.getIdentifier("byteValue");
            charValueIdentifier = Identifier.getIdentifier("charValue");
            shortValueIdentifier = Identifier.getIdentifier("shortValue");
            intValueIdentifier = Identifier.getIdentifier("intValue");
            longValueIdentifier = Identifier.getIdentifier("longValue");
            floatValueIdentifier = Identifier.getIdentifier("floatValue");
            doubleValueIdentifier = Identifier.getIdentifier("doubleValue");
            runtimeVisibleAnnotationAttribute = Identifier.getIdentifier("RuntimeVisibleAnnotations");
            runtimeInvisibleAnnotationAttribute = Identifier.getIdentifier("RuntimeInvisibleAnnotations");
            runtimeVisibleParameterAnnotationAttribute = Identifier.getIdentifier("RuntimeVisibleParameterAnnotations");
            runtimeInvisibleParameterAnnotationAttribute = Identifier.getIdentifier("RuntimeInvisibleParameterAnnotations");
            annotationDefaultAttribute = Identifier.getIdentifier("AnnotationDefault");
            signatureAttribute = Identifier.getIdentifier("Signature");
            enclosingMethodAttribute = Identifier.getIdentifier("EnclosingMethod");
            localVarsTypeTableAttribute = Identifier.getIdentifier("LocalVariableTypeTable");
            javaUtilIteratorInternal = Identifier.getIdentifier("java/util/Iterator");
            javaLangStringInternal = Identifier.getIdentifier("java/lang/String");
            javaLangIllegalArgumentExceptionInternal = Identifier.getIdentifier("java/lang/IllegalArgumentException");
            javaLangStringBuilderInternal = Identifier.getIdentifier("java/lang/StringBuilder");
            javaLangStringBuilderMethodBooleanSignature = Identifier.getIdentifier("(Z)Ljava/lang/StringBuilder;");
            javaLangStringBuilderMethodCharSignature = Identifier.getIdentifier("(C)Ljava/lang/StringBuilder;");
            javaLangStringBuilderMethodIntSignature = Identifier.getIdentifier("(I)Ljava/lang/StringBuilder;");
            javaLangStringBuilderMethodLongSignature = Identifier.getIdentifier("(J)Ljava/lang/StringBuilder;");
            javaLangStringBuilderMethodFloatSignature = Identifier.getIdentifier("(F)Ljava/lang/StringBuilder;");
            javaLangStringBuilderMethodDoubleSignature = Identifier.getIdentifier("(D)Ljava/lang/StringBuilder;");
            javaLangStringBuilderMethodObjectSignature = Identifier.getIdentifier("(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            javaLangStringBuilderMethodStringSignature = Identifier.getIdentifier("(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            javaLangEnumMethodClassStringSignature = Identifier.getIdentifier("(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;");
            javaUtilIteratorMethodSignature = Identifier.getIdentifier("()Ljava/util/Iterator;");
            booleanMethodObjectSignature = Identifier.getIdentifier("(Ljava/lang/Object;)Z");
            javaLangBooleanMethodBooleanSignature = Identifier.getIdentifier("(Z)Ljava/lang/Boolean;");
            javaLangByteMethodByteSignature = Identifier.getIdentifier("(B)Ljava/lang/Byte;");
            javaLangCharacterMethodCharSignature = Identifier.getIdentifier("(C)Ljava/lang/Character;");
            javaLangShortMethodShortSignature = Identifier.getIdentifier("(S)Ljava/lang/Short;");
            javaLangIntegerMethodIntSignature = Identifier.getIdentifier("(I)Ljava/lang/Integer;");
            javaLangLongMethodLongSignature = Identifier.getIdentifier("(J)Ljava/lang/Long;");
            javaLangFloatMethodFloatSignature = Identifier.getIdentifier("(F)Ljava/lang/Float;");
            javaLangDoubleMethodDoubleSignature = Identifier.getIdentifier("(D)Ljava/lang/Double;");
            intArraySignature = Identifier.getIdentifier("[I");
            javaLangNoSuchFieldErrorInternal = Identifier.getIdentifier("java/lang/NoSuchFieldError");
            enumValuesInternal = Identifier.getIdentifier(dollarString + "v");
        }
        dynamicInitializerIdentifier = Identifier.getIdentifier(dollarString + "init" + dollarString);
        assertionsDisabledInternal = Identifier.getIdentifier(dollarString + "a");
        classObjectInternal = Identifier.getIdentifier(dollarString + "c");
    }

    static void releaseIdentifiers() {
        discreteIdentifierMap = null;
    }

    /*
     * Unable to fully structure code
     */
    static boolean compare(char[] name1, char[] name2) {
        len = name1.length;
        if (len == name2.length) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (name1[len] == name2[len]) continue;
            return false;
lbl6:
            // 2 sources

            ** while (--len >= 0)
        }
lbl7:
        // 1 sources

        return true;
    }

    /*
     * Unable to fully structure code
     */
    static boolean compare(char[] name1, int start1, char[] name2, int start2, int len) {
        if (start1 + len <= name1.length && start2 + len <= name2.length) ** GOTO lbl5
        return false;
lbl-1000:
        // 1 sources

        {
            if (name1[start1 + len] == name2[start2 + len]) continue;
            return false;
lbl5:
            // 2 sources

            ** while (--len >= 0)
        }
lbl6:
        // 1 sources

        return true;
    }

    static int lastIndexOf(char[] name, char c) {
        int len = name.length;
        while (--len >= 0) {
            if (name[len] == c) break;
        }
        return len;
    }

    private static int hashCode(char[] name, int start, int len) {
        int hash = 0;
        while (--len >= 0) {
            hash += hashIdentifierMap[name[start + len]];
        }
        return hash;
    }

    static int hashCode(char[] name) {
        return Identifier.hashCode(name, 0, name.length);
    }

    private static int Random() {
        int result;
        while ((result = (seed = seed * 19650323 + 1) >> 3) == 0) {
        }
        return result;
    }

    public int hashCode() {
        return this.hash;
    }

    private static int rehashIdentifiers() {
        int cnt = discreteIdentifierMapCount;
        Identifier[] oldTable = discreteIdentifierMap;
        int oldLength = oldTable.length;
        int newLength = oldLength << 1;
        Identifier[] newTable = new Identifier[newLength];
        int i = 0;
        while (i < oldLength) {
            Identifier id = oldTable[i];
            if (id != null) {
                Identifier nid;
                do {
                    --cnt;
                    nid = id.nextHashed;
                    int hash = id.hash & newLength - 1;
                    id.nextHashed = newTable[hash];
                    newTable[hash] = id;
                } while ((id = nid) != null);
                if (cnt == 0) break;
            }
            ++i;
        }
        discreteIdentifierMap = newTable;
        return newLength;
    }

    private static Identifier lookupIdentifier(char[] name, int start, int len, boolean useName, int hash) {
        int length = discreteIdentifierMap.length;
        int count = discreteIdentifierMapCount;
        if (length < 0x200000 && count > length - (length >> 2)) {
            length = Identifier.rehashIdentifiers();
        }
        discreteIdentifierMapCount = count + 1;
        Identifier identifier = discreteIdentifierMap[hash & length - 1];
        while (identifier != null) {
            if (identifier.hash == hash && identifier.name.length == len && Identifier.compare(name, start, identifier.name, 0, len)) {
                return identifier;
            }
            identifier = identifier.nextHashed;
        }
        if (!useName || start != 0 || len != name.length) {
            char[] buffer = new char[len];
            while (--len >= 0) {
                buffer[len] = name[start + len];
            }
            name = buffer;
        }
        identifier = new Identifier(name, hash);
        identifier.nextHashed = discreteIdentifierMap[hash &= length - 1];
        Identifier.discreteIdentifierMap[hash] = identifier;
        return identifier;
    }

    static Identifier getIdentifier(char[] name, int start, int len, int hash) {
        return Identifier.lookupIdentifier(name, start, len, false, hash);
    }

    static Identifier getIdentifier(char[] name, int start, int end) {
        int len = end - start;
        int hash = Identifier.hashCode(name, start, len);
        return Identifier.lookupIdentifier(name, start, len, true, hash);
    }

    static Identifier getIdentifier(char[] name) {
        int hash = Identifier.hashCode(name);
        return Identifier.lookupIdentifier(name, 0, name.length, true, hash);
    }

    static Identifier getIdentifier(String name) {
        char[] buffer = name.toCharArray();
        int hash = Identifier.hashCode(buffer);
        return Identifier.lookupIdentifier(buffer, 0, buffer.length, true, hash);
    }

    public String toString() {
        return new String(this.name);
    }
}

