/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ClassScope;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.ImportDescriptor;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Symbol;

final class ImportSymbol
extends Symbol {
    static final byte ISF_NONE = 0;
    static final byte ISF_EXPLICITIMPORT = 1;
    static final byte ISF_STATICIMPORT = 2;
    static final byte ISF_ONDEMANDIMPORT = 4;
    static final byte ISF_INNERONDEMANDIMPORT = 8;
    ImportDescriptor importDescriptor;
    Symbol importedSymbol;
    boolean used;
    byte flags;
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    ImportSymbol(int pos, Symbol importedSymbol, ImportDescriptor importDescriptor) {
        super((byte)(importedSymbol.kind | 4), pos, importedSymbol.identifier);
        this.importDescriptor = importDescriptor;
        this.importedSymbol = importedSymbol;
    }

    public String toString() {
        return this.importedSymbol.toString();
    }

    String errorName() {
        return this.importedSymbol.errorName();
    }

    char[] getSignature() {
        return this.importedSymbol.getSignature();
    }

    Symbol importSymbolHidesOtherImport() {
        Symbol symbol = this.nextHashed;
        while (symbol != null) {
            if (symbol.identifier == this.identifier && symbol.kind == this.kind) {
                return symbol;
            }
            symbol = symbol.nextHashed;
        }
        return null;
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = ImportSymbol.class$("oracle.ojc.compiler.ImportSymbol");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    RawClassSymbol getImportSymbolClass() {
        switch (this.importedSymbol.kind) {
            default: {
                if (!$a) {
                    throw new AssertionError();
                }
            }
            case 32: {
                return (RawClassSymbol)this.importedSymbol;
            }
            case 2: {
                return ((FieldSymbol)this.importedSymbol).definingClass;
            }
            case 8: 
        }
        return ((MethodSymbol)this.importedSymbol).definingClass;
    }

    boolean resolveAndCheck(Parser parser, Scope scope) {
        RawClassSymbol classSymbol;
        if (this.importedSymbol instanceof RawClassSymbol && !(classSymbol = (RawClassSymbol)this.importedSymbol).isCompiled()) {
            ClassScope classScope = classSymbol.classScope;
            if (classScope == null) {
                classSymbol.loadType(parser, this.pos, false, true);
            }
            if ((classSymbol.access & 1) == 0 && !classSymbol.isInnerClass()) {
                if (scope != null) {
                    Symbol[] currentImportDeclarations = parser.currentImportDeclarations;
                    int size = currentImportDeclarations.length;
                    int i = 0;
                    while (i < size) {
                        if (currentImportDeclarations[i] == this) {
                            Symbol[] updatedImportDeclarations = new Symbol[--size];
                            int j = 0;
                            while (j < i) {
                                updatedImportDeclarations[j] = currentImportDeclarations[j];
                                ++j;
                            }
                            j = i;
                            while (j < size) {
                                updatedImportDeclarations[j] = currentImportDeclarations[j + 1];
                                ++j;
                            }
                            parser.currentImportDeclarations = updatedImportDeclarations;
                            scope.removeSymbol(this);
                            break;
                        }
                        ++i;
                    }
                }
                this.importDescriptor.importSymbolList.remove(this);
                return false;
            }
            if (classScope == null) {
                this.importDescriptor.importInnerClasses(parser, classSymbol, classSymbol.pos);
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

