/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.ArgumentVariableSymbol;
import oracle.ojc.compiler.AssignmentExpression;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.DynamicInitializationStatement;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.ExpressionStatement;
import oracle.ojc.compiler.FieldExpression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.MethodScope;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.MethodVariableExpression;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.ThisExpression;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeSymbol;

class InnerClassSymbol
extends RawClassSymbol {
    HiddenArgumentList hiddenArgumentList;

    InnerClassSymbol(int pos, Identifier identifier, short access, TypeParameterList typeParameterList, Annotation annotation, boolean compiled) {
        super(pos, identifier, access, typeParameterList, annotation, compiled, false);
    }

    protected void toString(StringBuffer sb) {
        this.getOuterClass().toString(sb);
        sb.append('.');
        sb.append(this.identifier.name);
    }

    boolean isInnerClass() {
        return true;
    }

    boolean isStaticInnerClass() {
        return (this.access & 8) != 0;
    }

    boolean isNonStaticInnerClass() {
        return (this.access & 8) == 0;
    }

    boolean isNonAnonymousInnerClass() {
        return true;
    }

    boolean isAccessible(ClassSymbol fromClass) {
        if (this.equalTo(fromClass)) {
            return true;
        }
        if (fromClass.isInnerClass() && this.getTopLevelClass().equalTo(fromClass.getTopLevelClass())) {
            return true;
        }
        if (this.isInnerClass(fromClass)) {
            return true;
        }
        if ((this.access & 4) != 0) {
            RawClassSymbol thisOuterClass = this.getOuterClass();
            while (true) {
                if (thisOuterClass.isSuperclass(fromClass)) {
                    return true;
                }
                if (fromClass.isInnerClass()) {
                    RawClassSymbol fromOuterClass = fromClass.getOuterClass();
                    while (true) {
                        if (thisOuterClass.isSuperclass(fromOuterClass)) {
                            return true;
                        }
                        if (!fromOuterClass.isInnerClass()) break;
                        fromOuterClass = ((ClassSymbol)fromOuterClass).getOuterClass();
                    }
                }
                if (!thisOuterClass.isInnerClass()) break;
                thisOuterClass = ((ClassSymbol)thisOuterClass).getOuterClass();
            }
        }
        return super.isAccessible(fromClass);
    }

    void fixConstructors(Parser parser) {
        int hiddenArgCount = 0;
        int nonLocals = 0;
        int locals = 0;
        HiddenArgumentList hal = this.hiddenArgumentList;
        while (hal != null) {
            if (hal.kind == 2) {
                locals = (short)(locals + 1);
                hal.stackVarIndex = hal.stackVarIndex;
                if ((hal.type.typeClass & 0x28) != 0) {
                    locals = (short)(locals + 1);
                    hiddenArgCount = (short)(hiddenArgCount + 1);
                }
            } else {
                nonLocals = (short)(nonLocals + 1);
                hal.stackVarIndex = hal.stackVarIndex;
            }
            hiddenArgCount = (short)(hiddenArgCount + 1);
            hal = hal.next;
        }
        if (hiddenArgCount == 0 && this.cd.ccd.dynamicInitializer == null) {
            return;
        }
        hal = this.hiddenArgumentList;
        while (hal != null) {
            if (hal.kind == 2) {
                hal.stackVarIndex = (short)(locals + 1 - hal.stackVarIndex);
            }
            hal = hal.next;
        }
        MethodSymbol constructor = (MethodSymbol)this.classScope.lookupSpecificSymbolInScope(Identifier.initializerIdentifier, 8, true);
        while (constructor != null) {
            StatementList stmtList;
            if (hiddenArgCount > 0) {
                MethodVariableSymbol localVar;
                int i;
                if (nonLocals > 0) {
                    i = 0;
                    while (i < constructor.actualArgCount) {
                        localVar = (MethodVariableSymbol)constructor.cmd.localVariables.get(i);
                        if (localVar != null) {
                            localVar.varStackIndex = (short)(localVar.varStackIndex + nonLocals);
                        }
                        ++i;
                    }
                }
                i = constructor.actualArgCount;
                while (i < constructor.localVarCount) {
                    localVar = (MethodVariableSymbol)constructor.cmd.localVariables.get(i);
                    if (localVar != null) {
                        localVar.varStackIndex = (short)(localVar.varStackIndex + hiddenArgCount);
                    }
                    ++i;
                }
                constructor.localVarCount = (short)(constructor.localVarCount + hiddenArgCount);
                hal = this.hiddenArgumentList;
                while (hal != null) {
                    if (hal.kind == 0 || hal.kind == 1) {
                        constructor.cmd.localVariables.add(1, null);
                    } else {
                        constructor.cmd.localVariables.add(constructor.actualArgCount, null);
                        if ((hal.type.typeClass & 0x28) != 0) {
                            constructor.cmd.localVariables.add(constructor.actualArgCount, null);
                            constructor.actualArgCount = (short)(constructor.actualArgCount + 1);
                        }
                    }
                    constructor.actualArgCount = (short)(constructor.actualArgCount + 1);
                    hal = hal.next;
                }
            }
            if ((stmtList = constructor.cmd.statementList) == null) {
                constructor.cmd.statementList = stmtList = new StatementList();
            }
            if ((constructor.flags & 2) == 0) {
                DynamicInitializationStatement initStmt = null;
                if (this.cd.ccd.dynamicInitializer != null) {
                    initStmt = new DynamicInitializationStatement(stmtList);
                    if (stmtList.first == null) {
                        stmtList.add(initStmt);
                    } else {
                        stmtList.first.insertAfter(initStmt);
                    }
                }
                hal = this.hiddenArgumentList;
                while (hal != null) {
                    hal.type = hal.type.resolveType(parser, 0, true, false, false);
                    if (hal.kind != 1 && (hal.kind != 2 || hal.fieldSymbol != null)) {
                        Expression expr = new ThisExpression(0, this);
                        expr.setType(this);
                        expr = new FieldExpression(0, hal.fieldSymbol, expr);
                        expr.setType(hal.fieldSymbol.type);
                        short varStackIndex = hal.kind == 2 ? (short)(constructor.actualArgCount - hal.stackVarIndex) : hal.stackVarIndex;
                        ArgumentVariableSymbol arg = new ArgumentVariableSymbol(0, constructor, null, hal.type, 0, 0, null, varStackIndex);
                        expr = new AssignmentExpression(this.pos, expr, new MethodVariableExpression(0, arg));
                        ExpressionStatement statement = new ExpressionStatement(stmtList, 0, expr);
                        int size = this.cd.fieldCount + constructor.localVarCount;
                        parser.defSet = new BitSet(size);
                        parser.posSet = new BitSet(size);
                        parser.useSet = new BitSet(size);
                        parser.suspendDataFlowChecking = true;
                        parser.currentMethodSymbol = constructor;
                        ((Statement)statement).resolveAndCheck(parser);
                        if (stmtList.first == null) {
                            stmtList.add(statement);
                        } else {
                            stmtList.first.insertBefore(statement);
                        }
                    }
                    hal = hal.next;
                }
            }
            constructor = constructor.nextWithSameName;
        }
        parser.defSet = null;
        parser.posSet = null;
        parser.useSet = null;
        parser.currentMethodSymbol = null;
    }

    String errorName() {
        if (this.scope == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.getOuterClass().errorName());
        buf.append('.');
        buf.append(this.identifier.name);
        return buf.toString();
    }

    void addHiddenOuterThisArgument(TypeSymbol type, FieldSymbol fieldSymbol) {
        HiddenArgumentList hal = new HiddenArgumentList(0, type);
        hal.fieldSymbol = fieldSymbol;
        hal.next = this.hiddenArgumentList;
        this.hiddenArgumentList = hal;
    }

    void addHiddenSuperOuterThisArgument(InnerClassSymbol innerClass) {
        HiddenArgumentList hal = new HiddenArgumentList(1, innerClass.getOuterClass());
        if (this.hiddenArgumentList == null) {
            this.hiddenArgumentList = hal;
        } else if (this.hiddenArgumentList.kind == 0) {
            hal.next = this.hiddenArgumentList.next;
            this.hiddenArgumentList.next = hal;
        } else {
            hal.next = this.hiddenArgumentList;
            this.hiddenArgumentList = hal;
        }
    }

    void addHiddenFinalLocalArgument(MethodVariableSymbol localVar, FieldSymbol fieldSymbol) {
        HiddenArgumentList hal = new HiddenArgumentList(2, localVar.type);
        hal.localVar = localVar;
        hal.fieldSymbol = fieldSymbol;
        if (this.hiddenArgumentList == null) {
            this.hiddenArgumentList = hal;
        } else {
            HiddenArgumentList al = this.hiddenArgumentList;
            while (al.next != null) {
                al = al.next;
            }
            al.next = hal;
        }
    }

    boolean hasHiddenOuterThisArgument() {
        HiddenArgumentList hal = this.hiddenArgumentList;
        while (hal != null) {
            if (hal.kind == 0) {
                return true;
            }
            hal = hal.next;
        }
        return false;
    }

    MethodSymbol getEnclosingMethod() {
        if (this.scope.kind < 3) {
            return null;
        }
        Scope scp = this.scope;
        while (scp.kind != 3) {
            scp = scp.getOuterScope();
        }
        return ((MethodScope)scp).methodSymbol;
    }

    static final class HiddenArgumentList {
        static final byte HA_OUTER_THIS = 0;
        static final byte HA_SUPER_OUTER_THIS = 1;
        static final byte HA_FINAL_LOCAL = 2;
        HiddenArgumentList next;
        byte kind;
        short stackVarIndex;
        TypeSymbol type;
        FieldSymbol fieldSymbol;
        MethodVariableSymbol localVar;

        HiddenArgumentList(byte kind, TypeSymbol type) {
            this.kind = kind;
            this.type = type;
        }
    }
}

