/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.TypeSymbol;

final class InstanceOfExpression
extends Expression {
    Expression instance;
    TypeSymbol ofType;

    InstanceOfExpression(int pos, Expression instance, TypeSymbol ofType) {
        super((byte)28, pos);
        this.instance = instance;
        this.ofType = ofType;
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol toType;
        this.instance = this.instance.resolveAndCheck(parser);
        TypeSymbol fromType = this.instance.getType();
        this.ofType = toType = this.ofType.resolveType(parser, this.pos, true, true, true);
        if (fromType.isPrimitiveType()) {
            Error error = parser.error(Message.errorObjectOrArrayRequired, this.pos, fromType.isErroneous(), fromType.errorName());
            return new ErrorExpression(error);
        }
        if (toType.isPrimitiveType()) {
            Error error = parser.error(Message.errorObjectOrArrayRequired, this.pos, toType.isErroneous(), toType.errorName());
            return new ErrorExpression(error);
        }
        toType.resolveType(parser, this.pos, false, true, true);
        toType.checkDeprecated(parser, this.pos);
        ReferenceTypeSymbol fromRefSymbol = (ReferenceTypeSymbol)fromType;
        ReferenceTypeSymbol toRefSymbol = (ReferenceTypeSymbol)toType;
        if (fromType.isParameterizedClass()) {
            ParameterizedClassSymbol pcs = (ParameterizedClassSymbol)fromType;
            if (pcs.typeVariableList != null) {
                fromRefSymbol = ParameterizedClassSymbol.getParameterizedClassSymbol(pcs.genericClassSymbol, null, pcs.outerClassSymbol);
            }
        }
        if (!fromRefSymbol.isCastCompatible(parser, toRefSymbol) && !fromRefSymbol.isCastCompatible(parser, (ReferenceTypeSymbol)(toType = toType.resolveType(parser, this.pos, true, true, false)))) {
            Error error = parser.error(Message.errorCannotCompare, this.pos, fromType.isErroneous() | toType.isErroneous(), fromType.errorName(), toType.errorName());
            return new ErrorExpression(error);
        }
        if (!toRefSymbol.isReifiable()) {
            parser.error(Error.errorNoTypeParametersAllowed, this.pos, toRefSymbol.isErroneous(), toRefSymbol.errorName());
        } else if (toRefSymbol.isTypeParameter()) {
            parser.error(Error.errorIllegalTypeParameterOperator, this.pos, false, this.toString());
        }
        this.setType(TypeSymbol.booleanSymbol);
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        this.instance.generateByteCode(byteCodeGenerator);
        short index = byteCodeGenerator.constantPool.enterConstantPoolClass(this.ofType.getInternalName());
        byteCodeGenerator.generate_8_16((byte)-63, index);
        if (this.ofType.isClass()) {
            RawClassSymbol ofClass = ((ClassSymbol)this.ofType).getClassSymbol();
            byteCodeGenerator.constantPool.checkForOutOfPackageInnerClass(byteCodeGenerator.parser.currentClassSymbol, ofClass);
        }
    }

    public String toString() {
        return "instanceof";
    }
}

