/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.Message;
import oracle.ojc.interfaces.ErrorInfo;
import oracle.ojc.interfaces.Log;
import oracle.ojc.interfaces.Log2;
import oracle.ojc.interfaces.Storage;

class LogProxy
implements Log2 {
    private Log log;
    private Log2 log2;

    LogProxy(Log log) {
        this.log = log;
        this.log2 = log instanceof Log2 ? (Log2)log : null;
    }

    Log getLog() {
        return this.log;
    }

    public void printError(String errorMessage) {
        if (this.log2 != null) {
            this.log2.printError(errorMessage);
        } else {
            this.log.println(Message.errorColonString + errorMessage);
        }
    }

    public void printWarning(String warningMessage) {
        if (this.log2 != null) {
            this.log2.printWarning(warningMessage);
        } else {
            this.log.println(Message.warningColonString + warningMessage);
        }
    }

    public void redirect(String fileName) {
        this.log.redirect(fileName);
    }

    public void print(String string) {
        this.log.print(string);
    }

    public void println(String line) {
        this.log.println(line);
    }

    public void printError(Storage source, int pos, ErrorInfo info) {
        this.log.printError(source, pos, info);
    }

    public void printWarning(Storage source, int pos, ErrorInfo info) {
        this.log.printWarning(source, pos, info);
    }

    public int nerrors() {
        return this.log.nerrors();
    }

    public int nwarnings() {
        return this.log.nwarnings();
    }
}

