/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LogicalBinaryExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;

final class LogicalAndExpression
extends LogicalBinaryExpression {
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    LogicalAndExpression(int pos, Expression leftOperand, Expression rightOperand) {
        super((byte)18, pos, leftOperand, rightOperand);
    }

    Expression foldExpression() {
        Expression leftOp = this.leftOperand;
        Expression rightOp = this.rightOperand;
        if (leftOp.kind == 2 && rightOp.kind == 2) {
            return new BooleanConstantExpression(this.pos, ((BooleanConstantExpression)leftOp).bval & ((BooleanConstantExpression)rightOp).bval);
        }
        return this;
    }

    Expression resolveAndCheck(Parser parser) {
        Expression leftOp = this.leftOperand;
        leftOp = leftOp.resolveAndCheck(parser);
        TypeSymbol leftOpType = leftOp.getType();
        BitSet leftDefSet = (BitSet)parser.defSet.clone();
        boolean savedSuspendDataFlowChecking = parser.suspendDataFlowChecking;
        if (leftOp.isConstantBooleanExpression() && !leftOp.getConstantBooleanExpressionValue()) {
            parser.suspendDataFlowChecking = true;
        }
        if (leftOp.isLogicalExpression()) {
            parser.defSet = (BitSet)leftOp.getLogicalExpressionTrueDefSet().clone();
        }
        Expression rightOp = this.rightOperand;
        rightOp = rightOp.resolveAndCheck(parser);
        TypeSymbol rightOpType = rightOp.getType();
        parser.suspendDataFlowChecking = savedSuspendDataFlowChecking;
        TypeSymbol typeSymbol = TypeSymbol.booleanSymbol;
        this.setType(typeSymbol);
        if (leftOpType.typeKind != 2 || rightOpType.typeKind != 2) {
            if (parser.options.sourceJDKVersion >= 150 && (leftOpType == TypeSymbol.booleanSymbol || leftOpType.equalTo(parser.javaLangBooleanSymbol)) && (rightOpType == TypeSymbol.booleanSymbol || rightOpType.equalTo(parser.javaLangBooleanSymbol))) {
                rightOp = rightOp.promoteType(parser, TypeSymbol.booleanSymbol);
                leftOp = leftOp.promoteType(parser, TypeSymbol.booleanSymbol);
            } else {
                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, rightOpType.isErroneous() | leftOpType.isErroneous(), this.toString(), leftOpType.errorName() + " " + Message.andString + " " + rightOpType.errorName());
                return new ErrorExpression(error);
            }
        }
        if (leftOp.isLogicalExpression()) {
            this.trueDefSet = (BitSet)leftOp.getLogicalExpressionTrueDefSet().clone();
            if (rightOp.isLogicalExpression()) {
                this.trueDefSet.or(rightOp.getLogicalExpressionTrueDefSet());
            } else {
                this.trueDefSet.or(parser.defSet);
            }
        } else {
            this.trueDefSet = (BitSet)parser.defSet.clone();
            if (rightOp.isLogicalExpression()) {
                this.trueDefSet.or(rightOp.getLogicalExpressionTrueDefSet());
            }
        }
        if (leftOp.isLogicalExpression()) {
            this.falseDefSet = (BitSet)leftOp.getLogicalExpressionFalseDefSet().clone();
            if (rightOp.isLogicalExpression()) {
                BitSet rightDefSet = (BitSet)leftOp.getLogicalExpressionTrueDefSet().clone();
                rightDefSet.or(rightOp.getLogicalExpressionFalseDefSet());
                this.falseDefSet.and(rightDefSet);
            } else {
                this.falseDefSet.and(parser.defSet);
            }
        } else {
            this.falseDefSet = (BitSet)leftDefSet.clone();
            if (rightOp.isLogicalExpression()) {
                this.falseDefSet.and(rightOp.getLogicalExpressionFalseDefSet());
            }
        }
        if (leftOp.isConstantBooleanExpression()) {
            if (leftOp.getConstantBooleanExpressionValue()) {
                return rightOp;
            }
            parser.defSet = leftDefSet;
            return leftOp;
        }
        if (rightOp.kind == 2 && ((BooleanConstantExpression)rightOp).bval) {
            parser.defSet = leftDefSet;
            return leftOp;
        }
        parser.defSet = leftDefSet;
        this.rightOperand = rightOp;
        this.leftOperand = leftOp;
        return this;
    }

    boolean isConstantBooleanExpression() {
        if (this.rightOperand.isConstantBooleanExpression()) {
            if (!this.rightOperand.getConstantBooleanExpressionValue()) {
                return true;
            }
            if (this.leftOperand.isConstantBooleanExpression() && this.leftOperand.getConstantBooleanExpressionValue()) {
                return true;
            }
        } else if (this.leftOperand.isConstantBooleanExpression() && !this.leftOperand.getConstantBooleanExpressionValue()) {
            return true;
        }
        return false;
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = LogicalAndExpression.class$("oracle.ojc.compiler.LogicalAndExpression");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    boolean getConstantBooleanExpressionValue() {
        if (!$a && !this.isConstantBooleanExpression()) {
            throw new AssertionError();
        }
        if (this.rightOperand.isConstantBooleanExpression() && !this.rightOperand.getConstantBooleanExpressionValue()) {
            return false;
        }
        return !this.leftOperand.isConstantBooleanExpression() || this.leftOperand.getConstantBooleanExpressionValue();
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        Label falseLabel = new Label();
        this.leftOperand.generateByteCodeBranch(byteCodeGenerator, falseLabel, true);
        this.rightOperand.generateByteCodeBranch(byteCodeGenerator, falseLabel, true);
        byteCodeGenerator.generate_8((byte)4);
        byteCodeGenerator.generate_8_16((byte)-89, (short)4);
        byteCodeGenerator.setLabel(falseLabel);
        byteCodeGenerator.generate_8((byte)3);
        byteCodeGenerator.incOpStackHeight(1);
    }

    void generateByteCodeBranch(ByteCodeGenerator byteCodeGenerator, Label label, boolean branchIfFalse) {
        if (branchIfFalse) {
            this.leftOperand.generateByteCodeBranch(byteCodeGenerator, label, true);
            this.rightOperand.generateByteCodeBranch(byteCodeGenerator, label, true);
        } else {
            Label falseLabel = new Label();
            this.leftOperand.generateByteCodeBranch(byteCodeGenerator, falseLabel, true);
            this.rightOperand.generateByteCodeBranch(byteCodeGenerator, label, false);
            byteCodeGenerator.setLabel(falseLabel);
        }
    }

    public String toString() {
        return "&&";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

