/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.TypeSymbol;

final class LongConstantExpression
extends ConstantExpression {
    long lval;

    LongConstantExpression(int pos, long lval) {
        super(pos, TypeSymbol.longSymbol);
        this.lval = lval;
    }

    Expression copyConstantExpression(int newPos) {
        return new LongConstantExpression(newPos, this.lval);
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        long lval = this.lval;
        if (lval < (long)-128 || (long)127 < lval) {
            short index = byteCodeGenerator.constantPool.enterConstantPoolLong(lval);
            byteCodeGenerator.generate_8_16((byte)20, index);
        } else {
            switch ((int)lval) {
                default: {
                    byteCodeGenerator.generate_8_8_8((byte)16, (byte)lval, (byte)-123);
                    break;
                }
                case 0: 
                case 1: {
                    byteCodeGenerator.generate_8((byte)((long)9 + lval));
                    break;
                }
                case -1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    byteCodeGenerator.generate_8_8((byte)((long)3 + lval), (byte)-123);
                    break;
                }
            }
        }
        byteCodeGenerator.incOpStackHeight(2);
    }
}

