/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.DoubleConstantExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FloatConstantExpression;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.UnaryExpression;

final class NegateExpression
extends UnaryExpression {
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    NegateExpression(int pos, Expression operand) {
        super((byte)39, pos, operand);
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = NegateExpression.class$("oracle.ojc.compiler.NegateExpression");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    Expression foldExpression() {
        Expression op = this.operand;
        if (op.kind == 2) {
            TypeSymbol typeSymbol = op.getType();
            switch (typeSymbol.typeClass) {
                default: {
                    if (!$a) {
                        throw new AssertionError();
                    }
                }
                case 4: {
                    return new IntConstantExpression(this.pos, this.getType(), -((ConstantExpression)op).getIntConstValue());
                }
                case 8: {
                    return new LongConstantExpression(this.pos, -((LongConstantExpression)op).lval);
                }
                case 16: {
                    return new FloatConstantExpression(this.pos, -((FloatConstantExpression)op).fval);
                }
                case 32: 
            }
            return new DoubleConstantExpression(this.pos, -((DoubleConstantExpression)op).dval);
        }
        return this;
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol primitiveType;
        Expression op = this.operand.resolveAndCheck(parser);
        TypeSymbol typeSymbol = op.getType();
        if (!(typeSymbol.isNumericType() || parser.options.sourceJDKVersion >= 150 && typeSymbol.isReferenceType() && (primitiveType = BoxingExpression.getPrimitiveType(parser, typeSymbol)) != null && primitiveType.isNumericType())) {
            Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, typeSymbol.isErroneous(), this.toString(), typeSymbol.errorName());
            return new ErrorExpression(error);
        }
        typeSymbol = TypeSymbol.unaryNumericPromotion(parser, typeSymbol);
        this.setType(typeSymbol);
        this.operand = op.promoteType(parser, typeSymbol);
        return this.foldExpression();
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        this.operand.generateByteCode(byteCodeGenerator);
        switch (this.getType().typeClass) {
            default: {
                if (!$a) {
                    throw new AssertionError();
                }
            }
            case 4: {
                byteCodeGenerator.generate_8((byte)116);
                break;
            }
            case 8: {
                byteCodeGenerator.generate_8((byte)117);
                break;
            }
            case 16: {
                byteCodeGenerator.generate_8((byte)118);
                break;
            }
            case 32: {
                byteCodeGenerator.generate_8((byte)119);
                break;
            }
        }
    }

    public String toString() {
        return "-";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

