/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import oracle.ojc.compiler.Compiler;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.LogProxy;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.PackageScope;
import oracle.ojc.compiler.PackageSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Warning;
import oracle.ojc.interfaces.IdeEnv;
import oracle.ojc.interfaces.Log;
import oracle.ojc.interfaces.Log2;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.FileStorage;
import oracle.ojc.storage.JarStorage;

public class Options {
    public static final int JDK_1_1_0 = 110;
    public static final int JDK_1_2_0 = 120;
    public static final int JDK_1_3_0 = 130;
    public static final int JDK_1_4_0 = 140;
    public static final int JDK_1_5_0 = 150;
    public static final int JDK_1_6_0 = 160;
    public static final int JDK_1_7_0 = 170;
    static final String ENCLOSING_STORAGE = "enclosing_storage";
    public Log log;
    LogProxy logProxy;
    public IdeEnv ideEnv;
    public int sourceJDKVersion;
    public int targetJDKVersion;
    boolean sourceTargetJDKDefault;
    int javaLangObjectJDKVersion;
    String fileSeparator;
    String pathSeparator;
    String prependBootClasspathStr;
    public String bootClasspathStr;
    String appendBootClasspathStr;
    String endorseddirsStr;
    String extdirsStr;
    public String classpathStr;
    public Storage[] classpathStorage;
    public String sourcepathStr;
    public Storage[] sourcepathStorage;
    Storage[] bootClasspath;
    Storage[] endorseddirs;
    Storage[] extdirs;
    Storage[] classpath;
    Storage[] sourcepath;
    String[] deployExtensions;
    public ArrayList excludeClasses;
    public Storage makeFile;
    public String destinationDir;
    Storage destinationFile;
    public String encoding;
    char[][] tagNameList;
    int messageLimit;
    int errorLimit;
    int warningLimit;
    boolean noCodeGeneration;
    boolean helpPrinted;
    public boolean verbose;
    boolean verbosepath;
    public boolean noquiet;
    public boolean lineNumbers;
    public boolean sourceFile;
    public boolean localVariables;
    public boolean codecoach;
    public boolean omitAssertions;
    public boolean selfDeprecation;
    boolean strictfpmethods;
    boolean elapsedTime;
    boolean noWarnings;
    boolean warningsAreErrors;
    public boolean rebuild;
    public boolean generateClassesDespiteErrors;
    public boolean lineColumnInfo;
    public boolean addNameReferences;
    private static Map supportedOptionsTable;
    private List jarStorageList;
    boolean errorFound;
    private boolean ignoreManifests;
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    public Options(Log log) {
        this.log = log;
        this.logProxy = new LogProxy(log);
        this.sourceTargetJDKDefault = true;
        this.targetJDKVersion = 150;
        this.sourceJDKVersion = 150;
        this.fileSeparator = System.getProperty("file.separator");
        this.pathSeparator = System.getProperty("path.separator");
        this.encoding = Options.getDefaultEncoding();
        this.lineNumbers = true;
        this.sourceFile = true;
        this.localVariables = false;
        this.messageLimit = 1000;
        this.warningLimit = Integer.MAX_VALUE;
        this.errorLimit = Integer.MAX_VALUE;
        this.jarStorageList = new ArrayList(60);
        this.errorFound = false;
        this.ignoreManifests = false;
    }

    private void listFiles(ArrayList al, Storage storage, String fileExtension, boolean returnStorage) {
        ArrayList files = storage.listStorage();
        if (files != null) {
            int size;
            int i = size = files.size();
            while (--i >= 0) {
                Storage file = (Storage)files.get(i);
                String name = file.getName();
                if (fileExtension != null && !name.endsWith(fileExtension)) continue;
                if (returnStorage) {
                    al.add(file);
                    continue;
                }
                name = name.substring(0, name.indexOf(46));
                al.add(Identifier.getIdentifier(name));
            }
        }
    }

    private ArrayList findInPackage(Storage[] storage, String fileExtension) {
        if (storage == null) {
            return null;
        }
        ArrayList al = new ArrayList(20);
        int i = 0;
        while (i < storage.length) {
            this.listFiles(al, storage[i], fileExtension, false);
            ++i;
        }
        return al;
    }

    ArrayList findClassesInPackage(PackageSymbol packageSymbol) {
        return this.findInPackage(packageSymbol.classStorage, ".class");
    }

    ArrayList findSourcesInPackage(PackageSymbol packageSymbol) {
        return this.findInPackage(packageSymbol.sourceStorage, ".java");
    }

    ArrayList findSourcesInPackage(Parser parser, String packageName) {
        PackageSymbol packageSymbol = PackageSymbol.getPackageSymbol(parser, packageName);
        Storage[] sourceStorage = packageSymbol.sourceStorage;
        if (sourceStorage == null) {
            return null;
        }
        ArrayList al = new ArrayList(20);
        int i = 0;
        while (i < sourceStorage.length) {
            this.listFiles(al, sourceStorage[i], null, true);
            ++i;
        }
        return al.size() == 0 ? null : al;
    }

    Storage findStorageOfClass(String className) {
        return null;
    }

    Storage findStorageOfClass(RawClassSymbol classSymbol) {
        String signature = new String(classSymbol.getInternalName());
        int index = signature.lastIndexOf(47);
        String className = index < 0 ? signature + ".class" : signature.substring(index + 1) + ".class";
        PackageScope packageScope = (PackageScope)classSymbol.getPackageScope();
        PackageSymbol packageSymbol = packageScope.packageSymbol;
        Storage[] classStorage = packageSymbol == null ? this.classpath : packageSymbol.classStorage;
        if (classStorage == null) {
            return null;
        }
        int i = 0;
        while (i < classStorage.length) {
            Storage storage = classStorage[i].open(className);
            if (storage != null) {
                return storage;
            }
            ++i;
        }
        return null;
    }

    Storage findStorageOfSource(RawClassSymbol classSymbol) {
        String signature = new String(classSymbol.getInternalName());
        int index = signature.lastIndexOf(47);
        String className = index < 0 ? signature + ".java" : signature.substring(index + 1) + ".java";
        PackageScope packageScope = (PackageScope)classSymbol.getPackageScope();
        PackageSymbol packageSymbol = packageScope.packageSymbol;
        Storage[] sourceStorage = packageSymbol == null ? this.sourcepath : packageSymbol.sourceStorage;
        if (sourceStorage == null) {
            return null;
        }
        int i = 0;
        while (i < sourceStorage.length) {
            Storage storage = sourceStorage[i].open(className);
            if (storage != null) {
                return storage;
            }
            ++i;
        }
        return null;
    }

    void findSourceStorageForPackage(PackageSymbol packageSymbol) {
        int size;
        ArrayList<Storage> al = new ArrayList<Storage>();
        String packageName = packageSymbol.identifier.toString();
        PackageSymbol outerPackageSymbol = packageSymbol.getOuterPackage();
        Storage[] sourceStorage = outerPackageSymbol == null ? this.sourcepath : outerPackageSymbol.sourceStorage;
        if (sourceStorage != null) {
            int i = 0;
            while (i < sourceStorage.length) {
                Storage storage = sourceStorage[i].open(packageName);
                if (storage != null && storage.isDirectory()) {
                    al.add(storage);
                }
                ++i;
            }
        }
        if ((size = al.size()) > 0) {
            packageSymbol.sourceStorage = al.toArray(new Storage[size]);
        }
    }

    void findClassStorageForPackage(PackageSymbol packageSymbol) {
        int size;
        ArrayList<Storage> al = new ArrayList<Storage>();
        String packageName = packageSymbol.identifier.toString() + '/';
        PackageSymbol outerPackageSymbol = packageSymbol.getOuterPackage();
        if (outerPackageSymbol == null) {
            Storage storage;
            int i;
            if (this.targetJDKVersion >= 120) {
                if (this.endorseddirs != null) {
                    i = 0;
                    while (i < this.endorseddirs.length) {
                        storage = this.endorseddirs[i].open(packageName);
                        if (storage != null && storage.isDirectory()) {
                            al.add(storage);
                        }
                        ++i;
                    }
                }
                if (this.bootClasspath != null) {
                    i = 0;
                    while (i < this.bootClasspath.length) {
                        storage = this.bootClasspath[i].open(packageName);
                        if (storage != null && storage.isDirectory()) {
                            al.add(storage);
                        }
                        ++i;
                    }
                }
            }
            if (this.extdirs != null) {
                i = 0;
                while (i < this.extdirs.length) {
                    storage = this.extdirs[i].open(packageName);
                    if (storage != null && storage.isDirectory()) {
                        al.add(storage);
                    }
                    ++i;
                }
            }
            if (this.classpath != null) {
                i = 0;
                while (i < this.classpath.length) {
                    storage = this.classpath[i].open(packageName);
                    if (storage != null && storage.isDirectory()) {
                        al.add(storage);
                    }
                    ++i;
                }
            }
            if (this.targetJDKVersion == 110 && this.bootClasspath != null) {
                i = 0;
                while (i < this.bootClasspath.length) {
                    storage = this.bootClasspath[i].open(packageName);
                    if (storage != null && storage.isDirectory()) {
                        al.add(storage);
                    }
                    ++i;
                }
            }
        } else {
            Storage[] classStorage = outerPackageSymbol.classStorage;
            if (classStorage != null) {
                int i = 0;
                while (i < classStorage.length) {
                    Storage storage = classStorage[i].open(packageName);
                    if (storage != null && storage.isDirectory()) {
                        al.add(storage);
                    }
                    ++i;
                }
            }
        }
        if ((size = al.size()) > 0) {
            packageSymbol.classStorage = al.toArray(new Storage[size]);
        }
    }

    public static String[] stringToArray(String s, String separator) {
        if (s == null) {
            return null;
        }
        int index = 0;
        int cnt = 0;
        while (true) {
            ++cnt;
            if ((index = s.indexOf(separator, index)) < 0) break;
            ++index;
        }
        if (cnt == 0) {
            return null;
        }
        String[] result = new String[cnt];
        int lastIndex = 0;
        cnt = 0;
        while (true) {
            if ((index = s.indexOf(separator, lastIndex)) < 0) break;
            result[cnt++] = s.substring(lastIndex, index);
            lastIndex = index + 1;
        }
        result[cnt] = s.substring(lastIndex);
        return result;
    }

    protected Storage[] makeClassPath(String pathList, String pathKind, boolean warn, boolean expand) {
        String[] as = Options.stringToArray(pathList, this.pathSeparator);
        if (as == null) {
            return null;
        }
        int size = as.length;
        ArrayList list = new ArrayList(size + 10);
        HashSet set = new HashSet(size + 10);
        int i = 0;
        while (i < size) {
            String dirname = as[i];
            if (dirname != null && dirname.length() > 0) {
                File dirfile = new File(dirname);
                this.addClassPathItemToList(pathKind, warn, expand, list, set, dirname, dirfile, null);
            }
            ++i;
        }
        return list.toArray(new Storage[list.size()]);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addClassPathItemToList(String pathKind, boolean warn, boolean expand, ArrayList list, HashSet set, String dirname, File dirfile, Storage enclosingStorage) {
        if (dirname.indexOf("..") >= 0) {
            try {
                dirname = dirfile.getCanonicalPath();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (set.contains(dirname)) {
            return;
        }
        if (this.verbosepath) {
            this.log.println("Dynamically adding entry to classpath: " + dirname);
        }
        set.add(dirname);
        if (!dirfile.exists()) {
            if (!warn) return;
            Warning warning = new Warning(null, Message.warningDirectoryDoesntExist, 0, dirname, pathKind);
            int messageNumber = Message.warningDirectoryDoesntExist.getNumber();
            if (messageNumber < Warning.warnings.size() && !Warning.warnings.get(messageNumber)) return;
            this.getLog().printWarning("#" + warning.message.getNumber() + " " + warning.message.getMessage());
            if (!this.warningsAreErrors) return;
            this.errorFound = true;
            return;
        }
        if (dirname.endsWith(".zip") || dirname.endsWith(".jar")) {
            JarFile jarFile;
            block21: {
                String cp;
                Attributes mainAttrs;
                Manifest manifest;
                JarStorage jarStorage = new JarStorage(dirfile);
                if (enclosingStorage != null) {
                    jarStorage.setProperty(ENCLOSING_STORAGE, enclosingStorage);
                }
                this.jarStorageList.add(jarStorage);
                list.add(jarStorage);
                if (this.ignoreManifests) return;
                jarFile = null;
                jarFile = new JarFile(dirfile);
                if (jarFile == null || (manifest = jarFile.getManifest()) == null || (mainAttrs = manifest.getMainAttributes()) == null || (cp = mainAttrs.getValue(Attributes.Name.CLASS_PATH)) == null) break block21;
                File dir = dirfile.getParentFile();
                StringTokenizer st = new StringTokenizer(cp);
                while (st.hasMoreTokens()) {
                    String cpItemStr = st.nextToken();
                    File cpItem = new File(dir, cpItemStr);
                    this.addClassPathItemToList(pathKind, false, expand, list, set, cpItem.getAbsolutePath(), cpItem, jarStorage);
                }
            }
            Object var30_21 = null;
            if (jarFile == null) return;
            try {
                jarFile.close();
                return;
            }
            catch (IOException e2) {}
            return;
            {
                catch (IOException e) {
                    this.getLog().printError(dirname + ": " + e.getLocalizedMessage());
                    Object var30_22 = null;
                    if (jarFile == null) return;
                    try {
                        jarFile.close();
                        return;
                    }
                    catch (IOException e2) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var30_23 = null;
                if (jarFile == null) throw throwable;
                try {
                    jarFile.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (expand) {
            if (!dirfile.isDirectory()) return;
            DirectoryStorage storage = new DirectoryStorage(dirfile);
            ArrayList ds = storage.listStorage();
            int len = ds.size();
            int j = 0;
            while (j < len) {
                String name = ((Storage)ds.get(j)).getPath();
                if (name.endsWith(".zip") || name.endsWith(".jar")) {
                    File file = new File(name);
                    this.addClassPathItemToList(pathKind, warn, expand, list, set, name, file, null);
                }
                ++j;
            }
            return;
        } else {
            if (!dirfile.isDirectory()) return;
            list.add(new DirectoryStorage(dirfile));
        }
    }

    public static String getDefaultEncoding() {
        return Options.getEncoding("default");
    }

    public static String getEncoding(String newEncoding) {
        if (newEncoding == null || newEncoding.equals("null")) {
            return null;
        }
        if (newEncoding.equalsIgnoreCase("default")) {
            String encoding = System.getProperty("file.encoding", "8859_1");
            if (encoding != null && encoding.equals("ISO8859_1")) {
                return null;
            }
            return encoding;
        }
        return newEncoding;
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = Options.class$("oracle.ojc.compiler.Options");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    static String JDKVersionToString(int version) {
        switch (version) {
            default: {
                if (!$a) {
                    throw new AssertionError();
                }
            }
            case 110: {
                return "1.1";
            }
            case 120: {
                return "1.2";
            }
            case 130: {
                return "1.3";
            }
            case 140: {
                return "1.4";
            }
            case 150: {
                return "1.5";
            }
            case 160: {
                return "1.6";
            }
            case 170: 
        }
        return "1.7";
    }

    boolean checkSourceTargetVersions() {
        switch (this.sourceJDKVersion) {
            default: {
                return true;
            }
            case 140: 
            case 150: 
            case 160: 
            case 170: 
        }
        if (this.targetJDKVersion >= this.sourceJDKVersion) {
            return true;
        }
        Error error = new Error(null, Message.errorIncompatibleSourceTargetVersion, 0, Options.JDKVersionToString(this.targetJDKVersion), Options.JDKVersionToString(this.sourceJDKVersion));
        this.getLog().printError(error.message.getMessage());
        return false;
    }

    public int parseOption(String[] args, int index) {
        String arg = args[index].trim();
        if (arg.startsWith("-g")) {
            if (arg.equals("-g")) {
                this.localVariables = true;
                this.sourceFile = true;
                this.lineNumbers = true;
            } else if (arg.equals("-g:none")) {
                this.sourceFile = false;
                this.lineNumbers = false;
                this.localVariables = false;
            } else {
                if (arg.indexOf("lines") > 0) {
                    this.lineNumbers = true;
                }
                if (arg.indexOf("source") > 0) {
                    this.sourceFile = true;
                }
                if (arg.indexOf("vars") > 0) {
                    this.localVariables = true;
                }
            }
            return 1;
        }
        if (arg.equals("-nowarn")) {
            this.noWarnings = true;
            Warning.disableAllWarnings();
            return 1;
        }
        if (arg.equals("-verbose")) {
            this.verbose = true;
            this.verbosepath = true;
            return 1;
        }
        if (arg.startsWith("-deprecation")) {
            if (arg.endsWith(":self")) {
                this.selfDeprecation = true;
            }
            Warning.enableWarning(Message.warningIsDeprecated.getNumber());
            return 1;
        }
        if (arg.equals("-classpath") || arg.equals("-cp")) {
            if (index + 1 >= args.length) {
                Error error = new Error(null, Message.errorMissingPathnameList, 0, arg);
                this.getLog().printError(error.message.getMessage());
                return 0;
            }
            this.classpathStr = args[index + 1].trim();
            return 2;
        }
        if (arg.equals("-sourcepath")) {
            if (index + 1 >= args.length) {
                Error error = new Error(null, Message.errorMissingPathnameList, 0, arg);
                this.getLog().printError(error.message.getMessage());
                return 0;
            }
            this.sourcepathStr = args[index + 1].trim();
            return 2;
        }
        if (arg.equals("-bootclasspath") || arg.equals("-sysclasspath")) {
            if (index + 1 >= args.length) {
                Error error = new Error(null, Message.errorMissingPathnameList, 0, arg);
                this.getLog().printError(error.message.getMessage());
                return 0;
            }
            this.bootClasspathStr = args[index + 1].trim();
            return 2;
        }
        if (arg.equals("-extdirs")) {
            if (index + 1 >= args.length) {
                Error error = new Error(null, Message.errorMissingPathnameList, 0, arg);
                this.getLog().printError(error.message.getMessage());
                return 0;
            }
            this.extdirsStr = args[index + 1].trim();
            return 2;
        }
        if (arg.equals("-endorseddirs")) {
            if (index + 1 >= args.length) {
                Error error = new Error(null, Message.errorMissingPathnameList, 0, arg);
                this.getLog().printError(error.message.getMessage());
                return 0;
            }
            this.endorseddirsStr = args[index + 1].trim();
            return 2;
        }
        if (arg.equals("-d")) {
            if (index + 1 >= args.length) {
                Error error = new Error(null, Message.errorMissingDirectoryName, 0, arg);
                this.getLog().printError(error.message.getMessage());
                return 0;
            }
            this.destinationDir = args[index + 1].trim();
            if (!this.destinationDir.endsWith(this.fileSeparator)) {
                this.destinationDir = this.destinationDir + this.fileSeparator;
            }
            return 2;
        }
        if (arg.equals("-encoding")) {
            if (index + 1 >= args.length) {
                Error error = new Error(null, Message.errorMissingEncoding, 0, arg);
                this.getLog().printError(error.message.getMessage());
                return 0;
            }
            this.encoding = Options.getEncoding(args[index + 1].trim());
            return 2;
        }
        if (arg.equals("-source")) {
            if (index + 1 >= args.length) {
                Error error = new Error(null, Message.errorMissingVersionNumber, 0, arg);
                this.getLog().printError(error.message.getMessage());
                return 0;
            }
            arg = args[index + 1].trim();
            if (arg.startsWith("1.1")) {
                this.sourceJDKVersion = 110;
            } else if (arg.startsWith("1.2")) {
                this.sourceJDKVersion = 120;
            } else if (arg.startsWith("1.3")) {
                this.sourceJDKVersion = 130;
            } else if (arg.startsWith("1.4")) {
                this.targetJDKVersion = 140;
                this.sourceJDKVersion = 140;
            } else if (arg.startsWith("1.5") || arg.startsWith("5")) {
                this.targetJDKVersion = 150;
                this.sourceJDKVersion = 150;
            } else if (arg.startsWith("1.6") || arg.startsWith("6")) {
                this.targetJDKVersion = 160;
                this.sourceJDKVersion = 160;
            } else if (arg.startsWith("1.7") || arg.startsWith("7")) {
                this.targetJDKVersion = 170;
                this.sourceJDKVersion = 170;
            } else {
                Error error = new Error(null, Message.errorUnsupportedVersionNumber, 0, arg);
                this.getLog().printError(error.message.getMessage());
                return 0;
            }
            this.sourceTargetJDKDefault = false;
            return 2;
        }
        if (arg.equals("-target")) {
            if (index + 1 >= args.length) {
                Error error = new Error(null, Message.errorMissingVersionNumber, 0, arg);
                this.getLog().printError(error.message.getMessage());
                return 0;
            }
            arg = args[index + 1].trim();
            if (arg.startsWith("1.1")) {
                this.targetJDKVersion = 110;
            } else if (arg.startsWith("1.2")) {
                this.targetJDKVersion = 120;
            } else if (arg.startsWith("1.3")) {
                this.targetJDKVersion = 130;
            } else if (arg.startsWith("1.4")) {
                this.targetJDKVersion = 140;
            } else if (arg.startsWith("1.5") || arg.startsWith("5")) {
                this.targetJDKVersion = 150;
            } else if (arg.startsWith("1.6") || arg.startsWith("6")) {
                this.targetJDKVersion = 160;
            } else if (arg.startsWith("1.7") || arg.startsWith("7")) {
                this.targetJDKVersion = 170;
            } else {
                Error error = new Error(null, Message.errorUnsupportedVersionNumber, 0, arg);
                this.getLog().printError(error.message.getMessage());
                return 0;
            }
            this.sourceTargetJDKDefault = false;
            return 2;
        }
        if (arg.equals("-version")) {
            this.helpPrinted = true;
            this.log.println("ojc " + 11 + "." + 1 + "." + 1 + " build " + 4935);
            return 1;
        }
        if (arg.equals("-help") || arg.equals("--help")) {
            this.helpPrinted = true;
            Compiler.standardUsage(this.log);
            return 1;
        }
        if (arg.startsWith("-J-")) {
            return 1;
        }
        if (arg.equals("-X")) {
            this.helpPrinted = true;
            Compiler.nonstandardUsage(this.log);
            return 1;
        }
        if (arg.startsWith("-et")) {
            this.elapsedTime = true;
            return 1;
        }
        if (arg.equals("-exclude")) {
            if (index + 1 >= args.length) {
                Error error = new Error(null, Message.errorMissingClassnameList, 0, arg);
                this.getLog().printError(error.message.getMessage());
                return 0;
            }
            if (this.excludeClasses == null) {
                this.excludeClasses = new ArrayList();
            }
            String[] strList = Options.stringToArray(args[index + 1].trim(), File.pathSeparator);
            int i = 0;
            while (i < strList.length) {
                this.excludeClasses.add(strList[i]);
                ++i;
            }
            return 2;
        }
        if (arg.equals("-make")) {
            if (index + 1 >= args.length) {
                Error error = new Error(null, Message.errorMissingFilename, 0, arg);
                this.getLog().printError(error.message.getMessage());
                return 0;
            }
            this.makeFile = new FileStorage(new File(args[index + 1].trim()));
            return 2;
        }
        if (arg.equals("-rebuild")) {
            this.rebuild = true;
            return 1;
        }
        if (arg.equals("-obfuscate") || arg.startsWith("-updateimports")) {
            Error error = new Error(null, Message.warningObsoleteCompilerOption, 0, arg);
            this.getLog().printError("#" + error.message.getNumber() + " " + error.message.getMessage());
            return 1;
        }
        if (arg.startsWith("-msglimit:")) {
            int numArgsParsed = 1;
            String number = arg.substring(arg.indexOf(58) + 1).trim();
            if (number.length() == 0) {
                if (index + 1 >= args.length) {
                    Error error = new Error(null, Message.errorInvalidMessageLimit, 0, arg);
                    this.getLog().printError(error.message.getMessage());
                    return 0;
                }
                number = args[index + 1].trim();
                ++numArgsParsed;
            }
            try {
                int value = Integer.parseInt(number);
                if (value < -1) {
                    throw new NumberFormatException();
                }
                if (value == -1) {
                    value = Integer.MAX_VALUE;
                }
                this.messageLimit = value;
            }
            catch (NumberFormatException e) {
                Error error = new Error(null, Message.errorInvalidMessageLimit, 0, number);
                this.getLog().printError(error.message.getMessage());
                int n = 0;
                return n;
            }
            return numArgsParsed;
        }
        if (arg.startsWith("-nowarn:")) {
            int numArgsParsed = 1;
            String number = arg.substring(arg.indexOf(58) + 1).trim();
            if (number.length() == 0) {
                if (index + 1 >= args.length) {
                    Error error = new Error(null, Message.errorWarningNumberExpected, 0, arg);
                    this.getLog().printError(error.message.getMessage());
                    return 0;
                }
                number = args[index + 1].trim();
                ++numArgsParsed;
            }
            try {
                Warning.disableWarning(Integer.parseInt(number));
            }
            catch (NumberFormatException e) {
                Error error = new Error(null, Message.errorWarningNumberExpected, 0, arg);
                this.getLog().printError(error.message.getMessage());
                int n = 0;
                return n;
            }
            return numArgsParsed;
        }
        if (arg.equals("-O")) {
            return 1;
        }
        if (arg.equals("-noquiet")) {
            this.noquiet = true;
            return 1;
        }
        if (arg.equals("-nowrite")) {
            this.noCodeGeneration = true;
            return 1;
        }
        if (arg.equals("-strictfp")) {
            this.strictfpmethods = true;
            return 1;
        }
        if (arg.equals("-verbosepath")) {
            this.verbosepath = true;
            return 1;
        }
        if (arg.equals("-warn")) {
            this.noWarnings = false;
            Warning.enableAllWarnings();
            return 1;
        }
        if (arg.startsWith("-warn:")) {
            this.noWarnings = false;
            int numArgsParsed = 1;
            String number = arg.substring(arg.indexOf(58) + 1).trim();
            if (number.length() == 0) {
                if (index + 1 >= args.length) {
                    Error error = new Error(null, Message.errorWarningNumberExpected, 0, arg);
                    this.getLog().printError(error.message.getMessage());
                    return 0;
                }
                number = args[index + 1].trim();
                ++numArgsParsed;
            }
            try {
                Warning.enableWarning(Integer.parseInt(number));
            }
            catch (NumberFormatException e) {
                Error error = new Error(null, Message.errorWarningNumberExpected, 0, arg);
                this.getLog().printError(error.message.getMessage());
                int n = 0;
                return n;
            }
            return numArgsParsed;
        }
        if (arg.equals("-warningtag")) {
            if (index + 1 >= args.length) {
                Error error = new Error(null, Message.errorMissingTagList, 0, arg);
                this.getLog().printError(error.message.getMessage());
                return 0;
            }
            String[] strList = Options.stringToArray(args[index + 1].trim(), ",");
            this.tagNameList = new char[strList.length][];
            int i = 0;
            while (i < strList.length) {
                this.tagNameList[i] = strList[i].toCharArray();
                ++i;
            }
            return 2;
        }
        if (arg.equals("-deploy")) {
            if (index + 1 >= args.length) {
                Error error = new Error(null, Message.errorDeployExtensionsExpected, 0, arg);
                this.getLog().printError(error.message.getMessage());
                return 0;
            }
            this.deployExtensions = Options.stringToArray(args[index + 1].trim(), this.pathSeparator);
            return 2;
        }
        if (arg.equals("-Xomitasserts")) {
            this.omitAssertions = true;
            return 1;
        }
        if (arg.equals("-Xwarnerror")) {
            this.warningsAreErrors = true;
            return 1;
        }
        if (arg.equals("-Xhelp")) {
            this.helpPrinted = true;
            if (index + 1 >= args.length) {
                Error error = new Error(null, Message.errorOptionExpected, 0, arg);
                this.getLog().printError(error.message.getMessage());
                return 0;
            }
            Compiler.help(this.getLog(), args[index + 1].trim());
            return 2;
        }
        if (arg.startsWith("-Djava.endorsed.dirs=")) {
            int numArgsParsed = 1;
            this.endorseddirsStr = arg.substring(21);
            if (this.endorseddirsStr.length() == 0) {
                if (index + 1 >= args.length) {
                    Error error = new Error(null, Message.errorMissingPathnameList, 0, arg);
                    this.getLog().printError(error.message.getMessage());
                    return 0;
                }
                ++numArgsParsed;
                this.endorseddirsStr = args[index + 1].trim();
            }
            return numArgsParsed;
        }
        if (arg.startsWith("-Djava.ext.dirs=")) {
            int numArgsParsed = 1;
            this.extdirsStr = arg.substring(16);
            if (this.extdirsStr.length() == 0) {
                if (index + 1 >= args.length) {
                    Error error = new Error(null, Message.errorMissingPathnameList, 0, arg);
                    this.getLog().printError(error.message.getMessage());
                    return 0;
                }
                ++numArgsParsed;
                this.extdirsStr = args[index + 1].trim();
            }
            return numArgsParsed;
        }
        if (arg.startsWith("-Xbootclasspath/:")) {
            int numArgsParsed = 1;
            this.bootClasspathStr = arg.substring(17);
            if (this.bootClasspathStr.length() == 0) {
                if (index + 1 >= args.length) {
                    Error error = new Error(null, Message.errorMissingPathnameList, 0, arg);
                    this.getLog().printError(error.message.getMessage());
                    return 0;
                }
                ++numArgsParsed;
                this.bootClasspathStr = args[index + 1].trim();
            }
            return numArgsParsed;
        }
        if (arg.startsWith("-Xbootclasspath/a:")) {
            int numArgsParsed = 1;
            this.appendBootClasspathStr = arg.substring(18);
            if (this.appendBootClasspathStr.length() == 0) {
                if (index + 1 >= args.length) {
                    Error error = new Error(null, Message.errorMissingPathnameList, 0, arg);
                    this.getLog().printError(error.message.getMessage());
                    return 0;
                }
                ++numArgsParsed;
                this.appendBootClasspathStr = args[index + 1].trim();
            }
            return numArgsParsed;
        }
        if (arg.startsWith("-Xbootclasspath/p:")) {
            int numArgsParsed = 1;
            this.prependBootClasspathStr = arg.substring(18);
            if (this.prependBootClasspathStr.length() == 0) {
                if (index + 1 >= args.length) {
                    Error error = new Error(null, Message.errorMissingPathnameList, 0, arg);
                    this.getLog().printError(error.message.getMessage());
                    return 0;
                }
                ++numArgsParsed;
                this.prependBootClasspathStr = args[index + 1].trim();
            }
            return numArgsParsed;
        }
        if (arg.startsWith("-Xlint")) {
            if (arg.equals("-Xlint")) {
                Warning.enableWarning(Message.warningFallThrough.getNumber());
                Warning.enableWarning(Message.warningUnterminatedFinally.getNumber());
                Warning.enableWarning(Message.warningNoSerialVersionUID.getNumber());
                Warning.enableWarning(Message.warningUncheckedConversion.getNumber());
                Warning.enableWarning(Message.warningDirectoryDoesntExist.getNumber());
                Warning.enableWarning(Message.warningZipFileNotUsed.getNumber());
            } else if (arg.equals("-Xlint:none")) {
                Warning.disableWarning(Message.warningFallThrough.getNumber());
                Warning.disableWarning(Message.warningUnterminatedFinally.getNumber());
                Warning.disableWarning(Message.warningNoSerialVersionUID.getNumber());
                Warning.disableWarning(Message.warningUncheckedConversion.getNumber());
                Warning.disableWarning(Message.warningDirectoryDoesntExist.getNumber());
                Warning.disableWarning(Message.warningZipFileNotUsed.getNumber());
            } else if (arg.equals("-Xlint:fallthrough")) {
                Warning.enableWarning(Message.warningFallThrough.getNumber());
            } else if (arg.equals("-Xlint:-fallthrough")) {
                Warning.disableWarning(Message.warningFallThrough.getNumber());
            } else if (arg.equals("-Xlint:finally")) {
                Warning.enableWarning(Message.warningUnterminatedFinally.getNumber());
            } else if (arg.equals("-Xlint:-finally")) {
                Warning.disableWarning(Message.warningUnterminatedFinally.getNumber());
            } else if (arg.equals("-Xlint:path")) {
                Warning.enableWarning(Message.warningDirectoryDoesntExist.getNumber());
                Warning.enableWarning(Message.warningZipFileNotUsed.getNumber());
            } else if (arg.equals("-Xlint:-path")) {
                Warning.disableWarning(Message.warningDirectoryDoesntExist.getNumber());
                Warning.disableWarning(Message.warningZipFileNotUsed.getNumber());
            } else if (arg.equals("-Xlint:serial")) {
                Warning.enableWarning(Message.warningNoSerialVersionUID.getNumber());
            } else if (arg.equals("-Xlint:-serial")) {
                Warning.disableWarning(Message.warningNoSerialVersionUID.getNumber());
            } else if (arg.equals("-Xlint:unchecked")) {
                Warning.enableWarning(Message.warningUncheckedConversion.getNumber());
            } else if (arg.equals("-Xlint:-unchecked")) {
                Warning.disableWarning(Message.warningUncheckedConversion.getNumber());
            }
            return 1;
        }
        if (arg.equals("-Xmaxerrors") || arg.equals("-Xmaxerrs")) {
            if (index + 1 >= args.length) {
                Error error = new Error(null, Message.errorMissingNumber, 0, arg);
                this.getLog().printError(error.message.getMessage());
                return 0;
            }
            String number = args[index + 1].trim();
            try {
                int value = Integer.parseInt(number);
                if (value < -1) {
                    throw new NumberFormatException();
                }
                if (value == -1) {
                    value = Integer.MAX_VALUE;
                }
                this.errorLimit = value;
            }
            catch (NumberFormatException e) {
                Error error = new Error(null, Message.errorInvalidMessageLimit, 0, number);
                this.getLog().printError(error.message.getMessage());
                int n = 0;
                return n;
            }
            return 2;
        }
        if (arg.equals("-Xmaxwarns")) {
            if (index + 1 >= args.length) {
                Error error = new Error(null, Message.errorMissingNumber, 0, arg);
                this.getLog().printError(error.message.getMessage());
                return 0;
            }
            String number = args[index + 1].trim();
            try {
                int value = Integer.parseInt(number);
                if (value < -1) {
                    throw new NumberFormatException();
                }
                if (value == -1) {
                    value = Integer.MAX_VALUE;
                }
                this.warningLimit = value;
            }
            catch (NumberFormatException e) {
                Error error = new Error(null, Message.errorInvalidMessageLimit, 0, number);
                this.getLog().printError(error.message.getMessage());
                int n = 0;
                return n;
            }
            return 2;
        }
        if (arg.equals("-Xstdout")) {
            if (index + 1 >= args.length) {
                Error error = new Error(null, Message.errorMissingFilename, 0, arg);
                this.getLog().printError(error.message.getMessage());
                return 0;
            }
            this.log.redirect(args[index + 1].trim());
            return 2;
        }
        if (arg.equals("-forcecodegen")) {
            this.generateClassesDespiteErrors = true;
            return 1;
        }
        if (arg.equals("-namereferences")) {
            this.addNameReferences = true;
            return 1;
        }
        if (arg.equals("-ignoremanifests")) {
            this.ignoreManifests = true;
            return 1;
        }
        Error error = new Error(null, Message.errorUnknownCompilerOption, 0, arg);
        this.getLog().printError(error.message.getMessage());
        return 0;
    }

    public static int isSupportedOption(String option) {
        Integer numArgs;
        if (option.startsWith("-msglimit:") || option.startsWith("-nowarn:") || option.startsWith("-warn:")) {
            String number = option.substring(option.indexOf(58) + 1);
            try {
                int value = Integer.parseInt(number);
                if (option.startsWith("-msglimit:")) {
                    int n = value < -1 ? -1 : 0;
                    return n;
                }
                int n = value < 1 ? -1 : 0;
                return n;
            }
            catch (NumberFormatException e) {
                int n = -1;
                return n;
            }
        }
        if (option.startsWith("-Djava.endorsed.dirs=") || option.startsWith("-Xbootclasspath/:") || option.startsWith("-Xbootclasspath/a:") || option.startsWith("-Xbootclasspath/p:") || option.startsWith("-Djava.ext.dirs=")) {
            return 0;
        }
        if (supportedOptionsTable == null) {
            supportedOptionsTable = new Hashtable();
            supportedOptionsTable.put("-bootclasspath", new Integer(1));
            supportedOptionsTable.put("-classpath", new Integer(1));
            supportedOptionsTable.put("-cp", new Integer(1));
            supportedOptionsTable.put("-d", new Integer(1));
            supportedOptionsTable.put("-deploy", new Integer(1));
            supportedOptionsTable.put("-deprecation", new Integer(0));
            supportedOptionsTable.put("-deprecation:self", new Integer(0));
            supportedOptionsTable.put("-encoding", new Integer(1));
            supportedOptionsTable.put("-endorseddirs", new Integer(1));
            supportedOptionsTable.put("-et", new Integer(0));
            supportedOptionsTable.put("-exclude", new Integer(1));
            supportedOptionsTable.put("-extdirs", new Integer(1));
            supportedOptionsTable.put("-forcecodegen", new Integer(0));
            supportedOptionsTable.put("-g", new Integer(0));
            supportedOptionsTable.put("-g:lines", new Integer(0));
            supportedOptionsTable.put("-g:none", new Integer(0));
            supportedOptionsTable.put("-g:source", new Integer(0));
            supportedOptionsTable.put("-g:vars", new Integer(0));
            supportedOptionsTable.put("-help", new Integer(0));
            supportedOptionsTable.put("-ignoremanifests", new Integer(0));
            supportedOptionsTable.put("-make", new Integer(1));
            supportedOptionsTable.put("-namereferences", new Integer(0));
            supportedOptionsTable.put("-noquiet", new Integer(0));
            supportedOptionsTable.put("-nowarn", new Integer(0));
            supportedOptionsTable.put("-nowrite", new Integer(0));
            supportedOptionsTable.put("-O", new Integer(0));
            supportedOptionsTable.put("-rebuild", new Integer(0));
            supportedOptionsTable.put("-source", new Integer(1));
            supportedOptionsTable.put("-sourcepath", new Integer(1));
            supportedOptionsTable.put("-strictfp", new Integer(0));
            supportedOptionsTable.put("-sysclasspath", new Integer(1));
            supportedOptionsTable.put("-target", new Integer(1));
            supportedOptionsTable.put("-verbose", new Integer(0));
            supportedOptionsTable.put("-verbosepath", new Integer(0));
            supportedOptionsTable.put("-version", new Integer(0));
            supportedOptionsTable.put("-warn", new Integer(0));
            supportedOptionsTable.put("-warningtag", new Integer(1));
            supportedOptionsTable.put("-X", new Integer(0));
            supportedOptionsTable.put("-Xhelp", new Integer(1));
            supportedOptionsTable.put("-Xlint", new Integer(0));
            supportedOptionsTable.put("-Xlint:fallthrough", new Integer(0));
            supportedOptionsTable.put("-Xlint:-fallthrough", new Integer(0));
            supportedOptionsTable.put("-Xlint:finally", new Integer(0));
            supportedOptionsTable.put("-Xlint:-finally", new Integer(0));
            supportedOptionsTable.put("-Xlint:none", new Integer(0));
            supportedOptionsTable.put("-Xmaxerrors", new Integer(1));
            supportedOptionsTable.put("-Xmaxerrs", new Integer(1));
            supportedOptionsTable.put("-Xmaxwarns", new Integer(1));
            supportedOptionsTable.put("-Xomitasserts", new Integer(0));
            supportedOptionsTable.put("-Xpath", new Integer(0));
            supportedOptionsTable.put("-X-path", new Integer(0));
            supportedOptionsTable.put("-Xserial", new Integer(0));
            supportedOptionsTable.put("-X-serial", new Integer(0));
            supportedOptionsTable.put("-Xstdout", new Integer(1));
            supportedOptionsTable.put("-Xunchecked", new Integer(0));
            supportedOptionsTable.put("-X-unchecked", new Integer(0));
            supportedOptionsTable.put("-Xwarnerror", new Integer(0));
        }
        return (numArgs = (Integer)supportedOptionsTable.get(option)) == null ? -1 : numArgs;
    }

    private static boolean printStoragePath(PrintStream out, Storage[] storagePath, String separator, boolean separatorRequired) {
        int size = storagePath.length;
        int i = 0;
        while (i < size) {
            if (!separatorRequired) {
                separatorRequired = true;
            } else {
                out.print(separator);
            }
            out.print(storagePath[i].getPath());
            ++i;
        }
        return separatorRequired;
    }

    void print(PrintStream out) {
        out.println("\tsource:         " + this.sourceJDKVersion);
        out.println("\ttarget:         " + this.targetJDKVersion);
        out.println();
        out.print("\tclasspath:        ");
        boolean separatorRequired = false;
        if (this.endorseddirs != null) {
            separatorRequired = Options.printStoragePath(out, this.endorseddirs, this.pathSeparator, separatorRequired);
        }
        if (this.bootClasspath != null) {
            separatorRequired = Options.printStoragePath(out, this.bootClasspath, this.pathSeparator, separatorRequired);
        }
        if (this.extdirs != null) {
            separatorRequired = Options.printStoragePath(out, this.extdirs, this.pathSeparator, separatorRequired);
        }
        if (this.classpath != null) {
            Options.printStoragePath(out, this.classpath, this.pathSeparator, separatorRequired);
        }
        out.println();
        out.println();
        out.print("\tsourcepath:       ");
        if (this.sourcepath != null) {
            Options.printStoragePath(out, this.sourcepath, this.pathSeparator, false);
        }
        out.println();
        out.println();
        out.println("\tencoding:       " + this.encoding);
        out.println();
        out.print("\texcluded cls:  ");
        if (this.excludeClasses != null) {
            int size = this.excludeClasses.size();
            int i = 0;
            while (i < size) {
                out.println("\t" + (String)this.excludeClasses.get(i));
                ++i;
            }
        }
        out.println();
        out.println("\trebuild:        " + this.rebuild);
        out.println("\tnoCodeGen:      " + this.noCodeGeneration);
        out.println("\tlineNumbers:    " + this.lineNumbers);
        out.println("\tsourceFile:     " + this.sourceFile);
        out.println("\tlocalVars:      " + this.localVariables);
        out.println("\tomitAsserts:    " + this.omitAssertions);
    }

    public void setLog(Log log) {
        this.log = log;
        this.logProxy = new LogProxy(log);
    }

    public Log2 getLog() {
        if (this.logProxy == null || this.logProxy.getLog() != this.log) {
            this.logProxy = new LogProxy(this.log);
        }
        return this.logProxy;
    }

    void releaseJars() {
        if (this.verbose) {
            this.log.println("***********  Closing " + this.jarStorageList.size() + " jars.");
        }
        int x = 0;
        while (x < this.jarStorageList.size()) {
            JarStorage jarStorage = (JarStorage)this.jarStorageList.get(x);
            jarStorage.close();
            ++x;
        }
        this.jarStorageList = new ArrayList(0);
    }

    static void releaseStatics() {
        supportedOptionsTable = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

