/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.IdeLog;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.interfaces.ErrorInfo;
import oracle.ojc.interfaces.Storage;

class OutOfProcessLog
extends IdeLog {
    private int nerrors;
    private int nwarnings;

    OutOfProcessLog() {
    }

    public void print(String word) {
        super.println("OutOfProcessWord:" + word);
    }

    public void println(String line) {
        super.println("OutOfProcessLine:" + line);
    }

    void println(String prefix, String line) {
        super.println(prefix + line);
    }

    public void printError(Storage source, int pos, ErrorInfo info) {
        ++this.nerrors;
        super.println(this.getDiagnostic(source, pos, false, info.getNumber(), info.getMessage()));
    }

    public void printError(String errorMessage) {
        ++this.nerrors;
        super.println(this.getDiagnostic(null, -1, false, -1, errorMessage));
    }

    public void printWarning(Storage source, int pos, ErrorInfo info) {
        ++this.nwarnings;
        super.println(this.getDiagnostic(source, pos, true, info.getNumber(), info.getMessage()));
    }

    public void printWarning(String warningMessage) {
        ++this.nwarnings;
        super.println(this.getDiagnostic(null, -1, true, -1, warningMessage));
    }

    public int nerrors() {
        return this.nerrors;
    }

    public int nwarnings() {
        return this.nwarnings;
    }

    private String getDiagnostic(Storage source, int pos, boolean isWarning, int diagnosticNumber, String diagnosticMessage) {
        StringBuffer buf = new StringBuffer();
        if (isWarning) {
            buf.append("OutOfProcessWarning");
        } else {
            buf.append("OutOfProcessError");
        }
        buf.append(',');
        if (source != null) {
            buf.append(source.getPath());
        } else {
            buf.append(' ');
        }
        buf.append(',');
        if (pos >= 0) {
            buf.append(Scanner.positionToLine(pos));
            buf.append(',');
            buf.append(Scanner.positionToColumn(pos));
        } else {
            buf.append(" , ");
        }
        buf.append(',');
        if (diagnosticNumber > 0) {
            buf.append(diagnosticNumber);
        } else {
            buf.append(' ');
        }
        buf.append(',');
        buf.append(diagnosticMessage);
        return buf.toString();
    }
}

