/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.PackageScope;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.StorageScope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.interfaces.Storage;

final class PackageSymbol
extends Symbol {
    PackageScope packageScope;
    Storage[] classStorage;
    Storage[] sourceStorage;
    char[] signature;

    PackageSymbol(int pos, Identifier identifier, PackageScope packageScope) {
        super((byte)16, pos, identifier);
        this.packageScope = packageScope;
        packageScope.parser.options.findClassStorageForPackage(this);
        packageScope.parser.options.findSourceStorageForPackage(this);
    }

    String errorName() {
        return this.toString();
    }

    String kindName() {
        return Message.packageString;
    }

    char[] getSignature() {
        if (this.signature == null) {
            char[] packageSignature = null;
            int size = this.identifier.name.length;
            StorageScope outerScope = this.packageScope.outerScope;
            if (outerScope.kind == 1) {
                PackageScope packageScope = (PackageScope)outerScope;
                PackageSymbol packageSymbol = packageScope.packageSymbol;
                if (packageSymbol != null) {
                    packageSignature = packageSymbol.getSignature();
                    size += packageSignature.length + 1;
                }
            }
            this.signature = new char[size];
            int i = 0;
            if (packageSignature != null) {
                System.arraycopy(packageSignature, 0, this.signature, 0, packageSignature.length);
                i = packageSignature.length;
                this.signature[i++] = 47;
            }
            System.arraycopy(this.identifier.name, 0, this.signature, i, this.identifier.name.length);
        }
        return this.signature;
    }

    protected void toString(StringBuffer sb) {
        StorageScope outerScope = this.packageScope.outerScope;
        if (outerScope.kind == 1) {
            PackageScope packageScope = (PackageScope)outerScope;
            PackageSymbol packageSymbol = packageScope.packageSymbol;
            if (packageSymbol != null) {
                packageSymbol.toString(sb);
                sb.append('.');
            }
        }
        sb.append(this.identifier.name);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        this.toString(sb);
        return sb.toString();
    }

    byte getAnnotationTarget() {
        return -128;
    }

    PackageSymbol getOuterPackage() {
        StorageScope outerScope = this.packageScope.outerScope;
        if (outerScope.kind == 1) {
            PackageScope packageScope = (PackageScope)outerScope;
            PackageSymbol packageSymbol = packageScope.packageSymbol;
            return packageSymbol;
        }
        return null;
    }

    static PackageSymbol getPackageSymbol(Parser parser, String packageName) {
        PackageSymbol packageSymbol;
        int len = packageName.length();
        StorageScope currentScope = parser.globalScope;
        int lastIndex = 0;
        while (true) {
            PackageScope packageScope;
            Identifier identifier;
            int index;
            if ((index = packageName.indexOf(46, lastIndex)) < 0) {
                index = len;
            }
            if ((packageSymbol = (PackageSymbol)currentScope.lookupSpecificSymbolInScope(identifier = Identifier.getIdentifier(packageName.substring(lastIndex, index)), 16, false)) != null) {
                packageScope = packageSymbol.packageScope;
            } else {
                packageScope = new PackageScope(parser, currentScope);
                packageSymbol = new PackageSymbol(0, identifier, packageScope);
                currentScope.enterSymbol(packageSymbol);
                packageScope.packageSymbol = packageSymbol;
                packageScope.readPackage();
            }
            if (index == len) break;
            currentScope = packageScope;
            lastIndex = index + 1;
        }
        return packageSymbol;
    }
}

