/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.AppendStringExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.DoubleConstantExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FloatConstantExpression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.NumericBinaryExpression;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.StringConstantExpression;
import oracle.ojc.compiler.TypeSymbol;

final class PlusExpression
extends NumericBinaryExpression {
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    PlusExpression(int pos, Expression leftOperand, Expression rightOperand) {
        super((byte)33, pos, leftOperand, rightOperand);
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = PlusExpression.class$("oracle.ojc.compiler.PlusExpression");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    strictfp Expression foldExpression() {
        Expression leftOp = this.leftOperand;
        Expression rightOp = this.rightOperand;
        if (rightOp.kind == 2) {
            TypeSymbol typeSymbol = this.getType();
            byte typeClass = typeSymbol.typeClass;
            if (leftOp.kind == 2) {
                switch (typeClass) {
                    default: {
                        if (!$a) {
                            throw new AssertionError();
                        }
                    }
                    case 4: {
                        return new IntConstantExpression(this.pos, this.getType(), ((ConstantExpression)leftOp).getIntConstValue() + ((ConstantExpression)rightOp).getIntConstValue());
                    }
                    case 8: {
                        return new LongConstantExpression(this.pos, ((LongConstantExpression)leftOp).lval + ((LongConstantExpression)rightOp).lval);
                    }
                    case 16: {
                        return new FloatConstantExpression(this.pos, ((FloatConstantExpression)leftOp).fval + ((FloatConstantExpression)rightOp).fval);
                    }
                    case 32: 
                }
                return new DoubleConstantExpression(this.pos, ((DoubleConstantExpression)leftOp).dval + ((DoubleConstantExpression)rightOp).dval);
            }
            if (typeClass == 4 && ((ConstantExpression)rightOp).getIntConstValue() == 0) {
                return leftOp;
            }
        } else if (rightOp.kind == 51 && leftOp.kind == 51) {
            AppendStringExpression leftApOp = (AppendStringExpression)leftOp;
            AppendStringExpression rightApOp = (AppendStringExpression)rightOp;
            if (rightApOp.expr instanceof StringConstantExpression && leftApOp.expr instanceof StringConstantExpression) {
                StringConstantExpression leftScExpr = (StringConstantExpression)leftApOp.expr;
                StringConstantExpression rightScExpr = (StringConstantExpression)rightApOp.expr;
                int size = leftScExpr.sval.length + rightScExpr.sval.length;
                char[] sval = new char[size];
                System.arraycopy(leftScExpr.sval, 0, sval, 0, leftScExpr.sval.length);
                System.arraycopy(rightScExpr.sval, 0, sval, leftScExpr.sval.length, rightScExpr.sval.length);
                return new StringConstantExpression(this.pos, this.getType(), sval);
            }
        }
        return this;
    }

    strictfp Expression resolveAndCheck(Parser parser) {
        Expression leftOp = this.leftOperand;
        leftOp = leftOp.resolveAndCheck(parser);
        Expression rightOp = this.rightOperand;
        rightOp = rightOp.resolveAndCheck(parser);
        TypeSymbol leftOpType = leftOp.getType();
        if (leftOpType.isErroneous()) {
            return leftOp;
        }
        TypeSymbol rightOpType = rightOp.getType();
        if (rightOpType.isErroneous()) {
            return rightOp;
        }
        RawClassSymbol javaLangString = parser.javaLangStringSymbol;
        if (leftOpType.equalTo(javaLangString) || rightOpType.equalTo(javaLangString)) {
            if (leftOpType.typeKind == 1 || rightOpType.typeKind == 1) {
                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, false, this.toString(), leftOpType.errorName() + " " + Message.andString + " " + rightOpType.errorName());
                return new ErrorExpression(error);
            }
            if (leftOp.kind != 51) {
                leftOp = new AppendStringExpression(parser, leftOp);
            }
            this.leftOperand = leftOp;
            if (rightOp.kind != 51) {
                rightOp = new AppendStringExpression(parser, rightOp);
            }
            this.rightOperand = rightOp;
            this.setType(parser.javaLangStringPcs);
        } else {
            TypeSymbol commonType = TypeSymbol.binaryNumericPromotion(parser, leftOpType, rightOpType);
            this.setType(commonType);
            if (commonType.isErroneous()) {
                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, leftOpType.isErroneous() | rightOpType.isErroneous(), this.toString(), leftOpType.errorName() + " " + Message.andString + " " + rightOpType.errorName());
                return new ErrorExpression(error);
            }
            this.leftOperand = leftOp.promoteType(parser, commonType);
            this.rightOperand = rightOp.promoteType(parser, commonType);
        }
        return this.foldExpression();
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        byte typeClass = this.getType().typeClass;
        if (typeClass == 64) {
            ConstantPool constantPool = byteCodeGenerator.constantPool;
            if (byteCodeGenerator.doingStringConcatonation) {
                this.leftOperand.generateByteCode(byteCodeGenerator);
                this.rightOperand.generateByteCode(byteCodeGenerator);
            } else {
                boolean savedDoingStringConcatonation = byteCodeGenerator.doingStringConcatonation;
                byteCodeGenerator.doingStringConcatonation = true;
                char[] className = byteCodeGenerator.parser.options.targetJDKVersion < 150 ? Identifier.javaLangStringBufferInternal.name : Identifier.javaLangStringBuilderInternal.name;
                short index = constantPool.enterConstantPoolClass(className);
                byteCodeGenerator.generate_8_16((byte)-69, index);
                byteCodeGenerator.generate_8((byte)89);
                byteCodeGenerator.incOpStackHeight(2);
                index = constantPool.enterConstantPoolMethodRef(className, Identifier.initializerIdentifier.name, Identifier.voidMethodSignature.name);
                byteCodeGenerator.generate_8_16((byte)-73, index);
                byteCodeGenerator.decOpStackHeight(1);
                this.leftOperand.generateByteCode(byteCodeGenerator);
                this.rightOperand.generateByteCode(byteCodeGenerator);
                index = constantPool.enterConstantPoolMethodRef(className, Identifier.toStringIdentifier.name, Identifier.javaLangStringMethodSignature.name);
                byteCodeGenerator.generate_8_16((byte)-74, index);
                byteCodeGenerator.doingStringConcatonation = savedDoingStringConcatonation;
            }
        } else {
            this.leftOperand.generateByteCode(byteCodeGenerator);
            this.rightOperand.generateByteCode(byteCodeGenerator);
            switch (typeClass) {
                default: {
                    if (!$a) {
                        throw new AssertionError();
                    }
                }
                case 4: {
                    byteCodeGenerator.generate_8((byte)96);
                    byteCodeGenerator.decOpStackHeight(1);
                    break;
                }
                case 8: {
                    byteCodeGenerator.generate_8((byte)97);
                    byteCodeGenerator.decOpStackHeight(2);
                    break;
                }
                case 16: {
                    byteCodeGenerator.generate_8((byte)98);
                    byteCodeGenerator.decOpStackHeight(1);
                    break;
                }
                case 32: {
                    byteCodeGenerator.generate_8((byte)99);
                    byteCodeGenerator.decOpStackHeight(2);
                    break;
                }
            }
        }
    }

    public String toString() {
        return "+";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

