/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.Hashtable;
import java.util.Iterator;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;

class ReferenceTypeSymbol
extends TypeSymbol {
    static ReferenceTypeSymbol nullTypeSymbol;
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    ReferenceTypeSymbol(int pos, Identifier identifier, byte kind, short access, Annotation annotation) {
        super(pos, identifier, kind, access, annotation);
    }

    char[] getSignature() {
        if (this == nullTypeSymbol) {
            return Identifier.javaLangObjectSignature.name;
        }
        return super.getSignature();
    }

    boolean isReferenceType() {
        return true;
    }

    static void initializeStatics() {
        nullTypeSymbol = new ReferenceTypeSymbol(0, Identifier.getIdentifier("null"), 10, 1, null);
    }

    static void releaseStatics() {
        nullTypeSymbol = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isAssignmentCompatible(Parser parser, ReferenceTypeSymbol targetType) {
        boolean saveDoMethodTypeParameterConversion;
        block24: {
            boolean bl;
            block26: {
                boolean bl2;
                block25: {
                    boolean bl3;
                    block23: {
                        boolean bl4;
                        block22: {
                            boolean bl5;
                            block21: {
                                boolean bl6;
                                block20: {
                                    boolean bl7;
                                    block19: {
                                        boolean bl8;
                                        block18: {
                                            boolean bl9;
                                            block17: {
                                                boolean bl10;
                                                block16: {
                                                    boolean bl11;
                                                    block15: {
                                                        boolean bl12;
                                                        block14: {
                                                            saveDoMethodTypeParameterConversion = ClassSymbol.doMethodTypeParameterConversion;
                                                            ClassSymbol.doMethodTypeParameterConversion = false;
                                                            try {
                                                                if (this.isArrayType() && targetType.isArrayType()) {
                                                                    ArraySymbol sourceArray = (ArraySymbol)this;
                                                                    ArraySymbol targetArray = (ArraySymbol)targetType;
                                                                    TypeSymbol sourceBaseType = ArraySymbol.getArrayType(sourceArray.baseType, sourceArray.dimension - 1);
                                                                    TypeSymbol targetBaseType = ArraySymbol.getArrayType(targetArray.baseType, targetArray.dimension - 1);
                                                                    if (sourceBaseType.isPrimitiveType() || targetBaseType.isPrimitiveType()) {
                                                                        boolean bl13 = sourceBaseType == targetBaseType;
                                                                        Object var24_9 = null;
                                                                        ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                                                                        return bl13;
                                                                    }
                                                                    bl12 = ((ReferenceTypeSymbol)sourceBaseType).isAssignmentCompatible(parser, (ReferenceTypeSymbol)targetBaseType);
                                                                    break block14;
                                                                }
                                                                if (this.equalTo(targetType)) {
                                                                    bl11 = true;
                                                                    break block15;
                                                                }
                                                                if (this == nullTypeSymbol || targetType == nullTypeSymbol) {
                                                                    bl10 = true;
                                                                    break block16;
                                                                }
                                                                if (this.isTypeParameter()) {
                                                                    bl9 = ((TypeParameterSymbol)this).bound.isAssignmentCompatible(parser, targetType);
                                                                    break block17;
                                                                }
                                                                if (this.isClass()) {
                                                                    ClassSymbol sourceClass = (ClassSymbol)this;
                                                                    if (!sourceClass.isInterface()) {
                                                                        if (targetType.isClass()) {
                                                                            ClassSymbol targetClass = (ClassSymbol)targetType;
                                                                            if (!targetClass.isInterface()) {
                                                                                bl8 = targetClass.isSuperclass(sourceClass);
                                                                                break block18;
                                                                            }
                                                                            bl7 = sourceClass.implementsInterface(targetClass);
                                                                            break block19;
                                                                        }
                                                                        bl6 = false;
                                                                        break block20;
                                                                    }
                                                                    if (targetType.isClass()) {
                                                                        ClassSymbol targetClass = (ClassSymbol)targetType;
                                                                        if (!targetClass.isInterface()) {
                                                                            bl5 = targetClass.equalTo(parser.javaLangObjectSymbol);
                                                                            break block21;
                                                                        }
                                                                        bl4 = sourceClass.implementsInterface(targetClass);
                                                                        break block22;
                                                                    }
                                                                    bl3 = false;
                                                                    break block23;
                                                                }
                                                                if (!targetType.isClass()) break block24;
                                                                ClassSymbol targetClass = (ClassSymbol)targetType;
                                                                if (!targetClass.isInterface()) {
                                                                    bl2 = targetClass.equalTo(parser.javaLangObjectSymbol);
                                                                    break block25;
                                                                }
                                                                bl = targetClass.equalTo(parser.javaLangCloneableSymbol) || targetClass.equalTo(parser.javaIoSerializableSymbol);
                                                                break block26;
                                                            }
                                                            catch (Throwable throwable) {
                                                                Object var24_23 = null;
                                                                ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                                                                throw throwable;
                                                            }
                                                        }
                                                        Object var24_10 = null;
                                                        ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                                                        return bl12;
                                                    }
                                                    Object var24_11 = null;
                                                    ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                                                    return bl11;
                                                }
                                                Object var24_12 = null;
                                                ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                                                return bl10;
                                            }
                                            Object var24_13 = null;
                                            ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                                            return bl9;
                                        }
                                        Object var24_14 = null;
                                        ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                                        return bl8;
                                    }
                                    Object var24_15 = null;
                                    ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                                    return bl7;
                                }
                                Object var24_16 = null;
                                ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                                return bl6;
                            }
                            Object var24_17 = null;
                            ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                            return bl5;
                        }
                        Object var24_18 = null;
                        ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                        return bl4;
                    }
                    Object var24_19 = null;
                    ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                    return bl3;
                }
                Object var24_20 = null;
                ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                return bl2;
            }
            Object var24_21 = null;
            ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
            return bl;
        }
        Object var24_22 = null;
        ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
        return false;
    }

    boolean isReturnSubstitutable(Parser parser, ReferenceTypeSymbol otherType) {
        ReferenceTypeSymbol thisType = this;
        if (thisType.isTypeParameter() && !otherType.isTypeParameter()) {
            thisType = (ReferenceTypeSymbol)thisType.eraseType();
        }
        if (otherType.equalTo(thisType)) {
            return true;
        }
        if (this.isClass()) {
            ClassSymbol thisClass = (ClassSymbol)thisType;
            if (!thisClass.isInterface()) {
                if (otherType.isClass()) {
                    ClassSymbol otherClass = (ClassSymbol)otherType;
                    if (!otherClass.isInterface()) {
                        return thisClass.isSuperclass(otherClass);
                    }
                    return thisClass.equalTo(parser.javaLangObjectSymbol);
                }
                return thisClass.equalTo(parser.javaLangObjectSymbol);
            }
            if (otherType.isClass()) {
                ClassSymbol otherClass = (ClassSymbol)otherType;
                return otherClass.implementsInterface(thisClass);
            }
            return thisClass.equalTo(parser.javaLangCloneableSymbol) || thisClass.equalTo(parser.javaIoSerializableSymbol);
        }
        if (otherType.isClass()) {
            return false;
        }
        ArraySymbol thisArray = (ArraySymbol)thisType;
        ArraySymbol otherArray = (ArraySymbol)otherType;
        TypeSymbol thisBaseType = ArraySymbol.getArrayType(thisArray.baseType, thisArray.dimension - 1);
        TypeSymbol otherBaseType = ArraySymbol.getArrayType(otherArray.baseType, otherArray.dimension - 1);
        if (thisBaseType.isPrimitiveType() || otherBaseType.isPrimitiveType()) {
            return thisBaseType == otherBaseType;
        }
        return ((ReferenceTypeSymbol)thisBaseType).isReturnSubstitutable(parser, (ReferenceTypeSymbol)otherBaseType);
    }

    static boolean compareMethods(MethodSymbol method1, MethodSymbol method2) {
        if (method1.identifier != method2.identifier) {
            return false;
        }
        if (method1.argCount != method2.argCount) {
            return false;
        }
        if (method1.argumentList == null || method2.argumentList == null) {
            return method1.argumentList == method2.argumentList;
        }
        return method1.argumentList.equals(method2.argumentList);
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = ReferenceTypeSymbol.class$("oracle.ojc.compiler.ReferenceTypeSymbol");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    private static boolean checkInterfaces(Parser parser, ClassSymbol interface1, ClassSymbol interface2) {
        if (!($a || interface1.isInterface() && interface2.isInterface())) {
            throw new AssertionError();
        }
        MethodSymbol[] methodArray1 = interface1.getClassSymbol().getMethodTable(parser);
        MethodSymbol[] methodArray2 = interface2.getClassSymbol().getMethodTable(parser);
        int i = methodArray1.length;
        block0: while (--i >= 0) {
            MethodSymbol methodSymbol1 = methodArray1[i];
            if (methodSymbol1.definingClass == parser.javaLangObjectSymbol) continue;
            int j = methodArray2.length;
            while (--j >= 0) {
                MethodSymbol methodSymbol2 = methodArray2[j];
                if (methodSymbol2.definingClass == parser.javaLangObjectSymbol || !ReferenceTypeSymbol.compareMethods(methodSymbol1, methodSymbol2)) continue;
                if (methodSymbol1.resultType.equalTo(methodSymbol2.resultType)) continue block0;
                return false;
            }
        }
        return true;
    }

    boolean isCastCompatible(Parser parser, ReferenceTypeSymbol targetType) {
        if (this.equalTo(targetType)) {
            return true;
        }
        if (this == nullTypeSymbol || targetType == nullTypeSymbol) {
            return true;
        }
        if (this.isClass()) {
            ClassSymbol sourceClass = (ClassSymbol)this;
            if (sourceClass.isTypeParameter()) {
                return ((TypeParameterSymbol)this).bound.isCastCompatible(parser, targetType);
            }
            if (!sourceClass.isInterface()) {
                if (targetType.isClass()) {
                    ClassSymbol targetClass = (ClassSymbol)targetType;
                    if (targetClass.isTypeParameter()) {
                        return this.isCastCompatible(parser, ((TypeParameterSymbol)targetType).bound);
                    }
                    if (!targetClass.isInterface()) {
                        if (targetClass.equalTo(sourceClass) || targetClass.isSuperclass(sourceClass) || sourceClass.isSuperclass(targetClass)) {
                            return this.hasDistinctParameterizedSupers(parser, sourceClass, targetClass) ^ true;
                        }
                        return false;
                    }
                    if ((sourceClass.access & 0x10) == 0) {
                        return this.hasDistinctParameterizedSupers(parser, sourceClass, targetClass) ^ true;
                    }
                    return sourceClass.implementsInterface(targetClass);
                }
                return sourceClass.equalTo(parser.javaLangObjectSymbol);
            }
            if (targetType.isClass()) {
                ClassSymbol targetClass = (ClassSymbol)targetType;
                if ((targetClass.access & 0x10) == 0 && this.hasDistinctParameterizedSupers(parser, sourceClass, targetClass)) {
                    return false;
                }
                if (!targetClass.isInterface()) {
                    if ((targetClass.access & 0x10) == 0) {
                        return true;
                    }
                    return targetClass.implementsInterface(sourceClass);
                }
                if (parser.options.sourceJDKVersion >= 150) {
                    if ((targetClass.access & 0x10) == 0) {
                        return true;
                    }
                    return targetClass.implementsInterface(sourceClass);
                }
                return ReferenceTypeSymbol.checkInterfaces(parser, sourceClass, targetClass);
            }
            return sourceClass.equalTo(parser.javaLangCloneableSymbol) || sourceClass.equalTo(parser.javaIoSerializableSymbol);
        }
        if (targetType.isClass()) {
            ClassSymbol targetClass = (ClassSymbol)targetType;
            if (targetClass.isTypeParameter()) {
                return this.isCastCompatible(parser, ((TypeParameterSymbol)targetType).bound);
            }
            if (!targetClass.isInterface()) {
                return targetClass.equalTo(parser.javaLangObjectSymbol);
            }
            return targetClass.equalTo(parser.javaLangCloneableSymbol) || targetClass.equalTo(parser.javaIoSerializableSymbol);
        }
        ArraySymbol sourceArray = (ArraySymbol)this;
        ArraySymbol targetArray = (ArraySymbol)targetType;
        TypeSymbol sourceBaseType = ArraySymbol.getArrayType(sourceArray.baseType, sourceArray.dimension - 1);
        TypeSymbol targetBaseType = ArraySymbol.getArrayType(targetArray.baseType, targetArray.dimension - 1);
        if (sourceBaseType.isPrimitiveType() || targetBaseType.isPrimitiveType()) {
            return sourceBaseType == targetBaseType;
        }
        return ((ReferenceTypeSymbol)sourceBaseType).isCastCompatible(parser, (ReferenceTypeSymbol)targetBaseType);
    }

    private boolean hasDistinctParameterizedSupers(Parser parser, ClassSymbol sourceClass, ClassSymbol targetClass) {
        if (parser.options.sourceJDKVersion >= 150) {
            Hashtable sourceSupers = new Hashtable();
            Hashtable targetSupers = new Hashtable();
            this.collectSupers(sourceClass, sourceSupers);
            this.collectSupers(targetClass, targetSupers);
            Iterator sourceIter = sourceSupers.keySet().iterator();
            while (sourceIter.hasNext()) {
                ClassSymbol sourceSuper;
                TypeSymbol erasedSource = (TypeSymbol)sourceIter.next();
                ClassSymbol targetSuper = (ClassSymbol)targetSupers.get(erasedSource);
                if (targetSuper == null || !ParameterizedClassSymbol.areDistinctParameterizedTypes(sourceSuper = (ClassSymbol)sourceSupers.get(erasedSource), targetSuper)) continue;
                return true;
            }
        }
        return false;
    }

    private void collectSupers(ClassSymbol classSymbol, Hashtable table) {
        if (classSymbol != null) {
            table.put(classSymbol.eraseType(), classSymbol);
            this.collectInterfaces(classSymbol, table);
            this.collectSupers(classSymbol.getSuperClassSymbol(), table);
        }
    }

    private void collectInterfaces(ClassSymbol classSymbol, Hashtable table) {
        if (classSymbol != null) {
            ImplementationList impls = classSymbol.getImplementationList();
            while (impls != null) {
                table.put(impls.interfaceSymbol.eraseType(), impls.interfaceSymbol);
                this.collectInterfaces(impls.interfaceSymbol, table);
                impls = impls.next;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

