/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BinaryExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;

abstract class RelationalExpression
extends BinaryExpression {
    RelationalExpression(byte kind, int pos, Expression leftOperand, Expression rightOperand) {
        super(kind, pos, leftOperand, rightOperand);
    }

    Expression resolveAndCheck(Parser parser) {
        Expression leftOp = this.leftOperand.resolveAndCheck(parser);
        Expression rightOp = this.rightOperand.resolveAndCheck(parser);
        TypeSymbol leftOpType = leftOp.getType();
        TypeSymbol rightOpType = rightOp.getType();
        if ((leftOpType.typeClass & 2) != 0 || (rightOpType.typeClass & 2) != 0) {
            Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, leftOpType.isErroneous() | rightOpType.isErroneous(), this.toString(), leftOpType.errorName() + " " + Message.andString + " " + rightOpType.errorName());
            return new ErrorExpression(error);
        }
        TypeSymbol commonType = TypeSymbol.binaryNumericPromotion(parser, leftOpType, rightOpType);
        if (commonType.isErroneous()) {
            Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, leftOpType.isErroneous() | rightOpType.isErroneous(), this.toString(), leftOpType.errorName() + " " + Message.andString + " " + rightOpType.errorName());
            return new ErrorExpression(error);
        }
        this.leftOperand = leftOp.promoteType(parser, commonType);
        this.rightOperand = rightOp.promoteType(parser, commonType);
        this.setType(TypeSymbol.booleanSymbol);
        return this.foldExpression();
    }
}

