/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.TypeSymbol;

final class ReturnStatement
extends Statement {
    Expression returnExpr;
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    ReturnStatement(StatementList parent, int pos, Expression returnExpr) {
        super(parent, pos, (byte)14);
        this.returnExpr = returnExpr;
    }

    /*
     * Enabled aggressive block sorting
     */
    void resolveAndCheck(Parser parser) {
        if (parser.innerTrySync != null) {
            parser.innerTrySync.resolveAndCheck(parser);
        }
        TypeSymbol retType = parser.currentMethodSymbol.resultType;
        Expression expr = this.returnExpr;
        if (retType == TypeSymbol.voidSymbol) {
            if (expr != null) {
                parser.error(Message.errorReturnFromVoid, expr.pos, false);
            }
        } else {
            block25: {
                if (expr == null) {
                    parser.error(Message.errorMissingReturnValue, this.pos, false);
                    return;
                }
                if (expr.takeAssignmentContext()) {
                    parser.assignmentContext = retType;
                }
                expr = expr.resolveAndCheck(parser);
                TypeSymbol exprType = expr.getType();
                if (!retType.isErroneous() && !exprType.isErroneous()) {
                    if ((retType.typeClass & 0xFFFFFFC0) != 0) {
                        if ((exprType.typeClass & 0xFFFFFFC0) == 0) {
                            if (parser.options.sourceJDKVersion >= 150 && exprType.isPrimitiveType() && BoxingExpression.getPrimitiveType(parser, retType) != null) {
                                expr = expr.promoteType(parser, retType);
                                break block25;
                            } else {
                                parser.error(Message.errorIncompatibleTypes, this.pos, false, exprType.errorName(), retType.errorName());
                                return;
                            }
                        }
                        ReferenceTypeSymbol exprRefSymbol = (ReferenceTypeSymbol)exprType;
                        ReferenceTypeSymbol retRefSymbol = (ReferenceTypeSymbol)retType;
                        if (!exprRefSymbol.isAssignmentCompatible(parser, retRefSymbol)) {
                            parser.error(Message.errorIncompatibleTypes, this.pos, false, exprType.errorName(), retType.errorName());
                            return;
                        }
                        retType.checkForUncheckedConversion(parser, this.pos, exprType, false);
                        expr = expr.promoteType(parser, retType);
                    } else if ((retType.typeClass & 2) != 0) {
                        if ((exprType.typeClass & 2) == 0) {
                            if (parser.options.sourceJDKVersion >= 150 && exprType.isReferenceType() && BoxingExpression.getPrimitiveType(parser, exprType) != null) {
                                expr = expr.promoteType(parser, retType);
                            } else {
                                parser.error(Message.errorIncompatibleTypes, this.pos, false, exprType.errorName(), retType.errorName());
                                return;
                            }
                        }
                    } else {
                        if ((exprType.typeClass & 0xFFFFFFC2) != 0) {
                            if (parser.options.sourceJDKVersion >= 150 && exprType.isReferenceType() && BoxingExpression.getPrimitiveType(parser, exprType) != null) {
                                expr = expr.promoteType(parser, retType);
                            } else {
                                parser.error(Message.errorIncompatibleTypes, this.pos, false, exprType.errorName(), retType.errorName());
                                return;
                            }
                        }
                        expr = expr.promoteType(parser, retType);
                    }
                }
            }
            this.returnExpr = expr;
        }
        ++parser.estimatedLineCount;
        this.parent.updateDefUseSetsAfterReturn(parser);
        if (!parser.suspendDataFlowChecking) {
            if (parser.exitDefSet == null) {
                parser.exitDefSet = (BitSet)parser.defSet.clone();
            } else {
                parser.exitDefSet.or(parser.defSet);
            }
        }
        this.setLastStatement();
        if (this.next != null && this.next.isCodeStatement()) {
            parser.error(Message.errorUnreachableStatement, this.next.pos, false);
        }
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = ReturnStatement.class$("oracle.ojc.compiler.ReturnStatement");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        Expression expr = this.returnExpr;
        if (expr == null) {
            if (byteCodeGenerator.parser.innerTrySync != null) {
                byteCodeGenerator.parser.innerTrySync.generateByteCode(byteCodeGenerator);
            }
            if (this.pos > 0) {
                byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.pos));
            } else {
                byteCodeGenerator.generateLineNumber(byteCodeGenerator.methodSymbol.cmd.lastLine);
            }
            byteCodeGenerator.generate_8((byte)-79);
        } else {
            expr.generateByteCode(byteCodeGenerator);
            TypeSymbol retType = expr.getType();
            if (byteCodeGenerator.parser.innerTrySync != null) {
                short s = byteCodeGenerator.methodSymbol.localVarCount;
                byteCodeGenerator.methodSymbol.localVarCount = (short)(s + 1);
                short localVar = s;
                byteCodeGenerator.methodSymbol.cmd.localVariables.add(null);
                if ((retType.typeClass & 0x28) != 0) {
                    byteCodeGenerator.methodSymbol.localVarCount = (short)(byteCodeGenerator.methodSymbol.localVarCount + 1);
                    byteCodeGenerator.methodSymbol.cmd.localVariables.add(null);
                }
                byteCodeGenerator.storeLocalVariable(retType, localVar);
                byteCodeGenerator.parser.innerTrySync.generateByteCode(byteCodeGenerator);
                byteCodeGenerator.loadLocalVariable(retType, localVar);
            }
            switch (retType.typeClass) {
                default: {
                    if (!$a) {
                        throw new AssertionError();
                    }
                }
                case -128: 
                case 64: {
                    byteCodeGenerator.generate_8((byte)-80);
                    byteCodeGenerator.decOpStackHeight(1);
                    break;
                }
                case 2: 
                case 4: {
                    byteCodeGenerator.generate_8((byte)-84);
                    byteCodeGenerator.decOpStackHeight(1);
                    break;
                }
                case 8: {
                    byteCodeGenerator.generate_8((byte)-83);
                    byteCodeGenerator.decOpStackHeight(2);
                    break;
                }
                case 16: {
                    byteCodeGenerator.generate_8((byte)-82);
                    byteCodeGenerator.decOpStackHeight(1);
                    break;
                }
                case 32: {
                    byteCodeGenerator.generate_8((byte)-81);
                    byteCodeGenerator.decOpStackHeight(2);
                    break;
                }
            }
        }
    }

    boolean isLoopExitStatement() {
        return true;
    }

    boolean canReachNextStatement(boolean strict) {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

