/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.KeywordTable;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Token;
import oracle.ojc.compiler.Warning;

public final class Scanner {
    static final int SCANNER_EOF = 64;
    static boolean[] _isOctDigit;
    static boolean[] _isHexDigit;
    static boolean[] _isDigit;
    static boolean[] _isWhitespace;
    static int[] _hexDigitValue;
    char[] scanBuffer;
    private int scanPosition;
    private int scanLine;
    private int scanLineStart;
    private int scanBufferLength;
    private int lineInc;
    Parser parser;
    Token token;
    KeywordTable keywordTable;
    int sourceJDKVersion;
    boolean warnedAssert;
    boolean warnedEnum;
    byte prevPrevTokenKind;
    byte prevTokenKind;
    int prevScanPosition;
    private static final byte STATE_DEFAULT = -1;
    private static final byte STATE_OFF = 0;
    private static final byte STATE_ON = 1;
    private static char[] deprecatedTag;
    private static char[] lineinfoTag;
    private static char[] warningTag;
    private static char[] onTag;
    private static char[] offTag;
    private static char[] defaultTag;
    private static char[] filenameTag;
    private static char[] userCodeTag;
    private static char[] translatedCodeTag;
    private static char[] generatedCodeTag;
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;
    private static /* synthetic */ Class class$java$lang$Character;

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = Scanner.class$("oracle.ojc.compiler.Scanner");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
        _isOctDigit = new boolean[256];
        _isHexDigit = new boolean[256];
        _isDigit = new boolean[256];
        _isWhitespace = new boolean[256];
        _hexDigitValue = new int[256];
        int i = 48;
        while (i <= 55) {
            Scanner._isHexDigit[i] = true;
            Scanner._isDigit[i] = true;
            Scanner._isOctDigit[i] = true;
            Scanner._hexDigitValue[i] = i - 48;
            ++i;
        }
        Scanner._isHexDigit[56] = true;
        Scanner._isDigit[56] = true;
        Scanner._hexDigitValue[56] = 8;
        Scanner._isHexDigit[57] = true;
        Scanner._isDigit[57] = true;
        Scanner._hexDigitValue[57] = 9;
        i = 97;
        while (i <= 102) {
            Scanner._isHexDigit[i] = true;
            Scanner._hexDigitValue[i] = i - 97 + 10;
            ++i;
        }
        i = 65;
        while (i <= 70) {
            Scanner._isHexDigit[i] = true;
            Scanner._hexDigitValue[i] = i - 65 + 10;
            ++i;
        }
        Scanner._isWhitespace[12] = true;
        Scanner._isWhitespace[9] = true;
        Scanner._isWhitespace[32] = true;
        deprecatedTag = new char[]{'d', 'e', 'p', 'r', 'e', 'c', 'a', 't', 'e', 'd'};
        lineinfoTag = new char[]{'l', 'i', 'n', 'e', 'i', 'n', 'f', 'o', ':'};
        warningTag = new char[]{'w', 'a', 'r', 'n', 'i', 'n', 'g', ':'};
        onTag = new char[]{'o', 'n'};
        offTag = new char[]{'o', 'f', 'f'};
        defaultTag = new char[]{'d', 'e', 'f', 'a', 'u', 'l', 't'};
        filenameTag = new char[]{'f', 'i', 'l', 'e', 'n', 'a', 'm', 'e', '='};
        userCodeTag = new char[]{'u', 's', 'e', 'r', '-', 'c', 'o', 'd', 'e'};
        translatedCodeTag = new char[]{'t', 'r', 'a', 'n', 's', 'l', 'a', 't', 'e', 'd', '-', 'c', 'o', 'd', 'e'};
        generatedCodeTag = new char[]{'g', 'e', 'n', 'e', 'r', 'a', 't', 'e', 'd', '-', 'c', 'o', 'd', 'e'};
    }

    Scanner(Parser parser, byte[] sourceFileBuffer, int sourceFileSize, String encoding, int sourceJDKVersion) {
        this.parser = parser;
        this.keywordTable = parser.keywordTable;
        this.sourceJDKVersion = parser.options.sourceJDKVersion;
        this.convertByteBuffer2Unicode(sourceFileBuffer, sourceFileSize, encoding);
        this.token = new Token();
        this.scanLine = 1;
        this.lineInc = 1;
        this.prevTokenKind = (byte)109;
        this.prevPrevTokenKind = (byte)109;
        parser.deprecatedFlag = false;
    }

    private static boolean isASCII(char c) {
        return c <= '\u00ff';
    }

    private static boolean isOctDigit(char c) {
        return c <= '\u00ff' && _isOctDigit[c];
    }

    static boolean isHexDigit(char c) {
        return c <= '\u00ff' && _isHexDigit[c];
    }

    private static boolean isDigit(char c) {
        return c <= '\u00ff' && _isDigit[c];
    }

    private static boolean isWhitespace(char c) {
        return c <= '\u00ff' && _isWhitespace[c];
    }

    static int hexDigitValue(char c) {
        return c <= '\u00ff' ? _hexDigitValue[c] : 0;
    }

    private static int octDigitValue(char c) {
        return c - 48;
    }

    private static int digitValue(char c) {
        return c - 48;
    }

    private void convertByteBuffer2Unicode(byte[] bbuffer, int len, String encoding) {
        int i;
        int sourceLength;
        char[] targetBuffer;
        char[] sourceBuffer;
        if (encoding != null) {
            Charset charSet = Charset.forName(encoding);
            CharsetDecoder decoder = charSet.newDecoder();
            decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            decoder.onMalformedInput(CodingErrorAction.REPLACE);
            ByteBuffer byteBuffer = ByteBuffer.wrap(bbuffer, 0, len);
            CharBuffer charBuffer = CharBuffer.allocate((int)((float)len * decoder.maxCharsPerByte()));
            decoder.decode(byteBuffer, charBuffer, true);
            sourceBuffer = charBuffer.array();
            this.scanBuffer = sourceBuffer;
            targetBuffer = sourceBuffer;
            sourceLength = charBuffer.position();
            if (sourceLength + 1 >= targetBuffer.length) {
                this.scanBuffer = new char[sourceLength + 1];
                System.arraycopy(sourceBuffer, 0, this.scanBuffer, 0, sourceLength);
                sourceBuffer = this.scanBuffer;
                targetBuffer = this.scanBuffer;
            }
        } else {
            sourceLength = len;
            this.scanBuffer = new char[sourceLength + 1];
            targetBuffer = this.scanBuffer;
            sourceBuffer = this.scanBuffer;
            i = 0;
            while (i < len) {
                sourceBuffer[i] = (char)(bbuffer[i] & 0xFF);
                ++i;
            }
        }
        int line = 1;
        int lineStart = 0;
        int j = 0;
        i = 0;
        while (i < sourceLength) {
            char c = sourceBuffer[i];
            block0 : switch (c) {
                case '\\': {
                    if (i + 1 < sourceLength && sourceBuffer[i + 1] == '\\') {
                        ++i;
                        targetBuffer[j++] = 92;
                        targetBuffer[j++] = 92;
                        break;
                    }
                    int k = 0;
                    while (true) {
                        if (i + k + 1 < sourceLength && sourceBuffer[i + k + 1] != 'u') {
                            targetBuffer[j++] = 92;
                            break block0;
                        }
                        if (i + k + 2 >= sourceLength || sourceBuffer[i + k + 2] != 'u') break;
                        ++k;
                    }
                    if (i + k + 5 < sourceLength && Scanner.isHexDigit(sourceBuffer[i + k + 5]) && Scanner.isHexDigit(sourceBuffer[i + k + 4]) && Scanner.isHexDigit(sourceBuffer[i + k + 3]) && Scanner.isHexDigit(sourceBuffer[i + k + 2])) {
                        c = (char)(Scanner.hexDigitValue(sourceBuffer[i + k + 2]) << 12);
                        c = (char)(c | (char)(Scanner.hexDigitValue(sourceBuffer[i + k + 3]) << 8));
                        c = (char)(c | (char)(Scanner.hexDigitValue(sourceBuffer[i + k + 4]) << 4));
                        c = (char)(c | (char)Scanner.hexDigitValue(sourceBuffer[i + k + 5]));
                        i += k + 5;
                        targetBuffer[j++] = c;
                        break;
                    }
                    this.parser.error(Message.errorInvalidEscapeChar, line << 16 | j - lineStart & 0xFFFF, false);
                    targetBuffer[j++] = 92;
                    break;
                }
                case '\ufffd': {
                    this.parser.warning(null, Message.warningMalformedInput, line << 16 | j - lineStart & 0xFFFF);
                    targetBuffer[j++] = 32;
                    break;
                }
                case '\n': {
                    ++line;
                    lineStart = j + 1;
                }
                default: {
                    targetBuffer[j++] = c;
                    break;
                }
            }
            ++i;
        }
        if (j == 0 || targetBuffer[j - 1] != '@') {
            targetBuffer[j++] = 64;
        }
        this.scanBufferLength = j;
    }

    public static int positionToLine(int position) {
        return position >>> 16;
    }

    public static int positionToColumn(int position) {
        return position & 0xFFFF;
    }

    public static int lineColumnToPosition(int line, int column) {
        return line << 16 | column & 0xFFFF;
    }

    private int scanPosToLineColumnPos(int pos) {
        return this.scanLine << 16 | pos - this.scanLineStart & 0xFFFF;
    }

    private int parseWarningTag(char[] buffer, int position) {
        int state;
        if (this.parser.options.sourceJDKVersion >= 150) {
            this.parser.warning(null, Message.warningInvalidWarningTag, this.scanPosToLineColumnPos(this.scanPosition));
            return position;
        }
        if (Identifier.compare(buffer, position, onTag, 0, onTag.length)) {
            state = 1;
            position += onTag.length;
        } else if (Identifier.compare(buffer, position, offTag, 0, offTag.length)) {
            state = 0;
            position += offTag.length;
        } else if (Identifier.compare(buffer, position, defaultTag, 0, defaultTag.length)) {
            state = -1;
            position += defaultTag.length;
        } else {
            this.parser.warning(null, Message.warningInvalidWarningTag, this.scanPosToLineColumnPos(this.scanPosition));
            return position;
        }
        int number = 0;
        if (buffer[position] == ':') {
            char c;
            ++position;
            while (Scanner.isDigit(c = buffer[position])) {
                number = number * 10 + (c - 48);
                ++position;
            }
            if (number == 0) {
                this.parser.warning(null, Message.warningInvalidWarningTag, this.scanPosToLineColumnPos(this.scanPosition));
                return position;
            }
        }
        switch (state) {
            default: {
                if (number > 0) {
                    Warning.defaultWarning(number);
                    break;
                }
                Warning.defaultAllWarnings();
                break;
            }
            case 1: {
                if (number > 0) {
                    Warning.enableWarning(number);
                    break;
                }
                Warning.enableAllWarnings();
                break;
            }
            case 0: {
                if (number > 0) {
                    Warning.disableWarning(number);
                    break;
                }
                Warning.disableAllWarnings();
                break;
            }
        }
        return position;
    }

    private int parseLineinfoFilename(char[] buffer, int position) {
        String path;
        int lastSepChar;
        int start = position;
        char c = buffer[position++];
        while (c != '@' && c != '\n' && c != '\r' && c != '*') {
            c = buffer[position++];
        }
        if (start == --position) {
            return start;
        }
        String fname = new String(buffer, start, position - start).replace('/', File.separatorChar).replace('\\', File.separatorChar);
        if (fname.indexOf(File.separatorChar) == -1 && (fname.length() > 2 && fname.charAt(1) != ':' || fname.length() <= 2) && (lastSepChar = (path = this.parser.sourceFile.getCanonicalPath()).lastIndexOf(File.separatorChar)) != -1) {
            fname = path.substring(0, lastSepChar + 1) + fname;
        }
        if (!(fname.endsWith(".jsp") || fname.endsWith(".jspx") || fname.endsWith(".jsa"))) {
            c = '\u0000';
            int i = fname.length() - 1;
            while (i >= 0) {
                c = fname.charAt(i);
                if (c == File.separatorChar || c == ':' || c == '.') break;
                --i;
            }
            if (c != '.') {
                fname = fname + ".sqlj";
            }
        }
        if (position + 1 < this.scanBufferLength && buffer[position] == '*' && buffer[position + 1] == '/') {
            this.parser.sourceFile.preprocessorFile = new File(fname);
        }
        return position;
    }

    private int parseLineinfoTag(char[] buffer, int position) {
        int newLineInc = this.lineInc;
        int newScanLine = this.scanLine;
        if (Identifier.compare(buffer, position, filenameTag, 0, filenameTag.length)) {
            position = this.parseLineinfoFilename(buffer, position + filenameTag.length);
        } else if (Identifier.compare(buffer, position, userCodeTag, 0, userCodeTag.length)) {
            position += userCodeTag.length;
            newLineInc = 1;
        } else if (Identifier.compare(buffer, position, generatedCodeTag, 0, generatedCodeTag.length)) {
            position += generatedCodeTag.length;
            newScanLine = 1;
            newLineInc = 0;
        } else if (Identifier.compare(buffer, position, translatedCodeTag, 0, translatedCodeTag.length)) {
            position += translatedCodeTag.length;
            newLineInc = 0;
        } else {
            int[] newPosition = new int[]{0, 0};
            char c = buffer[position++];
            int i = 0;
            while (i < 2) {
                if (!Scanner.isDigit(c)) {
                    return position - 1;
                }
                do {
                    newPosition[i] = newPosition[i] * 10 + (c - 48);
                } while (Scanner.isDigit(c = buffer[position++]));
                if (i == 0) {
                    if (c != '^') {
                        return position - 1;
                    }
                    c = buffer[position++];
                }
                ++i;
            }
            position = c == '^' ? this.parseLineinfoFilename(buffer, position) : --position;
            if (newPosition[0] == 0) {
                newPosition[0] = 1;
            }
            newScanLine = newPosition[0];
        }
        if (position + 1 < this.scanBufferLength && buffer[position] == '*' && buffer[position + 1] == '/') {
            this.lineInc = newLineInc;
            this.scanLine = newScanLine;
        }
        return position;
    }

    private int parseJavaDocComment(char[] buffer, int position) {
        char[][] tagNameList;
        if (Identifier.compare(buffer, position, deprecatedTag, 0, deprecatedTag.length)) {
            position += deprecatedTag.length;
            this.parser.deprecatedFlag = true;
        }
        if ((tagNameList = this.parser.options.tagNameList) != null) {
            int i = 0;
            while (i < tagNameList.length) {
                char[] tag = tagNameList[i];
                if (Identifier.compare(buffer, position, tag, 0, tag.length)) {
                    this.parser.warning(null, Message.warningWarningTagFound, this.scanPosToLineColumnPos(position), new String(tag));
                    break;
                }
                ++i;
            }
        }
        return position;
    }

    private void skipLineComment() {
        char c;
        char[] buffer = this.scanBuffer;
        int position = this.scanPosition;
        if ((c = buffer[position++]) == '@' && position < this.scanBufferLength) {
            if (Identifier.compare(buffer, position, warningTag, 0, warningTag.length)) {
                position = this.parseWarningTag(buffer, position + warningTag.length);
            }
            c = buffer[position++];
        }
        while (true) {
            switch (c) {
                default: {
                    break;
                }
                case '@': {
                    if (position != this.scanBufferLength) break;
                    this.scanPosition = position - 1;
                    return;
                }
                case '\r': {
                    c = buffer[position];
                    if (c == '\n') {
                        ++position;
                    }
                }
                case '\n': {
                    this.scanLine += this.lineInc;
                    this.scanLineStart = this.scanPosition = position;
                    return;
                }
            }
            c = buffer[position++];
        }
    }

    private void skipTraditionalComment(int position) {
        char c;
        int pos = this.scanPosToLineColumnPos(position - 2);
        int commentLineStart = position + 1;
        boolean isJavaDocComment = false;
        char[] buffer = this.scanBuffer;
        if ((c = buffer[position++]) == '@' && position < this.scanBufferLength) {
            if (Identifier.compare(buffer, position, warningTag, 0, warningTag.length)) {
                position = this.parseWarningTag(buffer, position + warningTag.length);
            } else if (Identifier.compare(buffer, position, lineinfoTag, 0, lineinfoTag.length)) {
                position = this.parseLineinfoTag(buffer, position + lineinfoTag.length);
            }
            c = buffer[position++];
        } else if (c == '*') {
            isJavaDocComment = true;
        }
        block6: while (true) {
            switch (c) {
                default: {
                    break;
                }
                case '@': {
                    if (position == this.scanBufferLength) {
                        this.parser.error(Message.errorUnclosedComment, pos, false);
                        this.scanPosition = position - 1;
                        return;
                    }
                    if (!isJavaDocComment) break;
                    boolean isTag = true;
                    int lookBackPosition = position - 2;
                    while (lookBackPosition >= commentLineStart) {
                        if ((c = buffer[lookBackPosition--]) == '*' || Scanner.isWhitespace(c)) continue;
                        isTag = false;
                        break;
                    }
                    if (!isTag) break;
                    position = this.parseJavaDocComment(buffer, position);
                    break;
                }
                case '\r': {
                    c = buffer[position];
                    if (c == '\n') {
                        // empty if block
                    }
                }
                case '\n': {
                    this.scanLine += this.lineInc;
                    this.scanLineStart = commentLineStart = ++position;
                    break;
                }
                case '*': {
                    if ((c = buffer[position++]) != '/') continue block6;
                    this.scanPosition = position;
                    return;
                }
            }
            c = buffer[position++];
        }
    }

    private boolean isFloatValueZeroDotZero(int start, int end) {
        char[] buffer = this.scanBuffer;
        while (start <= end) {
            char c;
            if ((c = buffer[start++]) == '.' || !Scanner.isDigit(c) || Scanner.digitValue(c) == 0) continue;
            return false;
        }
        return true;
    }

    private strictfp byte scanFloatingPointConstant(int startPosition, int position, char suffixLC) {
        char c;
        char suffixUC = suffixLC == 'e' ? (char)'E' : 'P';
        char[] buffer = this.scanBuffer;
        if ((c = buffer[position++]) == '.') {
            do {
                c = buffer[position++];
            } while (!(suffixLC == 'e' ? !Scanner.isDigit(c) : !Scanner.isHexDigit(c)));
        }
        int endPosition = position - 1;
        if (c == suffixLC || c == suffixUC) {
            if ((c = buffer[position++]) == '+' || c == '-') {
                c = buffer[position++];
            }
            while (Scanner.isDigit(c)) {
                c = buffer[position++];
            }
        }
        if (c == 'f' || c == 'F') {
            String str = new String(buffer, startPosition, position - startPosition);
            try {
                this.token.fval = Float.parseFloat(str);
                if (this.token.fval == 0.0f && !this.isFloatValueZeroDotZero(startPosition, endPosition)) {
                    this.parser.error(Message.errorNumericUnderflow, this.scanPosToLineColumnPos(startPosition), false);
                } else if (this.token.fval == Float.POSITIVE_INFINITY) {
                    this.parser.error(Message.errorNumericOverflow, this.scanPosToLineColumnPos(startPosition), false);
                }
            }
            catch (NumberFormatException e) {
                this.parser.error(Message.errorMalformedFloating, this.scanPosToLineColumnPos(startPosition), false);
            }
            this.scanPosition = position;
            return 15;
        }
        if (c != 'd' && c != 'D') {
            --position;
        }
        String str = new String(buffer, startPosition, position - startPosition);
        try {
            this.token.dval = Double.parseDouble(str);
            if (this.token.dval == 0.0 && !this.isFloatValueZeroDotZero(startPosition, endPosition)) {
                this.parser.error(Message.errorNumericUnderflow, this.scanPosToLineColumnPos(startPosition), false);
            } else if (this.token.dval == Double.POSITIVE_INFINITY) {
                this.parser.error(Message.errorNumericOverflow, this.scanPosToLineColumnPos(startPosition), false);
            }
        }
        catch (NumberFormatException e) {
            this.parser.error(Message.errorMalformedFloating, this.scanPosToLineColumnPos(startPosition), false);
        }
        this.scanPosition = position;
        return 16;
    }

    private strictfp byte scanDecFloatingPointConstant(int startPosition, int position) {
        return this.scanFloatingPointConstant(startPosition, position, 'e');
    }

    private strictfp byte scanHexFloatingPointConstant(int startPosition, int position) {
        return this.scanFloatingPointConstant(startPosition, position, 'p');
    }

    private byte scanHexConstant() {
        char c;
        char[] buffer = this.scanBuffer;
        int position = this.scanPosition;
        if (!$a && buffer[position - 1] != 'x' && buffer[position - 1] != 'X') {
            throw new AssertionError();
        }
        if (!Scanner.isHexDigit(c = buffer[position++])) {
            if (c == '.' && this.parser.options.sourceJDKVersion >= 150) {
                return this.scanHexFloatingPointConstant(this.scanPosition - 2, position - 1);
            }
            this.parser.error(Message.errorMalformedInteger, this.scanPosToLineColumnPos(position - 1), false);
            c = buffer[position++];
            if (!Scanner.isHexDigit(c)) {
                this.token.ival = 0;
                this.scanPosition = position - 2;
                return 13;
            }
        }
        long val = Scanner.hexDigitValue(c);
        int digits = 1;
        while (Scanner.isHexDigit(c = buffer[position++])) {
            val = val * (long)16 + (long)Scanner.hexDigitValue(c);
            if (digits++ != 16) continue;
            this.parser.error(Message.errorIntegerTooLarge, this.token.pos, false);
        }
        switch (c) {
            case '.': 
            case 'P': 
            case 'p': {
                if (this.parser.options.sourceJDKVersion >= 150) {
                    return this.scanHexFloatingPointConstant(this.scanPosition - 2, position - 1);
                }
            }
            default: {
                --position;
                if (0L <= val && val <= 0xFFFFFFFFL) {
                    this.scanPosition = position;
                    this.token.ival = (int)val;
                    return 13;
                }
                this.parser.error(Message.errorIntegerTooLarge, this.token.pos, false);
            }
            case 'L': 
            case 'l': 
        }
        this.scanPosition = position;
        this.token.lval = val;
        return 14;
    }

    private byte scanOctConstant() {
        char c;
        char[] buffer = this.scanBuffer;
        int position = this.scanPosition;
        if (!$a && buffer[position - 1] != '0') {
            throw new AssertionError();
        }
        boolean errorFlag = false;
        long octVal = 0L;
        long decVal = 0L;
        long val = 0L;
        while (Scanner.isOctDigit(c = buffer[position++])) {
            if (octVal < 0L && !errorFlag) {
                errorFlag = true;
                this.parser.error(Message.errorIntegerTooLarge, this.scanPosToLineColumnPos(this.scanPosition), false);
            }
            val = Scanner.octDigitValue(c);
            octVal = octVal * (long)8 + val;
            decVal = octVal * (long)10 + val;
        }
        switch (c) {
            default: {
                break;
            }
            case 'F': 
            case 'f': {
                this.scanPosition = position;
                this.token.fval = decVal;
                return 15;
            }
            case 'D': 
            case 'd': {
                this.scanPosition = position;
                this.token.dval = decVal;
                return 15;
            }
            case '.': 
            case 'E': 
            case 'e': {
                return this.scanDecFloatingPointConstant(this.scanPosition - 1, position - 1);
            }
        }
        if (c != 'l' && c != 'L') {
            if (0L <= octVal && octVal <= 0xFFFFFFFFL) {
                this.scanPosition = position - 1;
                this.token.ival = (int)octVal;
                return 13;
            }
            if (!errorFlag) {
                this.parser.error(Message.errorIntegerTooLarge, this.token.pos, false);
            }
            this.scanPosition = position - 1;
        } else {
            this.scanPosition = position;
        }
        this.token.lval = octVal;
        return 14;
    }

    private byte scanNumericConstant() {
        char c;
        char[] buffer = this.scanBuffer;
        int position = this.scanPosition - 1;
        boolean errorFlag = false;
        long val = 0L;
        long prevVal = 0L;
        while (Scanner.isDigit(c = buffer[position++])) {
            prevVal = val;
            if (((val = val * (long)10 + (long)Scanner.digitValue(c)) >= prevVal || val == Long.MIN_VALUE) && prevVal >= 0L) continue;
            while (Scanner.isDigit(c = buffer[position++])) {
            }
            switch (c) {
                case '.': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'd': 
                case 'e': 
                case 'f': {
                    return this.scanDecFloatingPointConstant(this.scanPosition - 1, position - 1);
                }
            }
            if (errorFlag) break;
            this.parser.error(Message.errorIntegerTooLarge, this.token.pos, false);
            errorFlag = true;
            break;
        }
        boolean longFlag = false;
        switch (c) {
            default: {
                break;
            }
            case 'L': 
            case 'l': {
                longFlag = true;
                break;
            }
            case 'F': 
            case 'f': {
                this.scanPosition = position;
                this.token.fval = val;
                return 15;
            }
            case 'D': 
            case 'd': {
                this.scanPosition = position;
                this.token.dval = val;
                return 16;
            }
            case '.': 
            case 'E': 
            case 'e': {
                return this.scanDecFloatingPointConstant(this.scanPosition - 1, position - 1);
            }
        }
        if (0L <= val && val <= 0xFFFFFFFFL && !longFlag) {
            this.scanPosition = position - 1;
            this.token.ival = (int)val;
            if ((int)val < 0) {
                if (val == 0x80000000L) {
                    if (this.prevTokenKind != 97 || Token.isIdentifierOrNumeralToken(this.prevPrevTokenKind)) {
                        this.parser.error(Message.errorIntegerTooLarge, this.token.pos, false);
                    }
                } else {
                    this.parser.error(Message.errorIntegerTooLarge, this.token.pos, false);
                }
            }
            return 13;
        }
        if (!longFlag) {
            this.parser.error(Message.errorIntegerTooLarge, this.token.pos, false);
            this.scanPosition = position - 1;
        } else {
            this.scanPosition = position;
        }
        this.token.lval = val;
        if (val == Long.MIN_VALUE && (this.prevTokenKind != 97 || Token.isIdentifierOrNumeralToken(this.prevPrevTokenKind))) {
            this.parser.error(Message.errorIntegerTooLarge, this.token.pos, false);
        }
        return 14;
    }

    private char scanEscapeSequence() {
        char[] buffer = this.scanBuffer;
        int position = this.scanPosition;
        if (!$a && buffer[position - 1] != '\\') {
            throw new AssertionError();
        }
        char c = buffer[position++];
        switch (c) {
            case '@': {
                if (position == this.scanBufferLength) {
                    this.scanPosition = position - 1;
                }
            }
            default: {
                this.parser.error(Message.errorInvalidEscapeChar, this.scanPosToLineColumnPos(position - 1), false);
                this.scanPosition = position;
                return '\u0000';
            }
            case '\"': 
            case '\'': 
            case '\\': {
                this.scanPosition = position;
                return c;
            }
            case 'b': {
                this.scanPosition = position;
                return '\b';
            }
            case 't': {
                this.scanPosition = position;
                return '\t';
            }
            case 'n': {
                this.scanPosition = position;
                return '\n';
            }
            case 'f': {
                this.scanPosition = position;
                return '\f';
            }
            case 'r': {
                this.scanPosition = position;
                return '\r';
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
        }
        int n = c - 48;
        char c1 = buffer[position];
        if (!Scanner.isOctDigit(c1)) {
            this.scanPosition = position;
            return (char)n;
        }
        n = n * 8 + Scanner.octDigitValue(c1);
        if (!Scanner.isOctDigit(c1 = buffer[++position]) || c > '3') {
            this.scanPosition = position;
            return (char)n;
        }
        n = n * 8 + Scanner.octDigitValue(c1);
        this.scanPosition = position + 1;
        return (char)n;
    }

    private void scanCharacterConstant() {
        char[] buffer = this.scanBuffer;
        int position = this.scanPosition;
        if (!$a && buffer[position - 1] != '\'') {
            throw new AssertionError();
        }
        char c = buffer[position++];
        switch (c) {
            case '@': {
                if (position == this.scanBufferLength) {
                    this.token.cval = '\u0000';
                    this.parser.error(Message.errorUnclosedCharLiteral, this.token.pos, false);
                    this.scanPosition = position - 1;
                    return;
                }
            }
            default: {
                this.token.cval = c;
                break;
            }
            case '\n': 
            case '\r': {
                this.scanLine += this.lineInc;
                this.scanLineStart = this.scanPosition = position;
                this.parser.error(Message.errorUnclosedCharLiteral, this.token.pos, false);
                this.token.cval = '\u0000';
                return;
            }
            case '\'': {
                this.parser.error(Message.errorEmptyCharLiteral, this.token.pos, false);
                this.scanPosition = position;
                return;
            }
            case '\\': {
                c = buffer[position];
                this.scanPosition = position;
                this.token.cval = this.scanEscapeSequence();
                position = this.scanPosition;
                break;
            }
        }
        c = buffer[position];
        if (c != '\'') {
            this.parser.error(Message.errorUnclosedCharLiteral, this.token.pos, false);
        } else {
            ++position;
        }
        this.scanPosition = position;
    }

    private void scanStringConstant() {
        int position;
        StringBuffer str = null;
        int len = 0;
        int strlen = 0;
        char[] buffer = this.scanBuffer;
        int strStartPos = position = this.scanPosition;
        if (!$a && buffer[position - 1] != '\"') {
            throw new AssertionError();
        }
        block6: while (true) {
            char c = buffer[position++];
            switch (c) {
                case '@': {
                    if (position == this.scanBufferLength) {
                        this.scanPosition = position - 1;
                        this.parser.error(Message.errorUnclosedCharLiteral, this.token.pos, false);
                        this.token.sval = new char[0];
                        return;
                    }
                }
                default: {
                    ++strlen;
                    ++len;
                    continue block6;
                }
                case '\n': 
                case '\r': {
                    this.scanLine += this.lineInc;
                    this.scanLineStart = this.scanPosition = position;
                    this.parser.error(Message.errorUnclosedCharLiteral, this.token.pos, false);
                    this.token.sval = new char[0];
                    return;
                }
                case '\"': {
                    this.scanPosition = position;
                    this.token.sval = new char[strlen];
                    if (str == null) {
                        System.arraycopy(buffer, strStartPos, this.token.sval, 0, len);
                    } else {
                        str.append(buffer, strStartPos, len);
                        str.getChars(0, strlen, this.token.sval, 0);
                    }
                    return;
                }
                case '\\': 
            }
            c = buffer[position];
            this.scanPosition = position;
            if (str == null) {
                str = new StringBuffer(len + 80);
            }
            str.append(buffer, strStartPos, len);
            int pos = position - 1;
            char wc = this.scanEscapeSequence();
            if (c == 'u' && (wc == '\r' || wc == '\n')) {
                this.parser.error(Message.errorIllegalCharacter, this.scanPosToLineColumnPos(pos), false);
            }
            str.append(wc);
            ++strlen;
            len = 0;
            strStartPos = position = this.scanPosition;
        }
    }

    private static boolean isUTF32JavaIdentifier(boolean start, char c1, char c2) {
        Class[] formalParams = new Class[]{Character.TYPE, Character.TYPE};
        Object[] actualParams = new Object[]{new Character(c1), new Character(c2)};
        try {
            Method m;
            Boolean b;
            Class clazz = class$java$lang$Character;
            if (clazz == null) {
                clazz = class$java$lang$Character = Scanner.class$("java.lang.Character");
            }
            if (!(b = (Boolean)(m = clazz.getMethod("isSurrogatePair", formalParams)).invoke(null, actualParams)).booleanValue()) {
                boolean bl = false;
                return bl;
            }
            Class clazz2 = class$java$lang$Character;
            if (clazz2 == null) {
                clazz2 = class$java$lang$Character = Scanner.class$("java.lang.Character");
            }
            m = clazz2.getMethod("toCodePoint", formalParams);
            Integer i = (Integer)m.invoke(null, actualParams);
            Class clazz3 = class$java$lang$Character;
            if (clazz3 == null) {
                clazz3 = class$java$lang$Character = Scanner.class$("java.lang.Character");
            }
            if (!(b = (Boolean)(m = clazz3.getMethod(start ? "isJavaIdentifierStart" : "isJavaIdentifierPart", Integer.TYPE)).invoke(null, i)).booleanValue()) {
                boolean bl = false;
                return bl;
            }
        }
        catch (ClassCastException e) {
            boolean bl = false;
            return bl;
        }
        catch (NoSuchMethodException e) {
            boolean bl = false;
            return bl;
        }
        catch (IllegalAccessException e) {
            boolean bl = false;
            return bl;
        }
        catch (InvocationTargetException e) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private void scanIdentifier() {
        int position;
        char[] buffer = this.scanBuffer;
        int startPosition = position = this.scanPosition;
        int hash = 0;
        boolean start = true;
        while (true) {
            char c;
            int h;
            if ((h = Identifier.hashIdentifierMap[c = buffer[position++]]) == 0) {
                if (c == '@' || this.parser.options.sourceJDKVersion < 150 || !Scanner.isUTF32JavaIdentifier(start, c, buffer[position])) break;
                hash += c;
                hash += buffer[position++];
            } else {
                hash += h;
            }
            start = false;
        }
        this.scanPosition = position - 1;
        this.token.id = Identifier.getIdentifier(buffer, startPosition, this.scanPosition - startPosition, hash);
    }

    byte scan() {
        int tokenKind22;
        char[] buffer = this.scanBuffer;
        int position = this.scanPosition;
        this.token.prevEndPos = this.scanPosToLineColumnPos(position);
        this.prevScanPosition = position;
        this.prevPrevTokenKind = this.prevTokenKind;
        this.prevTokenKind = this.token.kind;
        block79: while (true) {
            char c = buffer[position++];
            while (Scanner.isWhitespace(c)) {
                c = buffer[position++];
            }
            this.token.pos = this.scanPosToLineColumnPos(position - 1);
            switch (c) {
                default: {
                    if (Character.isJavaIdentifierStart(c) || this.parser.options.sourceJDKVersion >= 150 && Scanner.isUTF32JavaIdentifier(true, c, buffer[position])) {
                        this.scanPosition = position - 1;
                        this.scanIdentifier();
                        this.token.kind = 10;
                        byte tokenKind22 = 10;
                        return tokenKind22;
                    }
                    this.parser.error(Message.errorIllegalCharacter, this.scanPosToLineColumnPos(position - 1), false);
                    continue block79;
                }
                case '\u001a': {
                    if (position + 1 == this.scanBufferLength) continue block79;
                    this.parser.error(Message.errorIllegalCharacter, this.scanPosToLineColumnPos(position - 1), false);
                    continue block79;
                }
                case '\r': {
                    c = buffer[position];
                    if (c == '\n') {
                        // empty if block
                    }
                }
                case '\n': {
                    this.scanLine += this.lineInc;
                    this.scanLineStart = ++position;
                    continue block79;
                }
                case '@': {
                    if (position == this.scanBufferLength) {
                        tokenKind22 = 9;
                        break block79;
                    }
                    if (this.parser.options.sourceJDKVersion < 150) {
                        this.parser.error(Message.errorIllegalCharacter, this.scanPosToLineColumnPos(position - 1), false);
                        continue block79;
                    }
                    tokenKind22 = 107;
                    break block79;
                }
                case ',': {
                    tokenKind22 = 62;
                    break block79;
                }
                case ';': {
                    tokenKind22 = 63;
                    break block79;
                }
                case '(': {
                    tokenKind22 = 101;
                    break block79;
                }
                case ')': {
                    tokenKind22 = 102;
                    break block79;
                }
                case '[': {
                    tokenKind22 = 76;
                    break block79;
                }
                case ']': {
                    tokenKind22 = 77;
                    break block79;
                }
                case '{': {
                    tokenKind22 = 80;
                    break block79;
                }
                case '}': {
                    tokenKind22 = 81;
                    break block79;
                }
                case '?': {
                    tokenKind22 = 78;
                    break block79;
                }
                case ':': {
                    tokenKind22 = 79;
                    break block79;
                }
                case '~': {
                    tokenKind22 = 106;
                    break block79;
                }
                case '!': {
                    c = buffer[position];
                    if (c == '=') {
                        ++position;
                        tokenKind22 = 88;
                        break block79;
                    }
                    tokenKind22 = 105;
                    break block79;
                }
                case '=': {
                    c = buffer[position];
                    if (c == '=') {
                        ++position;
                        tokenKind22 = 87;
                        break block79;
                    }
                    tokenKind22 = 64;
                    break block79;
                }
                case '*': {
                    c = buffer[position];
                    if (c == '=') {
                        ++position;
                        tokenKind22 = 67;
                        break block79;
                    }
                    tokenKind22 = 98;
                    break block79;
                }
                case '^': {
                    c = buffer[position];
                    if (c == '=') {
                        ++position;
                        tokenKind22 = 71;
                        break block79;
                    }
                    tokenKind22 = 86;
                    break block79;
                }
                case '%': {
                    c = buffer[position];
                    if (c == '=') {
                        ++position;
                        tokenKind22 = 72;
                        break block79;
                    }
                    tokenKind22 = 100;
                    break block79;
                }
                case '+': {
                    c = buffer[position];
                    switch (c) {
                        default: {
                            tokenKind22 = 96;
                            break block79;
                        }
                        case '+': {
                            ++position;
                            tokenKind22 = 103;
                            break block79;
                        }
                        case '=': 
                    }
                    ++position;
                    tokenKind22 = 65;
                    break block79;
                }
                case '-': {
                    c = buffer[position];
                    switch (c) {
                        default: {
                            tokenKind22 = 97;
                            break block79;
                        }
                        case '-': {
                            ++position;
                            tokenKind22 = 104;
                            break block79;
                        }
                        case '=': 
                    }
                    ++position;
                    tokenKind22 = 66;
                    break block79;
                }
                case '&': {
                    c = buffer[position];
                    switch (c) {
                        default: {
                            tokenKind22 = 84;
                            break block79;
                        }
                        case '&': {
                            ++position;
                            tokenKind22 = 82;
                            break block79;
                        }
                        case '=': 
                    }
                    ++position;
                    tokenKind22 = 69;
                    break block79;
                }
                case '|': {
                    c = buffer[position];
                    switch (c) {
                        default: {
                            tokenKind22 = 85;
                            break block79;
                        }
                        case '|': {
                            ++position;
                            tokenKind22 = 83;
                            break block79;
                        }
                        case '=': 
                    }
                    ++position;
                    tokenKind22 = 70;
                    break block79;
                }
                case '<': {
                    c = buffer[position];
                    switch (c) {
                        default: {
                            tokenKind22 = 89;
                            break block79;
                        }
                        case '=': {
                            ++position;
                            tokenKind22 = 91;
                            break block79;
                        }
                        case '<': 
                    }
                    c = buffer[++position];
                    if (c == '=') {
                        ++position;
                        tokenKind22 = 73;
                        break block79;
                    }
                    tokenKind22 = 93;
                    break block79;
                }
                case '>': {
                    c = buffer[position];
                    switch (c) {
                        default: {
                            tokenKind22 = 90;
                            break block79;
                        }
                        case '=': {
                            ++position;
                            tokenKind22 = 92;
                            break block79;
                        }
                        case '>': 
                    }
                    c = buffer[++position];
                    switch (c) {
                        default: {
                            tokenKind22 = 94;
                            break block79;
                        }
                        case '=': {
                            ++position;
                            tokenKind22 = 74;
                            break block79;
                        }
                        case '>': 
                    }
                    c = buffer[++position];
                    if (c == '=') {
                        ++position;
                        tokenKind22 = 75;
                        break block79;
                    }
                    tokenKind22 = 95;
                    break block79;
                }
                case '/': {
                    c = buffer[position];
                    switch (c) {
                        default: {
                            tokenKind22 = 99;
                            break block79;
                        }
                        case '=': {
                            ++position;
                            tokenKind22 = 68;
                            break block79;
                        }
                        case '/': {
                            this.scanPosition = position + 1;
                            this.skipLineComment();
                            position = this.scanPosition;
                            continue block79;
                        }
                        case '*': 
                    }
                    this.skipTraditionalComment(position + 1);
                    position = this.scanPosition;
                    continue block79;
                }
                case '\"': {
                    this.scanPosition = position;
                    this.scanStringConstant();
                    this.token.kind = 12;
                    byte tokenKind22 = 12;
                    return tokenKind22;
                }
                case '\'': {
                    this.scanPosition = position;
                    this.scanCharacterConstant();
                    this.token.kind = 11;
                    byte tokenKind22 = 11;
                    return tokenKind22;
                }
                case '.': {
                    c = buffer[position];
                    if (Scanner.isDigit(c)) {
                        byte tokenKind22;
                        this.token.kind = tokenKind22 = this.scanDecFloatingPointConstant(--position, position);
                        return tokenKind22;
                    }
                    if (c == '.' && buffer[position + 1] == '.') {
                        position += 2;
                        tokenKind22 = 108;
                        break block79;
                    }
                    tokenKind22 = 61;
                    break block79;
                }
                case '0': {
                    byte tokenKind22;
                    c = buffer[position];
                    switch (c) {
                        default: {
                            if (Scanner.isOctDigit(c)) {
                                byte tokenKind22;
                                this.scanPosition = position;
                                this.token.kind = tokenKind22 = this.scanOctConstant();
                                return tokenKind22;
                            }
                            this.token.ival = 0;
                            tokenKind22 = 13;
                            break block79;
                        }
                        case 'D': 
                        case 'd': {
                            this.token.dval = 0.0;
                            tokenKind22 = 16;
                            ++position;
                            break block79;
                        }
                        case '.': 
                        case 'E': 
                        case 'e': {
                            byte tokenKind22;
                            this.token.kind = tokenKind22 = this.scanDecFloatingPointConstant(position - 1, position);
                            return tokenKind22;
                        }
                        case 'F': 
                        case 'f': {
                            this.token.fval = 0.0f;
                            tokenKind22 = 15;
                            ++position;
                            break block79;
                        }
                        case 'L': 
                        case 'l': {
                            this.token.lval = 0L;
                            tokenKind22 = 14;
                            ++position;
                            break block79;
                        }
                        case 'X': 
                        case 'x': 
                    }
                    this.scanPosition = position + 1;
                    this.token.kind = tokenKind22 = this.scanHexConstant();
                    return tokenKind22;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    byte tokenKind22;
                    this.scanPosition = position;
                    this.token.kind = tokenKind22 = this.scanNumericConstant();
                    return tokenKind22;
                }
                case '$': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    int hash = Identifier.hashIdentifierMap[c];
                    int startPosition = position - 1;
                    c = buffer[position++];
                    int h = Identifier.hashIdentifierMap[c];
                    if (h != 0) {
                        hash += h;
                        if ((h = Identifier.hashIdentifierMap[c = buffer[position++]]) != 0) {
                            hash += h;
                            if ((h = Identifier.hashIdentifierMap[c = buffer[position++]]) != 0) {
                                hash += h;
                                if ((h = Identifier.hashIdentifierMap[c = buffer[position++]]) != 0) {
                                    hash += h;
                                    if ((h = Identifier.hashIdentifierMap[c = buffer[position++]]) != 0) {
                                        hash += h;
                                        if ((h = Identifier.hashIdentifierMap[c = buffer[position++]]) != 0) {
                                            hash += h;
                                            if ((h = Identifier.hashIdentifierMap[c = buffer[position++]]) != 0) {
                                                hash += h;
                                                c = buffer[position++];
                                                while ((h = Identifier.hashIdentifierMap[c]) != 0) {
                                                    hash += h;
                                                    c = buffer[position++];
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (c > '\u00ff' && this.parser.options.sourceJDKVersion >= 150 && Scanner.isUTF32JavaIdentifier(false, c, buffer[position])) {
                        this.scanPosition = startPosition;
                        this.scanIdentifier();
                        this.token.kind = (byte)10;
                        return 10;
                    }
                    tokenKind22 = 10;
                    int len = --position - startPosition;
                    this.token.id = Identifier.getIdentifier(buffer, startPosition, len, hash);
                    if (2 > len || len > 12) break block79;
                    tokenKind22 = this.keywordTable.lookupKeyword(this.token.id);
                    switch (tokenKind22) {
                        default: {
                            break block79;
                        }
                        case 17: {
                            if (this.sourceJDKVersion >= 140) break block79;
                            tokenKind22 = 10;
                            if (this.warnedAssert) break block79;
                            this.warnedAssert = true;
                            this.parser.warning(null, Message.warningKeywordShouldNotBeUsed, this.scanPosToLineColumnPos(startPosition), "assert", "1.4");
                            break block79;
                        }
                        case 28: {
                            if (this.sourceJDKVersion >= 150) break block79;
                            tokenKind22 = 10;
                            if (this.warnedEnum) break block79;
                            this.warnedEnum = true;
                            this.parser.warning(null, Message.warningKeywordShouldNotBeUsed, this.scanPosToLineColumnPos(startPosition), "enum", "1.5");
                            break block79;
                        }
                    }
                }
            }
            break;
        }
        this.scanPosition = position;
        this.token.kind = (byte)tokenKind22;
        return (byte)tokenKind22;
    }

    byte scanAhead() {
        byte savedPrevPrevTokenKind = this.prevPrevTokenKind;
        byte savedPrevTokenKind = this.prevTokenKind;
        int prevScanPos = this.prevScanPosition;
        int prevTokenPos = this.token.prevEndPos;
        byte kind = this.scan();
        this.prevTokenKind = savedPrevPrevTokenKind;
        this.token.kind = savedPrevTokenKind;
        this.scanPosition = prevScanPos;
        this.scanLine = Scanner.positionToLine(prevTokenPos);
        this.scanLineStart = this.scanPosition - Scanner.positionToColumn(prevTokenPos);
        this.scan();
        return kind;
    }

    Object saveScannerState() {
        SavedScannerState sss = new SavedScannerState();
        sss.scanPosition = this.scanPosition;
        sss.scanLine = this.scanLine;
        sss.scanLineStart = this.scanLineStart;
        sss.lineInc = this.lineInc;
        sss.token = new Token();
        sss.token.copy(this.token);
        sss.prevPrevTokenKind = this.prevPrevTokenKind;
        sss.prevTokenKind = this.prevTokenKind;
        sss.prevScanPosition = this.prevScanPosition;
        return sss;
    }

    void restoreScannerState(Object o) {
        SavedScannerState sss = (SavedScannerState)o;
        this.scanPosition = sss.scanPosition;
        this.scanLine = sss.scanLine;
        this.scanLineStart = sss.scanLineStart;
        this.lineInc = sss.lineInc;
        this.token.copy(sss.token);
        this.prevPrevTokenKind = sss.prevPrevTokenKind;
        this.prevTokenKind = sss.prevTokenKind;
        this.prevScanPosition = sss.prevScanPosition;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class SavedScannerState {
        int scanPosition;
        int scanLine;
        int scanLineStart;
        int lineInc;
        Token token;
        byte prevPrevTokenKind;
        byte prevTokenKind;
        int prevScanPosition;

        private SavedScannerState() {
        }
    }
}

