/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import java.util.BitSet;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LabelStatement;
import oracle.ojc.compiler.LabelSymbol;
import oracle.ojc.compiler.LoopStatement;
import oracle.ojc.compiler.SwitchStatement;

final class SwitchLoopList {
    SwitchLoopList outerSwitchLoop;
    SwitchStatement switchStmt;
    LoopStatement loopStmt;
    ArrayList caseStmts;
    LabelSymbol breakSymbol;
    LabelSymbol continueSymbol;
    BitSet defSet;
    BitSet posSet;
    BitSet useSet;
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    SwitchLoopList(SwitchLoopList outerSwitchLoop, SwitchStatement switchStmt, LoopStatement loopStmt, BitSet defSet, BitSet posSet, BitSet useSet) {
        this.outerSwitchLoop = outerSwitchLoop;
        this.switchStmt = switchStmt;
        this.loopStmt = loopStmt;
        this.defSet = (BitSet)defSet.clone();
        this.posSet = (BitSet)posSet.clone();
        this.useSet = (BitSet)useSet.clone();
        if (switchStmt != null) {
            this.caseStmts = new ArrayList();
        }
    }

    boolean inLoop() {
        SwitchLoopList sll = this;
        while (sll != null) {
            if (sll.loopStmt != null) {
                return true;
            }
            sll = sll.outerSwitchLoop;
        }
        return false;
    }

    LoopStatement getLoopStatement() {
        SwitchLoopList sll = this;
        while (sll != null) {
            if (sll.loopStmt != null) {
                return sll.loopStmt;
            }
            sll = sll.outerSwitchLoop;
        }
        return null;
    }

    LabelSymbol getBreakSymbol() {
        LabelSymbol bsym = this.breakSymbol;
        if (bsym == null) {
            bsym = new LabelSymbol(0, null);
            bsym.label = new Label();
            this.breakSymbol = bsym;
        }
        return bsym;
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = SwitchLoopList.class$("oracle.ojc.compiler.SwitchLoopList");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    LabelSymbol getContinueSymbol() {
        if (!$a && this.loopStmt == null) {
            throw new AssertionError();
        }
        LabelSymbol csym = this.continueSymbol;
        if (csym == null) {
            csym = new LabelSymbol(0, null);
            csym.label = new Label();
            this.continueSymbol = csym;
        }
        return csym;
    }

    void insertLabels() {
        LabelSymbol csym;
        LabelSymbol bsym = this.breakSymbol;
        if (bsym != null) {
            if (this.switchStmt != null) {
                this.switchStmt.insertAfter(new LabelStatement(this.switchStmt.parent, 0, 7, bsym));
            } else {
                this.loopStmt.insertAfter(new LabelStatement(this.loopStmt.parent, 0, 7, bsym));
            }
        }
        if ((csym = this.continueSymbol) != null) {
            if (!$a && this.loopStmt == null) {
                throw new AssertionError();
            }
            this.loopStmt.bodyStatements.last.insertAfter(new LabelStatement(this.loopStmt.bodyStatements, 0, 7, csym));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

