/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import java.util.BitSet;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.BreakStatement;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.CaseStatement;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.DefaultStatement;
import oracle.ojc.compiler.EnumMapClassSymbol;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LabelSymbol;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SwitchLoopList;
import oracle.ojc.compiler.TypeSymbol;

final class SwitchStatement
extends Statement {
    Expression switchExpr;
    StatementList bodyStatements;
    DefaultStatement defaultStmt;
    CaseStatement[] caseStmts;
    SwitchLoopList switchRec;
    BitSet resultDefSet;
    BitSet resultPosSet;
    BitSet resultUseSet;
    EnumMapClassSymbol emc;

    SwitchStatement(StatementList parent, int pos, Expression switchExpr, StatementList bodyStatements) {
        super(parent, pos, (byte)4);
        this.switchExpr = switchExpr;
        this.bodyStatements = bodyStatements;
        bodyStatements.parent = this;
    }

    private void saveCaseStatementConstants(ArrayList al) {
        int size = al.size();
        if (size > 0) {
            CaseStatement[] csarr;
            int off;
            if (this.caseStmts != null) {
                off = this.caseStmts.length;
                csarr = new CaseStatement[off + size];
                System.arraycopy(this.caseStmts, 0, csarr, 0, off);
            } else {
                off = 0;
                csarr = new CaseStatement[size];
            }
            int i = size;
            while (--i >= 0) {
                csarr[off + i] = (CaseStatement)al.get(i);
            }
            this.caseStmts = csarr;
        } else if (this.caseStmts == null) {
            this.caseStmts = new CaseStatement[0];
        }
    }

    void resolveAndCheck(Parser parser) {
        Expression expr = this.switchExpr;
        expr = expr.resolveAndCheck(parser);
        TypeSymbol exprType = expr.getType();
        byte typeClass = exprType.typeClass;
        if ((typeClass & 4) == 0) {
            TypeSymbol primitiveType;
            if (exprType.isEnum()) {
                this.emc = EnumMapClassSymbol.getEnumMapClass(parser, parser.currentClassSymbol);
            } else if (parser.options.sourceJDKVersion >= 150 && exprType.isReferenceType() && (primitiveType = BoxingExpression.getPrimitiveType(parser, exprType)) != null && (primitiveType.typeClass & 4) != 0) {
                expr = expr.promoteType(parser, primitiveType);
            } else {
                parser.error(Message.errorIncompatibleTypes, expr.pos, exprType.isErroneous(), exprType.errorName(), "int");
            }
        }
        this.switchExpr = expr;
        SwitchLoopList outerSwitchLoop = parser.innerSwitchLoop;
        this.switchRec = new SwitchLoopList(outerSwitchLoop, this, null, parser.defSet, parser.posSet, parser.useSet);
        try {
            parser.innerSwitchLoop = this.switchRec;
            this.bodyStatements.resolveAndCheck(parser);
            Statement last = this.bodyStatements.last;
            if (last != null) {
                if (last.kind == 9) {
                    BreakStatement breakStmt = (BreakStatement)last;
                    if (breakStmt.labelSymbol == null) {
                        this.bodyStatements.remove(breakStmt);
                    }
                }
                if (!last.canReachNextStatement(true) && this.resultDefSet != null) {
                    parser.defSet = this.resultDefSet;
                }
            }
            this.saveCaseStatementConstants(this.switchRec.caseStmts);
            this.switchRec.caseStmts = null;
            CaseStatement[] csarr = this.caseStmts;
            int size = csarr.length;
            if (size == 0) {
                parser.warning(null, Message.warningSwitchWithoutCase, this.pos);
            } else {
                boolean swapped;
                int l = 1;
                do {
                    swapped = false;
                    int i = 0;
                    while (i < size - l) {
                        CaseStatement cs1 = csarr[i + 1];
                        CaseStatement cs0 = csarr[i];
                        int cv1 = cs1.caseValue;
                        int cv0 = cs0.caseValue;
                        if (cv1 < cv0) {
                            csarr[i + 1] = cs0;
                            csarr[i] = cs1;
                            swapped = true;
                        } else if (cv1 == cv0) {
                            parser.error(Message.errorDuplicateCase, cs1.pos, false);
                        }
                        ++i;
                    }
                    ++l;
                } while (swapped);
            }
            this.switchRec.insertLabels();
            if (this.resultDefSet != null) {
                if (this.defaultStmt == null) {
                    parser.defSet = this.switchRec.defSet;
                } else {
                    parser.defSet.and(this.resultDefSet);
                }
            }
            if (this.resultPosSet != null) {
                parser.posSet.or(this.resultPosSet);
            }
            if (this.resultUseSet != null) {
                parser.useSet.or(this.resultUseSet);
            }
            Object var19_18 = null;
            if (this.switchRec.caseStmts != null) {
                this.saveCaseStatementConstants(this.switchRec.caseStmts);
            }
            parser.innerSwitchLoop = outerSwitchLoop;
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            if (this.switchRec.caseStmts != null) {
                this.saveCaseStatementConstants(this.switchRec.caseStmts);
            }
            parser.innerSwitchLoop = outerSwitchLoop;
            throw throwable;
        }
        if (!this.canReachNextStatement(true)) {
            this.setLastStatement();
        }
        if (this.next != null && this.next.isCodeStatement() && !this.canReachNextStatement(false)) {
            parser.error(Message.errorUnreachableStatement, this.next.pos, false);
        }
    }

    void updateDefUseSetsAfterReturn(Parser parser) {
        if (this.resultUseSet == null) {
            this.resultUseSet = parser.useSet;
        } else {
            this.resultUseSet.or(parser.useSet);
        }
        this.parent.updateDefUseSetsAfterReturn(parser);
    }

    void updateDefUseSetsAfterThrow(Parser parser, ClassSymbol thrownClass) {
        if (this.resultUseSet == null) {
            this.resultUseSet = parser.useSet;
        } else {
            this.resultUseSet.or(parser.useSet);
        }
        this.parent.updateDefUseSetsAfterThrow(parser, thrownClass);
    }

    void updateDefUseSetsAfterBreak(Parser parser, LabelSymbol labelSymbol) {
        if (labelSymbol != null) {
            this.parent.updateDefUseSetsAfterBreak(parser, labelSymbol);
        } else {
            if (!parser.suspendDataFlowChecking) {
                if (this.resultDefSet == null) {
                    this.resultDefSet = (BitSet)parser.defSet.clone();
                } else {
                    this.resultDefSet.and(parser.defSet);
                }
            }
            if (this.resultPosSet == null) {
                this.resultPosSet = (BitSet)parser.posSet.clone();
            } else {
                this.resultPosSet.or(parser.posSet);
            }
            if (this.resultUseSet == null) {
                this.resultUseSet = (BitSet)parser.useSet.clone();
            } else {
                this.resultUseSet.or(parser.useSet);
            }
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        if (this.emc != null) {
            RawClassSymbol enumClassSymbol = ((ClassSymbol)this.switchExpr.getType()).getClassSymbol();
            short index = byteCodeGenerator.constantPool.enterConstantPoolFieldRef(this.emc.getInternalName(), this.emc.getMapName(enumClassSymbol), Identifier.intArraySignature.name);
            byteCodeGenerator.generate_8_16((byte)-78, index);
            byteCodeGenerator.incOpStackHeight(1);
            this.switchExpr.generateByteCode(byteCodeGenerator);
            index = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(enumClassSymbol.getInternalName(), Identifier.ordinalIdentifier.name, Identifier.intMethodSignature.name);
            byteCodeGenerator.generate_8_16_8((byte)-74, index, (byte)46);
            byteCodeGenerator.decOpStackHeight(1);
        } else {
            this.switchExpr.generateByteCode(byteCodeGenerator);
        }
        SwitchLoopList outerSwitchLoop = byteCodeGenerator.parser.innerSwitchLoop;
        byteCodeGenerator.parser.innerSwitchLoop = this.switchRec;
        CaseStatement[] csarr = this.caseStmts;
        int size = csarr.length;
        int x = 0;
        while (x < size) {
            csarr[x].label = new Label();
            ++x;
        }
        if (this.defaultStmt != null) {
            this.defaultStmt.label = new Label();
        }
        if (this.switchRec.breakSymbol != null) {
            this.switchRec.breakSymbol.label = new Label();
        }
        if (size == 0) {
            byteCodeGenerator.generate_8((byte)87);
            byteCodeGenerator.decOpStackHeight(1);
            if (this.defaultStmt != null) {
                this.bodyStatements.generateByteCode(byteCodeGenerator);
            }
        } else {
            int lo = csarr[0].caseValue;
            int hi = csarr[size - 1].caseValue;
            Label defaultLabel = this.defaultStmt == null ? new Label() : this.defaultStmt.label;
            if (0 < hi - lo && hi - lo < size + size / 4) {
                short basePC = byteCodeGenerator.generateGetPC();
                byteCodeGenerator.generate_8((byte)-86);
                byteCodeGenerator.decOpStackHeight(1);
                int pc = basePC + 1;
                while ((pc & 3) != 0) {
                    ++pc;
                    byteCodeGenerator.generate_8((byte)0);
                }
                byteCodeGenerator.generateTableFixup(basePC, defaultLabel);
                byteCodeGenerator.generate_32(lo);
                byteCodeGenerator.generate_32(hi);
                int cv = csarr[0].caseValue;
                int i = 0;
                while (true) {
                    if (lo != cv) {
                        byteCodeGenerator.generateTableFixup(basePC, defaultLabel);
                        ++lo;
                        continue;
                    }
                    byteCodeGenerator.generateTableFixup(basePC, csarr[i].label);
                    if (lo != hi) {
                        ++lo;
                        cv = csarr[++i].caseValue;
                        continue;
                    }
                    break;
                }
            } else {
                short basePC = byteCodeGenerator.generateGetPC();
                byteCodeGenerator.generate_8((byte)-85);
                byteCodeGenerator.decOpStackHeight(1);
                int pc = basePC + 1;
                while ((pc & 3) != 0) {
                    ++pc;
                    byteCodeGenerator.generate_8((byte)0);
                }
                byteCodeGenerator.generateTableFixup(basePC, defaultLabel);
                byteCodeGenerator.generate_32(size);
                int i = 0;
                while (i < size) {
                    CaseStatement cs = csarr[i];
                    byteCodeGenerator.generate_32(cs.caseValue);
                    byteCodeGenerator.generateTableFixup(basePC, cs.label);
                    ++i;
                }
            }
            this.bodyStatements.generateByteCode(byteCodeGenerator);
            if (this.defaultStmt == null) {
                byteCodeGenerator.setLabel(defaultLabel);
            }
        }
        byteCodeGenerator.parser.innerSwitchLoop = outerSwitchLoop;
    }

    boolean canReachNextStatement(boolean strict) {
        if (this.defaultStmt == null) {
            return true;
        }
        return this.bodyStatements.canReachNextStatement(strict) || this.switchRec.breakSymbol != null && (this.switchRec.breakSymbol.labeledStatement == null || this.switchRec.breakSymbol.labeledStatement.labeledStatements == this.parent);
    }
}

