/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.PackageScope;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.TypeSymbol;

abstract class Symbol {
    static final short ACC_NONE = 0;
    static final short ACC_PUBLIC = 1;
    static final short ACC_PRIVATE = 2;
    static final short ACC_PROTECTED = 4;
    static final short ACC_STATIC = 8;
    static final short ACC_FINAL = 16;
    static final short ACC_SUPER = 32;
    static final short ACC_SYNCHRONIZED = 32;
    static final short ACC_VOLATILE = 64;
    static final short ACC_BRIDGE = 64;
    static final short ACC_TRANSIENT = 128;
    static final short ACC_VARARGS = 128;
    static final short ACC_NATIVE = 256;
    static final short ACC_INTERFACE = 512;
    static final short ACC_ABSTRACT = 1024;
    static final short ACC_STRICTFP = 2048;
    static final short ACC_SYNTHETIC = 4096;
    static final short ACC_ANNOTATION = 8192;
    static final short ACC_ENUM = 16384;
    static final byte SY_UNRESOLVED = 1;
    static final byte SY_FIELD = 2;
    static final byte SY_IMPORT = 4;
    static final byte SY_METHOD = 8;
    static final byte SY_PACKAGE = 16;
    static final byte SY_TYPE = 32;
    static final byte SY_VARIABLE = 64;
    static final byte SY_LABEL = -128;
    static final byte SY_ANY = -1;
    static final byte SF_NONE = 0;
    static final byte SF_SUPPRESSWARNINGS = 1;
    static final byte SF_ERROR = 2;
    static final byte SF_EMIT_FINAL_ERROR = 4;
    static final byte SF_NON_REIFIABLE = 8;
    Symbol nextHashed;
    Scope scope;
    byte kind;
    byte symbolFlags;
    int pos;
    Identifier identifier;
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    Symbol(byte kind, int pos, Identifier identifier) {
        this.kind = kind;
        this.pos = pos;
        this.identifier = identifier;
    }

    static void initializeSymbols() {
        TypeSymbol.initializeStatics();
        FieldSymbol.initializeStatics();
        RawClassSymbol.initializeStatics();
        ParameterizedClassSymbol.initializeStatics();
        ReferenceTypeSymbol.initializeStatics();
    }

    static void releaseSymbols() {
        TypeSymbol.releaseStatics();
        FieldSymbol.releaseStatics();
        ParameterizedClassSymbol.releaseStatics();
        RawClassSymbol.releaseStatics();
        ReferenceTypeSymbol.releaseStatics();
    }

    boolean isDeprecated() {
        return false;
    }

    boolean isSynthetic() {
        return false;
    }

    void deprecate() {
    }

    boolean isErroneous() {
        return false;
    }

    String errorName() {
        return this.kindName() + " " + this.identifier.toString();
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = Symbol.class$("oracle.ojc.compiler.Symbol");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    String kindName() {
        if (!$a) {
            throw new AssertionError();
        }
        return "";
    }

    protected void toString(StringBuffer sb) {
        if (!$a) {
            throw new AssertionError();
        }
    }

    char[] getInternalName() {
        return this.getSignature();
    }

    char[] getSignature() {
        if (!$a) {
            throw new AssertionError();
        }
        return null;
    }

    static final String accessToString(short access) {
        if ((access & 1) != 0) {
            return "public";
        }
        if ((access & 2) != 0) {
            return "private";
        }
        if ((access & 4) != 0) {
            return "protected";
        }
        if ((access & 8) != 0) {
            return "static";
        }
        if ((access & 0x10) != 0) {
            return "final";
        }
        if ((access & 0x20) != 0) {
            return "synchronized";
        }
        if ((access & 0x40) != 0) {
            return "volatile";
        }
        if ((access & 0x80) != 0) {
            return "transient";
        }
        if ((access & 0x100) != 0) {
            return "native";
        }
        if ((access & 0x400) != 0) {
            return "abstract";
        }
        if ((access & 0x800) != 0) {
            return "strictfp";
        }
        return "";
    }

    static int getAccessStrength(short access) {
        switch (access & 7) {
            case 1: {
                return 3;
            }
            case 4: {
                return 2;
            }
            default: {
                return 1;
            }
            case 2: 
        }
        return 0;
    }

    void checkForAmbigousImport(Parser parser, int pos, Scope scope, short kind) {
        while (scope.kind > 1) {
            scope = scope.getOuterScope();
        }
        PackageScope packageScope = (PackageScope)scope;
        if (packageScope.isAmbigousImport(this.identifier, kind)) {
            parser.error(Message.errorDoubleImport, pos, false, this.errorName());
        }
    }

    Annotation getAnnotations() {
        return null;
    }

    byte getAnnotationTarget() {
        if (!$a) {
            throw new AssertionError();
        }
        return -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

