/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.FileOutputStream;
import java.io.PrintStream;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.interfaces.ErrorInfo;
import oracle.ojc.interfaces.Log2;
import oracle.ojc.interfaces.Storage;

public class SystemLog
implements Log2 {
    private PrintStream ps = System.err;
    private int nwarnings;
    private int nerrors;
    private Storage sourceStorage;
    private byte[] sourceBuffer;

    public void redirect(String fileName) {
        try {
            this.ps = new PrintStream(new FileOutputStream(fileName));
        }
        catch (Exception e) {
            this.ps = System.err;
        }
    }

    protected void finalize() {
        this.ps.flush();
        if (this.ps != System.err) {
            this.ps.close();
        }
    }

    public void print(String word) {
        this.ps.print(word);
    }

    public void println(String line) {
        this.ps.println(line);
        this.ps.flush();
    }

    private void printMessage(Storage source, int pos, ErrorInfo info, boolean warning) {
        block22: {
            byte b;
            block21: {
                if (pos != 0) break block21;
                if (source != null) {
                    this.print(source.toString() + ":1: ");
                }
                this.println((warning ? Message.warningString : Message.errorString) + " #" + info.getNumber() + ": " + info.getMessage());
                break block22;
            }
            byte[] bbuffer = this.sourceBuffer;
            if (source != this.sourceStorage) {
                try {
                    source.open();
                    bbuffer = source.read();
                    source.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.sourceStorage = source;
                this.sourceBuffer = bbuffer;
            }
            int line = Scanner.positionToLine(pos);
            int column = Scanner.positionToColumn(pos);
            int currentLine = 1;
            int currentCol = 0;
            int lineStartOff = 0;
            byte pb = 0;
            int off = 0;
            while (currentLine != line || currentCol != column) {
                block20: {
                    b = bbuffer[off];
                    block1 : switch (b) {
                        case 13: {
                            if (bbuffer[off + 1] == 10) {
                                ++off;
                            }
                        }
                        case 10: {
                            lineStartOff = off + 1;
                            currentCol = 0;
                            ++currentLine;
                            pb = bbuffer[off];
                            break block20;
                        }
                        case 92: {
                            if (off + 1 < bbuffer.length && bbuffer[off + 1] == 92) {
                                ++off;
                                break;
                            }
                            int k = 0;
                            while (off + k + 1 >= bbuffer.length || this.sourceBuffer[off + k + 1] == 117) {
                                if (off + k + 2 < bbuffer.length && this.sourceBuffer[off + k + 2] == 117) {
                                    ++k;
                                    pb = b;
                                    continue;
                                }
                                if (off + k + 5 >= bbuffer.length || !Scanner.isHexDigit((char)bbuffer[off + k + 5]) || !Scanner.isHexDigit((char)bbuffer[off + k + 4]) || !Scanner.isHexDigit((char)bbuffer[off + k + 3]) || !Scanner.isHexDigit((char)bbuffer[off + k + 2])) break block1;
                                char c = (char)(Scanner.hexDigitValue((char)bbuffer[off + k + 2]) << 12);
                                c = (char)(c | (char)(Scanner.hexDigitValue((char)bbuffer[off + k + 3]) << 8));
                                c = (char)(c | (char)(Scanner.hexDigitValue((char)bbuffer[off + k + 4]) << 4));
                                if ((c = (char)(c | (char)Scanner.hexDigitValue((char)bbuffer[off + k + 5]))) == '\r' || c == '\n') {
                                    lineStartOff = off + k + 5;
                                    currentCol = 0;
                                    if (pb != 13) {
                                        ++currentLine;
                                    }
                                    pb = (byte)c;
                                    break block20;
                                }
                                off += k + 5;
                                break block1;
                            }
                            break;
                        }
                    }
                    pb = b;
                    ++currentCol;
                }
                ++off;
            }
            while (off != bbuffer.length && (b = bbuffer[off]) != 10) {
                ++off;
            }
            String str = new String(bbuffer, lineStartOff, off - lineStartOff);
            this.println(source.toString() + ":" + line + ": " + (warning ? Message.warningString : Message.errorString) + " #" + info.getNumber() + ": " + info.getMessage());
            this.println(str);
            int i = 0;
            while (i < column) {
                b = bbuffer[lineStartOff + i];
                if (b == 9) {
                    this.print("\t");
                } else {
                    this.print(" ");
                }
                ++i;
            }
            this.println("^");
        }
    }

    public void printError(Storage source, int pos, ErrorInfo info) {
        ++this.nerrors;
        this.printMessage(source, pos, info, false);
    }

    public void printError(String errorMessage) {
        ++this.nerrors;
        this.println(Message.errorColonString + errorMessage);
    }

    public void printWarning(Storage source, int pos, ErrorInfo info) {
        ++this.nwarnings;
        this.printMessage(source, pos, info, true);
    }

    public void printWarning(String warningMessage) {
        ++this.nwarnings;
        this.println(Message.warningColonString + warningMessage);
    }

    public int nerrors() {
        return this.nerrors;
    }

    public int nwarnings() {
        return this.nwarnings;
    }
}

