/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;
import oracle.ojc.compiler.VariableExpression;

class ThisExpression
extends VariableExpression {
    RawClassSymbol classSymbol;
    TypeSymbol outerClassSymbol;
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    ThisExpression(int pos, RawClassSymbol classSymbol) {
        super(pos);
        this.classSymbol = classSymbol;
    }

    short getAccess() {
        return 16;
    }

    String errorName() {
        return "this";
    }

    Expression resolveAndCheck(Parser parser) {
        RawClassSymbol thisClass;
        if (parser.currentMethodSymbol != null && (parser.currentMethodSymbol.access & 8) != 0 || parser.currentFieldSymbol != null && (parser.currentFieldSymbol.access & 8) != 0) {
            Error error = parser.error(Message.errorUndefinedThis, this.pos, false, "this");
            return new ErrorExpression(error);
        }
        if (this.outerClassSymbol != null) {
            TypeSymbol outerClass = this.outerClassSymbol.resolveType(parser, this.pos, true, true, false);
            if (outerClass.typeKind != 10) {
                Error error = parser.error(Message.errorObjectRequired, this.pos, outerClass.isErroneous(), outerClass.errorName());
                return new ErrorExpression(error);
            }
            this.outerClassSymbol = ((ClassSymbol)outerClass).getClassSymbol();
            if (this.classSymbol.equalTo(this.outerClassSymbol)) {
                this.outerClassSymbol = null;
                thisClass = this.classSymbol;
            } else {
                if (!this.classSymbol.isInnerClass((RawClassSymbol)this.outerClassSymbol)) {
                    Error error = parser.error(Message.errorIllegalQualifierNotInner, this.pos, false, this.outerClassSymbol.errorName());
                    return new ErrorExpression(error);
                }
                RawClassSymbol innerClass = this.classSymbol;
                while (!innerClass.equalTo(this.outerClassSymbol) && innerClass.isInnerClass()) {
                    if ((innerClass.access & 8) != 0) {
                        Error error = parser.error(Message.errorUndefinedThis, this.pos, false, "this");
                        return new ErrorExpression(error);
                    }
                    innerClass = innerClass.getOuterClass();
                }
                thisClass = (RawClassSymbol)this.outerClassSymbol;
            }
        } else {
            thisClass = this.classSymbol;
        }
        this.setType(ParameterizedClassSymbol.getParameterizedClassSymbol(thisClass, TypeVariableList.newTypeVariableList(thisClass.cd.getTypeParameterList()), null));
        return this;
    }

    Expression resolveAndCheckReadBeforeWrite(Parser parser) {
        parser.error(Message.errorFinalCannotBeAssigned, this.pos, false, this.errorName());
        return this.resolveAndCheck(parser);
    }

    Expression resolveAndCheckWrite(Parser parser) {
        parser.error(Message.errorFinalCannotBeAssigned, this.pos, false, this.errorName());
        return this.resolveAndCheck(parser);
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        if (!byteCodeGenerator.parser.currentMethodSymbol.isConstructor() || this.outerClassSymbol == null) {
            byteCodeGenerator.loadLocalVariable(this.getType(), (short)0);
        }
        if (this.outerClassSymbol != null) {
            byteCodeGenerator.generateOuterClassFieldAccessor((RawClassSymbol)this.outerClassSymbol, this.classSymbol, true);
        }
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = ThisExpression.class$("oracle.ojc.compiler.ThisExpression");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
    }

    void generateByteCodeReadBeforeWrite(ByteCodeGenerator byteCodeGenerator, boolean x1) {
        if (!$a) {
            throw new AssertionError();
        }
    }

    void generateByteCodeWrite(ByteCodeGenerator byteCodeGenerator) {
        if (!$a) {
            throw new AssertionError();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

