/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableSymbol;

final class TypeVariableList {
    TypeVariableList next;
    TypeVariableSymbol typeVariable;

    TypeVariableList(TypeVariableSymbol typeVariable) {
        this.typeVariable = typeVariable;
    }

    public boolean equals(TypeVariableList tvl2) {
        return this.equals(tvl2, null);
    }

    boolean equals(TypeVariableList tvl2, TypeSymbol recursionCheck) {
        TypeVariableList tvl1 = this;
        while (tvl1 != null && tvl2 != null) {
            if (!tvl1.typeVariable.equalTo(tvl2.typeVariable, recursionCheck)) {
                return false;
            }
            tvl1 = tvl1.next;
            tvl2 = tvl2.next;
        }
        return tvl1 == tvl2;
    }

    boolean isAccessible(ClassSymbol fromClass) {
        TypeVariableList tvl = this;
        while (tvl != null) {
            if (!tvl.typeVariable.isAccessible(fromClass)) {
                return false;
            }
            tvl = tvl.next;
        }
        return true;
    }

    static TypeVariableList newTypeVariableList(TypeParameterList tpl) {
        return TypeVariableList.newTypeVariableList(tpl, false);
    }

    static TypeVariableList newTypeVariableListExtendFromBounds(TypeParameterList tpl) {
        return TypeVariableList.newTypeVariableList(tpl, true);
    }

    private static TypeVariableList newTypeVariableList(TypeParameterList tpl, boolean extendsBounds) {
        TypeVariableList tvLast = null;
        TypeVariableList tvList = null;
        while (tpl != null) {
            TypeVariableSymbol tvs = extendsBounds ? new TypeVariableSymbol(0, 2, tpl.typeParameter.bound) : new TypeVariableSymbol(0, 1, tpl.typeParameter);
            TypeVariableList tvl = new TypeVariableList(tvs);
            if (tvList == null) {
                tvList = tvLast = tvl;
            } else {
                tvLast.next = tvl;
                tvLast = tvl;
            }
            tpl = tpl.next;
        }
        return tvList;
    }

    protected void toString(StringBuffer buf) {
        TypeVariableList tvl = this;
        buf.append('<');
        while (true) {
            tvl.typeVariable.toString(buf);
            tvl = tvl.next;
            if (tvl == null) break;
            buf.append(',');
        }
        buf.append('>');
    }
}

