/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;

final class TypeVariableSymbol
extends ClassSymbol {
    static final byte TVK_ANY = 0;
    static final byte TVK_VARIABLE = 1;
    static final byte TVK_UPPERBOUND = 2;
    static final byte TVK_LOWERBOUND = 3;
    private static final char[] wildcardSignature;
    byte typeVariableKind;
    TypeSymbol refSymbol;
    static final /* synthetic */ boolean $a;
    static /* synthetic */ Class $c;

    TypeVariableSymbol(int pos, byte typeVariableKind, ReferenceTypeSymbol refSymbol) {
        super(pos, null, (byte)10, (short)0, null);
        this.typeVariableKind = typeVariableKind;
        this.refSymbol = refSymbol;
    }

    String errorName() {
        if (this.refSymbol.isErroneous()) {
            return "";
        }
        return this.toString();
    }

    char[] getSignature() {
        if (this.refSymbol != null) {
            return this.refSymbol.getSignature();
        }
        return RawClassSymbol.javaLangObjectSymbol.getSignature();
    }

    static {
        Class clazz = $c;
        if (clazz == null) {
            clazz = $c = TypeVariableSymbol.class$("oracle.ojc.compiler.TypeVariableSymbol");
        }
        $a = clazz.desiredAssertionStatus() ^ true;
        wildcardSignature = new char[]{'*'};
    }

    protected void toString(StringBuffer sb) {
        switch (this.typeVariableKind) {
            default: {
                if (!$a) {
                    throw new AssertionError();
                }
            }
            case 0: {
                sb.append('?');
                break;
            }
            case 2: {
                sb.append("? extends ");
                this.refSymbol.toString(sb);
                break;
            }
            case 3: {
                sb.append("? super ");
                this.refSymbol.toString(sb);
                break;
            }
            case 1: {
                this.refSymbol.toString(sb);
                break;
            }
        }
    }

    boolean equalTo(TypeSymbol typeSymbol, TypeSymbol recursionCheck) {
        block32: {
            block31: {
                if (!(typeSymbol instanceof TypeVariableSymbol)) break block31;
                TypeVariableSymbol targetTvs = (TypeVariableSymbol)typeSymbol;
                TypeVariableSymbol sourceTvs = this;
                if (targetTvs.typeVariableKind == 0) {
                    return true;
                }
                if (sourceTvs.typeVariableKind == 0) {
                    if (ClassSymbol.doMethodTypeParameterConversion && targetTvs.refSymbol.isMethodTypeParameter()) {
                        TypeParameterSymbol tps = (TypeParameterSymbol)targetTvs.refSymbol;
                        return this.isJavaLangObject(tps.bound);
                    }
                    if (targetTvs.typeVariableKind == 2 && targetTvs.refSymbol.isClass() && !targetTvs.refSymbol.isTypeParameter()) {
                        return this.isJavaLangObject((ClassSymbol)targetTvs.refSymbol);
                    }
                    return false;
                }
                if (sourceTvs.refSymbol.isParameterizedClass() && targetTvs.refSymbol.isParameterizedClass()) {
                    ParameterizedClassSymbol sourcePc = (ParameterizedClassSymbol)sourceTvs.refSymbol;
                    ParameterizedClassSymbol targetPc = (ParameterizedClassSymbol)targetTvs.refSymbol;
                    if (sourcePc.genericClassSymbol == targetPc.genericClassSymbol) {
                        if (sourcePc.typeVariableList == null && targetPc.typeVariableList != null) {
                            return false;
                        }
                        if (sourcePc.typeVariableList != null && targetPc.typeVariableList == null) {
                            if (targetTvs.typeVariableKind != 2) {
                                return false;
                            }
                            if (sourceTvs.typeVariableKind == 3) {
                                return false;
                            }
                        } else if (sourcePc.typeVariableList != null && targetPc.typeVariableList != null && sourceTvs.typeVariableKind == 1 && targetTvs.typeVariableKind == 1 && this.nestedTypeVariableListsNotEqual(sourcePc.typeVariableList, targetPc.typeVariableList)) {
                            return false;
                        }
                    }
                }
                if (sourceTvs.refSymbol.isArrayType()) {
                    if (targetTvs.refSymbol.isArrayType()) {
                        ArraySymbol sourceArraySymbol = (ArraySymbol)sourceTvs.refSymbol;
                        ArraySymbol targetArraySymbol = (ArraySymbol)targetTvs.refSymbol;
                        TypeSymbol sourceTypeSymbol = ArraySymbol.getArrayType(sourceArraySymbol.baseType, sourceArraySymbol.dimension - 1);
                        TypeSymbol targetTypeSymbol = ArraySymbol.getArrayType(targetArraySymbol.baseType, targetArraySymbol.dimension - 1);
                        if (sourceTypeSymbol.isReferenceType() && targetTypeSymbol.isReferenceType()) {
                            TypeVariableSymbol baseSourceTvs = new TypeVariableSymbol(sourceTvs.pos, sourceTvs.typeVariableKind, (ReferenceTypeSymbol)sourceTypeSymbol);
                            TypeVariableSymbol baseTargetTvs = new TypeVariableSymbol(targetTvs.pos, targetTvs.typeVariableKind, (ReferenceTypeSymbol)targetTypeSymbol);
                            return baseSourceTvs.equalTo(baseTargetTvs);
                        }
                        return sourceTypeSymbol.equalTo(targetTypeSymbol, recursionCheck);
                    }
                    if (targetTvs.refSymbol.isTypeParameter()) {
                        return this.isJavaLangObject(((TypeParameterSymbol)targetTvs.refSymbol).bound);
                    }
                    return false;
                }
                if (!sourceTvs.refSymbol.isClass() || !targetTvs.refSymbol.isClass()) {
                    return false;
                }
                switch (sourceTvs.typeVariableKind << 8 | targetTvs.typeVariableKind) {
                    default: {
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 256: 
                    case 512: 
                    case 768: {
                        if (!$a) {
                            throw new AssertionError();
                        }
                        return false;
                    }
                    case 513: 
                    case 769: {
                        if (sourceTvs.refSymbol.isTypeParameter() && targetTvs.refSymbol.isTypeParameter() && sourceTvs.refSymbol == targetTvs.refSymbol) {
                            return false;
                        }
                        if (!targetTvs.refSymbol.isTypeParameter() && !sourceTvs.refSymbol.isTypeParameter()) {
                            return false;
                        }
                        if (ClassSymbol.doMethodTypeParameterConversion || !targetTvs.refSymbol.isTypeParameter()) break;
                        return false;
                    }
                }
                if (sourceTvs.refSymbol.equalTo(targetTvs.refSymbol, recursionCheck)) {
                    return true;
                }
                switch (sourceTvs.typeVariableKind << 8 | targetTvs.typeVariableKind) {
                    default: {
                        break block32;
                    }
                    case 257: 
                    case 515: 
                    case 770: {
                        return false;
                    }
                    case 258: 
                    case 514: 
                    case 769: {
                        ClassSymbol refClass = (ClassSymbol)this.refSymbol;
                        ClassSymbol tvsRefClass = (ClassSymbol)targetTvs.refSymbol;
                        return tvsRefClass.isSuperclass(refClass, recursionCheck) || refClass.implementsInterface(tvsRefClass, recursionCheck);
                    }
                    case 259: 
                    case 513: 
                    case 771: {
                        ClassSymbol refClass = (ClassSymbol)this.refSymbol;
                        ClassSymbol tvsRefClass = (ClassSymbol)targetTvs.refSymbol;
                        return refClass.isSuperclass(tvsRefClass, recursionCheck) || tvsRefClass.implementsInterface(refClass, recursionCheck);
                    }
                }
            }
            if (this.refSymbol != null) {
                return this.refSymbol.equalTo(typeSymbol, recursionCheck);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean nestedTypeVariableListsNotEqual(TypeVariableList source, TypeVariableList target) {
        TypeVariableList sourceTvl = source;
        TypeVariableList targetTvl = target;
        while (sourceTvl != null && targetTvl != null) {
            TypeVariableSymbol sourceTvs = sourceTvl.typeVariable;
            TypeVariableSymbol targetTvs = targetTvl.typeVariable;
            if (targetTvs.typeVariableKind == 0 && sourceTvs.typeVariableKind == 2 && sourceTvs.refSymbol != null && sourceTvs.refSymbol.isClass() && this.isJavaLangObject((ClassSymbol)sourceTvs.refSymbol)) {
                return false;
            }
            if (sourceTvs.typeVariableKind != targetTvs.typeVariableKind) {
                return true;
            }
            if (sourceTvs.refSymbol != targetTvs.refSymbol) {
                if (sourceTvs.refSymbol.isTypeParameter() && targetTvs.refSymbol.isTypeParameter()) {
                    TypeParameterSymbol sourceTps = (TypeParameterSymbol)sourceTvs.refSymbol;
                    TypeParameterSymbol targetTps = (TypeParameterSymbol)targetTvs.refSymbol;
                    if (!sourceTps.isMethodTypeParameter() || !targetTps.isMethodTypeParameter()) {
                        if (sourceTps.isMethodTypeParameter()) return true;
                        if (targetTps.isMethodTypeParameter()) return true;
                    }
                    if (!sourceTps.bound.equalTo(targetTps.bound)) {
                        return true;
                    }
                } else {
                    if (!sourceTvs.refSymbol.isParameterizedClass()) return true;
                    if (!targetTvs.refSymbol.isParameterizedClass()) {
                        return true;
                    }
                    ParameterizedClassSymbol sourcePcs = (ParameterizedClassSymbol)sourceTvs.refSymbol;
                    ParameterizedClassSymbol targetPcs = (ParameterizedClassSymbol)targetTvs.refSymbol;
                    if (sourcePcs.getClassSymbol() != targetPcs.getClassSymbol()) {
                        return true;
                    }
                    if (this.nestedTypeVariableListsNotEqual(sourcePcs.typeVariableList, targetPcs.typeVariableList)) {
                        return true;
                    }
                }
            }
            sourceTvl = sourceTvl.next;
            targetTvl = targetTvl.next;
        }
        if (sourceTvl == targetTvl) return false;
        return true;
    }

    TypeSymbol resolveType(Parser parser, int pos, boolean mustBePublic, boolean checkActualTypeParameters, boolean lazy) {
        if (this.refSymbol != null) {
            this.refSymbol = this.refSymbol.resolveType(parser, this.pos, mustBePublic, checkActualTypeParameters, false, true);
            if (this.refSymbol.isErroneous()) {
                this.refSymbol = parser.javaLangObjectPcs;
            }
        }
        return this;
    }

    boolean isTypeVariable() {
        return true;
    }

    boolean isInterface() {
        if (this.refSymbol.isArrayType()) {
            return false;
        }
        return ((ClassSymbol)this.refSymbol).isInterface();
    }

    boolean involvesGenerics() {
        return true;
    }

    char[] getGenericSignature() {
        StringBuffer sb;
        switch (this.typeVariableKind) {
            default: {
                if (!$a) {
                    throw new AssertionError();
                }
            }
            case 0: {
                return wildcardSignature;
            }
            case 2: {
                sb = new StringBuffer("+");
                break;
            }
            case 3: {
                sb = new StringBuffer("-");
                break;
            }
            case 1: {
                sb = new StringBuffer();
                break;
            }
        }
        sb.append(this.refSymbol.getGenericSignature());
        return sb.toString().toCharArray();
    }

    boolean involvesTypeParameter() {
        if (this.refSymbol != null) {
            return this.refSymbol.involvesTypeParameter();
        }
        return false;
    }

    boolean containsTypeParameterDefinedBy(Symbol definedBySymbol) {
        if (this.refSymbol != null) {
            return this.refSymbol.containsTypeParameterDefinedBy(definedBySymbol);
        }
        return false;
    }

    boolean containsTypeParameter(TypeParameterSymbol tps) {
        if (this.refSymbol != null) {
            return this.refSymbol.containsTypeParameter(tps);
        }
        return false;
    }

    void getTypeParameterSymbol(ArrayList al) {
        if (this.refSymbol != null) {
            this.refSymbol.getTypeParameterSymbol(al);
        }
    }

    void changeScope(Scope scope) {
        if (this.refSymbol != null) {
            this.refSymbol.changeScope(scope);
        }
    }

    TypeSymbol replaceUnresolvedTypeParameters(TypeParameterList tpl) {
        if (this.refSymbol != null) {
            this.refSymbol = this.refSymbol.replaceUnresolvedTypeParameters(tpl);
        }
        return this;
    }

    TypeSymbol replaceTypeParameters(TypeParameterList tpl) {
        TypeSymbol newRefSymbol;
        if (this.refSymbol != null && (newRefSymbol = this.refSymbol.replaceTypeParameters(tpl)) != this.refSymbol) {
            return new TypeVariableSymbol(this.pos, this.typeVariableKind, (ReferenceTypeSymbol)newRefSymbol);
        }
        return this;
    }

    TypeSymbol applyTypeVariables(TypeParameterList tpl, TypeVariableList tvl, boolean topLevel) {
        TypeSymbol newRefSymbol;
        if (this.refSymbol != null && (newRefSymbol = this.refSymbol.applyTypeVariables(tpl, tvl, false)) != this.refSymbol) {
            if (newRefSymbol == null) {
                return new TypeVariableSymbol(this.pos, 0, null);
            }
            if (newRefSymbol.isTypeVariable()) {
                TypeVariableSymbol tvs = (TypeVariableSymbol)newRefSymbol;
                if (tvs.refSymbol == null) {
                    return new TypeVariableSymbol(this.pos, 0, null);
                }
                switch (this.typeVariableKind | tvs.typeVariableKind << 8) {
                    case 257: 
                    case 513: 
                    case 769: {
                        return tvs;
                    }
                    case 258: {
                        tvs.typeVariableKind = (byte)2;
                        return tvs;
                    }
                    case 514: 
                    case 770: {
                        return new TypeVariableSymbol(this.pos, 2, tvs);
                    }
                    case 259: {
                        tvs.typeVariableKind = (byte)3;
                        return tvs;
                    }
                    case 515: 
                    case 771: {
                        return new TypeVariableSymbol(this.pos, 3, tvs);
                    }
                }
                return new TypeVariableSymbol(this.pos, this.typeVariableKind, tvs);
            }
            return new TypeVariableSymbol(this.pos, this.typeVariableKind, (ReferenceTypeSymbol)newRefSymbol);
        }
        return this;
    }

    RawClassSymbol getClassSymbol() {
        if (this.refSymbol.isArrayType()) {
            return null;
        }
        return ((ClassSymbol)this.refSymbol).getClassSymbol();
    }

    ClassSymbol getSuperClassSymbol() {
        if (this.refSymbol.isArrayType()) {
            return null;
        }
        return ((ClassSymbol)this.refSymbol).getSuperClassSymbol();
    }

    ClassSymbol getInterface(RawClassSymbol interfaceSymbol) {
        if (this.refSymbol.isArrayType()) {
            return null;
        }
        return ((ClassSymbol)this.refSymbol).getInterface(interfaceSymbol);
    }

    ImplementationList getImplementationList() {
        if (this.refSymbol.isArrayType()) {
            return null;
        }
        return ((ClassSymbol)this.refSymbol).getImplementationList();
    }

    boolean isSuperclass(ClassSymbol ofClass) {
        return this.isSuperclass(ofClass, null);
    }

    boolean isSuperclass(ClassSymbol ofClass, TypeSymbol recursionCheck) {
        if (this.refSymbol.isArrayType()) {
            return false;
        }
        return ((ClassSymbol)this.refSymbol).isSuperclass(ofClass, recursionCheck);
    }

    boolean implementsInterface(ClassSymbol interfaceClass) {
        return this.implementsInterface(interfaceClass, null);
    }

    boolean implementsInterface(ClassSymbol interfaceClass, TypeSymbol recursionCheck) {
        if (this.refSymbol.isArrayType()) {
            return false;
        }
        return ((ClassSymbol)this.refSymbol).implementsInterface(interfaceClass, recursionCheck);
    }

    void checkForOutOfPackageInnerClasses(ConstantPool constantPool, RawClassSymbol outerClass) {
        if (this.refSymbol != null) {
            ClassSymbol classSymbol;
            if (this.refSymbol.isArrayType()) {
                ArraySymbol arraySymbol = (ArraySymbol)this.refSymbol;
                if (!arraySymbol.baseType.isClass()) {
                    return;
                }
                classSymbol = (ClassSymbol)arraySymbol.baseType;
            } else {
                classSymbol = (ClassSymbol)this.refSymbol;
            }
            constantPool.checkForOutOfPackageInnerClass(outerClass, classSymbol.getClassSymbol());
            classSymbol.checkForOutOfPackageInnerClasses(constantPool, outerClass);
        }
    }

    private boolean isJavaLangObject(ClassSymbol classSymbol) {
        return classSymbol.getClassSymbol().errorName().equals(RawClassSymbol.javaLangObjectSymbol.errorName());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

