/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.storage;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import oracle.ojc.storage.AbstractStorage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.JarStorage;

final class JarFileStorage
extends AbstractStorage {
    JarStorage jarStorage;
    DirectoryStorage dir;
    String name;
    int offset;
    int size;
    int csize;

    JarFileStorage(JarStorage jarStorage, DirectoryStorage dir, String name, int offset, int size, int csize) {
        super(null, name);
        this.jarStorage = jarStorage;
        this.dir = dir;
        this.name = name;
        this.offset = offset;
        this.size = size;
        this.csize = csize;
    }

    private byte[] header() throws IOException {
        this.jarStorage.r.seek(this.offset);
        byte[] header = new byte[30];
        this.jarStorage.r.readFully(header);
        if (JarStorage.get4LE(header, 0) != 67324752) {
            throw new IOException("zip file is corrupted");
        }
        if ((JarStorage.get2LE(header, 6) & 1) != 0) {
            throw new IOException("zip file is encrypted");
        }
        return header;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean inflateFully(byte[] dest, byte[] src) {
        InflaterInputStream inf = null;
        try {
            boolean bl;
            try {
                ZippedFileInputStream in = new ZippedFileInputStream(src);
                inf = new InflaterInputStream(in, new Inflater(true), src.length);
                int readLength = inf.read(dest, 0, dest.length);
                bl = readLength == dest.length;
                Object var9_7 = null;
                if (inf == null) return bl;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (inf == null) throw throwable;
                inf.close();
                throw throwable;
            }
            inf.close();
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public byte[] read() throws IOException {
        byte[] header = this.header();
        byte[] cbuf = new byte[this.csize];
        this.jarStorage.r.skipBytes(JarStorage.get2LE(header, 26) + JarStorage.get2LE(header, 28));
        this.jarStorage.r.readFully(cbuf, 0, this.csize);
        if (JarStorage.get2LE(header, 8) == 0) {
            return cbuf;
        }
        byte[] buf = new byte[this.size];
        if (!this.inflateFully(buf, cbuf)) {
            throw new IOException("zip file is corrupted");
        }
        return buf;
    }

    public int read(byte[] buf) throws IOException {
        byte[] header = this.header();
        boolean deflated = JarStorage.get2LE(header, 8) != 0;
        this.jarStorage.r.skipBytes(JarStorage.get2LE(header, 26) + JarStorage.get2LE(header, 28));
        if (!deflated) {
            int nbytes = this.csize < buf.length ? this.csize : buf.length;
            this.jarStorage.r.readFully(buf, 0, nbytes);
            return this.csize;
        }
        if (this.size > buf.length) {
            return this.size;
        }
        byte[] cbuf = new byte[this.csize];
        this.jarStorage.r.readFully(cbuf, 0, this.csize);
        byte[] ucbuf = new byte[this.size];
        if (!this.inflateFully(ucbuf, cbuf)) {
            throw new IOException("zip file is corrupted");
        }
        System.arraycopy(ucbuf, 0, buf, 0, this.size);
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.dir.getPath() + File.separatorChar + this.name;
    }

    public String getCanonicalPath() {
        return this.dir.getCanonicalPath() + File.separatorChar + this.name;
    }

    public boolean isInJar() {
        return true;
    }

    public int size() {
        return this.size;
    }

    private static class ZippedFileInputStream
    extends InputStream {
        private byte[] cbuf;
        private int bytesRead;
        private int bytesLeft;

        ZippedFileInputStream(byte[] buf) throws IOException {
            this.cbuf = buf;
            this.bytesRead = 0;
            this.bytesLeft = buf.length;
        }

        public int available() {
            return this.bytesLeft;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.bytesLeft <= 0) {
                return -1;
            }
            if (len < 0) {
                len = 0;
            }
            if (len > this.bytesLeft) {
                len = this.bytesLeft;
            }
            System.arraycopy(this.cbuf, this.bytesRead, b, off, len);
            this.bytesRead += len;
            this.bytesLeft -= len;
            return len;
        }

        public int read() throws IOException {
            if (this.bytesLeft <= 0) {
                return -1;
            }
            byte n = this.cbuf[this.bytesRead];
            ++this.bytesRead;
            --this.bytesLeft;
            return n;
        }

        public long skip(long n) {
            if (n < 0L) {
                n = 0L;
            }
            if (n > (long)this.bytesLeft) {
                n = this.bytesLeft;
            }
            this.bytesRead = (int)((long)this.bytesRead + n);
            this.bytesLeft = (int)((long)this.bytesLeft - n);
            return n;
        }
    }
}

