/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.help.common.search.QueryHandler;
import oracle.help.common.search.SearchExpression;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.net.URLFileSystem;
import oracle.ide.searchbar.Provider;
import oracle.ide.searchbar.Result;
import oracle.ide.searchbar.ResultContext;
import oracle.javatools.data.PropertyStorage;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpSearchResult;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractRSSQueryHandler
extends QueryHandler {
    private boolean _cancelSearch;
    private String _errorText;

    public void executeQuery(SearchExpression searchExpression, Provider provider, ResultContext resultContext) {
        this.executeQuery(searchExpression, null, provider, resultContext, null);
    }

    public List executeQuery(SearchExpression searchExpression, Set set) {
        ArrayList list = new ArrayList();
        this.executeQuery(searchExpression, set, null, null, list);
        if (list.size() > 0) {
            return list;
        }
        return Collections.emptyList();
    }

    public String getErrorText() {
        return this._errorText;
    }

    private void executeQuery(SearchExpression searchExpression, Set set, Provider provider, ResultContext resultContext, List list) {
        String searchText = searchExpression.getData()[0];
        List<URL> urlSearchList = this.createSearchURLs(searchText);
        this.parseURL(urlSearchList, provider, resultContext, list);
    }

    protected abstract List<URL> createSearchURLs(String var1);

    protected abstract HelpSearchResult createSearchResult(String var1, String var2, String var3);

    protected String htmlEncodeString(String string) {
        return string.replace(" ", "%20");
    }

    private String getString(NodeList nodeList) {
        if (nodeList.getLength() > 0) {
            return nodeList.item(0).getTextContent();
        }
        return null;
    }

    private List parseURL(List<URL> urlSearchList, Provider provider, ResultContext resultContext, List list) {
        block4: for (URL searchURL : urlSearchList) {
            try {
                EnvironOptions envOpts = EnvironOptions.getInstance((PropertyStorage)Preferences.getPreferences());
                String encoding = envOpts.getEncoding();
                Reader reader = URLFileSystem.createReader((URL)searchURL, (String)encoding);
                DOMParser domParser = new DOMParser();
                try {
                    domParser.parse(reader);
                    XMLDocument document = domParser.getDocument();
                    NodeList itemNodelist = document.getElementsByTagName("item");
                    Node itemNode = null;
                    Element itemElement = null;
                    NodeList tempNodeList = null;
                    int tempLength = 0;
                    String title = null;
                    String link = null;
                    String summary = null;
                    if (itemNodelist == null || itemNodelist.getLength() <= 0) continue;
                    int numNodes = itemNodelist.getLength();
                    int i = 0;
                    while (i < numNodes) {
                        if (this.cancelSearch(resultContext)) continue block4;
                        itemNode = itemNodelist.item(i);
                        if (itemNode instanceof Element) {
                            itemElement = (Element)itemNode;
                            tempNodeList = itemElement.getElementsByTagName("title");
                            tempLength = tempNodeList.getLength();
                            title = this.getString(tempNodeList);
                            tempNodeList = itemElement.getElementsByTagName("link");
                            link = this.getString(tempNodeList);
                            tempNodeList = itemElement.getElementsByTagName("summary");
                            summary = this.getString(tempNodeList);
                            HelpSearchResult result = this.createSearchResult(title, link, summary);
                            if (list != null) {
                                list.add(result);
                            } else if (resultContext != null) {
                                this.addResult(provider, resultContext, result, numNodes - i);
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this._errorText = ex.getLocalizedMessage();
                }
            }
            catch (Throwable t) {
                this._errorText = this.buildErrorText(searchURL);
            }
        }
        return list;
    }

    private String buildErrorText(URL searchURL) {
        return HelpArb.format(60, searchURL.getHost());
    }

    private boolean cancelSearch(ResultContext resultContext) {
        return this._cancelSearch || resultContext != null && resultContext.canceled();
    }

    private void addResult(Provider provider, ResultContext resultContext, HelpSearchResult searchResult, int weight) {
        Result result = new Result.ResultBuilder(provider, (Object)searchResult).displayIcon(searchResult.getIcon()).displayText(searchResult.getResultTopic().getLabel()).displayLocation(searchResult.getLocation()).weight(weight).build();
        resultContext.add(result);
    }

    public void stopSearch() {
        this._cancelSearch = true;
    }

    public boolean supportsCaseSensitiveSearches() {
        return false;
    }

    public Set getSupportedSources() {
        return Collections.emptySet();
    }
}

