/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.Assert;
import oracle.jdevimpl.help.HelpSystemConstants;

public class ContextHelpCommand
extends Command {
    private boolean _debugMode;

    private void $init$() {
        this._debugMode = false;
    }

    public ContextHelpCommand() {
        super(HelpSystemConstants.CHELP_TOPICS_ID);
        this.$init$();
        try {
            String sDocDebug = Ide.getProperty((String)"oracle.jdevimpl.help.Debug", (String)"false");
            this._debugMode = Boolean.valueOf(sDocDebug);
        }
        catch (Exception ex) {
            Assert.printStackTrace((Throwable)ex);
        }
    }

    public int doit() {
        try {
            Context c = this.getContext();
            if (c != null) {
                if (this._debugMode) {
                    this._dumpViewInfo(c);
                }
                HelpSystem.getHelpSystem().showHelp(c);
            } else {
                Assert.println((String)"Context is NULL when trying to invoke Help");
            }
        }
        catch (Exception huEx) {
            huEx.printStackTrace();
        }
        return 0;
    }

    private void _dumpViewInfo(Context c) {
        Assert.println((String)"");
        Assert.println((String)"==============================================================================");
        Assert.println((String)("View = " + c.getView().getClass().toString()));
        Assert.println((String)("ID =  " + c.getView().getId()));
        Assert.println((String)("IdeLAV = " + Ide.getMainWindow().getLastActiveView().getClass().toString()));
        Assert.println((String)"==============================================================================");
        Assert.println((String)"");
        Assert.println((String)"");
    }
}

