/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.help.common.Topic;
import oracle.help.common.View;
import oracle.help.navigator.LazyNavigator;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.help.CueCardCategory;
import oracle.jdevimpl.help.CueCardCategoryNode;
import oracle.jdevimpl.help.CueCardSet;
import oracle.jdevimpl.help.CueCardSetNode;
import oracle.jdevimpl.help.CueCardTreeModel;
import oracle.jdevimpl.help.HelpArb;

public class CueCardNavigator
extends LazyNavigator {
    private JScrollPane _scrollPane;
    private JTree _tree;
    private CueCardTreeModel _treeModel;

    protected void doInitializationNow() {
        View[] initialViews = this.getInitialViewsArray();
        this._treeModel = new CueCardTreeModel();
        if (initialViews != null) {
            int i = 0;
            while (i < initialViews.length) {
                this.addViewNow(initialViews[i]);
                ++i;
            }
        }
        this._tree = new JTree(this._treeModel);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._scrollPane = new JScrollPane(this._tree);
        this._scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new BorderLayout());
        Color transparentColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBackground(transparentColor);
        JLabel lbl = new JLabel();
        lbl.setFocusable(false);
        lbl.setBorder(new EmptyBorder(5, 5, 5, 5));
        lbl.setOpaque(false);
        ResourceUtils.resLabel((JLabel)lbl, (Component)this._tree, (String)HelpArb.getString(163));
        this.add(lbl, "North");
        this.add(this._scrollPane, "Center");
        this._tree.getSelectionModel().setSelectionMode(1);
        CueCardTreeCellRenderer renderer = new CueCardTreeCellRenderer(null);
        this.addTreeCellRenderer(renderer);
        this._tree.getInputMap().put(KeyStroke.getKeyStroke("SPACE"), "pressed");
        this._tree.getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "pressed");
        this._tree.getActionMap().put("pressed", new PressAction(null));
        ToolTipManager.sharedInstance().registerComponent(this._tree);
        this.addMouseListener(this._tree);
    }

    protected void addMouseListener(JTree tree) {
        CueCardMouseAdapter mouseAdapter = new CueCardMouseAdapter(null);
        tree.addMouseListener(mouseAdapter);
    }

    protected void addTreeCellRenderer(DefaultTreeCellRenderer renderer) {
        this._tree.setCellRenderer(renderer);
    }

    protected void addViewNow(View view) {
        try {
            CueCardCategory[] cueCardCategories = (CueCardCategory[])view.getViewData();
            if (cueCardCategories != null) {
                int i = 0;
                while (i < cueCardCategories.length) {
                    CueCardCategoryNode categoryNode = this._treeModel.addCategoryNode(cueCardCategories[i].getCategoryName());
                    CueCardSet[] cueCardSets = cueCardCategories[i].getCueCardSets();
                    this._treeModel.addCueCardSetNodes(categoryNode, cueCardSets);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void removeViewNow(View view) {
    }

    public String getDefaultLabel() {
        return null;
    }

    public Topic getCurrentSelection() {
        if (this._tree == null) {
            return null;
        }
        Object selObj = this._tree.getLastSelectedPathComponent();
        if (selObj == null || selObj instanceof CueCardCategoryNode) {
            return null;
        }
        if (selObj instanceof CueCardSetNode) {
            CueCardSet cueCardSet = ((CueCardSetNode)selObj).getCueCardSet();
            return cueCardSet;
        }
        return null;
    }

    protected CueCardSet getCueCardSet(MouseEvent e) {
        DefaultMutableTreeNode node;
        CueCardSet cueCardSet = null;
        JTree tree = (JTree)e.getComponent();
        TreePath treePath = tree.getPathForLocation(e.getX(), e.getY());
        if (treePath != null && (node = (DefaultMutableTreeNode)treePath.getLastPathComponent()) != null && node.getUserObject() instanceof CueCardSet) {
            cueCardSet = (CueCardSet)node.getUserObject();
        }
        return cueCardSet;
    }

    static void mav$fireTopicActivated(CueCardNavigator cueCardNavigator, Topic topic) {
        cueCardNavigator.fireTopicActivated(topic);
    }

    private static class CueCardTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object userObj = node.getUserObject();
                if (userObj instanceof String) {
                    this.setText((String)userObj);
                    this.setToolTipText((String)userObj);
                } else if (userObj instanceof CueCardSet) {
                    CueCardSet entry = (CueCardSet)userObj;
                    this.setText(entry.getDisplayText());
                    this.setToolTipText(entry.getDisplayText());
                }
            }
            return this;
        }

        private CueCardTreeCellRenderer() {
        }

        CueCardTreeCellRenderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private class CueCardMouseAdapter
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            CueCardSet cueCardSet;
            if (e.getClickCount() == 2 && e.getButton() == 1 && (cueCardSet = CueCardNavigator.this.getCueCardSet(e)) != null) {
                CueCardNavigator.mav$fireTopicActivated(CueCardNavigator.this, cueCardSet);
            }
        }

        private CueCardMouseAdapter() {
        }

        CueCardMouseAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class PressAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            Object selObj;
            JTree tree = (JTree)e.getSource();
            TreePath treePath = tree.getSelectionPath();
            if (treePath != null && (selObj = treePath.getLastPathComponent()) != null && selObj instanceof CueCardSetNode) {
                CueCardSetNode node = (CueCardSetNode)selObj;
                CueCardSet cueCardSet = node.getCueCardSet();
                CueCardNavigator.mav$fireTopicActivated(CueCardNavigator.this, cueCardSet);
            }
        }

        private PressAction() {
        }

        PressAction(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

