/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.navigator.searchNavigator.SearchModel;
import oracle.help.common.navigator.searchNavigator.SearchModelData;
import oracle.help.htmlBrowser.find.FindDialog;
import oracle.help.library.Library;
import oracle.help.navigator.NavigatorHelper;
import oracle.help.navigator.searchNavigator.OHJSearchModelData;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ScrollableTabBar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.border.JavatoolsBorderFactory;
import oracle.javatools.data.ListStructure;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;
import oracle.jdevimpl.help.CueCardSet;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpContentPanel;
import oracle.jdevimpl.help.HelpNavigatorToolbar;
import oracle.jdevimpl.help.HelpOptions;
import oracle.jdevimpl.help.HelpSystemConstants;
import oracle.jdevimpl.help.HelpTopicDocument;
import oracle.jdevimpl.help.HelpTopicEditor;
import oracle.jdevimpl.help.HelpUtils;
import oracle.jdevimpl.help.HelpWindow;
import oracle.jdevimpl.help.JDevHelpSystemImpl;
import oracle.jdevimpl.help.JDevLibrary;
import oracle.jdevimpl.help.JDevTOCNavigator;
import oracle.jdevimpl.help.MultipleTypeTopic;
import oracle.jdevimpl.help.SearchOptionsPanel;
import oracle.jdevimpl.help.SearchResultsEditor;

public final class HelpCenterWindow {
    private static HelpCenterWindow INSTANCE;
    private static Window _instanceWindow;
    private static Window _baseInstance;
    private static HelpCenterView _helpCenterView;
    private static HelpWindow _helpWindow;
    private HelpContentPanel _cueCardViewer;
    private DefaultCustomTabPage _cueCardPage;
    private static AWTEventListener _awtEventListener;
    private static WindowAdapter _windowAdapter;
    private static boolean _userAlwaysOnTopSetting;
    private static SearchModel _searchModel;
    private static final int TOGGLE_WINDOW_ON_TOP_CMD_ID;
    private static final String VIEW_NAVIGATORS_CMD = "oracle.jdevimpl.help.HelpCenterWindow.ViewNavigatorsCommand";
    private static final int VIEW_NAVIGATORS_CMD_ID;
    private static final String GOTO_TOC_CMD = "oracle.jdevimpl.help.HelpCenterWindow.GoToTOCCmd";
    private static final int GOTO_TOC_CMD_ID;
    private static final String GOTO_FAV_CMD = "oracle.jdevimpl.help.HelpCenterWindow.GoToFavCmd";
    private static final int GOTO_FAV_CMD_ID;
    private static final String GOTO_DYN_CMD = "oracle.jdevimpl.help.HelpCenterWindow.GoToDynCmd";
    private static final int GOTO_DYN_CMD_ID;
    private static final String GOTO_CUECARDS_CMD = "oracle.jdevimpl.help.HelpCenterWindow.GoToCueCardsCmd";
    private static final int GOTO_CUECARDS_CMD_ID;
    private static final String CLOSE_TAB_CMD = "oracle.jdevimpl.help.HelpCenterWindow.CloseTabCmd";
    private static final int CLOSE_TAB_CMD_ID;
    private static final String CLOSE_OTHER_TABS_CMD = "oracle.jdevimpl.help.HelpCenterWindow.CloseOtherTabsCmd";
    private static final int CLOSE_OTHER_TABS_CMD_ID;
    private static final String CLOSE_ALL_TABS_CMD = "oracle.jdevimpl.help.HelpCenterWindow.CloseAllTabsCmd";
    private static final int CLOSE_ALL_TABS_CMD_ID;
    private static final int RIGHT = 0;
    private static final int LEFT = 1;
    private static final int TOP = 2;
    private static final int BOTTOM = 3;
    private static final int OFFSET = 1;

    private HelpCenterWindow() {
    }

    void setVisible(boolean visible) {
        _instanceWindow.setVisible(visible);
    }

    void requestFocus() {
        _instanceWindow.requestFocus();
    }

    String getSearchText() {
        return _helpCenterView.getSearchText();
    }

    static SearchModel getSearchModel() {
        Library library;
        if (_searchModel == null && (library = HelpWindow.getLibrary()) != null) {
            oracle.help.common.View[] searchViews = NavigatorHelper.filterViewsByLabel((oracle.help.common.View[])library.getAllViews(), (String)"Search");
            _searchModel = new SearchModel((SearchModelData)new OHJSearchModelData(), searchViews);
        }
        return _searchModel;
    }

    HelpContentPanel getCueCardViewer() {
        if (this._cueCardViewer == null) {
            this._cueCardPage = new DefaultCustomTabPage(HelpArb.getIcon(49), HelpArb.getString(144), null);
            this._cueCardPage.setTooltip(HelpArb.getString(144));
            HelpSystem helpSys = HelpSystem.getHelpSystem();
            if (helpSys instanceof JDevHelpSystemImpl) {
                JDevHelpSystemImpl jdevHelpSys = (JDevHelpSystemImpl)helpSys;
                Library library = jdevHelpSys.getLibrary();
                this._cueCardViewer = new HelpContentPanel(library, HelpContentPanel.ViewerType.CUE_CARD_VIEWER);
                HelpTopicEditor editor = new HelpTopicEditor(this._cueCardViewer);
                HelpTopicDocument helpDocument = new HelpTopicDocument();
                Context context = Context.newIdeContext((Node)helpDocument);
                context.setWorkspace(null);
                context.setProject(null);
                editor.setContext(context);
                editor.open();
                this._cueCardPage.setUserObject((Object)editor);
                _helpCenterView.add(this._cueCardPage, editor);
            }
        }
        if (_helpWindow != null) {
            _helpWindow.switchNavigator(0);
        }
        return this._cueCardViewer;
    }

    private static DefaultCustomTabPage getSearchResultsPage() {
        if (_helpCenterView != null) {
            return _helpCenterView.findSearchResultsEditor();
        }
        return null;
    }

    private static void removeTabPage(DefaultCustomTabPage tabPage) {
        if (_helpCenterView != null) {
            _helpCenterView.removeTabPage(tabPage);
        }
    }

    DefaultCustomTabPage getCueCardPage() {
        return this._cueCardPage;
    }

    void showCueCardSetForId(String cueCardId) {
        Library library = HelpWindow.getLibrary();
        if (library != null && library instanceof JDevLibrary) {
            JDevLibrary jdevLibrary = (JDevLibrary)library;
            CueCardSet cueCardSet = jdevLibrary.getCueCardSetById(cueCardId);
            if (cueCardSet != null) {
                this.showCueCardSet(cueCardSet);
            } else {
                URL cueCardURL = jdevLibrary.mapIDToURL(cueCardId);
                if (cueCardURL != null) {
                    MultipleTypeTopic mtt = new MultipleTypeTopic(null, cueCardId, "cuecardStep");
                    HelpContentPanel hcp = this.getCueCardViewer();
                    hcp.getTopicPanel().displayTopic((Topic)mtt);
                    HelpCenterWindow.getInstance().getWindow().setVisible(true);
                    hcp.getGUI().requestFocus();
                } else {
                    JDevHelpSystemImpl.showErrorMessage(HelpCenterWindow.getInstance().getWindow(), HelpArb.format(164, cueCardId), HelpArb.getString(22));
                    JDevHelpSystemImpl.printTopicForDebugging((Topic)new MultipleTypeTopic(null, cueCardId, "cuecardStep"), cueCardId, null);
                }
            }
        }
    }

    CueCardSet getCueCardSet() {
        if (this._cueCardViewer != null) {
            return this._cueCardViewer.getBrowserCueCardDisplay().getCueCardSet();
        }
        return null;
    }

    void showCueCardSet(CueCardSet cueCardSet) {
        cueCardSet.reset();
        HelpContentPanel hcp = this.getCueCardViewer();
        hcp.getBrowserCueCardDisplay().clear();
        hcp.displayTopic(cueCardSet);
        _instanceWindow.setVisible(true);
        _helpCenterView.setPageSelected(this._cueCardPage);
        GraphicsUtils.focusComponentOrChild((Component)hcp.getGUI());
    }

    public static HelpCenterWindow getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HelpCenterWindow();
        }
        if (_instanceWindow == null) {
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            try {
                Method setModalExclusionMethod = HelpCenterWindow.getSetModalExclusionTypeMethod();
                if (setModalExclusionMethod != null) {
                    _instanceWindow = new MyJFrame(setModalExclusionMethod);
                    _instanceWindow.setVisible(true);
                } else {
                    Dialog activeModalDialog = HelpCenterWindow.getActiveModalOwnerDialog();
                    _instanceWindow = new MyJDialog(true, null);
                    _instanceWindow.setVisible(true);
                    if (activeModalDialog != null) {
                        MyJDialog.maS$reparent(activeModalDialog);
                    }
                    _awtEventListener = new HelpAWTEventListener(null);
                    Toolkit.getDefaultToolkit().addAWTEventListener(_awtEventListener, 64);
                }
            }
            finally {
                wc.hide();
            }
        }
        return INSTANCE;
    }

    public Editor getCurrentEditor() {
        Object userObject;
        CustomTabPage tabPage;
        CustomTab customTab;
        int selectedPage;
        if (_helpCenterView != null && (selectedPage = (customTab = HelpCenterView.ra$_scrollableTabBar(_helpCenterView).getTabs()).getSelectedPage()) != -1 && (tabPage = customTab.getPage(selectedPage)) != null && tabPage instanceof DefaultCustomTabPage && (userObject = ((DefaultCustomTabPage)tabPage).getUserObject()) instanceof Editor) {
            return (Editor)userObject;
        }
        return null;
    }

    public Component getCurrentNavigator() {
        Object userObject;
        CustomTabPage tabPage;
        CustomTab customTab;
        int selectedPage;
        if (_helpWindow != null && (selectedPage = (customTab = _helpWindow.getCustomTab()).getSelectedPage()) != -1 && (tabPage = customTab.getPage(selectedPage)) != null && tabPage instanceof DefaultCustomTabPage && (userObject = ((DefaultCustomTabPage)tabPage).getUserObject()) instanceof HelpWindow.NavigatorHolder) {
            HelpWindow.NavigatorHolder holder = (HelpWindow.NavigatorHolder)userObject;
            return holder.getNavigator();
        }
        return null;
    }

    static HelpCenterWindow peekInstance() {
        return INSTANCE;
    }

    static JDevTOCNavigator getTOCNavigator() {
        if (_helpWindow != null) {
            return _helpWindow.getTOCNavigator();
        }
        return null;
    }

    static Component getGUI() {
        if (_helpCenterView != null) {
            return _helpCenterView.getGUI();
        }
        return null;
    }

    static void add(HelpTopicEditor helpTopicEditor) {
        _helpCenterView.add(helpTopicEditor);
        HelpCenterWindow.handleEditorBorder(helpTopicEditor, "active");
    }

    static HelpTopicEditor findEditorForTopic(Topic topic) {
        HelpTopicEditor retval;
        block5: {
            retval = null;
            if (topic.hasTarget() && _helpCenterView != null) {
                try {
                    URL findURL = topic.getTarget().getURL();
                    ListModel model = HelpCenterView.ra$_scrollableTabBar(_helpCenterView).getTabs().getModel();
                    if (model == null) break block5;
                    int numElements = model.getSize();
                    int i = 0;
                    while (i < numElements) {
                        HelpTopicEditor hte;
                        URL editorURL;
                        DefaultCustomTabPage tabPage;
                        Object obj = model.getElementAt(i);
                        if (obj instanceof DefaultCustomTabPage && (obj = (tabPage = (DefaultCustomTabPage)obj).getUserObject()) instanceof HelpTopicEditor && URLFileSystem.equals((URL)findURL, (URL)(editorURL = (hte = (HelpTopicEditor)((Object)obj)).getBrowser().getURL()))) {
                            retval = hte;
                            break;
                        }
                        ++i;
                    }
                }
                catch (MalformedURLException muex) {
                    // empty catch block
                }
            }
        }
        return retval;
    }

    static void selectHelpTopicEditor(HelpTopicEditor helpTopicEditor) {
        ListModel model;
        if (_helpCenterView != null && (model = HelpCenterView.ra$_scrollableTabBar(_helpCenterView).getTabs().getModel()) != null) {
            int numElements = model.getSize();
            int i = 0;
            while (i < numElements) {
                HelpTopicEditor hte;
                DefaultCustomTabPage tabPage;
                Object obj = model.getElementAt(i);
                if (obj instanceof DefaultCustomTabPage && (obj = (tabPage = (DefaultCustomTabPage)obj).getUserObject()) instanceof HelpTopicEditor && (hte = (HelpTopicEditor)((Object)obj)) == helpTopicEditor) {
                    HelpCenterView.ra$_scrollableTabBar(_helpCenterView).getTabs().setSelectedPage(i);
                    HelpCenterView.ra$_scrollableTabBar(_helpCenterView).ensureSelectedTabVisible();
                    GraphicsUtils.focusComponentOrChild((Component)helpTopicEditor.getGUI(), (boolean)true);
                }
                ++i;
            }
        }
    }

    void switchNavigator(int navigatorToShow) {
        if (_helpWindow != null) {
            _helpWindow.switchNavigator(navigatorToShow);
        }
    }

    void focusSearchControl() {
        if (_helpCenterView != null && HelpCenterView.ra$_searchField(_helpCenterView) != null) {
            HelpCenterView.ra$_searchField(_helpCenterView).requestFocus();
        }
    }

    public Window getWindow() {
        return _instanceWindow;
    }

    HelpWindow getHelpWindow() {
        return _helpWindow;
    }

    private static Method getSetModalExclusionTypeMethod() {
        Method[] methods = Window.class.getDeclaredMethods();
        if (methods != null) {
            Method[] methodArray = methods;
            int n = 0;
            while (n < methodArray.length) {
                Method m = methodArray[n];
                String mname = m.getName();
                if (mname.equals("setModalExclusionType")) {
                    return m;
                }
                ++n;
            }
        }
        return null;
    }

    static void setupSplitPaneDivider(JSplitPane splitPane) {
        splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        splitPane.setDividerSize(2);
        splitPane.setOpaque(false);
        Component[] comps = splitPane.getComponents();
        if (comps != null) {
            Component[] componentArray = comps;
            int n = 0;
            while (n < componentArray.length) {
                Component c = componentArray[n];
                if (c != null) {
                    Color color = new Color(0.0f, 0.0f, 0.0f, 0.0f);
                    c.setBackground(color);
                    HelpCenterWindow.callSetBorderMethod(c);
                    c.addMouseListener(new 1(splitPane));
                }
                ++n;
            }
        }
    }

    private static void callSetBorderMethod(Component divider) {
        Class<?> dividerClass = divider.getClass();
        Method[] methods = dividerClass.getMethods();
        if (methods != null) {
            Method[] methodArray = methods;
            int n = 0;
            while (n < methodArray.length) {
                Method m = methodArray[n];
                if (m.getName().equals("setBorder")) {
                    try {
                        m.invoke((Object)divider, new EmptyBorder(0, 0, 0, 0));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return;
                }
                ++n;
            }
        }
    }

    private static void handleEditorsBorder(String state) {
        ListModel model = HelpCenterView.ra$_scrollableTabBar(_helpCenterView).getTabs().getModel();
        if (model != null) {
            int numElements = model.getSize();
            int i = 0;
            while (i < numElements) {
                DefaultCustomTabPage tabPage;
                Object obj = model.getElementAt(i);
                if (obj instanceof DefaultCustomTabPage && (obj = (tabPage = (DefaultCustomTabPage)obj).getUserObject()) instanceof Editor) {
                    HelpCenterWindow.handleEditorBorder((Editor)obj, state);
                }
                ++i;
            }
        }
    }

    private static void handleEditorBorder(Editor editor, String state) {
        if (Themes.isThemed()) {
            ThemeProperties themeProperties = Themes.getActiveTheme().getStateProperties("view", state);
            Color color = themeProperties.getColor("bordercolor");
            Component c = editor.getGUI();
            CompoundBorder cb = new CompoundBorder(JavatoolsBorderFactory.createLeftRightBorder((Color)color), JavatoolsBorderFactory.createBottomBorder((Color)color));
            ((JPanel)c).setBorder(cb);
            if (editor instanceof HelpTopicEditor) {
                if (state.equals("active")) {
                    editor.activate();
                } else {
                    editor.deactivate();
                }
            }
        }
    }

    private HelpCenterView createHelpCenterView(boolean alwaysOnTop) {
        _helpCenterView = new HelpCenterView(_helpWindow, alwaysOnTop);
        return _helpCenterView;
    }

    private static JRootPane createRootPane(Window window) {
        2 actionListener = new 2(window);
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        InputMap imIde = Ide.getIdeInputMap();
        InputMap imMe = rootPane.getInputMap(1);
        imMe.setParent(imIde.getParent());
        ActionMap amIde = Ide.getIdeActionMap();
        ActionMap amMe = rootPane.getActionMap();
        amMe.setParent(amIde);
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext ksc = kscr.getContext("oracle/jdevimpl/help/localaccelerators.xml");
        MultiInputMap imap = MultiMapAdapter.getLocalMap((KeyStrokeOptions)kso, (KeyStrokeContext)ksc);
        IdeAction exitAction = IdeAction.newLocalAction((int)4, (View)_helpCenterView);
        exitAction.addController((Controller)_helpCenterView);
        HelpCenterWindow.updateMyMapWithAction(kso, amIde, imap, 4, exitAction);
        return rootPane;
    }

    private static void updateMyMapWithAction(KeyStrokeOptions kso, ActionMap aMap, MultiInputMap myMap, int cmdId, IdeAction action) {
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext ksc = kscr.getContext("oracle/jdevimpl/help/localaccelerators.xml");
        List kList = HelpCenterWindow.getKeyStrokesFor(kso, cmdId, ksc);
        if (kList != Collections.EMPTY_LIST) {
            int numKeys = kList.size();
            Integer integer = new Integer(cmdId);
            int i = 0;
            while (i < numKeys) {
                aMap.put(integer, (Action)action);
                myMap.put((KeyStrokes)kList.get(i), (Object)integer);
                ++i;
            }
        }
    }

    private static List getKeyStrokesFor(KeyStrokeOptions kso, int cmdId, KeyStrokeContext ksc) {
        KeyStrokeMap ksm = kso.getGlobalKeyMap();
        List kList = ksm.getKeyStrokesFor(cmdId);
        if (kList == Collections.EMPTY_LIST) {
            ksm = kso.getLocalKeyMap(ksc);
            kList = ksm.getKeyStrokesFor(cmdId);
        }
        return kList;
    }

    private static void fullInit(Window window) {
        boolean alwaysOnTop;
        _helpWindow = new HelpWindow("HelpSystemAddin.HelpWindow");
        _helpWindow.setActive(true);
        _helpWindow.setSeparateWindow(true);
        HelpOptions helpOptions = HelpOptions.getInstance();
        _userAlwaysOnTopSetting = alwaysOnTop = helpOptions.getHelpCenterWindowOnTop();
        window.setAlwaysOnTop(alwaysOnTop);
        if (helpOptions.getHelpCenterX() != -1) {
            window.setSize(helpOptions.getHelpCenterWidth(), helpOptions.getHelpCenterHeight());
            window.setLocation(helpOptions.getHelpCenterX(), helpOptions.getHelpCenterY());
        } else {
            int mainWindowHeight = Ide.getMainWindow().getHeight();
            window.setSize(500, mainWindowHeight);
            HelpCenterWindow.positionWindow(window, 0, window.getSize());
        }
        INSTANCE.createHelpCenterView(alwaysOnTop);
        ThemedContentPanel tcp = new ThemedContentPanel(null);
        tcp.setLayout(new BorderLayout());
        tcp.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (window instanceof JDialog) {
            JDialog dialog = (JDialog)window;
            dialog.setTitle(HelpArb.getString(115));
            dialog.setDefaultCloseOperation(2);
            dialog.setContentPane(tcp);
            dialog.getContentPane().add(_helpCenterView.getGUI(), "Center");
        } else {
            JFrame frame = (JFrame)window;
            frame.setIconImage(Ide.getMainWindow().getMainIcon());
            frame.setTitle(HelpArb.getString(115));
            frame.setDefaultCloseOperation(2);
            frame.setContentPane(tcp);
            frame.getContentPane().add(_helpCenterView.getGUI(), "Center");
        }
        HelpCenterWindow.recreateOpenDocuments(helpOptions);
        if (helpOptions.getSplitterPosition() != -1) {
            _helpCenterView.resetSplitterPosition(helpOptions.getSplitterPosition());
        }
        Ide.getMainWindow().registerView((View)_helpCenterView);
        window.addWindowListener(_windowAdapter);
    }

    static void saveLayout() {
        if (_instanceWindow == null) {
            HelpOptions helpOptions = HelpOptions.getInstance();
            helpOptions.setHelpCenterWindowOpen(false);
            helpOptions.setOpenDocuments(null);
        } else {
            _helpCenterView.saveLayout();
        }
    }

    private static Dialog getActiveModalOwnerDialog() {
        Window aWindow = WindowUtils.getActiveWindow();
        Dialog modalOwner = null;
        while (aWindow != null) {
            Dialog theDialog;
            if (aWindow instanceof Dialog && (theDialog = (Dialog)aWindow).isModal()) {
                modalOwner = theDialog;
                break;
            }
            aWindow = (Window)aWindow.getParent();
        }
        return modalOwner;
    }

    private static void positionWindow(Window window, int direction, Dimension windowSize) {
        Rectangle candidateRect = HelpCenterWindow.getAvailableScreenRectangle(direction, windowSize);
        window.setLocation(candidateRect.x, candidateRect.y);
    }

    private static Rectangle getAvailableScreenRectangle(int direction, Dimension windowSize) {
        Rectangle[] screenRect = GraphicsUtils.getScreenBounds();
        Dimension ideDim = Ide.getMainWindow().getSize();
        Point idePoint = Ide.getMainWindow().getLocationOnScreen();
        int ideBegin = idePoint.x;
        int ideEnd = idePoint.x + ideDim.width + 1;
        int ideTop = idePoint.y;
        int ideBottom = idePoint.y + ideDim.height + 1;
        int availWidth = 0;
        int availHeight = 0;
        int x = 0;
        int y = 0;
        if (direction == 0) {
            availWidth = screenRect[0].width - ideEnd;
            availHeight = screenRect[0].height - ideTop;
            x = ideEnd;
            y = ideTop;
        } else if (direction == 1) {
            availWidth = ideBegin - 1;
            availHeight = screenRect[0].height - ideTop;
            x = ideBegin - 1 - windowSize.width;
            y = ideTop;
        } else if (direction == 2) {
            availWidth = screenRect[0].width - ideBegin;
            availHeight = ideTop - 1;
            x = ideBegin;
            y = ideTop - 1 - windowSize.height;
        } else if (direction == 3) {
            availWidth = screenRect[0].width - ideBegin;
            availHeight = screenRect[0].height - (ideBottom + 1);
            x = ideBegin;
            y = ideBottom + 1;
        }
        x = Math.max(0, x);
        x = Math.min(x, screenRect[0].width - windowSize.width);
        y = Math.max(0, y);
        y = Math.min(y, screenRect[0].height - windowSize.height);
        return new Rectangle(x, y, availWidth, availHeight);
    }

    private static void recreateOpenDocuments(HelpOptions helpOptions) {
        ListStructure openDocuments = helpOptions.getOpenDocuments();
        if (openDocuments != null && openDocuments.size() > 0) {
            int numDocuments = openDocuments.size();
            int i = 0;
            while (i < numDocuments) {
                URL url = (URL)openDocuments.get(i);
                if (url != null) {
                    String urlString = url.toString();
                    if (urlString.endsWith(".helpT")) {
                        urlString = urlString.substring(0, urlString.length() - ".helpT".length());
                    } else if (urlString.endsWith(".help")) {
                        urlString = urlString.substring(0, urlString.length() - ".help".length());
                    }
                    SimpleURLTarget theTarget = new SimpleURLTarget(null, urlString);
                    SimpleTopic theTopic = new SimpleTopic(null, (Target)theTarget);
                    HelpTopicDocument htd = null;
                    try {
                        htd = new HelpTopicDocument((Topic)theTopic);
                    }
                    catch (Exception e) {
                        return;
                    }
                    Context ctx = Context.newIdeContext((Node)htd);
                    ctx.setWorkspace(null);
                    ctx.setProject(null);
                    HelpTopicEditor helpTopicEditor = new HelpTopicEditor();
                    helpTopicEditor.setContext(ctx);
                    helpTopicEditor.displayTopic((Topic)theTopic);
                    HelpCenterWindow.add(helpTopicEditor);
                    helpTopicEditor.setParent(INSTANCE);
                }
                ++i;
            }
        }
    }

    static {
        _windowAdapter = new HelpCenterWindowAdapter(null);
        TOGGLE_WINDOW_ON_TOP_CMD_ID = Ide.findCmdID((String)"oracle.jdevimpl.help.HelpCenterWindow.ToggleWindowOnTopCmd");
        VIEW_NAVIGATORS_CMD_ID = Ide.findOrCreateCmdID((String)VIEW_NAVIGATORS_CMD);
        GOTO_TOC_CMD_ID = Ide.findOrCreateCmdID((String)GOTO_TOC_CMD);
        GOTO_FAV_CMD_ID = Ide.findOrCreateCmdID((String)GOTO_FAV_CMD);
        GOTO_DYN_CMD_ID = Ide.findOrCreateCmdID((String)GOTO_DYN_CMD);
        GOTO_CUECARDS_CMD_ID = Ide.findOrCreateCmdID((String)GOTO_CUECARDS_CMD);
        CLOSE_TAB_CMD_ID = Ide.findOrCreateCmdID((String)CLOSE_TAB_CMD);
        CLOSE_OTHER_TABS_CMD_ID = Ide.findOrCreateCmdID((String)CLOSE_OTHER_TABS_CMD);
        CLOSE_ALL_TABS_CMD_ID = Ide.findOrCreateCmdID((String)CLOSE_ALL_TABS_CMD);
    }

    static Window ra$_instanceWindow() {
        return _instanceWindow;
    }

    static HelpCenterView ra$_helpCenterView() {
        return _helpCenterView;
    }

    static HelpWindow ra$_helpWindow() {
        return _helpWindow;
    }

    static void wa$_helpWindow(HelpWindow helpWindow) {
        _helpWindow = helpWindow;
    }

    static WindowAdapter ra$_windowAdapter() {
        return _windowAdapter;
    }

    static void wa$_instanceWindow(Window window) {
        _instanceWindow = window;
    }

    static void wa$_helpCenterView(HelpCenterView helpCenterView) {
        _helpCenterView = helpCenterView;
    }

    static AWTEventListener ra$_awtEventListener() {
        return _awtEventListener;
    }

    static HelpCenterWindow ra$INSTANCE() {
        return INSTANCE;
    }

    static void maS$handleEditorsBorder(String string) {
        HelpCenterWindow.handleEditorsBorder(string);
    }

    static int ra$TOGGLE_WINDOW_ON_TOP_CMD_ID() {
        return TOGGLE_WINDOW_ON_TOP_CMD_ID;
    }

    static void wa$_userAlwaysOnTopSetting(boolean bl) {
        _userAlwaysOnTopSetting = bl;
    }

    static int ra$GOTO_TOC_CMD_ID() {
        return GOTO_TOC_CMD_ID;
    }

    static int ra$GOTO_FAV_CMD_ID() {
        return GOTO_FAV_CMD_ID;
    }

    static int ra$GOTO_DYN_CMD_ID() {
        return GOTO_DYN_CMD_ID;
    }

    static int ra$GOTO_CUECARDS_CMD_ID() {
        return GOTO_CUECARDS_CMD_ID;
    }

    static int ra$CLOSE_ALL_TABS_CMD_ID() {
        return CLOSE_ALL_TABS_CMD_ID;
    }

    static int ra$CLOSE_OTHER_TABS_CMD_ID() {
        return CLOSE_OTHER_TABS_CMD_ID;
    }

    static int ra$CLOSE_TAB_CMD_ID() {
        return CLOSE_TAB_CMD_ID;
    }

    static int ra$VIEW_NAVIGATORS_CMD_ID() {
        return VIEW_NAVIGATORS_CMD_ID;
    }

    static DefaultCustomTabPage maS$getSearchResultsPage() {
        return HelpCenterWindow.getSearchResultsPage();
    }

    static void maS$removeTabPage(DefaultCustomTabPage defaultCustomTabPage) {
        HelpCenterWindow.removeTabPage(defaultCustomTabPage);
    }

    static HelpContentPanel ra$_cueCardViewer(HelpCenterWindow helpCenterWindow) {
        return helpCenterWindow._cueCardViewer;
    }

    static void wa$_cueCardViewer(HelpCenterWindow helpCenterWindow, HelpContentPanel helpContentPanel) {
        helpCenterWindow._cueCardViewer = helpContentPanel;
    }

    static void wa$_cueCardPage(HelpCenterWindow helpCenterWindow, DefaultCustomTabPage defaultCustomTabPage) {
        helpCenterWindow._cueCardPage = defaultCustomTabPage;
    }

    static Dialog maS$getActiveModalOwnerDialog() {
        return HelpCenterWindow.getActiveModalOwnerDialog();
    }

    static Window ra$_baseInstance() {
        return _baseInstance;
    }

    static void wa$_baseInstance(Window window) {
        _baseInstance = window;
    }

    static void maS$fullInit(Window window) {
        HelpCenterWindow.fullInit(window);
    }

    static JRootPane maS$createRootPane(Window window) {
        return HelpCenterWindow.createRootPane(window);
    }

    static boolean ra$_userAlwaysOnTopSetting() {
        return _userAlwaysOnTopSetting;
    }

    static DefaultCustomTabPage ra$_cueCardPage(HelpCenterWindow helpCenterWindow) {
        return helpCenterWindow._cueCardPage;
    }

    static final class 1
    implements MouseListener {
        private final /* synthetic */ JSplitPane v$splitPane;

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            HelpCenterWindow.ra$_instanceWindow().setCursor(Cursor.getPredefinedCursor(this.v$splitPane.getOrientation() == 1 ? 11 : 8));
        }

        public void mouseExited(MouseEvent e) {
            HelpCenterWindow.ra$_instanceWindow().setCursor(null);
        }

        public 1(JSplitPane jSplitPane) {
            this.v$splitPane = jSplitPane;
        }
    }

    static final class 2
    implements ActionListener {
        private final /* synthetic */ Window v$window;

        public void actionPerformed(ActionEvent actionEvent) {
            this.v$window.setVisible(false);
            this.v$window.dispatchEvent(new WindowEvent(this.v$window, 201));
        }

        public 2(Window window) {
            this.v$window = window;
        }
    }

    private static class HelpCenterWindowAdapter
    extends WindowAdapter {
        public void windowActivated(WindowEvent e) {
            if (HelpCenterWindow.ra$INSTANCE() != null && HelpCenterWindow.ra$_helpWindow() != null) {
                HelpCenterWindow.ra$_helpWindow().getCustomTab().setFocused(true);
                HelpCenterView.ra$_scrollableTabBar(HelpCenterWindow.ra$_helpCenterView()).getTabs().setFocused(true);
                HelpCenterWindow.ra$_helpWindow().setActive(true);
                HelpCenterView.ra$_toolbar(HelpCenterWindow.ra$_helpCenterView()).setActiveToolbar(true);
                HelpCenterView.ra$_mainPanel(HelpCenterWindow.ra$_helpCenterView()).repaint();
                HelpCenterWindow.maS$handleEditorsBorder("active");
            }
        }

        public void windowDeactivated(WindowEvent e) {
            if (HelpCenterWindow.ra$INSTANCE() != null && HelpCenterWindow.ra$_helpWindow() != null) {
                HelpCenterWindow.ra$_helpWindow().getCustomTab().setFocused(false);
                HelpCenterView.ra$_scrollableTabBar(HelpCenterWindow.ra$_helpCenterView()).getTabs().setFocused(false);
                HelpCenterWindow.ra$_helpWindow().setActive(false);
                HelpCenterView.ra$_toolbar(HelpCenterWindow.ra$_helpCenterView()).setActiveToolbar(false);
                HelpCenterView.ra$_mainPanel(HelpCenterWindow.ra$_helpCenterView()).repaint();
                HelpCenterWindow.maS$handleEditorsBorder("inactive");
            }
        }

        public void windowClosed(WindowEvent e) {
            this.cleanup(false);
        }

        public void windowClosing(WindowEvent e) {
            this.cleanup(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanup(boolean userRequested) {
            if (userRequested) {
                Window window = HelpCenterWindow.ra$_instanceWindow();
                synchronized (window) {
                    if (HelpCenterWindow.ra$_instanceWindow() != null) {
                        Ide.getMainWindow().unregisterView((View)HelpCenterWindow.ra$_helpCenterView());
                        HelpCenterWindow.saveLayout();
                        if (HelpCenterWindow.ra$_helpWindow() != null) {
                            HelpCenterWindow.wa$_helpWindow(null);
                            HelpCenterWindow.ra$_instanceWindow().removeWindowListener(HelpCenterWindow.ra$_windowAdapter());
                            HelpCenterWindow.ra$_instanceWindow().dispose();
                            if (HelpCenterWindow.ra$_instanceWindow() != null) {
                                HelpCenterWindow.ra$_instanceWindow().dispose();
                                HelpCenterWindow.wa$_instanceWindow(null);
                                HelpCenterWindow.wa$_helpCenterView(null);
                                HelpCenterWindow.wa$_helpWindow(null);
                            }
                            if (HelpCenterWindow.ra$_awtEventListener() != null) {
                                Toolkit.getDefaultToolkit().removeAWTEventListener(HelpCenterWindow.ra$_awtEventListener());
                            }
                        }
                    }
                }
            }
        }

        private HelpCenterWindowAdapter() {
        }

        HelpCenterWindowAdapter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private class HelpCenterView
    extends View
    implements Controller {
        private HelpNavigatorToolbar _toolbar;
        private JSplitPane _splitPane;
        private JPanel _mainPanel;
        private ScrollableTabBar _scrollableTabBar;
        private JPanel _editorPanel;
        private DefaultListModel _listModel;
        private Component _currentEditorComponent;
        private SearchField _searchField;
        private Action _showOptionsAction;
        private SearchOptionsPanel _optionPanel;

        private void $init$() {
            this._toolbar = new HelpNavigatorToolbar();
        }

        public HelpCenterView(HelpWindow helpWindow, boolean alwaysOnTop) {
            this.$init$();
            HelpCenterWindow.wa$_helpWindow(helpWindow);
            this._mainPanel = new JPanel();
            this._mainPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
            this._mainPanel.setOpaque(false);
            this._mainPanel.setLayout(new BorderLayout());
            this.createSplitPane();
            this._mainPanel.add((Component)this._splitPane, "Center");
            helpWindow.getCustomTab().addListDataListener((ListDataListener)new 1());
            this._toolbar.forcePrimaryViewToolbar(true);
            this._toolbar.setBorder(new EmptyBorder(3, 2, 3, 2));
            this._mainPanel.add((Component)((Object)this._toolbar), "North");
            IdeAction action = IdeAction.find((int)HelpCenterWindow.ra$TOGGLE_WINDOW_ON_TOP_CMD_ID());
            action.addController((Controller)this);
            action.putValue("State", (Object)(alwaysOnTop ? Boolean.TRUE : Boolean.FALSE));
            ToggleToolButton onTopBtn = new ToggleToolButton((ToggleAction)action);
            ResourceUtils.resButton((AbstractButton)onTopBtn, (String)HelpArb.getString(173));
            this._toolbar.add((Component)onTopBtn);
            String label = HelpArb.getString(31);
            action = IdeAction.get((int)HelpCenterWindow.ra$VIEW_NAVIGATORS_CMD_ID(), (String)HelpCenterWindow.VIEW_NAVIGATORS_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (Icon)OracleIcons.getIcon((String)"viewnavigators.png"), null, (boolean)true);
            action.addController((Controller)this);
            action.setEnabled(true);
            MenuToolButton viewButton = new MenuToolButton((ToggleAction)action);
            this.addActionsToViewButton(viewButton);
            viewButton.setText(StringUtils.stripMnemonic((String)label));
            this._toolbar.add((Component)viewButton);
            action = IdeAction.find((int)HelpSystemConstants.SHOW_FORUM_CMD_ID);
            if (action != null) {
                ToolButton toolButton = new ToolButton((Action)action);
                toolButton.setIcon(OracleIcons.getIcon((String)"forum.png"));
                toolButton.setText(StringUtils.stripMnemonic((String)HelpArb.getString(16)));
                this._toolbar.add((Component)toolButton);
            }
            this._searchField = new SearchField();
            this._searchField.setStyle(SearchField.Style.SEARCH);
            Dimension d = this._searchField.getPreferredSize();
            d = new Dimension(250, this._searchField.getPreferredSize().height);
            this._searchField.setPreferredSize(d);
            this._searchField.setMaximumSize(d);
            this._searchField.setMinimumSize(new Dimension(150, d.height));
            this._searchField.addSearchListener((SearchListener)new HelpSearchListener());
            JPanel spacerPanel = new JPanel();
            spacerPanel.setLayout(new GridBagLayout());
            spacerPanel.add((Component)this._searchField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            spacerPanel.setOpaque(false);
            this._toolbar.add(spacerPanel, -1);
            this._showOptionsAction = new MyAction('O');
            this._showOptionsAction.putValue("SmallIcon", OracleIcons.getIcon((String)"find.png"));
            KeyStroke keyStroke = KeyStroke.getKeyStroke("alt DOWN");
            this._showOptionsAction.putValue("AcceleratorKey", keyStroke);
            String tooltip = HelpArb.format(136, KeyUtil.toString((KeyStroke)keyStroke));
            this._showOptionsAction.putValue("ShortDescription", tooltip);
            this._searchField.setPopDownAction(this._showOptionsAction);
            JTextField textField = this.getTextField((Container)this._searchField);
            InputMap inputMap = textField.getInputMap(0);
            ActionMap actionMap = textField.getActionMap();
            MyAction cancelAction = new MyAction('C');
            inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelAction);
            actionMap.put(cancelAction, cancelAction);
            actionMap.put(this._showOptionsAction, this._showOptionsAction);
            this._searchField.setPrompt(HelpArb.getString(12));
            this._editorPanel = new JPanel(new BorderLayout());
            this._editorPanel.setBorder(new EmptyBorder(2, 3, 5, 3));
            this._editorPanel.setOpaque(false);
            this._editorPanel.setMinimumSize(new Dimension(0, 5));
            this._scrollableTabBar = new ScrollableTabBar();
            this._listModel = new DefaultListModel();
            CustomTab customTab = this._scrollableTabBar.getTabs();
            customTab.setModel((ListModel)this._listModel);
            customTab.setOpaque(false);
            customTab.setFocused(true);
            customTab.setCloseAction((Action)new TabCloseAction(null));
            customTab.setCtrlClickCloseEnabled(true);
            customTab.addSelectionListener((ListSelectionListener)new 2());
            customTab.addMouseListener((MouseListener)new TabMouseListener(null));
            this._listModel.addListDataListener(new 3());
            this._scrollableTabBar.setScrollMode(ScrollableTabBar.ScrollMode.SWITCH_TABS);
            customTab.setPosition(1);
            this._editorPanel.add((Component)this._scrollableTabBar, "North");
        }

        private void createSplitPane() {
            this._splitPane = new JSplitPane(1);
            this._splitPane.setResizeWeight(0.5);
            HelpCenterWindow.setupSplitPaneDivider(this._splitPane);
            JPanel jpanel = new JPanel();
            jpanel.setLayout(new BorderLayout());
            jpanel.setOpaque(false);
            jpanel.setBorder(new EmptyBorder(2, 3, 5, 0));
            jpanel.add(HelpCenterWindow.ra$_helpWindow().getGUI(), "Center");
            this._splitPane.setLeftComponent(jpanel);
        }

        public ContextMenu getContextMenu() {
            return HelpCenterWindow.ra$_helpWindow().getContextMenu();
        }

        public Toolbar getToolbar() {
            return this._toolbar;
        }

        public String getSearchText() {
            return this._searchField.getText();
        }

        public Component getGUI() {
            return this._mainPanel;
        }

        public DefaultCustomTabPage findSearchResultsEditor() {
            int numTabs = this._listModel.size();
            int i = 0;
            while (i < numTabs) {
                DefaultCustomTabPage tabPage = (DefaultCustomTabPage)this._listModel.get(i);
                if (tabPage.getUserObject() instanceof SearchResultsEditor) {
                    return tabPage;
                }
                ++i;
            }
            return null;
        }

        public void removeTabPage(DefaultCustomTabPage tabPage) {
            this._listModel.removeElement(tabPage);
        }

        public void add(Editor editor) {
            String title = null;
            Icon icon = null;
            if (editor instanceof HelpTopicEditor) {
                Context c = editor.getContext();
                HelpTopicDocument htd = (HelpTopicDocument)c.getNode();
                title = htd.getLongLabel();
                icon = htd.getIcon();
            } else if (editor instanceof SearchResultsEditor) {
                title = HelpArb.getString(149);
                icon = OracleIcons.getIcon((String)"find.png");
            } else {
                return;
            }
            DefaultCustomTabPage tabPage = new DefaultCustomTabPage(icon, title, (Object)editor);
            this.add(tabPage, editor);
        }

        public void add(DefaultCustomTabPage tabPage, Editor editor) {
            this._listModel.addElement(tabPage);
            int newPageNum = this.getPageForTabPage((CustomTabPage)tabPage);
            if (newPageNum != -1) {
                this._scrollableTabBar.getTabs().setSelectedPage(newPageNum);
                4 runnable = new 4();
                SwingUtilities.invokeLater(runnable);
            }
            this._currentEditorComponent = editor.getGUI();
            if (this._editorPanel.getParent() == null) {
                int desiredWidth = 0;
                int desiredHeight = 0;
                if (this._splitPane.getLeftComponent() != null) {
                    desiredWidth = this._splitPane.getLeftComponent().getWidth() / 2;
                    desiredHeight = this._splitPane.getLeftComponent().getHeight();
                }
                if (desiredWidth > 0) {
                    this._editorPanel.setSize(desiredWidth, desiredHeight);
                }
                this._splitPane.setRightComponent(this._editorPanel);
                this._splitPane.setDividerLocation(desiredWidth);
            }
            this._editorPanel.repaint();
            this._mainPanel.repaint();
        }

        public void resetSplitterPosition(int position) {
            if (this._splitPane.getLeftComponent() != null && this._splitPane.getRightComponent() != null) {
                this._splitPane.setDividerLocation(position);
            }
        }

        private void addActionsToViewButton(MenuToolButton viewButton) {
            IdeAction action = null;
            String label = null;
            if (HelpCenterWindow.ra$_helpWindow().isNavigatorAvailable(0)) {
                label = HelpArb.getString(72);
                action = IdeAction.get((int)HelpCenterWindow.ra$GOTO_TOC_CMD_ID(), (String)HelpCenterWindow.GOTO_TOC_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (Icon)OracleIcons.getIcon((String)"library.png"), null, (boolean)true);
                viewButton.addPopupItem((ToggleAction)action);
                action.addController((Controller)this);
            }
            if (HelpCenterWindow.ra$_helpWindow().isNavigatorAvailable(1)) {
                label = HelpArb.getString(172);
                action = IdeAction.get((int)HelpCenterWindow.ra$GOTO_FAV_CMD_ID(), (String)HelpCenterWindow.GOTO_FAV_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (Icon)OracleIcons.getIcon((String)"favorites.png"), null, (boolean)true);
                viewButton.addPopupItem((ToggleAction)action);
                action.addController((Controller)this);
            }
            if (HelpCenterWindow.ra$_helpWindow().isNavigatorAvailable(2)) {
                label = HelpArb.getString(159);
                action = IdeAction.get((int)HelpCenterWindow.ra$GOTO_DYN_CMD_ID(), (String)HelpCenterWindow.GOTO_DYN_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (Icon)OracleIcons.getIcon((String)"dynamicLink.png"), null, (boolean)true);
                viewButton.addPopupItem((ToggleAction)action);
                action.addController((Controller)this);
            }
            if (HelpCenterWindow.ra$_helpWindow().isNavigatorAvailable(3)) {
                label = HelpArb.getString(147);
                action = IdeAction.get((int)HelpCenterWindow.ra$GOTO_CUECARDS_CMD_ID(), (String)HelpCenterWindow.GOTO_CUECARDS_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (Icon)HelpArb.getIcon(49), null, (boolean)true);
                viewButton.addPopupItem((ToggleAction)action);
                action.addController((Controller)this);
            }
        }

        public void setPageSelected(DefaultCustomTabPage tabPage) {
            CustomTab cTab = this._scrollableTabBar.getTabs();
            int selPage = cTab.searchPage((CustomTabPage)tabPage);
            cTab.setSelectedPage(selPage);
            this._scrollableTabBar.ensureSelectedTabVisible();
        }

        private int getPageForTabPage(CustomTabPage tabPage) {
            int pageNum = -1;
            CustomTab cTab = this._scrollableTabBar.getTabs();
            int pageCount = cTab.getPageCount();
            int i = 0;
            while (i < pageCount) {
                if (cTab.getPage(i) == tabPage) {
                    pageNum = i;
                    break;
                }
                ++i;
            }
            return pageNum;
        }

        void saveLayout() {
            if (HelpCenterWindow.ra$_instanceWindow() != null) {
                HelpOptions helpOptions = HelpOptions.getInstance();
                helpOptions.setHelpCenterX(HelpCenterWindow.ra$_instanceWindow().getX());
                helpOptions.setHelpCenterY(HelpCenterWindow.ra$_instanceWindow().getY());
                helpOptions.setHelpCenterWidth(HelpCenterWindow.ra$_instanceWindow().getWidth());
                helpOptions.setHelpCenterHeight(HelpCenterWindow.ra$_instanceWindow().getHeight());
                helpOptions.setHelpCenterWindowOpen(true);
                helpOptions.setSplitterPosition(this._splitPane.getDividerLocation());
                if (this._listModel != null && this._listModel.getSize() > 0) {
                    int numTabs = this._listModel.getSize();
                    ArrayList<URL> urlList = new ArrayList<URL>(numTabs);
                    int i = 0;
                    while (i < numTabs) {
                        DefaultCustomTabPage tabPage = (DefaultCustomTabPage)this._listModel.get(i);
                        Editor editor = (Editor)tabPage.getUserObject();
                        if (editor instanceof HelpTopicEditor) {
                            HelpTopicDocument doc = ((HelpTopicEditor)editor).getHelpTopicDocument();
                            URL url = doc.getURL();
                            urlList.add(url);
                        }
                        ++i;
                    }
                    helpOptions.setOpenDocuments(urlList);
                } else {
                    helpOptions.setOpenDocuments(null);
                }
            }
        }

        private JTextField getTextField(Container parent) {
            if (parent instanceof JTextField) {
                JTextField jTextField = (JTextField)parent;
                return jTextField;
            }
            Component[] children = parent.getComponents();
            int i = 0;
            while (i < children.length) {
                Container container;
                JTextField textField;
                Component child = children[i];
                if (child instanceof Container && (textField = this.getTextField(container = (Container)child)) != null) {
                    return textField;
                }
                ++i;
            }
            return null;
        }

        private void whenAccept() {
            this._optionPanel.dismiss();
            this._optionPanel.saveOptions();
            this._searchField.requestFocus();
            this._optionPanel = null;
        }

        private void whenCancel() {
            this._optionPanel.dismiss();
            this._searchField.requestFocus();
            this._optionPanel = null;
        }

        private void showOptionPanel() {
            if (this._optionPanel == null) {
                this._optionPanel = SearchOptionsPanel.getSearchOptionsPanel();
                InputMap inputMap = this._optionPanel.getInputMap(1);
                ActionMap actionMap = this._optionPanel.getActionMap();
                inputMap.put(KeyStroke.getKeyStroke(40, 8), "showOptions");
                inputMap.put(KeyStroke.getKeyStroke(38, 8), "showOptions");
                inputMap.put(KeyStroke.getKeyStroke(10, 0), "showOptions");
                actionMap.put("showOptions", this._showOptionsAction);
                inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancelOptions");
                actionMap.put("cancelOptions", new MyAction('o'));
            }
            if (this._optionPanel.isShowing()) {
                this._optionPanel.dismiss();
                this._optionPanel.saveOptions();
                this._searchField.requestFocus();
                return;
            }
            this._optionPanel.addAncestorListener(new 5());
            this._optionPanel.show((Component)this._searchField, 3, this._searchField.getHeight() + 3);
        }

        public final boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == HelpCenterWindow.ra$TOGGLE_WINDOW_ON_TOP_CMD_ID()) {
                HelpCenterWindow.ra$_instanceWindow().setAlwaysOnTop(HelpCenterWindow.ra$_instanceWindow().isAlwaysOnTop() ^ true);
                HelpCenterWindow.wa$_userAlwaysOnTopSetting(HelpCenterWindow.ra$_instanceWindow().isAlwaysOnTop());
                action.putValue("State", (Object)(HelpCenterWindow.ra$_instanceWindow().isAlwaysOnTop() ? Boolean.TRUE : Boolean.FALSE));
                return true;
            }
            if (cmdId == HelpCenterWindow.ra$GOTO_TOC_CMD_ID()) {
                HelpCenterWindow.this.switchNavigator(0);
                return true;
            }
            if (cmdId == HelpCenterWindow.ra$GOTO_FAV_CMD_ID()) {
                HelpCenterWindow.this.switchNavigator(1);
                return true;
            }
            if (cmdId == HelpCenterWindow.ra$GOTO_DYN_CMD_ID()) {
                HelpCenterWindow.this.switchNavigator(2);
                return true;
            }
            if (cmdId == HelpCenterWindow.ra$GOTO_CUECARDS_CMD_ID()) {
                HelpCenterWindow.this.switchNavigator(3);
                return true;
            }
            if (cmdId == HelpCenterWindow.ra$CLOSE_ALL_TABS_CMD_ID()) {
                CustomTab cTab = this._scrollableTabBar.getTabs();
                cTab.removeAllPages();
                return true;
            }
            if (cmdId == HelpCenterWindow.ra$CLOSE_OTHER_TABS_CMD_ID()) {
                CustomTab cTab = this._scrollableTabBar.getTabs();
                int selPage = cTab.getSelectedPage();
                CustomTabPage currentPage = cTab.getPage(selPage);
                int numTabs = this._listModel.size();
                ArrayList<DefaultCustomTabPage> removeList = new ArrayList<DefaultCustomTabPage>(numTabs);
                int i = 0;
                while (i < numTabs) {
                    DefaultCustomTabPage page = (DefaultCustomTabPage)this._listModel.getElementAt(i);
                    if (page != currentPage) {
                        removeList.add(page);
                    }
                    ++i;
                }
                if (removeList.size() > 0) {
                    for (DefaultCustomTabPage removePage : removeList) {
                        cTab.removePage((CustomTabPage)removePage);
                    }
                }
                return true;
            }
            if (cmdId == HelpCenterWindow.ra$CLOSE_TAB_CMD_ID()) {
                CustomTab cTab = this._scrollableTabBar.getTabs();
                int selPage = cTab.getSelectedPage();
                if (selPage != -1) {
                    cTab.removePage(selPage);
                }
                return true;
            }
            if (cmdId == 4) {
                HelpCenterWindow.getInstance().setVisible(false);
                return true;
            }
            return false;
        }

        public final boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == HelpCenterWindow.ra$TOGGLE_WINDOW_ON_TOP_CMD_ID()) {
                action.setEnabled(true);
                return true;
            }
            return false;
        }

        static ScrollableTabBar ra$_scrollableTabBar(HelpCenterView helpCenterView) {
            return helpCenterView._scrollableTabBar;
        }

        static SearchField ra$_searchField(HelpCenterView helpCenterView) {
            return helpCenterView._searchField;
        }

        static HelpNavigatorToolbar ra$_toolbar(HelpCenterView helpCenterView) {
            return helpCenterView._toolbar;
        }

        static JPanel ra$_mainPanel(HelpCenterView helpCenterView) {
            return helpCenterView._mainPanel;
        }

        static SearchOptionsPanel ra$_optionPanel(HelpCenterView helpCenterView) {
            return helpCenterView._optionPanel;
        }

        static void wa$_optionPanel(HelpCenterView helpCenterView, SearchOptionsPanel searchOptionsPanel) {
            helpCenterView._optionPanel = searchOptionsPanel;
        }

        static DefaultListModel ra$_listModel(HelpCenterView helpCenterView) {
            return helpCenterView._listModel;
        }

        static JPanel ra$_editorPanel(HelpCenterView helpCenterView) {
            return helpCenterView._editorPanel;
        }

        static Component ra$_currentEditorComponent(HelpCenterView helpCenterView) {
            return helpCenterView._currentEditorComponent;
        }

        static void wa$_currentEditorComponent(HelpCenterView helpCenterView, Component component) {
            helpCenterView._currentEditorComponent = component;
        }

        static JSplitPane ra$_splitPane(HelpCenterView helpCenterView) {
            return helpCenterView._splitPane;
        }

        static void mav$whenAccept(HelpCenterView helpCenterView) {
            helpCenterView.whenAccept();
        }

        static void mav$whenCancel(HelpCenterView helpCenterView) {
            helpCenterView.whenCancel();
        }

        static void mav$showOptionPanel(HelpCenterView helpCenterView) {
            helpCenterView.showOptionPanel();
        }

        final class 1
        implements ListDataListener {
            public void intervalAdded(ListDataEvent e) {
                ListModel listModel = (ListModel)e.getSource();
                if (listModel.getSize() > 0 && HelpCenterView.ra$_splitPane(HelpCenterView.this).getLeftComponent() == null) {
                    HelpCenterView.ra$_splitPane(HelpCenterView.this).setLeftComponent(HelpCenterWindow.ra$_helpWindow().getGUI());
                }
            }

            public void intervalRemoved(ListDataEvent e) {
                ListModel listModel = (ListModel)e.getSource();
                if (listModel.getSize() == 0 && HelpCenterView.ra$_splitPane(HelpCenterView.this).getLeftComponent() != null) {
                    HelpCenterView.ra$_splitPane(HelpCenterView.this).setLeftComponent(null);
                    HelpCenterView.ra$_splitPane(HelpCenterView.this).repaint();
                }
            }

            public void contentsChanged(ListDataEvent e) {
            }
        }

        final class 2
        implements ListSelectionListener {
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    URL editorURL;
                    JDevTOCNavigator tocNavigator;
                    if (HelpCenterView.ra$_currentEditorComponent(HelpCenterView.this) != null) {
                        HelpCenterView.ra$_editorPanel(HelpCenterView.this).remove(HelpCenterView.ra$_currentEditorComponent(HelpCenterView.this));
                    }
                    int selPageIdx = HelpCenterView.ra$_scrollableTabBar(HelpCenterView.this).getTabs().getSelectedPage();
                    DefaultCustomTabPage tabPage = (DefaultCustomTabPage)HelpCenterView.ra$_scrollableTabBar(HelpCenterView.this).getTabs().getPage(selPageIdx);
                    Editor editor = (Editor)tabPage.getUserObject();
                    Component newEditorComponent = editor.getGUI();
                    HelpCenterView.ra$_editorPanel(HelpCenterView.this).add(newEditorComponent, "Center");
                    HelpCenterView.wa$_currentEditorComponent(HelpCenterView.this, newEditorComponent);
                    if (editor instanceof HelpTopicEditor && (tocNavigator = HelpCenterWindow.getTOCNavigator()) != null && (editorURL = ((HelpTopicEditor)editor).getBrowser().getURL()) != null) {
                        tocNavigator.selectMatchingTopic(editorURL);
                    }
                    HelpCenterView.ra$_editorPanel(HelpCenterView.this).invalidate();
                    HelpCenterView.ra$_editorPanel(HelpCenterView.this).repaint();
                    HelpCenterView.ra$_splitPane(HelpCenterView.this).repaint();
                }
            }
        }

        final class 3
        implements ListDataListener {
            public void intervalAdded(ListDataEvent e) {
            }

            public void intervalRemoved(ListDataEvent e) {
                int numTabs = HelpCenterView.ra$_listModel(HelpCenterView.this).size();
                if (numTabs == 0) {
                    HelpCenterView.ra$_splitPane(HelpCenterView.this).setRightComponent(null);
                    HelpCenterWindow.wa$_cueCardPage(HelpCenterWindow.this, null);
                    HelpCenterWindow.wa$_cueCardViewer(HelpCenterWindow.this, null);
                    return;
                }
                int i = 0;
                while (i < numTabs) {
                    Object page = HelpCenterView.ra$_listModel(HelpCenterView.this).getElementAt(i);
                    if (page == HelpCenterWindow.ra$_cueCardPage(HelpCenterWindow.this)) {
                        return;
                    }
                    ++i;
                }
                HelpCenterWindow.wa$_cueCardPage(HelpCenterWindow.this, null);
                HelpCenterWindow.wa$_cueCardViewer(HelpCenterWindow.this, null);
            }

            public void contentsChanged(ListDataEvent e) {
            }
        }

        final class 4
        implements Runnable {
            public void run() {
                HelpCenterView.ra$_scrollableTabBar(HelpCenterView.this).ensureSelectedTabVisible();
                HelpCenterView.ra$_scrollableTabBar(HelpCenterView.this).repaint();
            }
        }

        final class 5
        implements AncestorListener {
            public void ancestorAdded(AncestorEvent event) {
            }

            public void ancestorMoved(AncestorEvent event) {
            }

            public void ancestorRemoved(AncestorEvent event) {
                HelpCenterView.ra$_optionPanel(HelpCenterView.this).removeAncestorListener(this);
                HelpCenterView.ra$_optionPanel(HelpCenterView.this).saveOptions();
            }
        }

        private class HelpSearchListener
        implements SearchListener {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void searchPerformed(SearchEvent se) {
                if (HelpCenterView.ra$_optionPanel(HelpCenterView.this) != null && HelpCenterView.ra$_optionPanel(HelpCenterView.this).isShowing()) {
                    HelpCenterView.ra$_optionPanel(HelpCenterView.this).dismiss();
                    HelpCenterView.ra$_optionPanel(HelpCenterView.this).saveOptions();
                    HelpCenterView.wa$_optionPanel(HelpCenterView.this, null);
                }
                HelpCenterView helpCenterView = HelpCenterWindow.ra$_helpCenterView();
                synchronized (helpCenterView) {
                    String searchText = se.getSearchText().trim();
                    if (searchText != null && searchText.length() > 0) {
                        DefaultCustomTabPage removePage = HelpCenterWindow.maS$getSearchResultsPage();
                        SearchResultsEditor resultsEditor = new SearchResultsEditor(searchText, HelpCenterWindow.getSearchModel());
                        HelpCenterWindow.ra$_helpCenterView().add(resultsEditor);
                        if (removePage != null) {
                            HelpCenterWindow.maS$removeTabPage(removePage);
                        }
                        resultsEditor.startSearch(se);
                    }
                }
            }

            public void searchCategoryChanged(SearchEvent se) {
                this.searchPerformed(se);
            }
        }

        private final class TabCloseAction
        extends AbstractAction {
            public void actionPerformed(ActionEvent e) {
                HelpContentPanel hcp;
                DefaultCustomTabPage tabPage = (DefaultCustomTabPage)e.getSource();
                HelpCenterView.ra$_listModel(HelpCenterView.this).removeElement(tabPage);
                Editor editor = (Editor)tabPage.getUserObject();
                if (editor instanceof HelpTopicEditor && (hcp = ((HelpTopicEditor)editor).getHelpContentPanel()) == HelpCenterWindow.ra$_cueCardViewer(HelpCenterWindow.this)) {
                    HelpCenterWindow.wa$_cueCardViewer(HelpCenterWindow.this, null);
                    HelpCenterWindow.wa$_cueCardPage(HelpCenterWindow.this, null);
                }
                HelpCenterView.ra$_editorPanel(HelpCenterView.this).remove(editor.getGUI());
                int selPage = HelpCenterView.ra$_scrollableTabBar(HelpCenterView.this).getTabs().getSelectedPage();
                if (HelpCenterView.ra$_listModel(HelpCenterView.this).size() > 0 && selPage != -1) {
                    DefaultCustomTabPage selTabPage = (DefaultCustomTabPage)HelpCenterView.ra$_scrollableTabBar(HelpCenterView.this).getTabs().getPage(selPage);
                    editor = (Editor)selTabPage.getUserObject();
                    if (HelpCenterView.ra$_currentEditorComponent(HelpCenterView.this) != null) {
                        HelpCenterView.ra$_editorPanel(HelpCenterView.this).remove(HelpCenterView.ra$_currentEditorComponent(HelpCenterView.this));
                    }
                    if (editor != null) {
                        HelpCenterView.ra$_editorPanel(HelpCenterView.this).add(editor.getGUI(), "Center");
                        HelpCenterView.wa$_currentEditorComponent(HelpCenterView.this, editor.getGUI());
                    }
                }
                if (HelpCenterView.ra$_listModel(HelpCenterView.this).size() == 0) {
                    HelpCenterView.ra$_splitPane(HelpCenterView.this).remove(HelpCenterView.ra$_editorPanel(HelpCenterView.this));
                }
                HelpCenterView.ra$_splitPane(HelpCenterView.this).repaint();
                HelpCenterView.ra$_mainPanel(HelpCenterView.this).repaint();
            }

            private TabCloseAction() {
            }

            TabCloseAction(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }
    }

    private class MyAction
    extends AbstractAction {
        private char _type;

        public MyAction(char type) {
            this._type = type;
        }

        public void actionPerformed(ActionEvent e) {
            switch (this._type) {
                case 'A': {
                    HelpCenterView.mav$whenAccept(HelpCenterWindow.ra$_helpCenterView());
                    break;
                }
                case 'C': {
                    HelpCenterView.mav$whenCancel(HelpCenterWindow.ra$_helpCenterView());
                    break;
                }
                case 'O': {
                    HelpCenterView.mav$showOptionPanel(HelpCenterWindow.ra$_helpCenterView());
                    break;
                }
                case 'o': {
                    HelpCenterView.mav$showOptionPanel(HelpCenterWindow.ra$_helpCenterView());
                    break;
                }
            }
        }
    }

    private static class HelpAWTEventListener
    implements AWTEventListener {
        public void eventDispatched(AWTEvent event) {
            Dialog modalDlg;
            Object eventWindow;
            if (event.getID() == 200) {
                Dialog dlg;
                Object eventWindow2 = event.getSource();
                if (!(!(eventWindow2 instanceof Dialog) || eventWindow2 instanceof HelpCenterWindow || !(dlg = (Dialog)eventWindow2).isModal() || dlg instanceof FindDialog || dlg.getParent() instanceof FindDialog || dlg.getParent() instanceof MyJDialog || dlg instanceof HelpUtils.HelpJEWTDialog || dlg.getClass().getName().indexOf("ProgressBar") != -1 || this.doesDialogContainsJOptionPanel(dlg))) {
                    Component focusComp = null;
                    if (dlg instanceof JEWTDialog) {
                        focusComp = ((JEWTDialog)dlg).getInitialFocus();
                    }
                    MyJDialog.maS$reparent(dlg);
                    Component requestFocusComp = focusComp;
                    1 runnable = new 1(this, requestFocusComp, dlg);
                    SwingUtilities.invokeLater(runnable);
                }
            } else if (event.getID() == 202 && (eventWindow = event.getSource()) instanceof MyJDialog && (modalDlg = HelpCenterWindow.maS$getActiveModalOwnerDialog()) != null && modalDlg != null) {
                if (HelpCenterWindow.ra$_instanceWindow() != null && HelpCenterWindow.ra$_instanceWindow().getParent() == modalDlg) {
                    return;
                }
                if (HelpCenterWindow.ra$_baseInstance() != null && HelpCenterWindow.ra$_baseInstance().getParent() == modalDlg) {
                    return;
                }
                MyJDialog.maS$reparent(modalDlg);
            }
        }

        private boolean doesDialogContainsJOptionPanel(Dialog dlg) {
            if (dlg instanceof JDialog) {
                JDialog jdlg = (JDialog)dlg;
                return this.containsJOptionPanel(jdlg.getContentPane());
            }
            return false;
        }

        private boolean containsJOptionPanel(Container container) {
            Component[] comps = container.getComponents();
            if (comps != null) {
                Component[] componentArray = comps;
                int n = 0;
                while (n < componentArray.length) {
                    Component c = componentArray[n];
                    if (c instanceof JOptionPane) {
                        return true;
                    }
                    if (c instanceof Container) {
                        return this.containsJOptionPanel((Container)c);
                    }
                    ++n;
                }
            }
            return false;
        }

        private HelpAWTEventListener() {
        }

        HelpAWTEventListener(1 var1_1) {
            this();
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ Component v$requestFocusComp;
            private final /* synthetic */ Dialog v$dlg;
            final /* synthetic */ HelpAWTEventListener this$0;

            public void run() {
                if (this.v$requestFocusComp != null) {
                    this.v$dlg.requestFocus();
                    this.v$requestFocusComp.requestFocus();
                } else {
                    this.v$dlg.requestFocus();
                }
                int screenX = this.v$dlg.getLocationOnScreen().x;
                Point p = HelpCenterWindow.ra$_instanceWindow().getLocation();
                p.x = (screenX += this.v$dlg.getWidth()) + 2;
                HelpCenterWindow.ra$_instanceWindow().setLocation(p);
            }

            public 1(HelpAWTEventListener helpAWTEventListener, Component component, Dialog dialog) {
                this.v$dlg = dialog;
                this.v$requestFocusComp = component;
                this.this$0 = helpAWTEventListener;
            }
        }
    }

    private static class ThemedContentPanel
    extends JPanel {
        private Painter _painter;

        public void paintComponent(Graphics g) {
            if (this._painter == null && Themes.isThemed()) {
                this._painter = Themes.getActiveTheme().getStateProperties("mainwindow", "normal").getPainter("bg");
            }
            if (this._painter != null) {
                this._painter.paint(g, 0, 0, this.getWidth(), this.getHeight());
            } else {
                super.paintComponent(g);
            }
        }

        private ThemedContentPanel() {
        }

        ThemedContentPanel(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private class TabMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._showContextMenu(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._showContextMenu(e);
            }
        }

        private void _showContextMenu(MouseEvent e) {
            ContextMenu cm = new ContextMenu();
            cm.addContextMenuListener((ContextMenuListener)new 1());
            Context context = new Context((View)HelpCenterWindow.ra$_helpCenterView(), null, null, null);
            context.setEvent((EventObject)e);
            cm.show(context);
        }

        private TabMouseListener() {
        }

        TabMouseListener(1 var2_2) {
            this();
        }

        final class 1
        implements ContextMenuListener {
            public void menuWillShow(ContextMenu contextMenu) {
                String label = StringUtils.stripMnemonic((String)HelpArb.getString(45));
                IdeAction action = IdeAction.get((int)HelpCenterWindow.ra$CLOSE_ALL_TABS_CMD_ID(), (String)HelpCenterWindow.CLOSE_ALL_TABS_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), null, null, (boolean)true);
                action.addController((Controller)HelpCenterWindow.ra$_helpCenterView());
                JMenuItem menuItem = contextMenu.createMenuItem((ToggleAction)action);
                contextMenu.add((Component)menuItem);
                label = StringUtils.stripMnemonic((String)HelpArb.getString(96));
                action = IdeAction.get((int)HelpCenterWindow.ra$CLOSE_OTHER_TABS_CMD_ID(), (String)HelpCenterWindow.CLOSE_OTHER_TABS_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), null, null, (boolean)true);
                action.addController((Controller)HelpCenterWindow.ra$_helpCenterView());
                menuItem = contextMenu.createMenuItem((ToggleAction)action);
                contextMenu.add((Component)menuItem);
                label = StringUtils.stripMnemonic((String)HelpArb.getString(167));
                action = IdeAction.get((int)HelpCenterWindow.ra$CLOSE_TAB_CMD_ID(), (String)HelpCenterWindow.CLOSE_TAB_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), null, null, (boolean)true);
                action.addController((Controller)HelpCenterWindow.ra$_helpCenterView());
                menuItem = contextMenu.createMenuItem((ToggleAction)action);
                contextMenu.add((Component)menuItem);
            }

            public void menuWillHide(ContextMenu contextMenu) {
            }

            public boolean handleDefaultAction(Context context) {
                return false;
            }
        }
    }

    private static class MyJDialog
    extends JDialog {
        private MyJDialog(boolean initUI) {
            if (initUI) {
                this.fullInit();
            } else {
                this.shortInit();
            }
        }

        private MyJDialog(Dialog owner, boolean doInit) {
            super(owner);
            if (doInit) {
                this.fullInit();
            } else {
                this.shortInit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            HelpCenterWindow helpCenterWindow = HelpCenterWindow.ra$INSTANCE();
            synchronized (helpCenterWindow) {
                if (HelpCenterWindow.ra$_baseInstance() != null && HelpCenterWindow.ra$_instanceWindow() != null && this == HelpCenterWindow.ra$_instanceWindow()) {
                    MyJDialog.moveComponents((MyJDialog)HelpCenterWindow.ra$_baseInstance());
                    HelpCenterWindow.wa$_instanceWindow(HelpCenterWindow.ra$_baseInstance());
                    HelpCenterWindow.ra$_instanceWindow().setAlwaysOnTop(HelpCenterWindow.ra$_userAlwaysOnTopSetting());
                    HelpCenterWindow.ra$_instanceWindow().setVisible(true);
                    HelpCenterWindow.wa$_baseInstance(null);
                }
            }
            super.dispose();
        }

        protected JRootPane createRootPane() {
            return HelpCenterWindow.maS$createRootPane(this);
        }

        private void shortInit() {
            this.setContentPane(new ThemedContentPanel(null));
            this.getContentPane().setLayout(new BorderLayout());
            MyJDialog.moveComponents((MyJDialog)HelpCenterWindow.ra$_instanceWindow());
            this.addWindowListener(HelpCenterWindow.ra$_windowAdapter());
        }

        private void fullInit() {
            HelpCenterWindow.maS$fullInit(this);
        }

        private static void moveComponents(MyJDialog toWindow) {
            toWindow.getContentPane().add(HelpCenterWindow.ra$_helpCenterView().getGUI(), "Center");
        }

        private static void reparent(Dialog owner) {
            MyJDialog disposableInstance = null;
            if (HelpCenterWindow.ra$_baseInstance() == null) {
                HelpCenterWindow.wa$_baseInstance(HelpCenterWindow.ra$_instanceWindow());
                HelpCenterWindow.ra$_baseInstance().setAlwaysOnTop(false);
            } else {
                disposableInstance = (MyJDialog)HelpCenterWindow.ra$_instanceWindow();
            }
            MyJDialog hcw = MyJDialog.createCopyInstance(owner);
            HelpCenterWindow.wa$_instanceWindow(hcw);
            if (disposableInstance != null) {
                disposableInstance.dispose();
            }
        }

        private static MyJDialog createCopyInstance(Dialog owner) {
            MyJDialog copy = null;
            if (owner == null) {
                copy = new MyJDialog(false);
            } else {
                copy = new MyJDialog(owner, false);
                copy.setAlwaysOnTop(false);
            }
            MyJDialog.moveComponents(copy);
            HelpCenterWindow.ra$_helpWindow().getCustomTab().setFocused(true);
            copy.addComponentListener(new 1());
            copy.setTitle(HelpArb.getString(115));
            copy.setSize(HelpCenterWindow.ra$_baseInstance().getSize());
            copy.setLocation(HelpCenterWindow.ra$_baseInstance().getLocation());
            if (HelpCenterWindow.ra$_baseInstance().isVisible() || owner == null) {
                copy.setVisible(true);
            }
            return copy;
        }

        MyJDialog(boolean bl, 1 var2_2) {
            this(bl);
        }

        static void maS$reparent(Dialog dialog) {
            MyJDialog.reparent(dialog);
        }

        static final class 1
        implements ComponentListener {
            public void componentResized(ComponentEvent e) {
                if (HelpCenterWindow.ra$_baseInstance() != null) {
                    HelpCenterWindow.ra$_baseInstance().setSize(e.getComponent().getSize());
                }
            }

            public void componentMoved(ComponentEvent e) {
                if (HelpCenterWindow.ra$_baseInstance() != null) {
                    HelpCenterWindow.ra$_baseInstance().setLocation(e.getComponent().getLocation());
                }
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }
        }
    }

    private static class MyJFrame
    extends JFrame {
        public MyJFrame(Method setModalExclusionMethod) {
            HelpCenterWindow.maS$fullInit(this);
            try {
                Object[] args = new Object[]{MyJFrame.getApplicationExcludeType()};
                setModalExclusionMethod.invoke((Object)this, args);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        protected JRootPane createRootPane() {
            return HelpCenterWindow.maS$createRootPane(this);
        }

        private static Object getApplicationExcludeType() {
            Class<?>[] declaredClasses = Dialog.class.getDeclaredClasses();
            if (declaredClasses != null) {
                Class<?>[] classArray = declaredClasses;
                int n = 0;
                while (n < classArray.length) {
                    ?[] constants;
                    Class<?> dClass = classArray[n];
                    if (dClass.getName().indexOf("ModalExclusionType") != -1 && (constants = dClass.getEnumConstants()) != null) {
                        ?[] objArray = constants;
                        int n2 = 0;
                        while (n2 < objArray.length) {
                            Object obj = objArray[n2];
                            if (obj.toString().equals("APPLICATION_EXCLUDE")) {
                                return obj;
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
            }
            return null;
        }
    }
}

