/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.help.CustomProtocolHandler;
import oracle.help.common.IndirectTarget;
import oracle.help.common.Topic;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.htmlBrowser.ICEBrowser;
import oracle.help.library.Library;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.help.navigator.tocNavigator.TOCNavigator;
import oracle.help.topicDisplay.BrowserTopicDisplay;
import oracle.help.topicDisplay.CustomProtocolRegistry;
import oracle.help.topicDisplay.SimpleTopicDisplayPanel;
import oracle.help.topicDisplay.TopicDisplay;
import oracle.help.topicDisplay.TopicDisplayEvent;
import oracle.help.topicDisplay.TopicDisplayListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.EditorManager;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.gallery.GalleryManager;
import oracle.ide.gallery.ObjectGallery;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.ide.layout.URL2String;
import oracle.ide.model.Project;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.ideri.importexport.ExportWizard;
import oracle.ideri.importexport.ImportWizard;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Pair;
import oracle.jdevimpl.help.AbstractCustomProtocolHandler;
import oracle.jdevimpl.help.BrowserCueCardDisplay;
import oracle.jdevimpl.help.CueCardSet;
import oracle.jdevimpl.help.DynamicLinkTarget;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpCenterWindow;
import oracle.jdevimpl.help.HelpContentWindow;
import oracle.jdevimpl.help.HelpNavigatorToolbar;
import oracle.jdevimpl.help.HelpSystemConstants;
import oracle.jdevimpl.help.HelpTopicEditor;
import oracle.jdevimpl.help.HelpUtils;
import oracle.jdevimpl.help.HelpWindow;
import oracle.jdevimpl.help.JDevHelpSystemImpl;
import oracle.jdevimpl.help.JDevTOCNavigator;

public class HelpContentPanel
extends View
implements TopicDisplayListener,
ContextMenuListener {
    private Object _parent;
    private HTMLBrowser _browser;
    private TopicDisplay _topicDisplay;
    private SimpleTopicDisplayPanel _displayPanel;
    private boolean _helpSystemDependent;
    private boolean _syncTOCWithSelection;
    private Library _library;
    private IdeAction _backwardAction;
    private ToolButton _backwardBtn;
    private JMenuItem _backwardMenu;
    private IdeAction _forwardAction;
    private ToolButton _forwardBtn;
    private IdeAction _copyAction;
    private JMenuItem _forwardMenu;
    private IdeAction _printAction;
    private ToolButton _printBtn;
    private JMenuItem _printMenu;
    private IdeAction _findAction;
    private ToolButton _findBtn;
    private JMenuItem _findMenu;
    private JMenuItem _copyMenu;
    private JPanel _mainPanel;
    private Controller _controller;
    Toolbar _toolbar;
    private ContextMenu _contextMenu;
    private MouseListener _mouseListener;
    private IdeAction _contextMenuAction;
    private IdeAction _exitAction;
    private IdeAction _selectAllAction;
    private JMenuItem _selectAllMenu;
    private IdeAction _addFavoriteAction;
    private ToolButton _addFavoriteBtn;
    private JMenuItem _addFavoriteMenu;
    private boolean _cueCardViewer;
    private MenuToolButton _changeFontSizeBtn;
    private boolean _displayToolbar;
    private ChangeListener _changeListener;
    private static final List _protocolRegistryList = new ArrayList();
    private ContextMenu _activeContextMenu;
    private static final String VIEWID_STRING = "HelpSystemAddin.HelpContentPanel";
    private static final Class HTML_BROWSER_CLASS = ICEBrowser.class;
    private static final String TAB_ACTION = "oracle.jdevimpl.help.HelpContentPanel.TabAction";

    private void $init$() {
        this._displayToolbar = true;
    }

    public HelpContentPanel(Library library, boolean syncTOCWithSelection, boolean displayedInModalDialog, Object parent) {
        super(VIEWID_STRING);
        this.$init$();
        this._library = library;
        this._helpSystemDependent = true;
        this._syncTOCWithSelection = syncTOCWithSelection;
        this._parent = parent;
        this._init();
    }

    public HelpContentPanel(Library library, boolean syncTOCWithSelection, Object parent) {
        this(library, syncTOCWithSelection, false, parent);
    }

    public HelpContentPanel(Library library, Object parent) {
        this(library, true, false, parent);
    }

    public HelpContentPanel(Object parent) {
        super(VIEWID_STRING);
        this.$init$();
        this._parent = parent;
        this._helpSystemDependent = false;
        this._init();
    }

    public HelpContentPanel(JEWTDialog parent) {
        super(VIEWID_STRING);
        this.$init$();
        this._parent = parent;
        this._helpSystemDependent = false;
        this._displayToolbar = false;
        this._init();
    }

    public HelpContentPanel(Library library, ViewerType viewerType) {
        super(VIEWID_STRING);
        this.$init$();
        this._library = library;
        this._cueCardViewer = viewerType == ViewerType.CUE_CARD_VIEWER;
        this._helpSystemDependent = true;
        this._syncTOCWithSelection = true;
        this._init();
    }

    public void displayTopic(Topic topic) {
        try {
            this._displayPanel.displayTopic(topic);
        }
        catch (Exception e) {
            String topicId = null;
            if (topic.hasTarget()) {
                if (topic.getTarget() instanceof IndirectTarget) {
                    IndirectTarget iTarget = (IndirectTarget)topic.getTarget();
                    topicId = iTarget.getTargetName();
                } else if (topic.getTarget() instanceof DynamicLinkTarget) {
                    DynamicLinkTarget dTarget = (DynamicLinkTarget)topic.getTarget();
                    topicId = dTarget.getTopicId();
                }
            }
            Assert.println((String)("Failed to find URL for topic: " + topicId));
        }
    }

    public HTMLBrowser getBrowser() {
        return this._browser;
    }

    public TopicDisplay getTopicPanel() {
        return this._displayPanel;
    }

    BrowserCueCardDisplay getBrowserCueCardDisplay() {
        if (this._cueCardViewer) {
            return (BrowserCueCardDisplay)this._topicDisplay;
        }
        return null;
    }

    public void runFindDialog() {
        this._browser.runFindDialog();
    }

    public Controller getController() {
        return this._controller;
    }

    public ContextMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            this._backwardMenu = this._contextMenu.createMenuItem((ToggleAction)this._backwardAction);
            this._forwardMenu = this._contextMenu.createMenuItem((ToggleAction)this._forwardAction);
            this._printMenu = this._contextMenu.createMenuItem((ToggleAction)this._printAction);
            this._findMenu = this._contextMenu.createMenuItem((ToggleAction)this._findAction);
            this._copyMenu = this._contextMenu.createMenuItem((ToggleAction)this._copyAction);
            this._selectAllMenu = this._contextMenu.createMenuItem((ToggleAction)this._selectAllAction);
            this._addFavoriteMenu = this._contextMenu.createMenuItem((ToggleAction)this._addFavoriteAction);
            this._contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        return this._contextMenu;
    }

    public Component getGUI() {
        return this._mainPanel;
    }

    public void dispose() {
        if (this._displayPanel != null) {
            this._displayPanel = null;
        }
        if (this._toolbar != null) {
            this._toolbar.dispose();
            this._toolbar = null;
        }
        if (this._changeListener != null) {
            KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
            kso.removeChangeListener(this._changeListener);
            this._changeListener = null;
        }
        this._parent = null;
        if (this._controller != null) {
            this.removeControllerFromAction(this._backwardAction);
            this.removeControllerFromAction(this._forwardAction);
            this.removeControllerFromAction(this._copyAction);
            this.removeControllerFromAction(this._findAction);
            this.removeControllerFromAction(this._printAction);
            this.removeControllerFromAction(this._exitAction);
            this.removeControllerFromAction(this._contextMenuAction);
            this.removeControllerFromAction(this._selectAllAction);
            this.removeControllerFromAction(this._addFavoriteAction);
            this.removeControllerFromAction(IdeAction.find((int)22));
        }
    }

    boolean isCueCardViewer() {
        return this._cueCardViewer;
    }

    public boolean canGoBackward() {
        return this._displayPanel != null && this._displayPanel.canGoBack();
    }

    public boolean canGoForward() {
        return this._displayPanel != null && this._displayPanel.canGoForward();
    }

    public void goBackward() {
        this._displayPanel.goBack();
    }

    public void goForward() {
        this._displayPanel.goForward();
    }

    public boolean isTextSelected() {
        return this._browser.getSelectedText() != null;
    }

    public void copy() {
        JTextArea t = new JTextArea();
        t.setText(this._browser.getSelectedText());
        t.selectAll();
        t.copy();
    }

    public static Class getHTMLBrowserClass() {
        return HTML_BROWSER_CLASS;
    }

    public static HTMLBrowser createHTMLBrowser() {
        HTMLBrowser browser = null;
        try {
            browser = (HTMLBrowser)HelpContentPanel.getHTMLBrowserClass().newInstance();
            browser.setLocale(StaticLocaleContext.getLocale());
            if (StaticLocaleContext.getEncoding() != null) {
                browser.setCharset(StaticLocaleContext.getEncoding());
            }
            HTMLBrowser hTMLBrowser = browser;
            return hTMLBrowser;
        }
        catch (Exception e) {
            Assert.println((String)("Failed to create instance of " + HelpContentPanel.getHTMLBrowserClass().toString()));
            Assert.println((String)"Cannot create Topic Display");
            HTMLBrowser hTMLBrowser = null;
            return hTMLBrowser;
        }
    }

    public Object getParent() {
        return this._parent;
    }

    void setParent(Object parent) {
        this._parent = parent;
    }

    public void syncTOCToURL(URL url) {
        HelpCenterWindow hcw;
        CueCardSet ccSet;
        JDevTOCNavigator tocNavigator;
        HelpCenterWindow helpCenterWindow = HelpCenterWindow.peekInstance();
        if (helpCenterWindow == null) {
            return;
        }
        if (this._syncTOCWithSelection && (tocNavigator = HelpCenterWindow.getTOCNavigator()) != null) {
            1 runnable = new 1(this, tocNavigator, url);
            SwingUtilities.invokeLater(runnable);
        }
        if (this._cueCardViewer && (ccSet = (hcw = HelpCenterWindow.getInstance()).getCueCardSet()) != null) {
            ccSet.setCurrentURL(url);
        }
    }

    public void menuWillShow(ContextMenu popup) {
        float section = MenuConstants.SECTION_DYNAMIC_CTXT_MENU;
        this._contextMenu.add((Component)this._backwardMenu, section);
        this._contextMenu.add((Component)this._forwardMenu, section);
        this._contextMenu.add((Component)this._copyMenu, section += 0.001f);
        this._contextMenu.add((Component)this._selectAllMenu, section);
        this._contextMenu.add((Component)this._findMenu, section += 0.001f);
        this._contextMenu.add((Component)this._printMenu, section += 0.001f);
        section += 0.001f;
        if (!this._cueCardViewer) {
            this._contextMenu.add((Component)this._addFavoriteMenu, section);
        }
        if (this.canGoBackward()) {
            this._backwardMenu.setEnabled(true);
        } else {
            this._backwardMenu.setEnabled(false);
        }
        if (this.canGoForward()) {
            this._forwardMenu.setEnabled(true);
        } else {
            this._forwardMenu.setEnabled(false);
        }
        if (this._browser.getSelectedText() != null) {
            this._copyMenu.setEnabled(true);
        } else {
            this._copyMenu.setEnabled(false);
        }
        this._activeContextMenu = popup;
    }

    public void menuWillHide(ContextMenu popup) {
        this._activeContextMenu = null;
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    ContextMenu getActiveContextMenu() {
        return this._activeContextMenu;
    }

    private void _createKeyMappings() {
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext ksc = kscr.getContext("oracle/jdevimpl/help/localaccelerators.xml");
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        MultiInputMap imap = MultiMapAdapter.getLocalMap((KeyStrokeOptions)kso, (KeyStrokeContext)ksc);
        InputMap inputMap = Ide.getIdeInputMap();
        imap.setParent(inputMap);
        this._mainPanel.setInputMap(1, (InputMap)imap);
        this.loadMyMap(imap, this._mainPanel.getActionMap(), kso);
        this._changeListener = new 2(this, imap, kso, ksc);
        kso.addChangeListener(this._changeListener);
        this._setButtonTooltips();
        JRootPane rootPane = null;
        if (this._parent instanceof JDialog) {
            rootPane = ((JDialog)this._parent).getRootPane();
        } else if (this._parent instanceof HelpTopicEditor && ((HelpTopicEditor)((Object)this._parent)).getParent() instanceof HelpContentWindow) {
            HelpTopicEditor hte = (HelpTopicEditor)((Object)this._parent);
            HelpContentWindow hcw = (HelpContentWindow)hte.getParent();
            rootPane = hcw.getRootPane();
        }
        if (rootPane != null) {
            this._contextMenuAction = IdeAction.newLocalAction((int)50, (View)this);
            this._contextMenuAction.addController(this._controller);
            this._exitAction = IdeAction.newLocalAction((int)4, (View)this);
            this._exitAction.addController(this._controller);
            MultiInputMap myInputMap = new MultiInputMap(true);
            ActionMap myActionMap = new ActionMap();
            this.loadMyMap(myInputMap, myActionMap, kso);
            ActionMap amMe = rootPane.getActionMap();
            amMe.setParent(myActionMap);
            InputMap imMe = rootPane.getInputMap(1);
            imMe.setParent((InputMap)myInputMap);
            IdeAction.find((int)23).setEnabled(true);
            IdeAction.find((int)16).setEnabled(true);
            IdeAction.find((int)22).setEnabled(true);
            IdeAction.find((int)50).setEnabled(true);
        }
    }

    private void loadMyMap(MultiInputMap myMap, ActionMap aMap, KeyStrokeOptions kso) {
        this.updateMyMapWithAction(kso, aMap, myMap, 23, this._findAction);
        this._findAction.setEnabled(true);
        this.updateMyMapWithAction(kso, aMap, myMap, 16, this._printAction);
        this._printAction.setEnabled(true);
        this.updateMyMapWithAction(kso, aMap, myMap, 22, this._selectAllAction);
        this._selectAllAction.setEnabled(true);
        if (this._contextMenuAction != null) {
            this.updateMyMapWithAction(kso, aMap, myMap, 50, this._contextMenuAction);
            this._contextMenuAction.setEnabled(true);
            this.updateMyMapWithAction(kso, aMap, myMap, 4, this._exitAction);
            this._exitAction.setEnabled(true);
        }
        this.updateMyMapWithAction(kso, aMap, myMap, HelpSystemConstants.FORWARD_CMD_ID, this._forwardAction);
        this.updateMyMapWithAction(kso, aMap, myMap, HelpSystemConstants.BACKWARD_CMD_ID, this._backwardAction);
    }

    private void updateMyMapWithAction(KeyStrokeOptions kso, ActionMap aMap, MultiInputMap myMap, int cmdId, IdeAction action) {
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext ksc = kscr.getContext("oracle/jdevimpl/help/localaccelerators.xml");
        List kList = this.getKeyStrokesFor(kso, cmdId, ksc);
        if (kList != Collections.EMPTY_LIST) {
            int numKeys = kList.size();
            Integer integer = new Integer(cmdId);
            int i = 0;
            while (i < numKeys) {
                aMap.put(integer, (Action)action);
                myMap.put((KeyStrokes)kList.get(i), (Object)integer);
                ++i;
            }
        }
    }

    private List getKeyStrokesFor(KeyStrokeOptions kso, int cmdId, KeyStrokeContext ksc) {
        KeyStrokeMap ksm = kso.getGlobalKeyMap();
        List kList = ksm.getKeyStrokesFor(cmdId);
        if (kList == Collections.EMPTY_LIST) {
            ksm = kso.getLocalKeyMap(ksc);
            kList = ksm.getKeyStrokesFor(cmdId);
        }
        return kList;
    }

    private void _setButtonTooltips() {
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext ksc = kscr.getContext("oracle/jdevimpl/help/localaccelerators.xml");
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeMap localKeyMap = kso.getLocalKeyMap(ksc);
        KeyStrokeMap globalKeyMap = kso.getGlobalKeyMap();
        this._setTooltipForButton(this._forwardBtn, localKeyMap, globalKeyMap);
        this._setTooltipForButton(this._backwardBtn, localKeyMap, globalKeyMap);
    }

    private void _setTooltipForButton(ToolButton button, KeyStrokeMap localKeyMap, KeyStrokeMap globalKeyMap) {
        String acceleratorTip;
        IdeAction action = (IdeAction)button.getAction();
        String tip = (String)action.getValue("ShortDescription");
        if (tip == null || tip.length() == 0) {
            tip = (String)action.getValue("Name");
        }
        if ((acceleratorTip = KeyUtil.getAcceleratorTooltip((KeyStrokeMap)localKeyMap, (int)action.getCommandId())) == null || acceleratorTip.length() == 0) {
            acceleratorTip = KeyUtil.getAcceleratorTooltip((KeyStrokeMap)globalKeyMap, (int)action.getCommandId());
        }
        if (acceleratorTip != null && acceleratorTip.length() != 0) {
            tip = tip + " (" + acceleratorTip + ")";
        }
        button.setToolTipText(tip);
    }

    private void _init() {
        this._mainPanel = new JPanel(new BorderLayout());
        this._controller = new HelpTopicPanelController(null);
        String sCategory = IdeArb.getString((int)80);
        this._browser = HelpContentPanel.createHTMLBrowser();
        this._topicDisplay = this._cueCardViewer ? new BrowserCueCardDisplay(this._browser, this._library) : (this._helpSystemDependent ? new BrowserTopicDisplay(this._browser, this._library) : new BrowserTopicDisplay(this._browser));
        this._registerProtocolHandlers();
        this._topicDisplay.addDisplayListener((TopicDisplayListener)this);
        this._displayPanel = new SimpleTopicDisplayPanel(this._topicDisplay, null, null);
        this._displayPanel.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        if (this._displayToolbar) {
            this._backwardAction = IdeAction.newLocalAction((int)HelpSystemConstants.BACKWARD_CMD_ID, (View)this);
            this._backwardAction.addController(this._controller);
            this._backwardBtn = new ToolButton((Action)this._backwardAction);
            this._forwardAction = IdeAction.newLocalAction((int)HelpSystemConstants.FORWARD_CMD_ID, (View)this);
            this._forwardAction.addController(this._controller);
            this._forwardBtn = new ToolButton((Action)this._forwardAction);
            this._printAction = IdeAction.newLocalAction((int)16, (View)this);
            this._printBtn = new ToolButton((Action)this._printAction);
            this._findAction = IdeAction.newLocalAction((int)23, (View)this);
            this._findAction.addController(this._controller);
            this._findBtn = new ToolButton((Action)this._findAction);
            this._copyAction = IdeAction.newLocalAction((int)18, (View)this);
            this._copyAction.addController(this._controller);
            String label = HelpArb.getString(1);
            IdeAction baseAction = IdeAction.get((int)HelpSystemConstants.DECREASE_FONT_SIZE_CMD_ID, (String)"oracle.jdevimpl.help.HelpContentPanel.DecreaseFontSizeCmd", (String)StringUtils.stripMnemonic((String)label), null, (Integer)StringUtils.getMnemonicKeyCode((String)label), null, null, (boolean)true);
            IdeAction decreaseFontSizeAction = IdeAction.newLocalAction((int)HelpSystemConstants.DECREASE_FONT_SIZE_CMD_ID, (View)this);
            decreaseFontSizeAction.addController(this._controller);
            decreaseFontSizeAction.setEnabled(true);
            label = HelpArb.getString(169);
            baseAction = IdeAction.get((int)HelpSystemConstants.INCREASE_FONT_SIZE_CMD_ID, (String)"oracle.jdevimpl.help.HelpContentPanel.IncreaseFontSizeCmd", (String)StringUtils.stripMnemonic((String)label), null, (Integer)StringUtils.getMnemonicKeyCode((String)label), null, null, (boolean)true);
            IdeAction increaseFontSizeAction = IdeAction.newLocalAction((int)HelpSystemConstants.INCREASE_FONT_SIZE_CMD_ID, (View)this);
            increaseFontSizeAction.addController(this._controller);
            increaseFontSizeAction.setEnabled(true);
            this._changeFontSizeBtn = new MenuToolButton((ToggleAction)((IdeAction)null));
            this._changeFontSizeBtn.setIcon(OracleIcons.getIcon((String)"fontsize.png"));
            this._changeFontSizeBtn.setToolTipText(HelpArb.getString(81));
            this._changeFontSizeBtn.addPopupItem((ToggleAction)increaseFontSizeAction);
            this._changeFontSizeBtn.addPopupItem((ToggleAction)decreaseFontSizeAction);
            if (!this._cueCardViewer) {
                this._addFavoriteAction = IdeAction.newLocalAction((int)HelpSystemConstants.ADD_FAVORITE_CMD_ID, (View)this);
                this._addFavoriteAction.addController(this._controller);
                this._addFavoriteBtn = new ToolButton((Action)this._addFavoriteAction);
            }
            this._selectAllAction = IdeAction.newLocalAction((int)22, (View)this);
            this._selectAllAction.addController(this._controller);
            IdeAction.find((int)22).addController(this._controller);
            this._createKeyMappings();
            this._toolbar = new HelpNavigatorToolbar();
            this._toolbar.add((Component)this._backwardBtn);
            this._toolbar.add((Component)this._forwardBtn);
            this._toolbar.add((Component)this._printBtn);
            this._toolbar.add((Component)this._changeFontSizeBtn);
            if (!this._cueCardViewer) {
                this._toolbar.add((Component)this._addFavoriteBtn);
            }
            this._toolbar.add((Component)this._findBtn);
            this.installMouseListener();
            this._mainPanel.add((Component)this._toolbar, "North");
        } else {
            MyTabAction tabAction = new MyTabAction((Component)this._displayPanel);
            InputMap iMap = this._displayPanel.getInputMap(1);
            KeyStroke tabKey = KeyStroke.getKeyStroke(9, 0);
            iMap.put(tabKey, TAB_ACTION);
            ActionMap aMap = this._displayPanel.getActionMap();
            aMap.put(TAB_ACTION, tabAction);
        }
        this._mainPanel.add((Component)this._displayPanel, "Center");
    }

    private void _registerProtocolHandlers() {
        if (_protocolRegistryList.size() == 0) {
            _protocolRegistryList.add(new Pair((Object)"external", (Object)new ExternalBrowserHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevIdeSettings", (Object)new IdeSettingsHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevInvokableWizard", (Object)new InvokableWizardHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevInvokableAction", (Object)new InvokableActionHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevProjectSettings", (Object)new IdeProjectSettingsHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevLoadIntoEditor", (Object)new LoadIntoEditorHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevFileReopen", (Object)new FileReopenHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevShowTopic", (Object)new InitAndInvokeHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevShowHelpInWindow", (Object)new ShowHelpInWindowHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevShowCueCard", (Object)new CueCardHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevInvokeBrowserOnFile", (Object)new BrowserOnFileHandler(null)));
        }
        CustomProtocolRegistry cpr = new CustomProtocolRegistry(this._browser);
        int numHandlers = _protocolRegistryList.size();
        int i = 0;
        while (i < numHandlers) {
            Pair pair = (Pair)_protocolRegistryList.get(i);
            cpr.registerCustomProtocolHandler((String)pair.getFirst(), (CustomProtocolHandler)pair.getSecond());
            ++i;
        }
    }

    private void removeControllerFromAction(IdeAction action) {
        if (action != null) {
            action.removeController(this._controller);
        }
    }

    public void topicDisplayChanged(TopicDisplayEvent e) {
        if (e.getID() == 2000 && (e.getChangeType() == 0 || e.getChangeType() == 2)) {
            if (this._parent instanceof HelpTopicEditor) {
                ((HelpTopicEditor)((Object)this._parent)).getHelpTopicDocument().setURL(e.getURL());
            }
            this.updateActions();
            if (e.getChangeType() == 0) {
                this.syncTOCToURL(e.getURL());
            }
            if (JDevHelpSystemImpl.isDocWriter() && HelpSystem.getHelpSystem() instanceof JDevHelpSystemImpl) {
                JDevHelpSystemImpl hs = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
                JDevHelpSystemImpl.printTopicForDebugging(null, null, e.getURL());
            }
        }
    }

    private void updateActions() {
        3 runnable = new 3();
        SwingUtilities.invokeLater(runnable);
    }

    protected void installMouseListener() {
        JComponent comp;
        if (this._mouseListener == null) {
            this._mouseListener = new 4();
        }
        if ((comp = GraphicsUtils.getFocusableComponentOrChild((Component)this._displayPanel, (boolean)true)) != null) {
            comp.addMouseListener(this._mouseListener);
        }
    }

    protected void triggerPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            Component component = e.getComponent();
            component.requestFocus();
            ContextMenu menu = this.getContextMenu();
            if (menu == null) {
                return;
            }
            Context context = this.getContext(e);
            menu.show(context);
        }
    }

    static Object ra$_parent(HelpContentPanel helpContentPanel) {
        return helpContentPanel._parent;
    }

    static TopicDisplay ra$_topicDisplay(HelpContentPanel helpContentPanel) {
        return helpContentPanel._topicDisplay;
    }

    static SimpleTopicDisplayPanel ra$_displayPanel(HelpContentPanel helpContentPanel) {
        return helpContentPanel._displayPanel;
    }

    static JPanel ra$_mainPanel(HelpContentPanel helpContentPanel) {
        return helpContentPanel._mainPanel;
    }

    static Library ra$_library(HelpContentPanel helpContentPanel) {
        return helpContentPanel._library;
    }

    static IdeAction ra$_printAction(HelpContentPanel helpContentPanel) {
        return helpContentPanel._printAction;
    }

    static IdeAction ra$_findAction(HelpContentPanel helpContentPanel) {
        return helpContentPanel._findAction;
    }

    static IdeAction ra$_selectAllAction(HelpContentPanel helpContentPanel) {
        return helpContentPanel._selectAllAction;
    }

    static IdeAction ra$_forwardAction(HelpContentPanel helpContentPanel) {
        return helpContentPanel._forwardAction;
    }

    static IdeAction ra$_backwardAction(HelpContentPanel helpContentPanel) {
        return helpContentPanel._backwardAction;
    }

    static void mav$loadMyMap(HelpContentPanel helpContentPanel, MultiInputMap multiInputMap, ActionMap actionMap, KeyStrokeOptions keyStrokeOptions) {
        helpContentPanel.loadMyMap(multiInputMap, actionMap, keyStrokeOptions);
    }

    static void mav$_setButtonTooltips(HelpContentPanel helpContentPanel) {
        helpContentPanel._setButtonTooltips();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ViewerType
    extends Enum<ViewerType> {
        private static final /* synthetic */ ViewerType[] $v;
        public static final /* enum */ ViewerType CUE_CARD_VIEWER;
        public static final /* enum */ ViewerType ROADMAP_VIEWER;

        public static ViewerType valueOf(String string) {
            return Enum.valueOf(ViewerType.class, string);
        }

        public static final ViewerType[] values() {
            return (ViewerType[])$v.clone();
        }

        static {
            ViewerType[] viewerTypeArray = new ViewerType[2];
            viewerTypeArray[1] = ROADMAP_VIEWER = new ViewerType("ROADMAP_VIEWER", 1);
            viewerTypeArray[0] = CUE_CARD_VIEWER = new ViewerType("CUE_CARD_VIEWER", 0);
            $v = viewerTypeArray;
        }

        private ViewerType(String string2, int n2) {
        }
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ TOCNavigator v$tocNavigator;
        private final /* synthetic */ URL v$url;
        final /* synthetic */ HelpContentPanel this$0;

        public void run() {
            this.v$tocNavigator.selectMatchingTopic(this.v$url);
        }

        public 1(HelpContentPanel helpContentPanel, TOCNavigator tOCNavigator, URL uRL) {
            this.v$url = uRL;
            this.v$tocNavigator = tOCNavigator;
            this.this$0 = helpContentPanel;
        }
    }

    final class 2
    implements ChangeListener {
        private final /* synthetic */ MultiInputMap v$imap;
        private final /* synthetic */ KeyStrokeOptions v$kso;
        private final /* synthetic */ KeyStrokeContext v$ksc;
        final /* synthetic */ HelpContentPanel this$0;

        public void stateChanged(ChangeEvent e) {
            MultiMapAdapter.fillLocalMap((MultiInputMap)this.v$imap, (KeyStrokeOptions)this.v$kso, (KeyStrokeContext)this.v$ksc);
            HelpContentPanel.mav$loadMyMap(this.this$0, this.v$imap, HelpContentPanel.ra$_mainPanel(this.this$0).getActionMap(), this.v$kso);
            HelpContentPanel.mav$_setButtonTooltips(this.this$0);
        }

        public 2(HelpContentPanel helpContentPanel, MultiInputMap multiInputMap, KeyStrokeOptions keyStrokeOptions, KeyStrokeContext keyStrokeContext) {
            this.v$ksc = keyStrokeContext;
            this.v$kso = keyStrokeOptions;
            this.v$imap = multiInputMap;
            this.this$0 = helpContentPanel;
        }
    }

    final class 3
    implements Runnable {
        public void run() {
            if (HelpContentPanel.ra$_displayPanel(HelpContentPanel.this) == null) {
                return;
            }
            if (HelpContentPanel.ra$_printAction(HelpContentPanel.this) != null) {
                HelpContentPanel.ra$_printAction(HelpContentPanel.this).setEnabled(true);
            }
            if (HelpContentPanel.ra$_findAction(HelpContentPanel.this) != null) {
                HelpContentPanel.ra$_findAction(HelpContentPanel.this).setEnabled(true);
            }
            if (HelpContentPanel.ra$_selectAllAction(HelpContentPanel.this) != null) {
                HelpContentPanel.ra$_selectAllAction(HelpContentPanel.this).setEnabled(true);
            }
            if (HelpContentPanel.ra$_forwardAction(HelpContentPanel.this) != null) {
                HelpContentPanel.ra$_forwardAction(HelpContentPanel.this).setEnabled(HelpContentPanel.this.canGoForward());
            }
            if (HelpContentPanel.ra$_backwardAction(HelpContentPanel.this) != null) {
                HelpContentPanel.ra$_backwardAction(HelpContentPanel.this).setEnabled(HelpContentPanel.this.canGoBackward());
            }
        }
    }

    final class 4
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            HelpContentPanel.this.triggerPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            HelpContentPanel.this.triggerPopup(e);
        }
    }

    private class HelpTopicPanelController
    implements Controller {
        public boolean update(IdeAction action, Context context) {
            View view;
            if (context != null && ((view = context.getView()) instanceof HelpContentPanel || view instanceof HelpTopicEditor)) {
                int cmdId = action.getCommandId();
                if (cmdId == 23) {
                    action.setEnabled(true);
                    return true;
                }
                if (cmdId == 50) {
                    action.setEnabled(true);
                    return true;
                }
                if (cmdId == HelpSystemConstants.FORWARD_CMD_ID) {
                    if (HelpContentPanel.this.canGoForward()) {
                        action.setEnabled(true);
                    } else {
                        action.setEnabled(false);
                    }
                    return true;
                }
                if (cmdId == HelpSystemConstants.BACKWARD_CMD_ID) {
                    if (HelpContentPanel.this.canGoBackward()) {
                        action.setEnabled(true);
                    } else {
                        action.setEnabled(false);
                    }
                    return true;
                }
                if (cmdId == 16) {
                    action.setEnabled(true);
                    return true;
                }
                if (cmdId == 18) {
                    action.setEnabled(HelpContentPanel.this.isTextSelected());
                    return true;
                }
                if (cmdId == HelpSystemConstants.ADD_FAVORITE_CMD_ID) {
                    action.setEnabled(true);
                    return true;
                }
                if (cmdId == 22) {
                    action.setEnabled(true);
                    return true;
                }
                if (cmdId == HelpSystemConstants.INCREASE_FONT_SIZE_CMD_ID || cmdId == HelpSystemConstants.DECREASE_FONT_SIZE_CMD_ID) {
                    action.setEnabled(true);
                    return true;
                }
                action.setEnabled(false);
            }
            return false;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (!(context.getView() instanceof HelpContentPanel || context.getView() instanceof HelpTopicEditor || context.getView() instanceof HelpWindow)) {
                return false;
            }
            if (cmdId == HelpSystemConstants.FORWARD_CMD_ID) {
                HelpContentPanel.this.goForward();
                return true;
            }
            if (cmdId == HelpSystemConstants.BACKWARD_CMD_ID) {
                HelpContentPanel.this.goBackward();
                return true;
            }
            if (cmdId == 23) {
                HelpContentPanel.this.runFindDialog();
                return true;
            }
            if (cmdId == 18) {
                HelpContentPanel.this.copy();
                return true;
            }
            if (cmdId == HelpSystemConstants.ADD_FAVORITE_CMD_ID) {
                HelpSystem helpSys = HelpSystem.getHelpSystem();
                if (helpSys != null && helpSys instanceof JDevHelpSystemImpl) {
                    FavoritesModel favoritesModel = ((JDevHelpSystemImpl)helpSys).getFavoritesModel();
                    if (favoritesModel != null) {
                        Object parent = null;
                        if (HelpContentPanel.ra$_parent(HelpContentPanel.this) != null && HelpContentPanel.ra$_parent(HelpContentPanel.this) instanceof HelpTopicEditor) {
                            HelpTopicEditor hte = (HelpTopicEditor)((Object)HelpContentPanel.ra$_parent(HelpContentPanel.this));
                            parent = hte.getParent() != null && hte.getParent() instanceof HelpCenterWindow ? HelpCenterWindow.getInstance().getWindow() : Ide.getMainWindow();
                        }
                        String urlString = HelpContentPanel.ra$_topicDisplay(HelpContentPanel.this).getCurrentURL().toString();
                        String topicTitle = HelpContentPanel.ra$_topicDisplay(HelpContentPanel.this).getCurrentPageTitle();
                        HelpUtils.addFavoriteItem(favoritesModel, topicTitle, urlString, (Window)parent);
                    } else {
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), HelpArb.getString(145), HelpArb.getString(111), 0);
                    }
                }
                return true;
            }
            if (cmdId == 22) {
                HelpContentPanel hcp = null;
                hcp = context.getView() instanceof HelpTopicEditor ? ((HelpTopicEditor)context.getView()).getHelpContentPanel() : (HelpContentPanel)context.getView();
                hcp.getBrowser().selectAll();
                return true;
            }
            if (cmdId == 4 && action.isLocalAction()) {
                HelpContentPanel hcp = (HelpContentPanel)context.getView();
                Object parent = hcp.getParent();
                Window window = null;
                if (parent instanceof JDialog) {
                    window = (Window)parent;
                } else if (parent instanceof HelpTopicEditor && ((HelpTopicEditor)((Object)parent)).getParent() instanceof HelpContentWindow) {
                    window = (Window)((HelpTopicEditor)((Object)parent)).getParent();
                }
                window.setVisible(false);
                window.dispose();
                return true;
            }
            if (cmdId == HelpSystemConstants.INCREASE_FONT_SIZE_CMD_ID) {
                if (HelpContentPanel.ra$_displayPanel(HelpContentPanel.this) != null) {
                    HelpContentPanel.ra$_displayPanel(HelpContentPanel.this).increaseFontSize();
                }
                return true;
            }
            if (cmdId == HelpSystemConstants.DECREASE_FONT_SIZE_CMD_ID) {
                if (HelpContentPanel.ra$_displayPanel(HelpContentPanel.this) != null) {
                    HelpContentPanel.ra$_displayPanel(HelpContentPanel.this).decreaseFontSize();
                }
                return true;
            }
            if (cmdId == 50) {
                int yPos;
                int xPos;
                JPanel comp = HelpContentPanel.ra$_mainPanel(HelpContentPanel.this);
                Container parent = comp.getParent();
                if (comp.getParent() instanceof JViewport) {
                    JViewport viewport = (JViewport)parent;
                    Point ptViewPosition = viewport.getViewPosition();
                    xPos = ptViewPosition.x;
                    yPos = ptViewPosition.y;
                } else {
                    xPos = ((Component)comp).getX();
                    yPos = ((Component)comp).getY();
                }
                MouseEvent event = new MouseEvent(comp, 502, System.currentTimeMillis(), 0, xPos, yPos, 1, true);
                Context cmContext = HelpContentPanel.this.getContext(event);
                cmContext.setEvent((EventObject)event);
                ContextMenu cm = HelpContentPanel.this.getContextMenu();
                cm.show(cmContext);
                return true;
            }
            return false;
        }

        private HelpTopicPanelController() {
        }

        HelpTopicPanelController(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class ExternalBrowserHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "external";

        public void handleValue(String value) {
            try {
                BrowserRunner.getBrowserRunner().runBrowserOnURL(new URL(value), null, null);
            }
            catch (Exception ex) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ex, (String)HelpArb.format(33, value));
            }
        }

        private ExternalBrowserHandler() {
        }

        ExternalBrowserHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class IdeSettingsHandler
    extends AbstractCustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevIdeSettings";

        public void handleValue(String value) {
            if (value.equals("main")) {
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow());
            } else {
                String[] selectionPath = this.parseString(value);
                if (selectionPath != null) {
                    Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), selectionPath);
                } else {
                    Ide.getSettings().showDialog((Frame)Ide.getMainWindow());
                }
            }
        }

        private String[] parseString(String value) {
            List stringList = super.parseInputString(value);
            return super.parseTranslatableTextList(stringList);
        }

        private IdeSettingsHandler() {
        }

        IdeSettingsHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class IdeProjectSettingsHandler
    extends AbstractCustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevProjectSettings";

        public void handleValue(String value) {
            Context context = null;
            Project project = null;
            if (Ide.getLastActiveNavigator() != null) {
                context = Ide.getLastActiveNavigator().getContext();
                project = context.getProject();
            }
            if (project == null) {
                project = Ide.getActiveProject();
            }
            if (project == null) {
                return;
            }
            if (value.equals("main")) {
                ProjectPropertiesDialog.showDialog((Context)context, (Project)project);
            } else {
                String[] selectionPath = this.parseString(value);
                if (selectionPath != null) {
                    ProjectPropertiesDialog.showDialog((Context)context, (Frame)Ide.getMainWindow(), (Project)project, (String[])selectionPath);
                } else {
                    ProjectPropertiesDialog.showDialog((Context)context, (Project)project);
                }
            }
        }

        private String[] parseString(String value) {
            List stringList = super.parseInputString(value);
            return super.parseTranslatableTextList(stringList);
        }

        private IdeProjectSettingsHandler() {
        }

        IdeProjectSettingsHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class InvokableWizardHandler
    extends AbstractCustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevInvokableWizard";
        public static final String[] wizardsRequiringWorkspace = new String[]{"oracle.jdevimpl.wizard.project.NewApplicationProjectWizard", "oracle.jdevimpl.wizard.project.NewEmptyProjectWizard"};
        public static final String[] wizardsRequiringProject = new String[]{"oracle.jdeveloper.builder.cls.ClassBuilder", "oracle.jdeveloper.builder.ui.dialog.DialogBuilder", "oracle.jdeveloper.builder.iface.InterfaceBuilder", "oracle.jdeveloper.builder.application.ApplicationBuilder", "oracle.jdevimpl.webapp.jsp.wizards.JspWizard", "oracle.jbo.dt.jdevx.ui.JdxPKEntityAddin", "oracle.jdevimpl.webapp.jsp.taglibraries.jsf.JsfJspWizard", "oracle.jdevimpl.ejb.ejbwiz.NewSessionEjbWizard", "oracle.jdeveloper.offlinedb.wizard.ImportWizard", "oracle.toplink.addin.wizard.jobgeneration.JobWizard", "oracle.jdevimpl.ejb.ejbwiz.NewEjbWizard", "oracle.toplink.addin.wizard.mapcreation.TopLinkCMPMapWizard", "oracle.jdeveloper.dbmodeler.diagram.DBModelWizard", "oracle.jdeveloper.ejb.modeler.diagram.EJBModelWizard", "oracle.jdevimpl.ejb.ejbwiz.NewEjbEntityWizard"};

        public void handleValue(String value) {
            String requirementString;
            List list = super.parseInputString(value);
            String wizardClassStr = (String)list.remove(0);
            boolean needsWorkspace = false;
            boolean needsProject = false;
            if (list.size() > 0 && (requirementString = (String)list.get(0)) != null && (requirementString = requirementString.toLowerCase()).startsWith("requires=")) {
                list.remove(0);
                if (requirementString.indexOf("workspace") != -1) {
                    needsWorkspace = true;
                } else if (requirementString.indexOf("project") != -1) {
                    needsProject = true;
                }
            }
            int numStrings = list.size();
            String[] params = new String[numStrings];
            int i = 0;
            while (i < numStrings) {
                params[i] = (String)list.get(i);
                ++i;
            }
            if (!needsWorkspace) {
                int i2 = 0;
                while (i2 < wizardsRequiringWorkspace.length) {
                    if (wizardClassStr.equals(wizardsRequiringWorkspace[i2])) {
                        needsWorkspace = true;
                        break;
                    }
                    ++i2;
                }
            }
            if (!needsProject) {
                int i3 = 0;
                while (i3 < wizardsRequiringProject.length) {
                    if (wizardClassStr.equals(wizardsRequiringProject[i3])) {
                        needsProject = true;
                        break;
                    }
                    ++i3;
                }
            }
            Context context = null;
            if (Ide.getLastActiveNavigator() != null) {
                context = Ide.getLastActiveNavigator().getContext();
            } else {
                context = Context.newIdeContext();
                context.setWorkspace(Ide.getActiveWorkspace());
                context.setProject(Ide.getActiveProject());
            }
            if (needsWorkspace && context.getWorkspace() == null) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), HelpArb.getString(40), HelpArb.getString(48), 0);
                return;
            }
            if (needsProject && context.getProject() == null) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), HelpArb.getString(39), HelpArb.getString(48), 0);
                return;
            }
            WizardManager wizMgr = WizardManager.getInstance();
            Wizard wizard = wizMgr.getWizard(wizardClassStr);
            if (wizard != null) {
                if (!wizMgr.invokeWizard(wizard, context, params, null)) {
                    // empty if block
                }
            } else {
                try {
                    Class<?> clazz = Class.forName(wizardClassStr);
                    if (ExportWizard.class.isAssignableFrom(clazz)) {
                        ExportWizard expWiz = (ExportWizard)clazz.newInstance();
                        if (expWiz.isAvailableAsExportWizard(context)) {
                            expWiz.invokeExportWizard(context, params);
                        }
                    } else if (ImportWizard.class.isAssignableFrom(clazz)) {
                        ImportWizard impWiz = (ImportWizard)clazz.newInstance();
                        if (impWiz.isAvailableAsImportWizard(context)) {
                            impWiz.invokeImportWizard(context, params);
                        }
                    } else {
                        String[] galleryItemNames = super.parseTranslatableTextList(list);
                        if (galleryItemNames != null && galleryItemNames.length > 0) {
                            Wizard wiz;
                            GalleryManager gm = GalleryManager.getGalleryManager();
                            ObjectGallery gallery = gm.getGallery();
                            gallery.loadGalleryData();
                            GalleryFolder gFolder = gallery.getModel();
                            GalleryElement gElement = gFolder.getGalleryElement(galleryItemNames[0]);
                            if (gElement != null && (wiz = gElement.getWizard()) != null) {
                                wiz.invoke(context);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        private InvokableWizardHandler() {
        }

        InvokableWizardHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class InvokableActionHandler
    extends AbstractCustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevInvokableAction";

        public void handleValue(String value) {
            List list = super.parseInputString(value);
            String ideActionName = (String)list.remove(0);
            int numStrings = list.size();
            String[] params = new String[numStrings];
            int i = 1;
            while (i < numStrings) {
                params[i] = (String)list.get(i);
                ++i;
            }
            Context context = null;
            if (Ide.getLastActiveNavigator() != null) {
                context = Ide.getLastActiveNavigator().getContext();
            } else {
                context = Context.newIdeContext();
                context.setWorkspace(Ide.getActiveWorkspace());
                context.setProject(Ide.getActiveProject());
            }
            Integer cmdId = Ide.findCmdID((String)ideActionName);
            if (cmdId == null) {
                try {
                    Field field;
                    Object fieldObj;
                    int lastDotPosition = ideActionName.lastIndexOf(46);
                    String classString = ideActionName.substring(0, lastDotPosition);
                    String token = ideActionName.substring(lastDotPosition + 1);
                    Class<?> clzz = Class.forName(classString);
                    if (clzz != null && (fieldObj = (field = clzz.getField(token)).get(null)) != null && fieldObj instanceof Integer) {
                        cmdId = (Integer)fieldObj;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            if (cmdId != null) {
                IdeAction action = IdeAction.find((int)cmdId);
                action.updateAction(context);
                if (action != null && action.isEnabled()) {
                    try {
                        action.performAction(context);
                    }
                    catch (Exception e) {
                        Assert.printStackTrace((Throwable)e);
                    }
                }
            } else {
                Assert.println((String)("Cannot find IdeAction for : " + ideActionName));
            }
        }

        private InvokableActionHandler() {
        }

        InvokableActionHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private final class LoadIntoEditorHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevLoadIntoEditor";

        public void handleValue(String value) {
            EditorManager editorMgr;
            URL url;
            if (HelpContentPanel.ra$_library(HelpContentPanel.this) != null && (url = HelpContentPanel.ra$_library(HelpContentPanel.this).mapIDToURL(value)) != null && (editorMgr = EditorManager.getEditorManager()) != null) {
                editorMgr.openDefaultEditorInFrame(url);
            }
        }

        private LoadIntoEditorHandler() {
        }

        LoadIntoEditorHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class InitAndInvokeHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevShowTopic";

        public void handleValue(String value) {
            JDevHelpSystemImpl helpSysImpl;
            Library library;
            HelpSystem helpSys = HelpSystem.getHelpSystem();
            if (helpSys != null && helpSys instanceof JDevHelpSystemImpl && (library = (helpSysImpl = (JDevHelpSystemImpl)helpSys).getLibrary()) != null) {
                helpSysImpl.goTo(value);
            }
        }

        private InitAndInvokeHandler() {
        }

        InitAndInvokeHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class ShowHelpInWindowHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevShowHelpInWindow";

        public void handleValue(String value) {
            HelpSystem helpSys = HelpSystem.getHelpSystem();
            if (helpSys != null && helpSys instanceof JDevHelpSystemImpl) {
                JDevHelpSystemImpl helpSysImpl = (JDevHelpSystemImpl)helpSys;
                Library library = helpSysImpl.getLibrary();
                Topic topic = helpSysImpl.getTopicForString(value);
                if (topic != null && library != null) {
                    Context ctx = HelpUtils.createContext(topic);
                    HelpUtils.createHelpTopicEditor(ctx, topic);
                }
            }
        }

        private ShowHelpInWindowHandler() {
        }

        ShowHelpInWindowHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class FileReopenHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevFileReopen";

        public void handleValue(String value) {
            FileOpenHistory fileOpenHistory = FileOpenHistory.getInstance();
            String[] openedFiles = fileOpenHistory.getFileHistory();
            URLDisplayWrapper selectedFile = null;
            if (openedFiles == null) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), HelpArb.getString(86), HelpArb.getString(110), 1);
            } else {
                Object[] urls = new URLDisplayWrapper[openedFiles.length];
                int i = 0;
                while (i < openedFiles.length) {
                    URLDisplayWrapper urlDisplay = new URLDisplayWrapper(URL2String.toURL((String)openedFiles[i]));
                    urls[i] = urlDisplay;
                    ++i;
                }
                selectedFile = (URLDisplayWrapper)JOptionPane.showInputDialog((Component)Ide.getMainWindow(), HelpArb.getString(110), HelpArb.getString(148), 3, null, urls, urls[0]);
                if (selectedFile != null) {
                    URL selectedURL = selectedFile.getURL();
                    IdeAction action = FileOpenHistory.getNewReopenAction((URL)selectedURL);
                    1 runnable = new 1(this, action);
                    IdeUtil.invokeAfterRepaint((Runnable)runnable);
                }
            }
        }

        private FileReopenHandler() {
        }

        FileReopenHandler(1 var2_2) {
            this();
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ IdeAction v$action;
            final /* synthetic */ FileReopenHandler this$0;

            public void run() {
                try {
                    this.v$action.performAction();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public 1(FileReopenHandler fileReopenHandler, IdeAction ideAction) {
                this.v$action = ideAction;
                this.this$0 = fileReopenHandler;
            }
        }
    }

    private final class CueCardHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevShowCueCard";

        public void handleValue(String value) {
            JDevHelpSystemImpl helpSysImpl;
            Library library;
            HelpSystem helpSys = HelpSystem.getHelpSystem();
            if (helpSys != null && helpSys instanceof JDevHelpSystemImpl && (library = (helpSysImpl = (JDevHelpSystemImpl)helpSys).getLibrary()) != null) {
                HelpCenterWindow hcw = HelpCenterWindow.getInstance();
                hcw.showCueCardSetForId(value);
            }
        }

        private CueCardHandler() {
        }

        CueCardHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class BrowserOnFileHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevInvokeBrowserOnFile";

        public void handleValue(String value) {
            try {
                File ideHome = new File(Ide.getProductHomeDirectory());
                File file = new File(ideHome, value);
                URL fileURL = URLFactory.newFileURL((File)file);
                BrowserRunner.getBrowserRunner().runBrowserOnURL(fileURL, null, null);
            }
            catch (Exception ex) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ex, (String)HelpArb.format(33, value));
            }
        }

        private BrowserOnFileHandler() {
        }

        BrowserOnFileHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class URLDisplayWrapper {
        private URL _url;

        public URLDisplayWrapper(URL url) {
            this._url = url;
        }

        public URL getURL() {
            return this._url;
        }

        public String toString() {
            return URLFileSystem.getPlatformPathName((URL)this._url);
        }
    }

    private static class MyTabAction
    extends AbstractAction {
        private Component _displayPanel;

        public MyTabAction(Component displayPanel) {
            this._displayPanel = displayPanel;
        }

        public void actionPerformed(ActionEvent e) {
            KeyboardFocusManager kfm;
            Window window;
            boolean docPanelHasFocus = GraphicsUtils.isAncestorOfFocusedComponent((Component)this._displayPanel);
            if (docPanelHasFocus && (window = (kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager()).getActiveWindow()) instanceof JDevHelpSystemImpl.TipOfDayDialog) {
                JDevHelpSystemImpl.TipOfDayDialog tipDialog = (JDevHelpSystemImpl.TipOfDayDialog)((Object)window);
                JCheckBox cbox = tipDialog.getCheckBox();
                cbox.requestFocusInWindow();
            }
        }
    }
}

