/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockableListener;
import oracle.ide.model.Node;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpTopicDocument;
import oracle.jdevimpl.help.HelpTopicEditor;

public final class HelpContentWindow
extends JFrame
implements Controller,
ViewListener,
WindowFocusListener {
    private String _windowTitle;
    private HelpTopicEditor _helpTopicEditor;
    private DockableListener _dockableListener;
    private Context _context;
    private Controller _controller;
    static final String NODE_NAME = "HelpWindow";
    private static final String XPOS = "xpos";
    private static final String YPOS = "ypos";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String URL = "url";

    private void $init$() {
        this._windowTitle = HelpArb.getString(166);
    }

    public HelpContentWindow() {
        this.$init$();
        this._controller = this;
        this._helpTopicEditor = new HelpTopicEditor();
        this._helpTopicEditor.setParent(this);
        this.initialize();
        this.addWindowFocusListener(this);
    }

    public HelpContentWindow(Context context) {
        this();
        this._context = context;
        this._helpTopicEditor.setContext(context);
        this._helpTopicEditor.open();
    }

    protected JRootPane createRootPane() {
        HelpContentWindow win = this;
        1 actionListener = new 1();
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    public void activate() {
        if (this._helpTopicEditor != null) {
            this._helpTopicEditor.activate();
        }
    }

    public Component getGUI() {
        return this._helpTopicEditor.getGUI();
    }

    protected WindowListener getWindowListener() {
        return new 2();
    }

    protected void initGeometry() {
        this.setBounds(new Rectangle(0, 0, 400, 500));
        this.setLocationRelativeTo(null);
    }

    public HelpTopicEditor getHelpTopicEditor() {
        return this._helpTopicEditor;
    }

    public void close() {
        this.dispose();
    }

    public void dispose() {
        if (this._helpTopicEditor != null) {
            this._helpTopicEditor.close();
            this._helpTopicEditor = null;
        }
    }

    public void saveLayout(DefaultStructuredPropertyAccess topNode) {
        DefaultStructuredPropertyAccess windowNode = new DefaultStructuredPropertyAccess(NODE_NAME);
        windowNode.setProperty(XPOS, Integer.toString(this.getX()));
        windowNode.setProperty(YPOS, Integer.toString(this.getY()));
        windowNode.setProperty(WIDTH, Integer.toString(this.getWidth()));
        windowNode.setProperty(HEIGHT, Integer.toString(this.getHeight()));
        windowNode.setProperty(URL, this.getHelpTopicEditor().getHelpTopicDocument().getURL().toString());
        topNode.appendChild((StructuredPropertyAccess)windowNode);
    }

    public static void loadLayout(DefaultStructuredPropertyAccess windowNode) {
        String urlString = windowNode.getProperty(URL, "");
        if (urlString.length() > 0) {
            if (urlString.endsWith(".helpT")) {
                urlString = urlString.substring(0, urlString.length() - ".helpT".length());
            } else if (urlString.endsWith(".help")) {
                urlString = urlString.substring(0, urlString.length() - ".help".length());
            }
            SimpleURLTarget theTarget = new SimpleURLTarget(null, urlString);
            SimpleTopic theTopic = new SimpleTopic(null, (Target)theTarget);
            HelpTopicDocument htd = null;
            try {
                htd = new HelpTopicDocument((Topic)theTopic);
            }
            catch (Exception e) {
                return;
            }
            Context ctx = Context.newIdeContext((Node)htd);
            ctx.setWorkspace(null);
            ctx.setProject(null);
            HelpContentWindow helpContentWindow = new HelpContentWindow(ctx);
            int x = Integer.parseInt(windowNode.getProperty(XPOS, "0"));
            int y = Integer.parseInt(windowNode.getProperty(YPOS, "0"));
            int width = Integer.parseInt(windowNode.getProperty(WIDTH, "0"));
            int height = Integer.parseInt(windowNode.getProperty(HEIGHT, "0"));
            helpContentWindow.setBounds(x, y, width, height);
            3 r = new 3(helpContentWindow, theTopic);
            SwingUtilities.invokeLater(r);
        }
    }

    public Controller getController() {
        return this;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == 23) {
            this._helpTopicEditor.getHelpContentPanel().runFindDialog();
            return true;
        }
        if (cmdId == 16) {
            return this._helpTopicEditor.getController().handleEvent(action, context);
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (action == null) {
            return false;
        }
        int cmdId = action.getCommandId();
        if (cmdId == 16) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == 23) {
            action.setEnabled(true);
            return true;
        }
        return false;
    }

    public void viewActivated(ViewEvent e) {
        this._helpTopicEditor.activate();
    }

    public void viewDeactivated(ViewEvent e) {
    }

    public void viewClosed(ViewEvent e) {
        this.close();
    }

    public void windowLostFocus(WindowEvent e) {
    }

    public void windowGainedFocus(WindowEvent e) {
        this.activate();
    }

    private void initialize() {
        this.setTitle(HelpArb.getString(121));
        this.setIconImage(HelpArb.getImage(61));
        this.addWindowListener(this.getWindowListener());
        this.initGeometry();
        this.getContentPane().add(this._helpTopicEditor.getGUI(), "Center");
        this.setVisible(true);
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            HelpContentWindow.this.setVisible(false);
            HelpContentWindow.this.dispose();
        }
    }

    final class 2
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            HelpContentWindow.this.close();
        }
    }

    static final class 3
    implements Runnable {
        private final /* synthetic */ HelpContentWindow v$helpContentWindow;
        private final /* synthetic */ SimpleTopic v$theTopic;

        public void run() {
            this.v$helpContentWindow.getGUI().requestFocus();
            this.v$helpContentWindow.activate();
            this.v$helpContentWindow.getHelpTopicEditor().displayTopic((Topic)this.v$theTopic);
        }

        public 3(HelpContentWindow helpContentWindow, SimpleTopic simpleTopic) {
            this.v$theTopic = simpleTopic;
            this.v$helpContentWindow = helpContentWindow;
        }
    }
}

