/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.net.VirtualFileSystem;
import oracle.ide.IdeHook;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFactory;
import oracle.javatools.util.Pair;

public final class HelpHook
extends IdeHook {
    public static final ElementName ELEMENT = HelpHook.element((String)"help");
    private static final ElementName ITEM = HelpHook.element((String)"item");
    private static final ElementName HELP_NAME = HelpHook.element((String)"helpName");
    private static final ElementName HELP_ACTION = HelpHook.element((String)"helpAction");
    private static final ElementName HELP_URL = HelpHook.element((String)"helpURL");
    private static final ElementName RELATIVE_TO = HelpHook.element((String)"relativeTo");
    private static final ElementName RELATIVE_POSITION = HelpHook.element((String)"relativePosition");
    private static final ElementName TIP_OF_DAY_URL = HelpHook.element((String)"tipOfDayURL");
    private static final ElementName BROWSESYMBOL_RESOLVER = HelpHook.element((String)"browseSymbolResolver-class");
    private static final ElementName BOOK = HelpHook.element((String)"book");
    private static final ElementName BOOK_TITLE = HelpHook.element((String)"title");
    private static final ElementName BOOK_LABEL = HelpHook.element((String)"viewLabel");
    private static final String KEY_HELP_ITEM = "help-item";
    private static final String KEY_BOOK_PAIR = "book-pair";
    private static final String BEFORE = "before";
    private static final String REMOVE_ACTION = "remove";
    private final List _helpEntries;
    private final List _tipEntries;
    private final List _browseSymbolResolverEntries;
    private final ElementVisitor _item;
    private final ElementVisitor _helpName;
    private final ElementVisitor _helpAction;
    private final ElementVisitor _helpURL;
    private final ElementVisitor _relativeTo;
    private final ElementVisitor _relativePosition;
    private final ElementVisitor _tipOfDayURL;
    private final ElementVisitor _browseSymbolResolver;
    private final ElementVisitor _book;
    private final ElementVisitor _bookTitle;
    private final ElementVisitor _bookLabel;

    private void $init$() {
        this._helpEntries = new ArrayList();
        this._tipEntries = new ArrayList();
        this._browseSymbolResolverEntries = new ArrayList();
        this._item = new ItemHandler(null);
        this._helpName = new HelpNameHandler(null);
        this._helpAction = new HelpActionHandler(null);
        this._helpURL = new HelpURLHandler(null);
        this._relativeTo = new RelativeToHandler(null);
        this._relativePosition = new RelativePositionHandler(null);
        this._tipOfDayURL = new TipOfDayURLHandler(null);
        this._browseSymbolResolver = new BrowseSymbolResolverHandler(null);
        this._book = new BookHandler(null);
        this._bookTitle = new BookTitleHandler(null);
        this._bookLabel = new BookLabelHandler(null);
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(ITEM, this._item);
    }

    private static String[] splitJarPath(String path) {
        String[] parts = new String[2];
        int jarBangPos = path.toLowerCase().indexOf(".jar!");
        if (jarBangPos == -1) {
            parts[0] = path;
            parts[1] = null;
        } else {
            parts[0] = path.substring(0, jarBangPos + 4);
            parts[1] = path.substring(jarBangPos + 6);
        }
        return parts;
    }

    private URL getHelpURL(ElementContext context, String value) {
        try {
            String[] parts = HelpHook.splitJarPath(value);
            URI absURI = this.resolvePath(context, parts[0]);
            URL absURL = VirtualFileSystem.getVirtualFileSystem().toURL(absURI);
            if (parts[1] == null) {
                URL uRL = absURL;
                return uRL;
            }
            URL uRL = URLFactory.newJarURL((URL)absURL, (String)parts[1]);
            return uRL;
        }
        catch (MalformedURLException mfe) {
            mfe.printStackTrace();
            URL uRL = null;
            return uRL;
        }
    }

    private HelpObject getHelp(ElementContext context) {
        return (HelpObject)context.getScopeData().get(KEY_HELP_ITEM);
    }

    private Pair getBookPair(ElementContext context) {
        return (Pair)context.getScopeData().get(KEY_BOOK_PAIR);
    }

    void registerHelpSetJars(HelpSystem helpSystem) {
        for (HelpObject help : this._helpEntries) {
            helpSystem.registerHelpSetURL(help.getHelpName(), help.getHelpAction(), help.getHelpURL(), help.getRelativeTo(), help.getRelativePosition(), help.getBookMap());
        }
        this._helpEntries.clear();
    }

    void registerHelpTipJars(HelpSystem helpSystem) {
        for (URL tipURL : this._tipEntries) {
            helpSystem.registerTipOfDayURL(tipURL);
        }
        this._tipEntries.clear();
    }

    void registerBrowseSymbolResolvers(List list) {
        list.addAll(this._browseSymbolResolverEntries);
        this._browseSymbolResolverEntries.clear();
    }

    public HelpHook() {
        this.$init$();
    }

    static List ra$_helpEntries(HelpHook helpHook) {
        return helpHook._helpEntries;
    }

    static HelpObject mav$getHelp(HelpHook helpHook, ElementContext elementContext) {
        return helpHook.getHelp(elementContext);
    }

    static ElementName ra$HELP_NAME() {
        return HELP_NAME;
    }

    static ElementVisitor ra$_helpName(HelpHook helpHook) {
        return helpHook._helpName;
    }

    static ElementName ra$HELP_ACTION() {
        return HELP_ACTION;
    }

    static ElementVisitor ra$_helpAction(HelpHook helpHook) {
        return helpHook._helpAction;
    }

    static ElementName ra$HELP_URL() {
        return HELP_URL;
    }

    static ElementVisitor ra$_helpURL(HelpHook helpHook) {
        return helpHook._helpURL;
    }

    static ElementName ra$RELATIVE_TO() {
        return RELATIVE_TO;
    }

    static ElementVisitor ra$_relativeTo(HelpHook helpHook) {
        return helpHook._relativeTo;
    }

    static ElementName ra$RELATIVE_POSITION() {
        return RELATIVE_POSITION;
    }

    static ElementVisitor ra$_relativePosition(HelpHook helpHook) {
        return helpHook._relativePosition;
    }

    static ElementName ra$TIP_OF_DAY_URL() {
        return TIP_OF_DAY_URL;
    }

    static ElementVisitor ra$_tipOfDayURL(HelpHook helpHook) {
        return helpHook._tipOfDayURL;
    }

    static ElementName ra$BROWSESYMBOL_RESOLVER() {
        return BROWSESYMBOL_RESOLVER;
    }

    static ElementVisitor ra$_browseSymbolResolver(HelpHook helpHook) {
        return helpHook._browseSymbolResolver;
    }

    static ElementName ra$BOOK() {
        return BOOK;
    }

    static ElementVisitor ra$_book(HelpHook helpHook) {
        return helpHook._book;
    }

    static Pair mav$getBookPair(HelpHook helpHook, ElementContext elementContext) {
        return helpHook.getBookPair(elementContext);
    }

    static ElementName ra$BOOK_TITLE() {
        return BOOK_TITLE;
    }

    static ElementVisitor ra$_bookTitle(HelpHook helpHook) {
        return helpHook._bookTitle;
    }

    static ElementName ra$BOOK_LABEL() {
        return BOOK_LABEL;
    }

    static ElementVisitor ra$_bookLabel(HelpHook helpHook) {
        return helpHook._bookLabel;
    }

    static URL mav$getHelpURL(HelpHook helpHook, ElementContext elementContext, String string) {
        return helpHook.getHelpURL(elementContext, string);
    }

    static URI mav$resolvePath(HelpHook helpHook, ElementContext elementContext, String string) {
        return helpHook.resolvePath(elementContext, string);
    }

    static List ra$_tipEntries(HelpHook helpHook) {
        return helpHook._tipEntries;
    }

    static List ra$_browseSymbolResolverEntries(HelpHook helpHook) {
        return helpHook._browseSymbolResolverEntries;
    }

    private final class ItemHandler
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            context.getScopeData().put(HelpHook.KEY_HELP_ITEM, new HelpObject(null));
            context.registerChildVisitor(HelpHook.ra$HELP_NAME(), HelpHook.ra$_helpName(HelpHook.this));
            context.registerChildVisitor(HelpHook.ra$HELP_ACTION(), HelpHook.ra$_helpAction(HelpHook.this));
            context.registerChildVisitor(HelpHook.ra$HELP_URL(), HelpHook.ra$_helpURL(HelpHook.this));
            context.registerChildVisitor(HelpHook.ra$RELATIVE_TO(), HelpHook.ra$_relativeTo(HelpHook.this));
            context.registerChildVisitor(HelpHook.ra$RELATIVE_POSITION(), HelpHook.ra$_relativePosition(HelpHook.this));
            context.registerChildVisitor(HelpHook.ra$TIP_OF_DAY_URL(), HelpHook.ra$_tipOfDayURL(HelpHook.this));
            context.registerChildVisitor(HelpHook.ra$BROWSESYMBOL_RESOLVER(), HelpHook.ra$_browseSymbolResolver(HelpHook.this));
            context.registerChildVisitor(HelpHook.ra$BOOK(), HelpHook.ra$_book(HelpHook.this));
        }

        public void end(ElementEndContext context) {
            HelpHook.ra$_helpEntries(HelpHook.this).add(HelpHook.mav$getHelp(HelpHook.this, (ElementContext)context));
        }

        private ItemHandler() {
        }

        ItemHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class BookHandler
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            context.getScopeData().put(HelpHook.KEY_BOOK_PAIR, new Pair());
            context.registerChildVisitor(HelpHook.ra$BOOK_TITLE(), HelpHook.ra$_bookTitle(HelpHook.this));
            context.registerChildVisitor(HelpHook.ra$BOOK_LABEL(), HelpHook.ra$_bookLabel(HelpHook.this));
        }

        public void end(ElementEndContext context) {
            Pair bookPair = HelpHook.mav$getBookPair(HelpHook.this, (ElementContext)context);
            HelpObject helpObject = HelpHook.mav$getHelp(HelpHook.this, (ElementContext)context);
            helpObject.addBookPair((String)bookPair.getFirst(), (String)bookPair.getSecond());
        }

        private BookHandler() {
        }

        BookHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class HelpNameHandler
    extends ElementVisitor {
        public void end(ElementEndContext context) {
            HelpHook.mav$getHelp(HelpHook.this, (ElementContext)context).setHelpName(context.getText().trim());
        }

        private HelpNameHandler() {
        }

        HelpNameHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class HelpActionHandler
    extends ElementVisitor {
        public void end(ElementEndContext context) {
            HelpHook.mav$getHelp(HelpHook.this, (ElementContext)context).setHelpAction(context.getText().trim());
        }

        private HelpActionHandler() {
        }

        HelpActionHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class HelpURLHandler
    extends ElementVisitor {
        public final void end(ElementEndContext context) {
            String value = context.getText().trim();
            URL url = HelpHook.mav$getHelpURL(HelpHook.this, (ElementContext)context, value);
            if (url == null) {
                this.log((ElementContext)context, Level.SEVERE, "Unable to use help url " + value);
            } else {
                this.url((ElementContext)context, url);
            }
        }

        protected void url(ElementContext context, URL url) {
            HelpHook.mav$getHelp(HelpHook.this, context).setHelpURL(url);
        }

        private HelpURLHandler() {
        }

        HelpURLHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class RelativeToHandler
    extends ElementVisitor {
        public void end(ElementEndContext context) {
            HelpHook.mav$getHelp(HelpHook.this, (ElementContext)context).setRelativeTo(context.getText().trim());
        }

        private RelativeToHandler() {
        }

        RelativeToHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class RelativePositionHandler
    extends ElementVisitor {
        public void end(ElementEndContext context) {
            HelpHook.mav$getHelp(HelpHook.this, (ElementContext)context).setRelativePosition(context.getText().trim());
        }

        private RelativePositionHandler() {
        }

        RelativePositionHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class TipOfDayURLHandler
    extends ElementVisitor {
        public void end(ElementEndContext context) {
            String value = context.getText();
            URI absURI = HelpHook.mav$resolvePath(HelpHook.this, (ElementContext)context, value);
            try {
                URL absURL = VirtualFileSystem.getVirtualFileSystem().toURL(absURI);
                HelpHook.ra$_tipEntries(HelpHook.this).add(absURL);
            }
            catch (MalformedURLException mfe) {
                mfe.printStackTrace();
            }
        }

        private TipOfDayURLHandler() {
        }

        TipOfDayURLHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class BookTitleHandler
    extends ElementVisitor {
        public final void end(ElementEndContext context) {
            String value = context.getText().trim();
            Pair bookPair = HelpHook.mav$getBookPair(HelpHook.this, (ElementContext)context);
            bookPair.setFirst((Object)value);
        }

        private BookTitleHandler() {
        }

        BookTitleHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class BookLabelHandler
    extends ElementVisitor {
        public final void end(ElementEndContext context) {
            String value = context.getText().trim();
            Pair bookPair = HelpHook.mav$getBookPair(HelpHook.this, (ElementContext)context);
            bookPair.setSecond((Object)value);
        }

        private BookLabelHandler() {
        }

        BookLabelHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class BrowseSymbolResolverHandler
    extends ElementVisitor {
        public void end(ElementEndContext context) {
            String value = context.getText();
            HelpHook.ra$_browseSymbolResolverEntries(HelpHook.this).add(value);
        }

        private BrowseSymbolResolverHandler() {
        }

        BrowseSymbolResolverHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HelpObject {
        private String _helpName;
        private int _helpAction;
        private URL _helpURL;
        private String _relativeTo;
        private int _relativePos;
        private Map<String, String> _bookMap;

        private void $init$() {
            this._relativePos = 1;
            this._bookMap = new HashMap<String, String>();
        }

        public String getHelpName() {
            return this._helpName;
        }

        public void setHelpName(String name) {
            this._helpName = name;
        }

        public int getHelpAction() {
            return this._helpAction;
        }

        public void setHelpAction(String helpAction) {
            this._helpAction = helpAction.equalsIgnoreCase(HelpHook.REMOVE_ACTION) ? 1 : 0;
        }

        public void setHelpURL(URL url) {
            this._helpURL = url;
        }

        public URL getHelpURL() {
            return this._helpURL;
        }

        public void setRelativeTo(String relativeTo) {
            this._relativeTo = relativeTo;
        }

        public String getRelativeTo() {
            return this._relativeTo;
        }

        public void setRelativePosition(String position) {
            this._relativePos = position.equalsIgnoreCase(HelpHook.BEFORE) ? 0 : 1;
        }

        public int getRelativePosition() {
            return this._relativePos;
        }

        public void addBookPair(String title, String label) {
            this._bookMap.put(title, label);
        }

        public Map<String, String> getBookMap() {
            return this._bookMap;
        }

        private HelpObject() {
            this.$init$();
        }

        HelpObject(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

