/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.net.URL;
import java.util.List;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpOptions
extends ChangeEventSource
implements Copyable {
    static final String KEY_SETTINGS = "HelpOptions";
    private static final String SHOW_TOC = "showTOC";
    private static final String SHOW_KEYWORD_INDEX = "showKeywordIndex";
    private static final String SHOW_FULL_TEXT_SEARCH = "showFullTextSearch";
    private static final String SHOW_FAVORITES = "showFavorites";
    private static final String SHOW_DYNAMIC_LINKS = "showDynamicLinks";
    private static final String SHOW_CUE_CARDS = "showCueCards";
    private static final String MODAL_HELP_WIDTH = "modalHelpWidth";
    private static final String MODAL_HELP_HEIGHT = "modalHelpHeight";
    private static final String MODAL_HELP_X = "modalHelpX";
    private static final String MODAL_HELP_Y = "modalHelpY";
    public static final String HELP_CENTER_WINDOW_OPEN = "helpCenterWindowOpen";
    private static final String HELP_CENTER_WIDTH = "helpCenterWidth";
    private static final String HELP_CENTER_HEIGHT = "helpCenterHeight";
    private static final String HELP_CENTER_X = "helpCenterX";
    private static final String HELP_CENTER_Y = "helpCenterY";
    public static final String HELP_CENTER_WINDOW_ON_TOP = "helpCenterWindowOnTop";
    public static final int NOT_SHOWN = 0;
    public static final int EMBEDDED_WINDOW = 1;
    public static final int SEPARATE_WINDOW = 2;
    public static final int BOTH_WINDOWS = 3;
    public static String TOC_LOCATION = "helpTOCNavigatorLocation";
    public static String FAVORITES_LOCATION = "helpFavoritesNavigatorLocation";
    public static String DYNAMIC_LINKS_LOCATION = "helpDynamicLinksNavigatorLocation";
    public static String CUE_CARDS_LOCATION = "helpCueCardNavigatorLocation";
    public static String SEARCH_LOCATION = "searchNavigatorLocation";
    public static String LAST_EMBEDDED_TAB_FOCUSED = "lastEmbeddedTabFocused";
    public static String LAST_SEPARATE_TAB_FOCUSED = "lastSeparateTabFocused";
    public static String OPEN_DOCUMENTS = "openHelpDocuments";
    public static final String SPLITTER_POSITION = "splitterPosition";
    public static final String LOCAL_CASE_SENSITIVE_SEARCH = "localCaseSensitiveSearch";
    public static final String LOCAL_SEARCH_TYPE = "localSearchType";
    public static final int LOCAL_SEARCH_ALL_WORDS = 0;
    public static final int LOCAL_SEARCH_ANY_WORDS = 1;
    public static final int LOCAL_SEARCH_BOOLEAN_EXPRESSION = 2;
    public static final String INCLUDE_LOCAL = "includeLocal";
    public static final String INCLUDE_OTN = "includeOTN";
    public static final String INCLUDE_FUSION_MIDDLEWARE = "includeFusionMiddleware";
    public static final String INCLUDE_DATABASE = "includeDatabase";

    public HelpOptions() {
    }

    private HelpOptions(HashStructure hash) {
        super(hash);
    }

    public static HelpOptions getInstance(PropertyStorage prefs) {
        return new HelpOptions(HelpOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    public static HelpOptions getInstance() {
        Preferences prefs = Preferences.getPreferences();
        return HelpOptions.getInstance((PropertyStorage)prefs);
    }

    public boolean getShowTOC() {
        return this._hash.getBoolean(SHOW_TOC, true);
    }

    public void setShowTOC(boolean showTOC) {
        this._hash.putBoolean(SHOW_TOC, showTOC);
    }

    public boolean getShowKeywordIndex() {
        return this._hash.getBoolean(SHOW_KEYWORD_INDEX, true);
    }

    public void setShowKeywordIndex(boolean showKeywordIndex) {
        this._hash.putBoolean(SHOW_KEYWORD_INDEX, showKeywordIndex);
    }

    public boolean getShowFullTextSearch() {
        return this._hash.getBoolean(SHOW_FULL_TEXT_SEARCH, true);
    }

    public void setShowFullTextSearch(boolean showFullTextSearch) {
        this._hash.putBoolean(SHOW_FULL_TEXT_SEARCH, showFullTextSearch);
    }

    public boolean getShowFavorites() {
        return this._hash.getBoolean(SHOW_FAVORITES, false);
    }

    public void setShowFavorites(boolean showFavorites) {
        this._hash.putBoolean(SHOW_FAVORITES, showFavorites);
    }

    public boolean getShowDynamicLinks() {
        return this._hash.getBoolean(SHOW_DYNAMIC_LINKS, true);
    }

    public void setShowDynamicLinks(boolean showDynamicLinks) {
        this._hash.putBoolean(SHOW_DYNAMIC_LINKS, showDynamicLinks);
    }

    public boolean getShowCueCards() {
        return this._hash.getBoolean(SHOW_CUE_CARDS, true);
    }

    public void setShowCueCards(boolean showCueCards) {
        this._hash.putBoolean(SHOW_CUE_CARDS, showCueCards);
    }

    public int getModalHelpWidth() {
        return this._hash.getInt(MODAL_HELP_WIDTH, -1);
    }

    public void setModalHelpWidth(int width) {
        this._hash.putInt(MODAL_HELP_WIDTH, width);
    }

    public int getModalHelpHeight() {
        return this._hash.getInt(MODAL_HELP_HEIGHT, -1);
    }

    public void setModalHelpHeight(int width) {
        this._hash.putInt(MODAL_HELP_HEIGHT, width);
    }

    public int getModalHelpX() {
        return this._hash.getInt(MODAL_HELP_X, -1);
    }

    public void setModalHelpX(int x) {
        this._hash.putInt(MODAL_HELP_X, x);
    }

    public int getModalHelpY() {
        return this._hash.getInt(MODAL_HELP_Y, -1);
    }

    public void setModalHelpY(int y) {
        this._hash.putInt(MODAL_HELP_Y, y);
    }

    public boolean getHelpCenterWindowOpen() {
        return this._hash.getBoolean(HELP_CENTER_WINDOW_OPEN, false);
    }

    public void setHelpCenterWindowOpen(boolean helpCenterWindowOpen) {
        this._hash.putBoolean(HELP_CENTER_WINDOW_OPEN, helpCenterWindowOpen);
    }

    public int getHelpCenterWidth() {
        return this._hash.getInt(HELP_CENTER_WIDTH, -1);
    }

    public void setHelpCenterWidth(int width) {
        this._hash.putInt(HELP_CENTER_WIDTH, width);
    }

    public int getHelpCenterHeight() {
        return this._hash.getInt(HELP_CENTER_HEIGHT, -1);
    }

    public void setHelpCenterHeight(int width) {
        this._hash.putInt(HELP_CENTER_HEIGHT, width);
    }

    public int getHelpCenterX() {
        return this._hash.getInt(HELP_CENTER_X, -1);
    }

    public void setHelpCenterX(int x) {
        this._hash.putInt(HELP_CENTER_X, x);
    }

    public int getHelpCenterY() {
        return this._hash.getInt(HELP_CENTER_Y, -1);
    }

    public void setHelpCenterY(int y) {
        this._hash.putInt(HELP_CENTER_Y, y);
    }

    public boolean getHelpCenterWindowOnTop() {
        return this._hash.getBoolean(HELP_CENTER_WINDOW_ON_TOP, false);
    }

    public void setHelpCenterWindowOnTop(boolean helpCenterWindowOnTop) {
        this._hash.putBoolean(HELP_CENTER_WINDOW_ON_TOP, helpCenterWindowOnTop);
    }

    public int getTOCLocation() {
        return this._hash.getInt(TOC_LOCATION, 2);
    }

    public void setTOCLocation(int windowType, boolean displayed) {
        this._hash.putInt(TOC_LOCATION, this.determineSetting(TOC_LOCATION, windowType, displayed));
    }

    public int getFavoritesLocation() {
        return this._hash.getInt(FAVORITES_LOCATION, 2);
    }

    public void setFavoritesLocation(int windowType, boolean displayed) {
        this._hash.putInt(FAVORITES_LOCATION, this.determineSetting(FAVORITES_LOCATION, windowType, displayed));
    }

    public int getDynamicLinksLocation() {
        int retval = this._hash.getInt(DYNAMIC_LINKS_LOCATION, -1);
        if (retval == -1) {
            this._hash.putInt(DYNAMIC_LINKS_LOCATION, 3);
            retval = 3;
        }
        return retval;
    }

    public void setDynamicLinksLocation(int windowType, boolean displayed) {
        this._hash.putInt(DYNAMIC_LINKS_LOCATION, this.determineSetting(DYNAMIC_LINKS_LOCATION, windowType, displayed));
    }

    public int getCueCardsLocation() {
        return this._hash.getInt(CUE_CARDS_LOCATION, 2);
    }

    public void setCueCardsLocation(int windowType, boolean displayed) {
        this._hash.putInt(CUE_CARDS_LOCATION, this.determineSetting(CUE_CARDS_LOCATION, windowType, displayed));
    }

    public int getSearchLocation() {
        return this._hash.getInt(SEARCH_LOCATION, 2);
    }

    public void setSearchLocation(int windowType, boolean displayed) {
        this._hash.putInt(SEARCH_LOCATION, this.determineSetting(SEARCH_LOCATION, windowType, displayed));
    }

    public int getLastTabFocused(int windowType) {
        String keyName = windowType == 2 ? LAST_SEPARATE_TAB_FOCUSED : LAST_EMBEDDED_TAB_FOCUSED;
        return this._hash.getInt(keyName, -1);
    }

    public void setLastTabFocused(int focusedTab, int windowType) {
        String keyName = windowType == 2 ? LAST_SEPARATE_TAB_FOCUSED : LAST_EMBEDDED_TAB_FOCUSED;
        this._hash.putInt(keyName, focusedTab);
    }

    public ListStructure getOpenDocuments() {
        ListStructure listStructure = this._hash.getListStructure(OPEN_DOCUMENTS);
        return listStructure;
    }

    public void setOpenDocuments(List<URL> openDocuments) {
        if (openDocuments == null) {
            this._hash.remove(OPEN_DOCUMENTS);
        } else {
            ListStructure listStructure = this._hash.getOrCreateListStructure(OPEN_DOCUMENTS);
            listStructure.clear();
            listStructure.addAll(openDocuments);
        }
    }

    static boolean isNavigatorShown(int location, int windowType) {
        return location == windowType || location == 3;
    }

    public int getSplitterPosition() {
        return this._hash.getInt(SPLITTER_POSITION, -1);
    }

    public void setSplitterPosition(int position) {
        this._hash.putInt(SPLITTER_POSITION, position);
    }

    public boolean getLocalCaseSensitiveSearch() {
        return this._hash.getBoolean(LOCAL_CASE_SENSITIVE_SEARCH, false);
    }

    public void setLocalCaseSensitiveSearch(boolean caseSensitive) {
        this._hash.putBoolean(LOCAL_CASE_SENSITIVE_SEARCH, caseSensitive);
    }

    public int getLocalSearchType() {
        return this._hash.getInt(LOCAL_SEARCH_TYPE, 0);
    }

    public void setLocalSearchType(int searchType) {
        this._hash.putInt(LOCAL_SEARCH_TYPE, searchType);
    }

    public boolean includeLocal() {
        return this._hash.getBoolean(INCLUDE_LOCAL, true);
    }

    public void setIncludeLocal(boolean includeLocal) {
        this._hash.putBoolean(INCLUDE_LOCAL, includeLocal);
    }

    public boolean includeOTN() {
        return this._hash.getBoolean(INCLUDE_OTN, false);
    }

    public void setIncludeOTN(boolean includeOTN) {
        this._hash.putBoolean(INCLUDE_OTN, includeOTN);
    }

    public boolean includeFusionMiddleware() {
        return this._hash.getBoolean(INCLUDE_FUSION_MIDDLEWARE, true);
    }

    public void setIncludeFusionMiddleware(boolean includeFusionMiddleware) {
        this._hash.putBoolean(INCLUDE_FUSION_MIDDLEWARE, includeFusionMiddleware);
    }

    public boolean includeDatabase() {
        return this._hash.getBoolean(INCLUDE_DATABASE, false);
    }

    public void setIncludeDatabase(boolean includeDatabase) {
        this._hash.putBoolean(INCLUDE_DATABASE, includeDatabase);
    }

    private int determineSetting(String navigator, int windowType, boolean displayed) {
        int origSetting = this._hash.getInt(navigator, 2);
        if (displayed) {
            if (origSetting == 0 || origSetting == windowType) {
                return windowType;
            }
            return 3;
        }
        if (origSetting == windowType) {
            return 0;
        }
        if (origSetting == 3) {
            if (windowType == 1) {
                return 2;
            }
            return 1;
        }
        return origSetting;
    }
}

