/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.ProductInformation;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Node;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.print.PrintManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.MenuSpec;
import oracle.ide.util.MultiMap;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.ideri.util.Product;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpCenterWindow;
import oracle.jdevimpl.help.HelpContentPanel;
import oracle.jdevimpl.help.HelpOptions;
import oracle.jdevimpl.help.HelpSystemConstants;
import oracle.jdevimpl.help.HelpTopicDocument;
import oracle.jdevimpl.help.HelpTopicDocumentPrintFactory;
import oracle.jdevimpl.help.HelpTopicEditor;
import oracle.jdevimpl.help.HelpWindow;
import oracle.jdevimpl.help.JDevHelpSystemImpl;
import oracle.jdevimpl.help.JDevTOCNavigator;

public final class HelpSystemAddin
extends EditorAddin
implements ShutdownHook,
Controller {
    private static final float WEIGHT_HELP_SEARCH = 1.0f;
    private static final float WEIGHT_HELP_TOC = 2.0f;
    private static final float WEIGHT_HELP_FAVORITES = 3.0f;
    private static final float WEIGHT_HELP_DYNAMIC_LINKS = 4.0f;
    private static final float WEIGHT_HELP_CUECARDS = 5.0f;
    private static final float WEIGHT_HELP_START_PAGE = 6.0f;
    private static final float WEIGHT_HELP_FORUM = 7.0f;
    private static final float WEIGHT_HELP_OTN = 8.0f;
    private static final float WEIGHT_HELP_TUTORIAL = 9.0f;
    private static final float WEIGHT_HELP_SAMPLES = 10.0f;
    private static final float WEIGHT_HELP_JAVA_ED = 11.0f;
    private static final float WEIGHT_HELP_RELEASE_NOTES = 0.0f;
    private static final float WEIGHT_HELP_TIP_OF_DAY = 1.0f;
    private static HelpSystem _helpSystem;
    private MenuSpec _menuSpec;
    private boolean _readmeFileExists;
    private boolean _educationFileExists;
    private Map<Integer, String> _bookCommandMap;
    private static final String GLOBAL_ACCELERATORS = "oracle/jdevimpl/help/accelerators.xml";
    static final String LOCAL_ACCELERATORS = "oracle/jdevimpl/help/localaccelerators.xml";
    private static final String WEBLINK_EDUCATION_FILENAME = "education.html";
    private static final String WEBLINK_README_FILENAME = "readme.html";
    private static final String WELCOME_PAGE_FILENAME = "welcome";
    private static final String WELCOME_PAGE_FILE_EXT = ".html";
    private static final String WELCOME_DIR = "doc/welcome";
    static final int DOCERROR_URL_FAILED = 0;
    static final int DOCERROR_SYMBOL_NOT_FOUND = 1;
    static final int DOCERROR_SYMBOL_NOT_DETERMINED = 2;

    public final void initialize() {
        File readmeFile;
        File eduFile;
        JDevHelpSystemImpl helpSystemImpl = new JDevHelpSystemImpl();
        _helpSystem = helpSystemImpl;
        this._bookCommandMap = new HashMap<Integer, String>();
        this._initHelpProvider();
        if (Product.isRaptor()) {
            int[] supportedNavigators = new int[]{0};
            helpSystemImpl.supportsNavigators(supportedNavigators);
        } else {
            int[] supportedNavigators = new int[]{0, 1, 2, 3};
            helpSystemImpl.supportsNavigators(supportedNavigators);
        }
        WindowUtils.registerWindow((Window)Ide.getMainWindow());
        Menubar mm = Ide.getMenubar();
        AddinManager am = AddinManager.getAddinManager();
        JMenu help = MenuManager.getJMenu((String)"Help");
        File ideHome = new File(Ide.getProductHomeDirectory());
        String sCategory = IdeArb.getString((int)80);
        URL welcomeFile = this.getWelcomePageUrl();
        if (welcomeFile != null) {
            this._createActionAndMenu(mm, help, HelpSystemConstants.SHOW_WELCOME_PAGE_CMD_ID, "oracle.jdevimpl.help.welcomePage", sCategory, HelpArb.getString(138), null, 6.0f, 1.0f);
        }
        if (helpSystemImpl.isNavigatorSupported(0)) {
            this._createActionAndMenu(mm, help, HelpSystemConstants.SHOW_TOC_CMD_ID, "oracle.jdevimpl.help.TableOfContents", sCategory, HelpArb.getString(170), OracleIcons.getIcon((String)"library.png"), 2.0f, 1.0f);
        }
        if (helpSystemImpl.isNavigatorSupported(2)) {
            this._createActionAndMenu(mm, help, HelpSystemConstants.SHOW_DYNAMIC_LINKS_CMD_ID, "oracle.jdevimpl.help.DynamicLinks", sCategory, HelpArb.getString(91), OracleIcons.getIcon((String)"dynamicLink.png"), 4.0f, 1.0f);
        }
        this._createActionAndMenu(mm, help, HelpSystemConstants.SHOW_FULL_TEXT_SEARCH_CMD_ID, "oracle.jdevimpl.help.FullTextSearch", sCategory, HelpArb.getString(128), OracleIcons.getIcon((String)"find.png"), 1.0f, 1.0f);
        if (helpSystemImpl.isNavigatorSupported(1)) {
            this._createActionAndMenu(mm, help, HelpSystemConstants.SHOW_FAV_CMD_ID, "oracle.jdevimpl.help.Favorites", sCategory, HelpArb.getString(82), OracleIcons.getIcon((String)"favorites.png"), 3.0f, 1.0f);
        }
        if (Product.isJDeveloper()) {
            this._createActionAndMenu(mm, help, HelpSystemConstants.SHOW_FORUM_CMD_ID, "oracle.jdevimpl.help.ShowOTNForum", sCategory, HelpArb.getString(16), OracleIcons.getIcon((String)"forum.png"), 7.0f, MenuConstants.SECTION_HELP_GENERAL_HELP);
            this._createActionAndMenu(mm, help, HelpSystemConstants.WEBLINK_OTN_CMD_ID, "oracle.jdevimpl.help.WebLinkOtn", sCategory, HelpArb.getString(53), null, 8.0f, MenuConstants.SECTION_HELP_GENERAL_HELP);
        }
        if (Product.isJDeveloper()) {
            this._createActionAndMenu(mm, help, HelpSystemConstants.SHOW_TUTORIALS_CMD_ID, "oracle.jdevimpl.help.ShowOTNTutorials", sCategory, HelpArb.getString(19), null, 9.0f, MenuConstants.SECTION_HELP_JDEV_HELP);
            this._createActionAndMenu(mm, help, HelpSystemConstants.SHOW_SAMPLES_CMD_ID, "oracle.jdevimpl.help.ShowOTNSamples", sCategory, HelpArb.getString(117), null, 10.0f, MenuConstants.SECTION_HELP_JDEV_HELP);
        }
        if ((eduFile = new File(ideHome, WEBLINK_EDUCATION_FILENAME)).exists()) {
            this._createActionAndMenu(mm, help, HelpSystemConstants.WEBLINK_EDUCATION_CMD_ID, "oracle.jdevimpl.help.WebLinkEducation", sCategory, HelpArb.getString(34), null, 11.0f, MenuConstants.SECTION_HELP_JDEV_HELP);
            this._educationFileExists = true;
        }
        if ((readmeFile = new File(ideHome, WEBLINK_README_FILENAME)).exists()) {
            this._createActionAndMenu(mm, help, HelpSystemConstants.WEBLINK_README_CMD_ID, "oracle.jdevimpl.help.WebLinkReadme", sCategory, HelpArb.getString(73), null, 0.0f, MenuConstants.SECTION_HELP_UPDATES);
            this._readmeFileExists = true;
        }
        this._createActionAndMenu(mm, help, HelpSystemConstants.SHOW_TIP_OF_DAY_CMD_ID, "oracle.jdevimpl.help.tipOfDay", sCategory, HelpArb.getString(41), null, 1.0f, MenuConstants.SECTION_HELP_ADDINS);
        IdeAction action = IdeAction.find((int)HelpSystemConstants.SHOW_TIP_OF_DAY_CMD_ID);
        if (action != null) {
            action.setEnabled(false);
        }
        String chelpTopicsCmd = am.getCommand(HelpSystemConstants.CHELP_TOPICS_ID, "oracle.jdevimpl.help.ContextHelpCommand");
        IdeAction a = IdeAction.get((int)HelpSystemConstants.CHELP_TOPICS_ID, (String)chelpTopicsCmd, (String)HelpArb.getString(80), (String)sCategory, null, null, null, (boolean)true);
        a.addController((Controller)this);
        IdeAction.get((int)HelpSystemConstants.BACKWARD_CMD_ID, null, (String)HelpArb.getString(24), (String)sCategory, null, (Icon)OracleIcons.getIcon((String)"navigateBack.png"), null, (boolean)true);
        IdeAction.get((int)HelpSystemConstants.FORWARD_CMD_ID, null, (String)HelpArb.getString(62), (String)sCategory, null, (Icon)OracleIcons.getIcon((String)"navigateForward.png"), null, (boolean)true);
        IdeAction.get((int)HelpSystemConstants.ADD_FAVORITE_CMD_ID, (String)"oracle.jdevimpl.help.AddFavoriteCmd", (String)HelpArb.getString(157), (String)sCategory, (Integer)HelpArb.getInteger(6), (Icon)OracleIcons.getIcon((String)"addFavorites.png"), null, (boolean)true);
        MultiMap<String, JDevHelpSystemImpl.BookContributor> bookMap = helpSystemImpl.getBookMap();
        if (bookMap != null) {
            String allBooksTitle = StringUtils.stripMnemonic((String)HelpArb.getString(57));
            if (bookMap.keySet().contains(allBooksTitle) && bookMap.keySet().size() > 0) {
                int bookCmdId = Ide.createCmdID((String)"oracle.jdevimpl.help.HelpSystemAddin.AllBooksCmd");
                this._createActionAndMenu(mm, help, bookCmdId, null, sCategory, HelpArb.getString(57), null, 1.0f, MenuConstants.SECTION_HELP_ADDINS);
                this._bookCommandMap.put(bookCmdId, allBooksTitle);
            }
        }
        Ide.getKeyStrokeContextRegistry().addAcceleratorDefinitionFile(this.getClass().getClassLoader(), GLOBAL_ACCELERATORS);
        Ide.getKeyStrokeContextRegistry().addAcceleratorDefinitionFile(this.getClass().getClassLoader(), LOCAL_ACCELERATORS);
        this._initIdePreferencesPanels();
        EditorManager editorMgr = EditorManager.getEditorManager();
        Class[] types = new Class[]{HelpTopicDocument.class};
        editorMgr.register((EditorAddin)this, types);
        PrintManager.getPrintManager().registerDocumentPrintFactory(HelpTopicEditor.class, HelpTopicDocumentPrintFactory.class);
        PrintManager.getPrintManager().registerDocumentPrintFactory(HelpWindow.class, HelpTopicDocumentPrintFactory.class);
        PrintManager.getPrintManager().registerDocumentPrintFactory(HelpContentPanel.class, HelpTopicDocumentPrintFactory.class);
        Recognizer.mapExtensionToClass((String)".helpT", HelpTopicDocument.class);
        Recognizer.mapExtensionToClass((String)".help", HelpTopicDocument.class);
        Recognizer.registerDocumentInfo(HelpTopicDocument.class, (DocumentInfo)new DocumentInfo(HelpArb.getString(112)));
        Ide.addIdeListener((IdeListener)new 1());
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    private final void _createActionAndMenu(Menubar mm, JMenu help, int commandId, String commandString, String commandCategory, String label, Icon icon, float menuWeight, float menuSection) {
        IdeAction a = IdeAction.get((int)commandId, (String)commandString, (String)StringUtils.stripMnemonic((String)label), (String)commandCategory, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (Icon)icon, null, (boolean)true);
        a.addController((Controller)this);
        JMenuItem mitem = mm.createMenuItem((ToggleAction)a, menuWeight);
        mm.add((Component)mitem, help, menuSection);
    }

    private final void _mainWindowOpened() {
        HelpOptions helpOptions;
        boolean noNag = Ide.getIdeArgs().hasArg("-nonag");
        String showWelcomePageProperty = Ide.getProperty((String)"Ide.ShowWelcomePage", (String)Boolean.TRUE.toString());
        boolean showWelcomePage = Boolean.valueOf(showWelcomePageProperty);
        if (showWelcomePage) {
            URL welcomeURL = this.getWelcomePageUrl();
            if (welcomeURL != null && URLFileSystem.exists((URL)welcomeURL) && !noNag) {
                HelpSystemAddin.openEditorInFrameExternal(welcomeURL, null, StringUtils.stripMnemonic((String)HelpArb.getString(138)));
            }
            Ide.setProperty((String)"Ide.ShowWelcomePage", (String)Boolean.FALSE.toString());
        }
        if (_helpSystem.hasTipOfDayEntries()) {
            IdeAction action = IdeAction.find((int)HelpSystemConstants.SHOW_TIP_OF_DAY_CMD_ID);
            if (action != null) {
                action.setEnabled(true);
            }
            if (JDevHelpSystemImpl.getShowTipOfDayPreference() && !noNag) {
                _helpSystem.showTipOfTheDay();
            }
        }
        if ((helpOptions = HelpOptions.getInstance()).getHelpCenterWindowOpen()) {
            this.showNavigator(0, null);
        }
    }

    private final void _initHelpProvider() {
        HelpUtils.setDefaultHelpProvider((HelpProvider)new 2());
        HelpSystem.setHelpSystem((HelpSystem)_helpSystem);
    }

    private final void _initIdePreferencesPanels() {
        Preferences prefs = Preferences.getPreferences();
        HelpOptions helpOptions = HelpOptions.getInstance((PropertyStorage)prefs);
        IdeSettings ideSettings = Ide.getSettings();
        ideSettings.putLegacyData("HelpOptions", (Copyable)helpOptions);
    }

    public final void shutdown() {
        HelpCenterWindow.saveLayout();
        _helpSystem.clearHelpSystem();
    }

    public boolean canShutdown() {
        return true;
    }

    public final boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == HelpSystemConstants.WEBLINK_EDUCATION_CMD_ID) {
            if (this._educationFileExists) {
                File ideHome = new File(Ide.getProductHomeDirectory());
                File eduFile = new File(ideHome, WEBLINK_EDUCATION_FILENAME);
                URL url = URLFactory.newFileURL((File)eduFile);
                HelpSystemAddin.openEditorInFrameExternal(url, null, HelpArb.getString(131));
            }
            return true;
        }
        if (cmdId == HelpSystemConstants.WEBLINK_README_CMD_ID) {
            if (this._readmeFileExists) {
                File ideHome = new File(Ide.getProductHomeDirectory());
                File readmeFile = new File(ideHome, WEBLINK_README_FILENAME);
                URL url = URLFactory.newFileURL((File)readmeFile);
                HelpSystemAddin.openEditorInFrameExternal(url, null, HelpArb.getString(23));
            }
            return true;
        }
        if (cmdId == HelpSystemConstants.WEBLINK_OTN_CMD_ID) {
            this.showWebSite(HelpArb.getString(77));
            return true;
        }
        if (cmdId == HelpSystemConstants.SHOW_TOC_CMD_ID) {
            this.showNavigator(0, null);
            return true;
        }
        if (cmdId == HelpSystemConstants.SHOW_DYNAMIC_LINKS_CMD_ID) {
            this.showNavigator(2, null);
            return true;
        }
        if (cmdId == HelpSystemConstants.SHOW_FULL_TEXT_SEARCH_CMD_ID) {
            this.showSearch();
            return true;
        }
        if (cmdId == HelpSystemConstants.SHOW_FAV_CMD_ID) {
            this.showNavigator(1, null);
            return true;
        }
        if (cmdId == HelpSystemConstants.SHOW_CUE_CMD_ID) {
            this.showNavigator(3, null);
            return true;
        }
        if (cmdId == HelpSystemConstants.SHOW_TUTORIALS_CMD_ID) {
            this.showWebSite(HelpArb.getString(68));
            return true;
        }
        if (cmdId == HelpSystemConstants.SHOW_SAMPLES_CMD_ID) {
            this.showWebSite(HelpArb.getString(59));
            return true;
        }
        if (cmdId == HelpSystemConstants.SHOW_FORUM_CMD_ID) {
            this.showWebSite(HelpArb.getString(28));
            return true;
        }
        if (cmdId == HelpSystemConstants.SHOW_WELCOME_PAGE_CMD_ID) {
            3 r = new 3();
            EventQueue.invokeLater(r);
            return true;
        }
        if (cmdId == HelpSystemConstants.SHOW_TIP_OF_DAY_CMD_ID) {
            4 r = new 4();
            EventQueue.invokeLater(r);
            return true;
        }
        if (cmdId == HelpSystemConstants.FORWARD_CMD_ID) {
            if (context.getView() instanceof HelpContentPanel) {
                return context.getView().getController().handleEvent(action, context);
            }
        } else if (this._bookCommandMap.get(cmdId) != null) {
            String bookTitle = this._bookCommandMap.get(cmdId);
            this.showNavigator(0, bookTitle);
            return true;
        }
        return false;
    }

    private URL getWelcomePageUrl() {
        URL welcomePageUrl = null;
        ProductInformation productInfo = ProductInformation.getProductInformation();
        if (productInfo != null) {
            welcomePageUrl = productInfo.getWelcomePage();
        }
        if (welcomePageUrl == null) {
            File ideHome = new File(Ide.getProductHomeDirectory());
            File welcomeDir = new File(ideHome, WELCOME_DIR);
            File welcomeFile = new File(welcomeDir, WELCOME_PAGE_FILENAME);
            welcomePageUrl = URLFactory.newFileURL((File)welcomeFile);
        }
        URL welcomeFileDir = URLFileSystem.getParent((URL)welcomePageUrl);
        String welcomeFileName = URLFileSystem.getName((URL)welcomePageUrl);
        Locale locale = StaticLocaleContext.getLocale();
        String lang = locale.getLanguage();
        URL localeUrl = URLFactory.newURL((URL)welcomeFileDir, (String)(welcomeFileName + "_" + lang + WELCOME_PAGE_FILE_EXT));
        if (URLFileSystem.exists((URL)localeUrl)) {
            return localeUrl;
        }
        if (URLFileSystem.exists((URL)welcomePageUrl)) {
            return welcomePageUrl;
        }
        return null;
    }

    private void showSearch() {
        HelpCenterWindow hcWindow = null;
        hcWindow = HelpCenterWindow.getInstance();
        hcWindow.setVisible(true);
        hcWindow.requestFocus();
        hcWindow.focusSearchControl();
    }

    private void showNavigator(int navigatorToShow, String bookTitle) {
        Component c;
        JDevTOCNavigator tocNav;
        HelpCenterWindow hcWindow = null;
        hcWindow = HelpCenterWindow.getInstance();
        hcWindow.setVisible(true);
        hcWindow.requestFocus();
        hcWindow.switchNavigator(navigatorToShow);
        if (navigatorToShow == 0 && (tocNav = HelpCenterWindow.getTOCNavigator()) != null) {
            tocNav.setTOCSelection(bookTitle);
        }
        if ((c = HelpCenterWindow.getInstance().getCurrentNavigator()) != null) {
            GraphicsUtils.focusComponentOrChild((Component)c, (boolean)true);
        }
    }

    private void showWebSite(String webSiteString) {
        try {
            URL webSiteURL = new URL(webSiteString);
            BrowserRunner.getBrowserRunner().runBrowserOnURL(webSiteURL, null, null);
        }
        catch (MalformedURLException muEx) {
            Assert.printStackTrace((Throwable)muEx);
        }
    }

    public final boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == HelpSystemConstants.CHELP_TOPICS_ID || cmdId == HelpSystemConstants.SHOW_WELCOME_PAGE_CMD_ID || cmdId == HelpSystemConstants.SHOW_TOC_CMD_ID || cmdId == HelpSystemConstants.SHOW_DYNAMIC_LINKS_CMD_ID || cmdId == HelpSystemConstants.SHOW_FULL_TEXT_SEARCH_CMD_ID || cmdId == HelpSystemConstants.SHOW_FAV_CMD_ID || cmdId == HelpSystemConstants.SHOW_CUE_CMD_ID || cmdId == HelpSystemConstants.SHOW_TUTORIALS_CMD_ID || cmdId == HelpSystemConstants.SHOW_SAMPLES_CMD_ID || cmdId == HelpSystemConstants.SHOW_FORUM_CMD_ID || cmdId == HelpSystemConstants.WEBLINK_OTN_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == HelpSystemConstants.WEBLINK_README_CMD_ID) {
            if (this._readmeFileExists) {
                action.setEnabled(true);
            }
            return true;
        }
        if (cmdId == HelpSystemConstants.WEBLINK_EDUCATION_CMD_ID) {
            if (this._educationFileExists) {
                action.setEnabled(true);
            }
            return true;
        }
        return false;
    }

    public static void openEditorInFrameExternal(URL url) {
        HelpSystemAddin.openEditorInFrameExternal(url, null, null);
    }

    public static void openEditorInFrameExternal(URL url, Icon icon, String shortLabel) {
        HelpTopicDocument doc = new HelpTopicDocument(url);
        if (icon != null) {
            doc.setIcon(icon);
        }
        if (shortLabel != null) {
            doc.setShortLabel(shortLabel);
        }
        Context context = Context.newIdeContext((Node)doc);
        context.setWorkspace(null);
        context.setProject(null);
        EditorManager editorMgr = EditorManager.getEditorManager();
        HelpTopicEditor editor = (HelpTopicEditor)editorMgr.openEditorInFrame(HelpTopicEditor.class, context);
        if (shortLabel == null) {
            editor.setSharable(true);
        } else {
            editor.setSharable(false);
        }
        if (editor == null) {
            Assert.println((String)("Failed opening Editor on " + url.toString()));
            HelpSystemAddin.showJavadocException(0, url.toString());
        }
    }

    static void showJavadocException(int errorCode, String msg) {
        String errorMsg = null;
        switch (errorCode) {
            case 0: {
                errorMsg = HelpArb.format(75, msg);
                break;
            }
            case 1: {
                errorMsg = HelpArb.format(54, msg);
                break;
            }
            case 2: {
                errorMsg = HelpArb.format(26, msg);
                break;
            }
            default: {
                errorMsg = HelpArb.getString(109);
                break;
            }
        }
        String innerMsg = errorMsg;
        5 r = new 5(innerMsg);
        EventQueue.invokeLater(r);
    }

    public Class getEditorClass() {
        return HelpTopicEditor.class;
    }

    public synchronized MenuSpec getMenuSpecification() {
        if (this._menuSpec == null) {
            String name = HelpArb.getString(79);
            Integer mnemonic = HelpArb.getInteger(84);
            this._menuSpec = new MenuSpec(name, mnemonic, HelpArb.getIcon(107));
        }
        return this._menuSpec;
    }

    public boolean isDefault() {
        return true;
    }

    static String getExtensionID() {
        return AddinManager.getAddinManager().getExtensionIDForAddin(HelpSystemAddin.class);
    }

    static URL mav$getWelcomePageUrl(HelpSystemAddin helpSystemAddin) {
        return helpSystemAddin.getWelcomePageUrl();
    }

    static HelpSystem ra$_helpSystem() {
        return _helpSystem;
    }

    static void mav$_mainWindowOpened(HelpSystemAddin helpSystemAddin) {
        helpSystemAddin._mainWindowOpened();
    }

    final class 1
    extends IdeAdapter {
        public void mainWindowOpened(IdeEvent e) {
            HelpSystemAddin.mav$_mainWindowOpened(HelpSystemAddin.this);
            ((JDevHelpSystemImpl)HelpSystemAddin.ra$_helpSystem()).loadHelpWindows();
            Ide.removeIdeListener((IdeListener)this);
        }
    }

    final class 2
    implements HelpProvider {
        public void showHelp(Component component) throws HelpUnavailableException {
            if (component instanceof JComponent) {
                HelpSystemAddin.ra$_helpSystem().showHelp((JComponent)component);
            } else {
                Assert.println((String)("Tried to show help on a non-JComponent: " + component.toString()));
            }
        }
    }

    final class 3
    implements Runnable {
        public void run() {
            URL url = HelpSystemAddin.mav$getWelcomePageUrl(HelpSystemAddin.this);
            if (url != null) {
                HelpSystemAddin.openEditorInFrameExternal(url, null, StringUtils.stripMnemonic((String)HelpArb.getString(138)));
            } else {
                Assert.println((String)("Unable to find welcome page at: " + url));
            }
        }
    }

    final class 4
    implements Runnable {
        public void run() {
            HelpSystemAddin.ra$_helpSystem().showTipOfTheDay();
        }
    }

    static final class 5
    implements Runnable {
        private final /* synthetic */ String v$innerMsg;

        public void run() {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), this.v$innerMsg);
        }

        public 5(String string) {
            this.v$innerMsg = string;
        }
    }
}

