/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import oracle.help.common.IndirectTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.library.Book;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.help.DynamicLinkTarget;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.MultipleTypeTopic;

public class HelpTopicDocument
extends Node {
    private Topic _topic;
    private Icon _icon = HelpArb.getIcon(9);
    private String _shortLabel = HelpArb.getString(176);
    private String _longLabel;
    private boolean _helpDependent = true;
    private String _title;
    public static final String EXT1 = ".helpT";
    public static final String EXT2 = ".help";
    static final Logger LOG = Logger.getLogger(HelpTopicDocument.class.getName());

    public HelpTopicDocument() {
        this.getAttributes().set(ElementAttributes.CLOSEABLE);
        this.getAttributes().set(ElementAttributes.NON_RELOADABLE);
    }

    public HelpTopicDocument(Topic topic) throws MalformedURLException {
        this();
        this._topic = topic;
        URL topicURL = topic.getTarget().getURL();
        if (topicURL == null) {
            String topicId = null;
            if (topic.hasTarget()) {
                if (topic.getTarget() instanceof IndirectTarget) {
                    IndirectTarget iTarget = (IndirectTarget)topic.getTarget();
                    topicId = iTarget.getTargetName();
                } else if (topic.getTarget() instanceof DynamicLinkTarget) {
                    DynamicLinkTarget dTarget = (DynamicLinkTarget)topic.getTarget();
                    topicId = dTarget.getTopicId();
                }
            }
            Assert.println((String)("Failed to find URL for topic: " + topicId));
            throw new MalformedURLException("Failed to find url for topic");
        }
        super.setURL(URLFileSystem.ensureSuffix((URL)topicURL, (String)EXT1));
        if (topic != null && topic instanceof MultipleTypeTopic) {
            MultipleTypeTopic mTopic = (MultipleTypeTopic)topic;
            int topicType = mTopic.getTopicType();
            Icon icon = null;
            icon = topicType == 2 || topicType == 8 || topicType == 7 ? HelpArb.getIcon(49) : (topicType == 6 ? HelpArb.getIcon(113) : (topicType == 5 || topicType == 4 ? HelpArb.getIcon(9) : (topicType == 1 ? OracleIcons.getIcon((String)"link.png") : HelpArb.getIcon(158))));
            this.setIcon(icon);
        }
    }

    public HelpTopicDocument(URL url) {
        this();
        String title = HelpTopicDocument.getJavadocTitle(url);
        if (ModelUtil.hasLength((String)title)) {
            this._shortLabel = this._title = title;
        }
        this._topic = new TopicWrapper(url);
        super.setURL(URLFileSystem.ensureSuffix((URL)url, (String)EXT2));
        this._helpDependent = false;
    }

    public void setURL(URL inputURL) {
        URLPair urlPair = this._mapURL(inputURL);
        URL nodeURL = urlPair.getNodeURL();
        URL topicURL = urlPair.getTopicURL();
        if (this.getURL() != null && URLFileSystem.equals((URL)this.getURL(), (URL)nodeURL)) {
            return;
        }
        super.setURL(nodeURL);
        this._createTopicWrapper(topicURL);
        this._title = HelpTopicDocument.getTitleFromURL(topicURL);
        if (URLFileSystem.hasSuffix((URL)nodeURL, (String)EXT1)) {
            this._helpDependent = true;
        } else if (URLFileSystem.hasSuffix((URL)nodeURL, (String)EXT2)) {
            this._shortLabel = this._title;
            this._helpDependent = false;
        }
        this._longLabel = null;
        this.notifyObservers((Object)this, new UpdateMessage(UpdateMessage.ATTRIBUTE_CHANGED, (Object)this));
    }

    private URLPair _mapURL(URL inURL) {
        URLPair urlPair = new URLPair();
        if (URLFileSystem.hasSuffix((URL)inURL, (String)EXT1)) {
            urlPair.setTopicURL(URLFileSystem.convertSuffix((URL)inURL, (String)EXT1, (String)""));
            urlPair.setNodeURL(inURL);
        } else if (URLFileSystem.hasSuffix((URL)inURL, (String)EXT2)) {
            urlPair.setTopicURL(URLFileSystem.convertSuffix((URL)inURL, (String)EXT2, (String)""));
            urlPair.setNodeURL(inURL);
        } else if (URLFileSystem.hasSuffix((URL)this.getURL(), (String)EXT1)) {
            urlPair.setTopicURL(inURL);
            urlPair.setNodeURL(URLFileSystem.ensureSuffix((URL)inURL, (String)EXT1));
        } else {
            urlPair.setTopicURL(inURL);
            urlPair.setNodeURL(URLFileSystem.ensureSuffix((URL)inURL, (String)EXT2));
        }
        return urlPair;
    }

    public Topic getTopic() {
        return this._topic;
    }

    public void setTopic(Topic topic) {
        this._topic = topic;
        this._longLabel = topic.getLabel();
    }

    public boolean isHelpDependent() {
        return this._helpDependent;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
    }

    public String getShortLabel() {
        return this._shortLabel;
    }

    public void setShortLabel(String shortLabel) {
        this._shortLabel = shortLabel;
    }

    public String getLongLabel() {
        if (this._longLabel == null) {
            if (this._topic.getLabel() != null) {
                this._longLabel = this._topic.getLabel();
            } else if (this._topic.hasTarget()) {
                if (this._title == null) {
                    try {
                        URL url = this._topic.getTarget().getURL();
                        this._title = HelpTopicDocument.getTitleFromURL(url);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                this._longLabel = this._title;
            }
        }
        return this._longLabel;
    }

    public boolean isDirty() {
        return false;
    }

    private void _createTopicWrapper(URL url) {
        String label = null;
        if (this._topic != null && this._topic.hasTarget()) {
            try {
                URL origURL = this._topic.getTarget().getURL();
                if (URLFileSystem.equals((URL)url, (URL)origURL)) {
                    label = this._topic.getLabel();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this._topic = new TopicWrapper(url);
        if (label != null && this._topic instanceof TopicWrapper) {
            ((TopicWrapper)this._topic).setLabel(label);
        }
    }

    static String getTitleFromURL(URL url) {
        String title = null;
        String urlPathStr = url.getPath();
        if (urlPathStr.indexOf("truncateDocPath.do") != -1 || urlPathStr.indexOf("findDocument.do") != -1) {
            return "Doc Review";
        }
        title = HelpTopicDocument.getJavadocTitle(url);
        if (ModelUtil.hasLength((String)title)) {
            return title;
        }
        URL nodeURL = url;
        String urlStr = url.toString();
        String str = URLDecoder.decode(urlStr);
        if (!str.equals(urlStr)) {
            nodeURL = URLFactory.newURL((String)str);
        }
        ParserDelegator pd = new ParserDelegator();
        1Callback callback = new 1Callback();
        if (!URLFileSystem.exists((URL)nodeURL)) {
            title = HelpArb.getString(27);
            return title;
        }
        InputStreamReader reader = null;
        try {
            try {
                reader = new InputStreamReader(URLFileSystem.openInputStream((URL)nodeURL), "ISO-8859-1");
                pd.parse(reader, callback, false);
            }
            catch (ChangedCharSetException e) {
                String spec = e.getCharSetSpec();
                Pattern p = Pattern.compile("charset=\"?(.+)\"?\\s*;?", 2);
                Matcher m = p.matcher(spec);
                String charset = m.find() ? m.group(1) : "ISO-8859-1";
                InputStreamReader realReader = null;
                try {
                    try {
                        realReader = new InputStreamReader(URLFileSystem.openInputStream((URL)nodeURL), charset);
                        1Callback.wa$inTitle(callback, false);
                        pd.parse(realReader, callback, true);
                    }
                    catch (IOException ioe) {
                        LOG.log(Level.SEVERE, "Failed to load " + nodeURL, ioe);
                    }
                }
                catch (Throwable throwable) {
                    HelpTopicDocument.forceClose(realReader);
                    throw throwable;
                }
                HelpTopicDocument.forceClose(realReader);
            }
            catch (IOException ioe) {
                LOG.log(Level.SEVERE, "Failed to load " + nodeURL, ioe);
            }
        }
        catch (Throwable throwable) {
            HelpTopicDocument.forceClose(reader);
            throw throwable;
        }
        HelpTopicDocument.forceClose(reader);
        title = 1Callback.ra$title(callback);
        if (title == null || title.length() == 0) {
            title = HelpArb.getString(27);
        }
        return IdeUtil.decodeHTMLReservedCharacters((String)title).trim();
    }

    private static String getJavadocTitle(URL url) {
        int lastSlash;
        String title = null;
        if (url.getProtocol().equals("http") && url.getHost().indexOf("java") != -1 && url.getPath().indexOf("api") != -1 && (lastSlash = url.getPath().lastIndexOf("/")) != -1) {
            title = url.getPath().substring(lastSlash + 1);
        }
        return title;
    }

    private static void forceClose(InputStreamReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class 1Callback
    extends HTMLEditorKit.ParserCallback {
        private boolean inTitle;
        private String title;

        public void handleText(char[] data, int pos) {
            if (this.inTitle) {
                this.title = new String(data);
            }
        }

        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            if (t == HTML.Tag.TITLE) {
                this.inTitle = true;
            }
        }

        public void handleEndTag(HTML.Tag t, int pos) {
            if (t == HTML.Tag.TITLE) {
                this.inTitle = false;
            }
        }

        1Callback() {
        }

        static void wa$inTitle(1Callback callback, boolean bl) {
            callback.inTitle = bl;
        }

        static String ra$title(1Callback callback) {
            return callback.title;
        }
    }

    private class TopicWrapper
    implements Topic,
    Target {
        private URL _url;
        private String _label;

        public TopicWrapper(URL url) {
            this._url = url;
        }

        public URL getActiveIcon() {
            return null;
        }

        public URL getDefaultIcon() {
            return null;
        }

        public String getLabel() {
            return this._label;
        }

        public Book getParentBook() {
            return null;
        }

        public Target getTarget() {
            return this;
        }

        public boolean hasTarget() {
            return true;
        }

        public URL getURL() {
            return this._url;
        }

        public void setLabel(String label) {
            this._label = label;
        }
    }

    private static final class URLPair {
        private URL _nodeURL;
        private URL _topicURL;

        public URL getNodeURL() {
            return this._nodeURL;
        }

        public void setNodeURL(URL nodeURL) {
            this._nodeURL = nodeURL;
        }

        public URL getTopicURL() {
            return this._topicURL;
        }

        public void setTopicURL(URL topicURL) {
            this._topicURL = topicURL;
        }
    }
}

