/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;
import oracle.help.common.Topic;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.library.Library;
import oracle.help.topicDisplay.TopicDisplay;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.view.View;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpContentPanel;
import oracle.jdevimpl.help.HelpNavigatorToolbar;
import oracle.jdevimpl.help.HelpSystemConstants;
import oracle.jdevimpl.help.HelpTopicDocument;
import oracle.jdevimpl.help.JDevHelpSystemImpl;

public class HelpTopicEditor
extends Editor {
    private boolean _initialized;
    private HelpTopicDocument _helpDocument;
    private HelpContentPanel _helpContentPanel;
    private JPanel _panel;
    private HelpTopicEditorController _controller;
    private boolean _sharable;
    private Object _parent;
    private boolean _helpSystemDependent;
    public static final int HELP_RELATED = 0;
    public static final int NON_HELP_RELATED = 1;
    private static final String HELP_ID = "f1_helptopic_html";

    private void $init$() {
        this._panel = new JPanel();
        this._sharable = true;
        this._helpSystemDependent = true;
    }

    public HelpTopicEditor() {
        this.$init$();
        this._controller = new HelpTopicEditorController();
    }

    HelpTopicEditor(HelpContentPanel helpContentPanel) {
        this();
        this._helpContentPanel = helpContentPanel;
    }

    public TopicDisplay getTopicDisplayPanel() {
        if (this._helpContentPanel == null) {
            this._init((JDevHelpSystemImpl)HelpSystem.getHelpSystem());
        }
        return this._helpContentPanel.getTopicPanel();
    }

    public TopicDisplay getTopicDisplay() {
        if (this._helpContentPanel == null) {
            return null;
        }
        return this._helpContentPanel.getTopicPanel();
    }

    public void displayTopic(Topic topic) {
        this._helpDocument.setTopic(topic);
        if (topic.getLabel() != null) {
            Ide.getMainWindow().updateTitle();
        }
        this.getTopicDisplayPanel().displayTopic(topic);
    }

    public Object getEditorAttribute(String attribute) {
        if (attribute.equals("vertical_scrollbar_policy")) {
            return new Integer(21);
        }
        return super.getEditorAttribute(attribute);
    }

    public HTMLBrowser getBrowser() {
        return this._helpContentPanel.getBrowser();
    }

    public HelpTopicDocument getHelpTopicDocument() {
        return this._helpDocument;
    }

    public HelpContentPanel getHelpContentPanel() {
        return this._helpContentPanel;
    }

    public Toolbar getToolbar() {
        return this._helpContentPanel != null ? this._helpContentPanel._toolbar : null;
    }

    public boolean isSharable() {
        return this._sharable;
    }

    public void setSharable(boolean sharable) {
        this._sharable = sharable;
    }

    public Object getParent() {
        if (this._parent != null) {
            return this._parent;
        }
        return this.owner();
    }

    public void setParent(Object parent) {
        this._parent = parent;
    }

    public ContextMenu getContextMenu() {
        return this._helpContentPanel.getContextMenu();
    }

    public void activate() {
        super.activate();
        Toolbar tbar = this.getToolbar();
        if (tbar != null && tbar instanceof HelpNavigatorToolbar) {
            ((HelpNavigatorToolbar)tbar).setActiveToolbar(true);
        }
    }

    public void deactivate() {
        super.deactivate();
        Toolbar tbar = this.getToolbar();
        if (tbar != null && tbar instanceof HelpNavigatorToolbar) {
            ((HelpNavigatorToolbar)tbar).setActiveToolbar(false);
        }
    }

    public Controller getController() {
        return this._controller;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo(HELP_ID);
    }

    public Component getGUI() {
        return this._panel;
    }

    public void update(Object observed, UpdateMessage change) {
        if (change.getMessageID() == UpdateMessage.ATTRIBUTE_CHANGED) {
            Ide.getMainWindow().updateTitle();
        }
    }

    public synchronized void setContext(Context context) {
        Node node = context.getNode();
        if (node instanceof HelpTopicDocument) {
            super.setContext(context);
            this._helpDocument = (HelpTopicDocument)node;
            if (node.getURL() != null) {
                this._helpDocument.setURL(node.getURL());
            }
        } else if (node.getURL() != null) {
            super.setContext(context);
            this._helpDocument = new HelpTopicDocument(node.getURL());
        }
        this._helpDocument.attach((Observer)this);
    }

    public void open() {
        if (!this._initialized && this._init((JDevHelpSystemImpl)HelpSystem.getHelpSystem())) {
            this._initialized = true;
        }
        if (this._helpDocument.getTopic() != null) {
            this._helpContentPanel.getTopicPanel().displayTopic(this._helpDocument.getTopic());
            this._helpDocument.ensureOpen();
        }
    }

    public boolean isHelpSystemDependent() {
        return this._helpDocument.isHelpDependent();
    }

    public String getTitleLabel() {
        return HelpArb.getString(166);
    }

    public String getTabLabel() {
        return HelpArb.getString(151);
    }

    public Icon getTabIcon() {
        return HelpArb.getIcon(107);
    }

    public Component getDefaultFocusComponent() {
        return GraphicsUtils.getFocusableComponentOrChild((Component)this._helpContentPanel.getTopicPanel().getDisplayContainer(), (boolean)true);
    }

    public void close() {
        super.close();
        EditorManager.getEditorManager().removeLayoutListener(this.getId());
        this._controller = null;
        if (this._helpContentPanel != null) {
            this._helpContentPanel.dispose();
        }
        this._helpContentPanel = null;
    }

    private boolean _init(JDevHelpSystemImpl helpSys) {
        if (this._helpContentPanel == null) {
            if (this._helpDocument.isHelpDependent()) {
                this._helpSystemDependent = true;
                Library library = helpSys.getLibrary();
                this._helpContentPanel = library != null ? new HelpContentPanel(library, true, false, (Object)this) : new HelpContentPanel((Object)this);
            } else {
                this._helpSystemDependent = false;
                this._helpContentPanel = new HelpContentPanel((Object)this);
            }
        }
        this._panel.setLayout(new BorderLayout());
        this._panel.add(this._helpContentPanel.getGUI(), "Center");
        return true;
    }

    static HelpContentPanel ra$_helpContentPanel(HelpTopicEditor helpTopicEditor) {
        return helpTopicEditor._helpContentPanel;
    }

    private class HelpTopicEditorController
    implements Controller {
        private IdeAction _findAction = IdeAction.find((int)23);
        private IdeAction _closeAction = IdeAction.find((int)48);
        private IdeAction _closeAllAction = IdeAction.find((int)39);
        private IdeAction _copyAction = IdeAction.find((int)18);
        private IdeAction _printAction = IdeAction.find((int)16);

        public boolean update(IdeAction action, Context context) {
            View view;
            if (context != null && (view = context.getView()) instanceof HelpTopicEditor) {
                int cmdId = action.getCommandId();
                if (cmdId == 23) {
                    action.setEnabled(true);
                    return true;
                }
                if (cmdId == 48) {
                    action.setEnabled(true);
                    return true;
                }
                if (cmdId == 39) {
                    action.setEnabled(true);
                    return true;
                }
                if (cmdId == 18) {
                    action.setEnabled(HelpTopicEditor.ra$_helpContentPanel(HelpTopicEditor.this).isTextSelected());
                    return true;
                }
                if (cmdId == 16) {
                    action.setEnabled(true);
                    return true;
                }
                if (cmdId == HelpSystemConstants.BACKWARD_CMD_ID) {
                    return HelpTopicEditor.ra$_helpContentPanel(HelpTopicEditor.this).getController().update(action, context);
                }
                if (cmdId == HelpSystemConstants.FORWARD_CMD_ID) {
                    return HelpTopicEditor.ra$_helpContentPanel(HelpTopicEditor.this).getController().update(action, context);
                }
            }
            return false;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            View view;
            int cmdId = action.getCommandId();
            if (context != null && (view = context.getView()) instanceof HelpTopicEditor) {
                if (cmdId == 23) {
                    HelpTopicEditor.ra$_helpContentPanel(HelpTopicEditor.this).runFindDialog();
                    return true;
                }
                if (cmdId == 18) {
                    HelpTopicEditor.ra$_helpContentPanel(HelpTopicEditor.this).copy();
                    return true;
                }
                if (cmdId == HelpSystemConstants.BACKWARD_CMD_ID) {
                    HelpTopicEditor.ra$_helpContentPanel(HelpTopicEditor.this).getController().handleEvent(action, context);
                } else if (cmdId == HelpSystemConstants.FORWARD_CMD_ID) {
                    HelpTopicEditor.ra$_helpContentPanel(HelpTopicEditor.this).getController().handleEvent(action, context);
                }
            }
            return false;
        }
    }
}

