/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import oracle.bali.ewt.dTree.DTreeItemFactory;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.java.tree.TopicTreeComponent;
import oracle.help.java.tree.TopicTreeItem;
import oracle.help.java.tree.TopicTreeListener;
import oracle.help.java.tree.TopicTreePane;
import oracle.help.java.util.ImageLoader;
import oracle.help.navigator.favoritesNavigator.FavoriteItemFactory;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.ide.Context;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.border.JavatoolsBorderFactory;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpCenterWindow;
import oracle.jdevimpl.help.HelpTopicDocument;
import oracle.jdevimpl.help.HelpTopicEditor;
import oracle.jdevimpl.help.JDevNavigator;
import oracle.jdevimpl.help.MultipleTypeTopic;

class HelpUtils {
    static String getTagFromHTML(URL htmlURL, HTML.Tag htmlTag, boolean accumulateText, int lengthLimit) {
        String retval = null;
        Logger LOG = Logger.getLogger(HelpUtils.class.getName());
        if (!URLFileSystem.exists((URL)htmlURL)) {
            return retval;
        }
        ParserDelegator pd = new ParserDelegator();
        1Callback callback = new 1Callback(lengthLimit, accumulateText, htmlTag);
        InputStreamReader reader = null;
        try {
            try {
                reader = new InputStreamReader(URLFileSystem.openInputStream((URL)htmlURL), "ISO-8859-1");
                pd.parse(reader, callback, false);
            }
            catch (ChangedCharSetException e) {
                String spec = e.getCharSetSpec();
                Pattern p = Pattern.compile("charset=\"?(.+)\"?\\s*;?", 2);
                Matcher m = p.matcher(spec);
                String charset = m.find() ? m.group(1) : "ISO-8859-1";
                InputStreamReader realReader = null;
                try {
                    try {
                        realReader = new InputStreamReader(URLFileSystem.openInputStream((URL)htmlURL), charset);
                        1Callback.wa$inTag(callback, false);
                        pd.parse(realReader, callback, true);
                    }
                    catch (Exception ioe) {
                        LOG.log(Level.SEVERE, "Failed to load " + htmlURL, ioe);
                    }
                }
                catch (Throwable throwable) {
                    HelpUtils.forceClose(realReader);
                    throw throwable;
                }
                HelpUtils.forceClose(realReader);
            }
            catch (IOException ioe) {
                LOG.log(Level.SEVERE, "Failed to load " + htmlURL, ioe);
            }
        }
        catch (Throwable throwable) {
            HelpUtils.forceClose(reader);
            throw throwable;
        }
        HelpUtils.forceClose(reader);
        retval = 1Callback.ra$title(callback);
        return retval;
    }

    private static void forceClose(InputStreamReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void addFavoriteItem(FavoritesModel favoritesModel, String topicTitle, String topicURLString, Window parent) {
        JPanel panel = new JPanel();
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        helpSystem.registerTopic((JComponent)panel, "f1_idedaddfavorites_html");
        JButton newFolderBtn = new JButton();
        ResourceUtils.resButton((AbstractButton)newFolderBtn, (String)HelpArb.getString(88));
        JButton renameBtn = new JButton();
        ResourceUtils.resButton((AbstractButton)renameBtn, (String)HelpArb.getString(18));
        JButton deleteBtn = new JButton();
        ResourceUtils.resButton((AbstractButton)deleteBtn, (String)HelpArb.getString(32));
        panel.setLayout(new GridBagLayout());
        Insets fldInsets = new Insets(0, 5, 5, 5);
        Insets lblInsets = new Insets(5, 5, 2, 5);
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, lblInsets, 0, 0);
        JLabel label = new JLabel();
        JTextField nameField = new JTextField(50);
        nameField.setText(topicTitle);
        ResourceUtils.resLabel((JLabel)label, (Component)nameField, (String)HelpArb.getString(11));
        panel.add((Component)label, gbc);
        ++gbc.gridy;
        gbc.insets = fldInsets;
        panel.add((Component)nameField, gbc);
        TopicTreeNode rootTopicTreeNode = favoritesModel.getFavoritesRoot().getParent();
        TopicTreeComponent tree = new TopicTreeComponent(rootTopicTreeNode, (DTreeItemFactory)new FavoriteItemFactory(favoritesModel));
        tree.setPreferredItemsOnScreen(5);
        TopicTreePane treePane = new TopicTreePane(tree);
        boolean enableOkButton = false;
        if (rootTopicTreeNode.hasChildren()) {
            TopicTreeNode firstRootChild = rootTopicTreeNode.getChildByIndex(0);
            tree.selectTopicTreeNode(firstRootChild);
            enableOkButton = true;
        }
        treePane.addTopicTreeListener((TopicTreeListener)new 1(favoritesModel, renameBtn, deleteBtn));
        label = new JLabel();
        ResourceUtils.resLabel((JLabel)label, (Component)treePane, (String)HelpArb.getString(123));
        ++gbc.gridy;
        gbc.insets = lblInsets;
        panel.add((Component)label, gbc);
        ++gbc.gridy;
        gbc.gridheight = 4;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 5, 5, 5);
        panel.add((Component)treePane, gbc);
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout());
        btnPanel.add(newFolderBtn);
        renameBtn.setEnabled(false);
        btnPanel.add(renameBtn);
        deleteBtn.setEnabled(false);
        btnPanel.add(deleteBtn);
        deleteBtn.addActionListener(new 2(treePane, favoritesModel));
        gbc.gridy += 4;
        gbc.gridheight = 1;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        panel.add((Component)btnPanel, gbc);
        HelpJEWTDialog dlg = HelpJEWTDialog.createDialog(parent, HelpArb.getString(99));
        dlg.setContent(panel);
        dlg.setInitialFocus(nameField);
        dlg.setDefaultButton(1);
        dlg.setOKButtonEnabled(enableOkButton);
        newFolderBtn.addActionListener(new 3(dlg, treePane, favoritesModel, tree));
        renameBtn.addActionListener(new 4(dlg, treePane, favoritesModel));
        if (WizardLauncher.runDialog((JDialog)((Object)dlg))) {
            TopicTreeNode parentNode = treePane.getSelectedItem().getTopicTreeNode();
            favoritesModel.addFavoriteItem(nameField.getText(), null, null, topicURLString, parentNode);
        }
    }

    static HelpTopicEditor createHelpTopicEditor(String urlString) {
        SimpleURLTarget theTarget = new SimpleURLTarget(null, urlString);
        SimpleTopic theTopic = new SimpleTopic(null, (Target)theTarget);
        Context topicContext = HelpUtils.createContext((Topic)theTopic);
        return HelpUtils.createHelpTopicEditor(topicContext, (Topic)theTopic);
    }

    static Context createContext(Topic topic) {
        HelpTopicDocument htd = null;
        try {
            htd = new HelpTopicDocument(topic);
        }
        catch (Exception e) {
            Context context = null;
            return context;
        }
        Context ctx = Context.newIdeContext((Node)htd);
        ctx.setWorkspace(null);
        ctx.setProject(null);
        return ctx;
    }

    static HelpTopicEditor createHelpTopicEditor(Context context, Topic topic) {
        HelpTopicEditor helpTopicEditor = HelpCenterWindow.findEditorForTopic(topic);
        if (helpTopicEditor == null) {
            helpTopicEditor = new HelpTopicEditor();
            helpTopicEditor.setContext(context);
            helpTopicEditor.displayTopic(topic);
            HelpCenterWindow helpCenterWindow = HelpCenterWindow.getInstance();
            HelpCenterWindow.add(helpTopicEditor);
            helpTopicEditor.setParent(helpCenterWindow);
            GraphicsUtils.focusComponentOrChild((Component)helpTopicEditor.getGUI(), (boolean)true);
        } else {
            HelpCenterWindow.selectHelpTopicEditor(helpTopicEditor);
        }
        return helpTopicEditor;
    }

    static void setNavigatorBorderActive(JDevNavigator navigator, boolean active) {
        if (Themes.isThemed()) {
            String state = active ? "active" : "inactive";
            ThemeProperties themeProperties = Themes.getActiveTheme().getStateProperties("view", state);
            Color color = themeProperties.getColor("bordercolor");
            CompoundBorder cb = new CompoundBorder(JavatoolsBorderFactory.createLeftRightBorder((Color)color), JavatoolsBorderFactory.createBottomBorder((Color)color));
            if (navigator instanceof JPanel) {
                ((JPanel)((Object)navigator)).setBorder(cb);
            }
        }
    }

    static Icon getIconForTopic(Topic topic) {
        Icon resultIcon = null;
        Image resultImage = null;
        Image active = ImageLoader.loadImage((URL)topic.getActiveIcon());
        if (active != null) {
            resultImage = active;
        }
        if (resultImage == null) {
            resultImage = ImageLoader.loadImage((URL)topic.getDefaultIcon());
        }
        if (resultImage != null) {
            resultIcon = new ImageIcon(resultImage);
        }
        if (resultImage == null && topic instanceof MultipleTypeTopic) {
            MultipleTypeTopic mtt = (MultipleTypeTopic)topic;
            switch (mtt.getTopicType()) {
                case 3: {
                    resultIcon = HelpArb.getIcon(83);
                    break;
                }
                case 9: {
                    resultIcon = OracleIcons.getIcon((String)"forum.png");
                    break;
                }
                case 2: 
                case 7: 
                case 8: {
                    resultIcon = HelpArb.getIcon(49);
                    break;
                }
                case 6: 
                case 10: {
                    resultIcon = HelpArb.getIcon(113);
                    break;
                }
                default: {
                    resultIcon = HelpArb.getIcon(158);
                    break;
                }
            }
        }
        if (resultIcon == null) {
            resultIcon = HelpArb.getIcon(158);
        }
        return resultIcon;
    }

    HelpUtils() {
    }

    static class 1Callback
    extends HTMLEditorKit.ParserCallback {
        private boolean inTag;
        private String title;
        private final /* synthetic */ int v$lengthLimit;
        private final /* synthetic */ boolean v$accumulateText;
        private final /* synthetic */ HTML.Tag v$htmlTag;

        public void handleText(char[] data, int pos) {
            if (this.inTag) {
                if (this.title == null) {
                    this.title = new String(data);
                    if (this.title.length() > this.v$lengthLimit) {
                        this.title = this.title.substring(0, this.v$lengthLimit - 3);
                        this.title = this.title + HelpArb.getString(135);
                    }
                } else if (this.v$accumulateText && this.title.length() < this.v$lengthLimit) {
                    int titleLen = this.title.length();
                    String tempString = new String(data);
                    if (titleLen + data.length > this.v$lengthLimit) {
                        this.title = this.title + " " + tempString.substring(0, this.v$lengthLimit - titleLen);
                        this.title = this.title + HelpArb.getString(135);
                    } else {
                        this.title = this.title + " " + tempString;
                    }
                }
            }
        }

        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            if (t == this.v$htmlTag) {
                this.inTag = true;
            }
        }

        public void handleEndTag(HTML.Tag t, int pos) {
            if (t == this.v$htmlTag) {
                this.inTag = false;
            }
        }

        1Callback(int n, boolean bl, HTML.Tag tag) {
            this.v$htmlTag = tag;
            this.v$accumulateText = bl;
            this.v$lengthLimit = n;
        }

        static void wa$inTag(1Callback callback, boolean bl) {
            callback.inTag = bl;
        }

        static String ra$title(1Callback callback) {
            return callback.title;
        }
    }

    static final class 1
    implements TopicTreeListener {
        private final /* synthetic */ FavoritesModel v$favoritesModel;
        private final /* synthetic */ JButton v$renameBtn;
        private final /* synthetic */ JButton v$deleteBtn;

        public void topicActivated(TopicTreeItem item, boolean newWindow) {
        }

        public void popupDisplayed(TopicTreeItem item, JPopupMenu popup) {
        }

        public void topicSelected(TopicTreeItem item) {
            boolean enabled = item != null && item.getTopicTreeNode() != this.v$favoritesModel.getFavoritesRoot();
            this.v$renameBtn.setEnabled(enabled);
            this.v$deleteBtn.setEnabled(enabled);
        }

        public 1(FavoritesModel favoritesModel, JButton jButton, JButton jButton2) {
            this.v$deleteBtn = jButton2;
            this.v$renameBtn = jButton;
            this.v$favoritesModel = favoritesModel;
        }
    }

    static final class 2
    implements ActionListener {
        private final /* synthetic */ TopicTreePane v$treePane;
        private final /* synthetic */ FavoritesModel v$favoritesModel;

        public void actionPerformed(ActionEvent e) {
            TopicTreeItem tti = this.v$treePane.getSelectedItem();
            if (tti != null) {
                TopicTreeNode ttn = tti.getTopicTreeNode();
                TopicTreeNode parent = ttn.getParent();
                this.v$favoritesModel.removeFavoriteItem(ttn);
                this.v$treePane.selectTopicTreeNode(parent);
            }
        }

        public 2(TopicTreePane topicTreePane, FavoritesModel favoritesModel) {
            this.v$favoritesModel = favoritesModel;
            this.v$treePane = topicTreePane;
        }
    }

    static final class 3
    implements ActionListener {
        private final /* synthetic */ HelpJEWTDialog v$dlg;
        private final /* synthetic */ TopicTreePane v$treePane;
        private final /* synthetic */ FavoritesModel v$favoritesModel;
        private final /* synthetic */ TopicTreeComponent v$tree;

        public void actionPerformed(ActionEvent e) {
            HelpJEWTDialog newFolderDlg = new HelpJEWTDialog((Dialog)((Object)this.v$dlg), HelpArb.getString(126));
            JPanel panel = new JPanel(new BorderLayout());
            JTextField nameField = new JTextField();
            nameField.setText(HelpArb.getString(15));
            JLabel nameLbl = new JLabel();
            ResourceUtils.resLabel((JLabel)nameLbl, (Component)nameField, (String)HelpArb.getString(65));
            panel.add((Component)nameLbl, "West");
            panel.add((Component)nameField, "Center");
            newFolderDlg.setContent(panel);
            newFolderDlg.setInitialFocus(nameField);
            newFolderDlg.setDefaultButton(1);
            newFolderDlg.addVetoableChangeListener(new 1(this, nameField));
            if (WizardLauncher.runDialog((JDialog)((Object)newFolderDlg))) {
                TopicTreeItem tti = this.v$treePane.getSelectedItem();
                TopicTreeNode ttn = tti.getTopicTreeNode();
                this.v$favoritesModel.addFavoriteItem(nameField.getText(), null, null, null, ttn);
                int numChildren = ttn.getNumChildren();
                int i = 0;
                while (i < numChildren) {
                    TopicTreeNode childNode = ttn.getChildByIndex(i);
                    if (childNode.getTopic().getLabel().equals(nameField.getText())) {
                        this.v$tree.selectTopicTreeNode(childNode);
                        break;
                    }
                    ++i;
                }
            }
        }

        public 3(HelpJEWTDialog helpJEWTDialog, TopicTreePane topicTreePane, FavoritesModel favoritesModel, TopicTreeComponent topicTreeComponent) {
            this.v$tree = topicTreeComponent;
            this.v$favoritesModel = favoritesModel;
            this.v$treePane = topicTreePane;
            this.v$dlg = helpJEWTDialog;
        }

        static HelpJEWTDialog ra$v$dlg(3 var0) {
            return var0.v$dlg;
        }

        final class 1
        implements VetoableChangeListener {
            private final /* synthetic */ JTextField v$nameField;
            final /* synthetic */ 3 this$0;

            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && !ModelUtil.hasLength((String)this.v$nameField.getText())) {
                    JOptionPane.showMessageDialog((Component)((Object)3.ra$v$dlg(this.this$0)), HelpArb.getString(165), HelpArb.getString(98), 0);
                    throw new PropertyVetoException("no", evt);
                }
            }

            public 1(3 var1_1, JTextField jTextField) {
                this.v$nameField = jTextField;
                this.this$0 = var1_1;
            }
        }
    }

    static final class 4
    implements ActionListener {
        private final /* synthetic */ HelpJEWTDialog v$dlg;
        private final /* synthetic */ TopicTreePane v$treePane;
        private final /* synthetic */ FavoritesModel v$favoritesModel;

        public void actionPerformed(ActionEvent e) {
            HelpJEWTDialog renameDlg = new HelpJEWTDialog((Dialog)((Object)this.v$dlg), HelpArb.getString(69));
            JPanel panel = new JPanel(new BorderLayout());
            JTextField nameField = new JTextField();
            TopicTreeItem tti = this.v$treePane.getSelectedItem();
            nameField.setText(tti.getTopic().getLabel());
            JLabel nameLbl = new JLabel();
            ResourceUtils.resLabel((JLabel)nameLbl, (Component)nameField, (String)HelpArb.getString(11));
            panel.add((Component)nameLbl, "West");
            panel.add((Component)nameField, "Center");
            renameDlg.setContent(panel);
            renameDlg.setInitialFocus(nameField);
            renameDlg.setDefaultButton(1);
            renameDlg.addVetoableChangeListener(new 1(this, nameField));
            if (WizardLauncher.runDialog((JDialog)((Object)renameDlg))) {
                this.v$favoritesModel.renameFavoriteItem(tti.getTopicTreeNode(), nameField.getText());
            }
        }

        public 4(HelpJEWTDialog helpJEWTDialog, TopicTreePane topicTreePane, FavoritesModel favoritesModel) {
            this.v$favoritesModel = favoritesModel;
            this.v$treePane = topicTreePane;
            this.v$dlg = helpJEWTDialog;
        }

        static HelpJEWTDialog ra$v$dlg(4 var0) {
            return var0.v$dlg;
        }

        final class 1
        implements VetoableChangeListener {
            private final /* synthetic */ JTextField v$nameField;
            final /* synthetic */ 4 this$0;

            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && !ModelUtil.hasLength((String)this.v$nameField.getText())) {
                    JOptionPane.showMessageDialog((Component)((Object)4.ra$v$dlg(this.this$0)), HelpArb.getString(106), HelpArb.getString(98), 0);
                    throw new PropertyVetoException("no", evt);
                }
            }

            public 1(4 var1_1, JTextField jTextField) {
                this.v$nameField = jTextField;
                this.this$0 = var1_1;
            }
        }
    }

    static class HelpJEWTDialog
    extends JEWTDialog {
        public HelpJEWTDialog(Dialog dialog, String title) {
            super(dialog, title, 3);
        }

        public HelpJEWTDialog(Frame frame, String title) {
            super(frame, title, 3);
        }

        public static HelpJEWTDialog createDialog(Window window, String title) {
            HelpJEWTDialog dlg = null;
            if (window instanceof Dialog) {
                dlg = new HelpJEWTDialog((Dialog)window, title);
            } else if (window instanceof Frame) {
                dlg = new HelpJEWTDialog((Frame)window, title);
            }
            return dlg;
        }

        public static void showErrorDialog(Window owner, String title, String message) {
            HelpJEWTDialog dlg = null;
            dlg = owner instanceof Dialog ? new HelpJEWTDialog((Dialog)owner, title) : new HelpJEWTDialog((Frame)owner, title);
            dlg.setButtonMask(1);
            dlg.getContentPane().setLayout(new BorderLayout());
            dlg.getContentPane().add((Component)new JLabel(message), "Center");
            dlg.setCenterOver(owner);
            dlg.pack();
            dlg.setResizable(true);
            dlg.setVisible(true);
        }
    }
}

