/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.library.Library;
import oracle.help.navigator.LazyNavigator;
import oracle.help.navigator.Navigator;
import oracle.help.navigator.NavigatorEvent;
import oracle.help.navigator.NavigatorListener;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.help.navigator.tocNavigator.TOCNavigator;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.layout.ViewId;
import oracle.ide.print.PrintManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.MultiMap;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.ideimpl.controls.SwitchablePanel;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.help.CueCardSet;
import oracle.jdevimpl.help.DynamicLinksNavigator;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpCenterWindow;
import oracle.jdevimpl.help.HelpContentPanel;
import oracle.jdevimpl.help.HelpContext;
import oracle.jdevimpl.help.HelpOptions;
import oracle.jdevimpl.help.JDevCueCardNavigator;
import oracle.jdevimpl.help.JDevFavoritesNavigator;
import oracle.jdevimpl.help.JDevHelpSystemImpl;
import oracle.jdevimpl.help.JDevNavigator;
import oracle.jdevimpl.help.JDevTOCNavigator;
import oracle.jdevimpl.help.MultipleTypeTopic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpWindow
extends DockableWindow
implements ContextMenuListener,
Controller,
ListSelectionListener,
ActionListener {
    private static final float SECTION_TOP = 1.0f;
    private static final float SECTION_MIDDLE = 2.0f;
    public static final String VIEW_TYPE = "HelpSystemAddin";
    public static final String NAME = "HelpWindow";
    private JPanel _panel;
    private SwitchablePanel _switchablePanel;
    private boolean _initialized;
    private DefaultCustomTabPage _TOCPage;
    private JDevTOCNavigator _TOCNavigator;
    private JDevFavoritesNavigator _favoritesNavigator;
    private DefaultCustomTabPage _favoritesPage;
    private DynamicLinksNavigator _dynamicLinksNavigator;
    private DefaultCustomTabPage _dynamicLinksPage;
    private JDevCueCardNavigator _cueCardNavigator;
    private DefaultCustomTabPage _cueCardPage;
    private DefaultCustomTabPage _errorPage;
    private JScrollPane _errorScrollPane;
    private String _windowTitle;
    private HelpNavigatorListener _helpNavigatorListener;
    private ContextMenu _contextMenu;
    private CustomTab _tabs;
    private DefaultCustomTabPage _currentPage;
    private JMultiLineLabel _helpText;
    private JTextArea _textArea;
    private JLabel _textAreaLbl;
    private boolean _uiInitialized;
    private JButton _removeTabBtn;
    private JButton _clearTextBtn;
    private Action _closeTabAction;
    private MouseListener _contextMenuMouseListener;
    private boolean _separateWindow;
    private boolean _addCueCardTab;
    private List<IdeAction> _tabActionList;
    private static final int PRINT_TOPIC_SUBTREE_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.PrintTopicSubtreeCmd");
    private static final int OPEN_CUE_CARD_VIEWER_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.OpenCueCardViewerCmd");
    private static final int TOC_TAB_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.TOCTabCmd");
    private static final int FAV_TAB_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.FAVTabCmd");
    private static final int CUE_TAB_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.CUETabCmd");
    private static final int DYN_TAB_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.DYNTabCmd");
    private static final int SEARCH_TAB_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.SearchTabCmd");
    private static final int LEFT = -1;
    private static final int RIGHT = 1;
    public static final int TOC_NAVIGATOR = 0;
    public static final int FAVORITES_NAVIGATOR = 1;
    public static final int DYNAMIC_LINKS_NAVIGATOR = 2;
    public static final int CUE_CARDS_NAVIGATOR = 3;
    public static final int ERROR_DISPLAY = 4;
    static final String FOCUSED_TAB_NODE = "HelpWindowFocusedTabNode";
    static final String FOCUSED_TAB_NUM = "TabNum";
    private static final String HELP_ID = "f1_helpnav_html";

    private void $init$() {
        this._panel = new JPanel();
        this._windowTitle = HelpArb.getString(115);
        this._closeTabAction = new TabCloseAction(null);
        this._contextMenuMouseListener = new ContextMenuMouseListener(null);
    }

    public HelpWindow(String viewId) {
        super(viewId);
        this.$init$();
        this._helpNavigatorListener = new HelpNavigatorListener(null);
        this._panel.setOpaque(false);
    }

    public String getTitleName() {
        return this._windowTitle;
    }

    public String getTabName() {
        return HelpArb.getString(121);
    }

    public Icon getTabIcon() {
        return HelpArb.getIcon(61);
    }

    public String getMenuTitle() {
        return HelpArb.getString(115);
    }

    public Component getGUI() {
        this._init();
        return this._panel;
    }

    public Toolbar getToolbar() {
        if (this._currentPage == this._dynamicLinksPage) {
            return this._dynamicLinksNavigator.getToolbar();
        }
        if (this._currentPage == this._favoritesPage) {
            return this._favoritesNavigator.getToolbar();
        }
        return null;
    }

    public int getType() {
        return 32;
    }

    public JDevTOCNavigator getTOCNavigator() {
        return this._TOCNavigator;
    }

    public void updateTitle() {
        super.updateTitle((Object)this._windowTitle);
        this.fireTitleChangeListener();
    }

    public static ViewId getHelpWindowViewId() {
        return new ViewId("HelpSystemAddin.HelpWindow");
    }

    final void switchNavigator(int displayNavigator) {
        if (displayNavigator == 4) {
            if (!this._uiInitialized) {
                this._initializeUI();
            }
            this._addErrorTab();
            this._tabs.setSelectedPage(this._tabs.searchPage((CustomTabPage)this._errorPage));
        } else {
            Object userObject;
            if (!this._init()) {
                return;
            }
            DefaultCustomTabPage desiredPage = this.getTabPageForIntPage(displayNavigator);
            this.setSelectedTabToTab((CustomTabPage)desiredPage);
            if (desiredPage instanceof DefaultCustomTabPage && (userObject = desiredPage.getUserObject()) instanceof NavigatorHolder) {
                NavigatorHolder holder = (NavigatorHolder)userObject;
                GraphicsUtils.focusComponentOrChild((Component)holder, (boolean)true);
            }
        }
    }

    void setSeparateWindow(boolean separateWindow) {
        this._separateWindow = separateWindow;
    }

    private void saveLastFocusedTab(DefaultCustomTabPage tabPage) {
        HelpOptions opts = HelpOptions.getInstance();
        int windowType = this._separateWindow ? 2 : 1;
        opts.setLastTabFocused(this.getPageIntForPage(tabPage), windowType);
    }

    private void setSelectedTabToTab(CustomTabPage tabPage) {
        ListModel model = this._tabs.getModel();
        int numPages = model.getSize();
        int i = 0;
        while (i < numPages) {
            if (model.getElementAt(i) == tabPage) {
                this._tabs.setSelectedPage(i);
                return;
            }
            ++i;
        }
        this._handleDisplay(tabPage, true);
        this._setPageShowOption(tabPage, true);
        this.setSelectedTabToTab(tabPage);
        this.saveLastFocusedTab((DefaultCustomTabPage)tabPage);
    }

    protected void dockableHidden(DockableEvent evt) {
        if (this._currentPage == this._dynamicLinksPage) {
            this._dynamicLinksNavigator.deactivate();
        }
        super.dockableHidden(evt);
    }

    protected void dockableShown(DockableEvent e) {
        if (this._currentPage == this._dynamicLinksPage && this._dynamicLinksNavigator != null) {
            this._dynamicLinksNavigator.activate();
        }
        super.dockableShown(e);
    }

    public void close() {
        this.dispose();
        super.close();
    }

    public void dispose() {
        if (this._initialized) {
            this._helpNavigatorListener.removeListener();
            this._TOCPage.setUserObject(null);
            this._favoritesPage.setUserObject(null);
            this._dynamicLinksPage.setUserObject(null);
            if (this._cueCardPage != null) {
                this._cueCardPage.setUserObject(null);
            }
            this._switchablePanel = null;
            this._textArea.setText(null);
            this._TOCNavigator = null;
            this._favoritesNavigator = null;
            this._dynamicLinksNavigator = null;
            this._cueCardNavigator = null;
            IdeAction dropDownAction = IdeAction.find((int)EditorManagerImpl.SHOW_DROPDOWN_CMD_ID);
            dropDownAction.removeController((Controller)this);
            this._initialized = false;
        }
    }

    public boolean isPrintingEnabled() {
        if (this._currentPage != null && this._currentPage.getUserObject() != null) {
            Component comp = (Component)this._currentPage.getUserObject();
            if (comp instanceof TOCNavigator) {
                return this._TOCNavigator.getCurrentSelection() != null;
            }
            return false;
        }
        return false;
    }

    public void putError(String errorMessage) {
        if (this._textArea != null) {
            this._textArea.append(errorMessage + "\n");
            this._clearTextBtn.setEnabled(true);
            this._addErrorTab();
            this._tabs.setSelectedPage(4);
        }
    }

    void setActive(boolean active) {
        if (this._TOCNavigator != null) {
            this._TOCNavigator.setActive(active);
        }
        if (this._favoritesNavigator != null) {
            this._favoritesNavigator.setActive(active);
        }
        if (this._cueCardNavigator != null) {
            this._cueCardNavigator.setActive(active);
        }
        if (this._dynamicLinksNavigator != null) {
            this._dynamicLinksNavigator.setActive(active);
        }
    }

    public ContextMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            this._contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        if (this._currentPage != null) {
            return this._contextMenu;
        }
        return null;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo(HELP_ID);
    }

    public Controller getController() {
        return this;
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        this.addMenuItems(popup, null);
    }

    public void menuWillHide(ContextMenu popup) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        LazyNavigator lazyNav;
        if (e.getFirstIndex() == -1) {
            return;
        }
        DefaultCustomTabPage page = (DefaultCustomTabPage)this._tabs.getPage(e.getFirstIndex());
        if (page == this._currentPage) {
            return;
        }
        this.saveLastFocusedTab(page);
        Component targetComponent = (Component)page.getUserObject();
        NavigatorHolder holder = null;
        if (targetComponent instanceof NavigatorHolder) {
            holder = (NavigatorHolder)targetComponent;
            targetComponent = holder.getNavigator();
        }
        if (targetComponent == null) {
            this._initNavigatorHolder(page);
            targetComponent = ((NavigatorHolder)page.getUserObject()).getNavigator();
        }
        if (targetComponent == null) {
            targetComponent = this._errorScrollPane;
            page = this._errorPage;
        }
        this._helpNavigatorListener.removeListener();
        this._currentPage = page;
        this.updateSelection();
        if (targetComponent instanceof Navigator) {
            this._helpNavigatorListener.addListenerToNavigator((Navigator)targetComponent);
        }
        if (targetComponent == this._TOCNavigator) {
            if (!this._TOCNavigator.isInitialized()) {
                this._TOCNavigator.initializeLazyNavigator();
            }
        } else if (targetComponent instanceof LazyNavigator && !(lazyNav = (LazyNavigator)targetComponent).isInitialized()) {
            lazyNav.initializeLazyNavigator();
        }
        if (targetComponent instanceof JDevNavigator) {
            ((JDevNavigator)((Object)targetComponent)).setActive(true);
        }
    }

    private void _setPageShowOption(CustomTabPage page, boolean show) {
        int windowType;
        HelpOptions opts = HelpOptions.getInstance();
        int n = windowType = this._separateWindow ? 2 : 1;
        if (page == this._TOCPage) {
            opts.setTOCLocation(windowType, show);
        } else if (page == this._favoritesPage) {
            opts.setFavoritesLocation(windowType, show);
        } else if (page == this._dynamicLinksPage) {
            opts.setDynamicLinksLocation(windowType, show);
        } else if (page == this._cueCardPage) {
            opts.setCueCardsLocation(windowType, show);
        }
    }

    private void _toggleTab(int cmdId) {
        HelpOptions opts = HelpOptions.getInstance();
        int windowType = this._separateWindow ? 2 : 1;
        DefaultCustomTabPage page = null;
        boolean showPage = false;
        int pageNum = -1;
        if (cmdId == TOC_TAB_CMD_ID) {
            showPage = HelpOptions.isNavigatorShown(opts.getTOCLocation(), windowType) ^ true;
            opts.setTOCLocation(windowType, showPage);
            pageNum = 0;
            page = this._TOCPage;
        } else if (cmdId == FAV_TAB_CMD_ID) {
            showPage = HelpOptions.isNavigatorShown(opts.getFavoritesLocation(), windowType) ^ true;
            opts.setFavoritesLocation(windowType, showPage);
            pageNum = 1;
            page = this._favoritesPage;
        } else if (cmdId == DYN_TAB_CMD_ID) {
            showPage = HelpOptions.isNavigatorShown(opts.getDynamicLinksLocation(), windowType) ^ true;
            opts.setDynamicLinksLocation(windowType, showPage);
            pageNum = 2;
            page = this._dynamicLinksPage;
        } else if (cmdId == CUE_TAB_CMD_ID) {
            showPage = HelpOptions.isNavigatorShown(opts.getCueCardsLocation(), windowType) ^ true;
            opts.setCueCardsLocation(windowType, showPage);
            pageNum = 3;
            page = this._cueCardPage;
        }
        this._handleDisplay((CustomTabPage)page, showPage);
        if (showPage) {
            this.switchNavigator(pageNum);
        } else {
            int targetPosition = this._determineNavigation(-1);
            if (targetPosition != -1) {
                this._tabs.setSelectedPage(targetPosition);
            } else {
                targetPosition = this._determineNavigation(1);
                if (targetPosition != -1) {
                    this._tabs.setSelectedPage(targetPosition);
                }
            }
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == PRINT_TOPIC_SUBTREE_CMD_ID) {
            TopicTreeNode selectedNode = this._TOCNavigator.getCurrentSelectionNode();
            Topic[] topics = selectedNode.getAllTopicsInSubTree();
            Context newContext = new Context(context);
            HelpContext.setTopics(newContext, topics);
            PrintManager.getPrintManager().handleEvent(IdeAction.find((int)16), newContext);
            return true;
        }
        if (cmdId == 70) {
            this._navigate(-1);
            return true;
        }
        if (cmdId == 71) {
            this._navigate(1);
            return true;
        }
        if (cmdId == EditorManagerImpl.SHOW_DROPDOWN_CMD_ID) {
            if (context.getView() instanceof HelpWindow) {
                this._switchablePanel.displayDropdownMenu();
                return true;
            }
        } else {
            if (cmdId == OPEN_CUE_CARD_VIEWER_CMD_ID) {
                CueCardSet cueCardSet = (CueCardSet)this._cueCardNavigator.getCurrentSelection();
                this._cueCardNavigator.selectCueCardSet(cueCardSet);
                return true;
            }
            if (cmdId == TOC_TAB_CMD_ID || cmdId == FAV_TAB_CMD_ID || cmdId == SEARCH_TAB_CMD_ID || cmdId == DYN_TAB_CMD_ID || cmdId == CUE_TAB_CMD_ID) {
                this._toggleTab(cmdId);
                return true;
            }
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (action == null) {
            return false;
        }
        int cmdId = action.getCommandId();
        if (cmdId == 16) {
            action.setEnabled(this.isPrintingEnabled());
            return true;
        }
        if (cmdId == 70) {
            action.setEnabled(this._determineNavigation(-1) != -1);
            return true;
        }
        if (cmdId == 71) {
            action.setEnabled(this._determineNavigation(1) != -1);
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._removeTabBtn) {
            this._textArea.setText(null);
            this._switchablePanel.removePage((CustomTabPage)this._errorPage);
        } else if (e.getSource() == this._clearTextBtn) {
            this._textArea.setText(null);
            this._textArea.requestFocusInWindow();
            this._clearTextBtn.setEnabled(false);
        }
    }

    private synchronized boolean _init() {
        if (!this._uiInitialized) {
            this._initializeUI();
        }
        if (this._initialized) {
            return true;
        }
        Library library = HelpWindow.getLibrary();
        HelpSystem helpSys = HelpSystem.getHelpSystem();
        if (library != null) {
            int windowType;
            oracle.help.common.View[] views = library.getAllViews();
            if (views != null) {
                int i = 0;
                while (i < views.length) {
                    String labelString = views[i].getLabel();
                    if (labelString != null && labelString.equals("Cue Cards")) {
                        this._addCueCardTab = true;
                        break;
                    }
                    ++i;
                }
            }
            IdeSettings settings = Ide.getSettings();
            HelpOptions opts = (HelpOptions)((Object)settings.getData("HelpOptions"));
            int n = windowType = this._separateWindow ? 2 : 1;
            if (HelpOptions.isNavigatorShown(opts.getTOCLocation(), windowType)) {
                this._switchablePanel.addPage((CustomTabPage)this._TOCPage, (Component)this._TOCPage.getUserObject());
            }
            if (HelpOptions.isNavigatorShown(opts.getFavoritesLocation(), windowType)) {
                this._switchablePanel.addPage((CustomTabPage)this._favoritesPage, (Component)this._favoritesPage.getUserObject());
            }
            if (HelpOptions.isNavigatorShown(opts.getDynamicLinksLocation(), windowType)) {
                this._switchablePanel.addPage((CustomTabPage)this._dynamicLinksPage, (Component)this._dynamicLinksPage.getUserObject());
            }
            if (this._addCueCardTab && HelpOptions.isNavigatorShown(opts.getCueCardsLocation(), windowType)) {
                this._switchablePanel.addPage((CustomTabPage)this._cueCardPage, (Component)this._cueCardPage.getUserObject());
            }
            int focusedTab = -1;
            if (helpSys != null && helpSys instanceof JDevHelpSystemImpl) {
                focusedTab = opts.getLastTabFocused(this._separateWindow ? 2 : 1);
            }
            this._currentPage = focusedTab == -1 ? this.getTabPageForIntPage(2) : this.getTabPageForIntPage(focusedTab);
            this._handleDisplay((CustomTabPage)this._currentPage, true);
            NavigatorHolder holder = (NavigatorHolder)this._currentPage.getUserObject();
            if (holder.getNavigator() == null) {
                this._initNavigatorHolder(this._currentPage);
            }
            Navigator topNavigator = holder.getNavigator();
            this._helpNavigatorListener.addListenerToNavigator(topNavigator);
            this._switchablePanel.moveToFront((Component)holder);
            this.setSelectedTabToTab((CustomTabPage)this._currentPage);
            this._tabs.addHierarchyListener((HierarchyListener)new TabHierarchyListener(null));
            if (topNavigator instanceof LazyNavigator) {
                ((LazyNavigator)topNavigator).initializeLazyNavigator();
            } else if (topNavigator instanceof JDevTOCNavigator) {
                ((JDevTOCNavigator)topNavigator).initializeLazyNavigator();
            }
            this._panel.revalidate();
            this._initialized = true;
            this._removeErrorTab();
            this._removeTabBtn.setEnabled(true);
            return true;
        }
        if (helpSys instanceof JDevHelpSystemImpl) {
            this._setInitializationErrors((JDevHelpSystemImpl)helpSys);
        }
        this._initialized = false;
        this._addErrorTab();
        this._switchablePanel.moveToFront((Component)this._errorScrollPane);
        this._removeTabBtn.setEnabled(false);
        return false;
    }

    static Library getLibrary() {
        JDevHelpSystemImpl helpSys = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
        Library library = helpSys.getLibrary();
        return library;
    }

    private void _initNavigatorHolder(DefaultCustomTabPage tabPage) {
        Library library = HelpWindow.getLibrary();
        if (tabPage == this._TOCPage) {
            this._initTOCNavigator(library);
        } else if (tabPage == this._favoritesPage) {
            this._initFavoritesNavigator(library);
        } else if (tabPage == this._dynamicLinksPage) {
            this._initDynamicLinksNavigator(library);
        } else if (tabPage == this._cueCardPage) {
            this._initCueCardNavigator(library);
        }
    }

    private boolean _initTOCNavigator(Library library) {
        boolean retval = false;
        if (library != null) {
            try {
                JDevHelpSystemImpl helpSys = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
                MultiMap<String, JDevHelpSystemImpl.BookContributor> bookMap = helpSys.getBookMap();
                this._TOCNavigator = new JDevTOCNavigator(this, library, bookMap);
                NavigatorHolder holder = (NavigatorHolder)this._TOCPage.getUserObject();
                holder.setNavigator((Navigator)this._TOCNavigator);
                this._TOCNavigator.setBorder(new EmptyBorder(0, 0, 0, 0));
                retval = true;
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
                this._removeTabBtn.setEnabled(false);
            }
        }
        return retval;
    }

    private boolean _initFavoritesNavigator(Library library) {
        boolean retval = false;
        HelpSystem helpSys = HelpSystem.getHelpSystem();
        if (library != null) {
            try {
                FavoritesModel favoritesModel;
                if (helpSys != null && helpSys instanceof JDevHelpSystemImpl && (favoritesModel = ((JDevHelpSystemImpl)helpSys).getFavoritesModel()) != null) {
                    this._favoritesNavigator = new JDevFavoritesNavigator(this, library, "Favorites");
                    this._favoritesNavigator.setFavoritesModel(favoritesModel);
                    NavigatorHolder holder = (NavigatorHolder)this._favoritesPage.getUserObject();
                    holder.setNavigator((Navigator)this._favoritesNavigator);
                    this._favoritesNavigator.setBorder(new EmptyBorder(0, 0, 0, 0));
                    retval = true;
                }
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
                this._removeTabBtn.setEnabled(false);
            }
        }
        return retval;
    }

    private boolean _initDynamicLinksNavigator(Library library) {
        boolean retval = false;
        if (library != null) {
            try {
                this._dynamicLinksNavigator = (DynamicLinksNavigator)Navigator.createNavigator((String)"oracle.jdevimpl.help.DynamicLinksNavigator", (Library)library, (String)"Dynamic Links", null, (boolean)true);
                NavigatorHolder holder = (NavigatorHolder)this._dynamicLinksPage.getUserObject();
                holder.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                holder.setNavigator((Navigator)this._dynamicLinksNavigator);
                this._dynamicLinksNavigator.getTree().addMouseListener(this._contextMenuMouseListener);
                retval = true;
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
                this._removeTabBtn.setEnabled(false);
            }
        }
        return retval;
    }

    private boolean _initCueCardNavigator(Library library) {
        boolean retval = false;
        if (library != null) {
            try {
                this._cueCardNavigator = new JDevCueCardNavigator(this, library, "Cue Cards");
                NavigatorHolder holder = (NavigatorHolder)this._cueCardPage.getUserObject();
                holder.setNavigator((Navigator)this._cueCardNavigator);
                holder.setVisible(true);
                retval = true;
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
                this._removeTabBtn.setEnabled(false);
            }
        }
        return retval;
    }

    private void _initializeUI() {
        NavigatorHolder holder = new NavigatorHolder();
        this._TOCPage = new DefaultCustomTabPage(OracleIcons.getIcon((String)"library.png"), HelpArb.getString(72), (Object)holder);
        holder.setTabPage(this._TOCPage);
        this._TOCPage.setTooltip(HelpArb.getString(72));
        holder = new NavigatorHolder();
        this._favoritesPage = new DefaultCustomTabPage(OracleIcons.getIcon((String)"favorites.png"), HelpArb.getString(172), (Object)holder);
        holder.setTabPage(this._favoritesPage);
        this._favoritesPage.setTooltip(HelpArb.getString(172));
        holder = new NavigatorHolder();
        this._dynamicLinksPage = new DefaultCustomTabPage(OracleIcons.getIcon((String)"dynamicLink.png"), HelpArb.getString(159), (Object)holder);
        holder.setTabPage(this._dynamicLinksPage);
        this._dynamicLinksPage.setTooltip(HelpArb.getString(159));
        holder = new NavigatorHolder();
        this._cueCardPage = new DefaultCustomTabPage(HelpArb.getIcon(49), HelpArb.getString(147), (Object)holder);
        holder.setTabPage(this._cueCardPage);
        this._cueCardPage.setTooltip(HelpArb.getString(147));
        this._panel.setLayout(new BorderLayout());
        this._createErrorPage();
        Component[] comps = new Component[]{this._errorScrollPane};
        this._switchablePanel = new SwitchablePanel();
        this._tabs = this._switchablePanel.getCustomTab();
        this._switchablePanel.setOpaque(false);
        this._tabs.setOffsetSelected(0);
        this._tabs.addSelectionListener((ListSelectionListener)this);
        this._tabs.setCloseAction(this._closeTabAction);
        if (this._separateWindow) {
            this._switchablePanel.getCustomTab().setPosition(1);
        }
        this._tabs.addMouseListener((MouseListener)new CustomTabMouseListener(null));
        IdeAction dropDownAction = IdeAction.find((int)EditorManagerImpl.SHOW_DROPDOWN_CMD_ID);
        dropDownAction.addController((Controller)this);
        this._panel.add((Component)this._switchablePanel, "Center");
        this._uiInitialized = true;
    }

    CustomTab getCustomTab() {
        return this._tabs;
    }

    private int _getNumPagesNotCueCardViewer() {
        DefaultListModel model = this._switchablePanel.getModel();
        int numTabs = model.getSize();
        return numTabs;
    }

    private void _closeTabPage(CustomTabPage tabPage) {
        int numOpenTabs = this._getNumPagesNotCueCardViewer();
        if (numOpenTabs == 1) {
            this._switchablePanel.getCustomTab().setSelectedPage(-1);
        }
        this._switchablePanel.removePage(tabPage);
        this._setPageShowOption(tabPage, false);
    }

    private int _determineNavigation(int direction) {
        DefaultListModel listModel = this._switchablePanel.getModel();
        if (listModel.size() > 1) {
            int listPosition = listModel.indexOf(this._currentPage);
            if (listPosition == 0 && direction == -1) {
                return -1;
            }
            if (listPosition == listModel.size() - 1 && direction == 1) {
                return -1;
            }
            return listPosition + direction;
        }
        return -1;
    }

    private void _navigate(int direction) {
        int targetPosition = this._determineNavigation(direction);
        if (targetPosition != -1) {
            this._tabs.setSelectedPage(targetPosition);
        }
    }

    private void _createErrorPage() {
        if (this._errorPage == null) {
            JPanel errorPanel = new JPanel(new GridBagLayout());
            this._errorScrollPane = new JScrollPane(errorPanel);
            this._textAreaLbl = new JLabel();
            errorPanel.add((Component)this._textAreaLbl, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
            this._textArea = new JTextArea();
            ResourceUtils.resLabel((JLabel)this._textAreaLbl, (Component)this._textArea, (String)HelpArb.getString(46));
            this._textArea.setEditable(false);
            this._textArea.setLineWrap(true);
            this._textArea.setWrapStyleWord(true);
            JScrollPane scrollPane = new JScrollPane(this._textArea);
            scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
            errorPanel.add((Component)scrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this._clearTextBtn = new JButton();
            ResourceUtils.resButton((AbstractButton)this._clearTextBtn, (String)HelpArb.getString(78));
            errorPanel.add((Component)this._clearTextBtn, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this._clearTextBtn.addActionListener(this);
            this._clearTextBtn.setEnabled(false);
            this._helpText = new JMultiLineLabel(HelpArb.getString(47));
            errorPanel.add((Component)this._helpText, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
            this._removeTabBtn = new JButton();
            ResourceUtils.resButton((AbstractButton)this._removeTabBtn, (String)HelpArb.getString(141));
            errorPanel.add((Component)this._removeTabBtn, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this._removeTabBtn.addActionListener(this);
            this._errorPage = new DefaultCustomTabPage(HelpArb.getIcon(154), null, (Object)this._errorScrollPane);
            this._errorPage.setTooltip(HelpArb.getString(104));
        }
    }

    private void _setInitializationErrors(JDevHelpSystemImpl helpSys) {
        this._textArea.setText(null);
        List errorList = helpSys.getErrors();
        int errCount = errorList.size();
        this._clearTextBtn.setEnabled(true);
        int i = 0;
        while (i < errCount) {
            this._textArea.append((String)errorList.get(i));
            ++i;
        }
    }

    private void _removeErrorTab() {
        if (this._errorPage != null) {
            this._textArea.setText(null);
            this._switchablePanel.removePage((CustomTabPage)this._errorPage);
        }
    }

    private void _addErrorTab() {
        if (this._errorPage != null) {
            this._switchablePanel.addPage((CustomTabPage)this._errorPage, (Component)this._errorScrollPane);
        }
    }

    private int getPageIntForPage(DefaultCustomTabPage page) {
        int returnPage = -1;
        if (page == this._TOCPage) {
            returnPage = 0;
        } else if (page == this._favoritesPage) {
            returnPage = 1;
        } else if (page == this._dynamicLinksPage) {
            returnPage = 2;
        } else if (page == this._cueCardPage) {
            returnPage = 3;
        }
        return returnPage;
    }

    private DefaultCustomTabPage getTabPageForIntPage(int page) {
        DefaultCustomTabPage returnPage = null;
        if (page == 0) {
            returnPage = this._TOCPage;
        } else if (page == 1) {
            returnPage = this._favoritesPage;
        } else if (page == 2) {
            returnPage = this._dynamicLinksPage;
        } else if (page == 3) {
            returnPage = this._cueCardPage;
        }
        return returnPage;
    }

    private void _handleDisplay(CustomTabPage tabPage, boolean display) {
        boolean isCurrentlyDisplayed = false;
        Component comp = this._switchablePanel.getComponentForPage(tabPage);
        if (comp != null) {
            isCurrentlyDisplayed = true;
        }
        if (isCurrentlyDisplayed != display) {
            if (display) {
                int newPageNum = this.getPageIntForPage((DefaultCustomTabPage)tabPage);
                int pageNum = 0;
                int insertLocation = 0;
                DefaultListModel listModel = this._switchablePanel.getModel();
                int listLen = listModel.size();
                int i = 0;
                while (i < listLen && pageNum < newPageNum) {
                    DefaultCustomTabPage page = (DefaultCustomTabPage)listModel.elementAt(i);
                    pageNum = this.getPageIntForPage(page);
                    insertLocation = i;
                    if (i == listLen - 1 && pageNum < newPageNum) {
                        ++insertLocation;
                    }
                    ++i;
                }
                DefaultCustomTabPage dtabPage = (DefaultCustomTabPage)tabPage;
                NavigatorHolder holder = (NavigatorHolder)dtabPage.getUserObject();
                this._switchablePanel.addPage(tabPage, (Component)holder, insertLocation);
            } else {
                this._closeTabPage(tabPage);
            }
        }
    }

    void addMenuItems(Object popup, Topic topic) {
        boolean isCtxMenu = popup instanceof ContextMenu;
        ContextMenu cm = null;
        if (!isCtxMenu) {
            cm = this.getContextMenu();
            JPopupMenu pmenu = (JPopupMenu)popup;
            if (pmenu.getComponentCount() > 0) {
                pmenu.add(new JPopupMenu.Separator());
            }
        } else {
            cm = (ContextMenu)popup;
        }
        float currentItemLoc = 1.0f;
        if (this._currentPage != null && this._currentPage == this._TOCPage || this._currentPage == this._favoritesPage || this._currentPage == this._dynamicLinksPage) {
            Topic selTopic = topic;
            if (selTopic == null) {
                topic = this._currentPage == this._TOCPage ? this._TOCNavigator.getCurrentSelection() : (this._currentPage == this._favoritesPage ? this._favoritesNavigator.getCurrentSelection() : this._dynamicLinksNavigator.getCurrentSelection());
            }
            if (this._currentPage != null && this._currentPage == this._TOCPage) {
                IdeAction action = IdeAction.get((int)PRINT_TOPIC_SUBTREE_CMD_ID, null, (String)HelpArb.getString(97), null, (Integer)HelpArb.getInteger(92), (Icon)IdeArb.getIcon((int)69), null, (boolean)true);
                action.addController((Controller)this);
                action.setEnabled(topic != null);
                this._addMenuItemForAction(popup, action, 1.0f);
                if (!isCtxMenu && popup instanceof JPopupMenu) {
                    ((JPopupMenu)popup).addSeparator();
                }
            }
            if (this._currentPage != null && this._currentPage == this._favoritesPage && popup instanceof ContextMenu) {
                IdeAction action = this._favoritesNavigator.getNewFavoriteFolderAction();
                this._addMenuItemForAction(popup, action, currentItemLoc);
                action = this._favoritesNavigator.getAddExternalAction();
                this._addMenuItemForAction(popup, action, currentItemLoc);
                currentItemLoc = MenuConstants.increment((float)currentItemLoc);
                action = this._favoritesNavigator.getRenameFavoriteAction();
                this._addMenuItemForAction(popup, action, currentItemLoc);
                action = this._favoritesNavigator.getDeleteFavoriteAction();
                this._addMenuItemForAction(popup, action, currentItemLoc);
                ((ContextMenu)popup).addSeparator();
                currentItemLoc += MenuConstants.increment((float)currentItemLoc);
            }
        }
        if (this._currentPage != null && this._currentPage == this._cueCardPage) {
            CueCardSet cueCardSet = (CueCardSet)this._cueCardNavigator.getCurrentSelection();
            IdeAction action = IdeAction.get((int)OPEN_CUE_CARD_VIEWER_CMD_ID, null, (String)HelpArb.getString(95), null, (Integer)HelpArb.getInteger(119), null, null, null, (boolean)true);
            action.addController((Controller)this);
            action.setEnabled(cueCardSet != null);
            this._addMenuItemForAction(popup, action, 1.0f);
        }
        currentItemLoc = MenuConstants.increment((float)currentItemLoc);
        this._createAndAddTabMenuItems(popup, this._getActionsToToggleTabs(), true, currentItemLoc);
    }

    boolean isNavigatorAvailable(int navigator) {
        JDevHelpSystemImpl helpSys = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
        boolean available = helpSys.isNavigatorSupported(navigator);
        if (available && navigator == 3 && !this._addCueCardTab) {
            available = false;
        }
        return available;
    }

    private List<IdeAction> _getActionsToToggleTabs() {
        if (this._tabActionList == null) {
            this._tabActionList = new ArrayList<IdeAction>(4);
            String label = null;
            IdeAction action = null;
            if (this.isNavigatorAvailable(0)) {
                label = HelpArb.getString(72);
                action = IdeAction.get((int)TOC_TAB_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), null, null, null, (boolean)true);
                action = IdeAction.newLocalAction((int)TOC_TAB_CMD_ID, (View)this);
                action.addController((Controller)this);
                this._tabActionList.add(action);
            }
            if (this.isNavigatorAvailable(1)) {
                label = HelpArb.getString(172);
                action = IdeAction.get((int)FAV_TAB_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), null, null, null, (boolean)true);
                action = IdeAction.newLocalAction((int)FAV_TAB_CMD_ID, (View)this);
                action.addController((Controller)this);
                this._tabActionList.add(action);
            }
            if (this.isNavigatorAvailable(2)) {
                label = HelpArb.getString(159);
                action = IdeAction.get((int)DYN_TAB_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), null, null, null, (boolean)true);
                action = IdeAction.newLocalAction((int)DYN_TAB_CMD_ID, (View)this);
                action.addController((Controller)this);
                this._tabActionList.add(action);
            }
            if (this.isNavigatorAvailable(3)) {
                label = HelpArb.getString(147);
                action = IdeAction.get((int)CUE_TAB_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), null, null, null, (boolean)true);
                action = IdeAction.newLocalAction((int)CUE_TAB_CMD_ID, (View)this);
                action.addController((Controller)this);
                this._tabActionList.add(action);
            }
        }
        return this._tabActionList;
    }

    private boolean determineCheckboxState(IdeAction action, HelpOptions opts) {
        int windowType = this._separateWindow ? 2 : 1;
        int cmdId = action.getCommandId();
        if (cmdId == TOC_TAB_CMD_ID) {
            return HelpOptions.isNavigatorShown(opts.getTOCLocation(), windowType);
        }
        if (cmdId == FAV_TAB_CMD_ID) {
            return HelpOptions.isNavigatorShown(opts.getFavoritesLocation(), windowType);
        }
        if (cmdId == DYN_TAB_CMD_ID) {
            return HelpOptions.isNavigatorShown(opts.getDynamicLinksLocation(), windowType);
        }
        if (cmdId == CUE_TAB_CMD_ID) {
            return HelpOptions.isNavigatorShown(opts.getCueCardsLocation(), windowType);
        }
        if (cmdId == SEARCH_TAB_CMD_ID) {
            return HelpOptions.isNavigatorShown(opts.getSearchLocation(), windowType);
        }
        return false;
    }

    private void _createAndAddTabMenuItems(Object popup, List<IdeAction> tabActions, boolean createSubmenu, float menuSection) {
        boolean isCtxMenu = popup instanceof ContextMenu;
        ContextMenu cm = null;
        cm = !isCtxMenu ? this.getContextMenu() : (ContextMenu)popup;
        JMenu tabSubMenu = null;
        if (createSubmenu) {
            String label = HelpArb.getString(63);
            tabSubMenu = cm.createSubMenu(StringUtils.stripMnemonic((String)label), new Integer(StringUtils.getMnemonicKeyCode((String)label)));
        }
        HelpOptions opts = HelpOptions.getInstance();
        for (IdeAction tabAction : tabActions) {
            JCheckBoxMenuItem cbMenuItem = new JCheckBoxMenuItem((Action)tabAction);
            cbMenuItem.setSelected(this.determineCheckboxState(tabAction, opts));
            tabAction.setEnabled(true);
            if (createSubmenu) {
                tabSubMenu.add(cbMenuItem);
                continue;
            }
            cm.add((Component)cbMenuItem);
        }
        if (createSubmenu) {
            if (isCtxMenu) {
                cm.add((Component)tabSubMenu, menuSection);
            } else {
                ((JPopupMenu)popup).add(tabSubMenu);
            }
        }
    }

    private void _addMenuItemForAction(Object popup, IdeAction action, float location) {
        boolean isCtxMenu = popup instanceof ContextMenu;
        ContextMenu cm = null;
        cm = !isCtxMenu ? this.getContextMenu() : (ContextMenu)popup;
        JMenuItem menuItem = cm.createMenuItem((ToggleAction)action);
        if (isCtxMenu) {
            cm.add((Component)menuItem, location);
        } else {
            ((JPopupMenu)popup).add(menuItem);
        }
    }

    static void mav$_closeTabPage(HelpWindow helpWindow, CustomTabPage customTabPage) {
        helpWindow._closeTabPage(customTabPage);
    }

    static DefaultCustomTabPage ra$_currentPage(HelpWindow helpWindow) {
        return helpWindow._currentPage;
    }

    static DefaultCustomTabPage ra$_dynamicLinksPage(HelpWindow helpWindow) {
        return helpWindow._dynamicLinksPage;
    }

    static SwitchablePanel ra$_switchablePanel(HelpWindow helpWindow) {
        return helpWindow._switchablePanel;
    }

    static CustomTab ra$_tabs(HelpWindow helpWindow) {
        return helpWindow._tabs;
    }

    static void mav$_initNavigatorHolder(HelpWindow helpWindow, DefaultCustomTabPage defaultCustomTabPage) {
        helpWindow._initNavigatorHolder(defaultCustomTabPage);
    }

    static List mav$_getActionsToToggleTabs(HelpWindow helpWindow) {
        return helpWindow._getActionsToToggleTabs();
    }

    static void mav$_createAndAddTabMenuItems(HelpWindow helpWindow, Object object, List list, boolean bl, float f) {
        helpWindow._createAndAddTabMenuItems(object, list, bl, f);
    }

    private final class HelpNavigatorListener
    implements NavigatorListener {
        private Navigator _owner;

        public void addListenerToNavigator(Navigator navigator) {
            if (this._owner != null) {
                this._owner.removeNavigatorListener((NavigatorListener)this);
            }
            navigator.addNavigatorListener((NavigatorListener)this);
            this._owner = navigator;
        }

        public void removeListener() {
            if (this._owner != null) {
                this._owner.removeNavigatorListener((NavigatorListener)this);
                this._owner = null;
            }
        }

        public void topicSelected(NavigatorEvent e) {
        }

        public void topicActivated(NavigatorEvent e) {
            Topic topic = e.getTopic();
            if (topic instanceof CueCardSet) {
                HelpCenterWindow hcw = HelpCenterWindow.getInstance();
                hcw.showCueCardSet((CueCardSet)e.getTopic());
            } else if (topic instanceof MultipleTypeTopic) {
                MultipleTypeTopic mTopic = (MultipleTypeTopic)topic;
                if (mTopic.getTopicType() == 2) {
                    HelpCenterWindow hcw = HelpCenterWindow.getInstance();
                    hcw.showCueCardSetForId(mTopic.getCueCardId());
                } else if (mTopic.getTopicType() == 3) {
                    try {
                        URL externalURL = mTopic.getTarget().getURL();
                        BrowserRunner.getBrowserRunner().runBrowserOnURL(externalURL, null, null);
                    }
                    catch (MalformedURLException mue) {
                        Assert.println((String)"HelpWindow.HelpNavigatorListener.topicActivated() caught MalformedURLException");
                    }
                } else if (mTopic.getTopicType() == 7) {
                    HelpCenterWindow hcw = HelpCenterWindow.getInstance();
                    HelpContentPanel hcp = hcw.getCueCardViewer();
                    hcp.displayTopic((Topic)mTopic);
                    hcw.setVisible(true);
                    GraphicsUtils.focusComponentOrChild((Component)hcp.getGUI(), (boolean)true);
                } else if (topic.hasTarget()) {
                    JDevHelpSystemImpl helpSys = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
                    helpSys.showTopic(e.getTopic());
                }
            } else if (topic.hasTarget()) {
                Target target = topic.getTarget();
                if (target instanceof SimpleURLTarget) {
                    try {
                        URL targetURL = target.getURL();
                        if (targetURL.getProtocol().startsWith("http")) {
                            BrowserRunner.getBrowserRunner().runBrowserOnURL(targetURL, null, null);
                            return;
                        }
                    }
                    catch (MalformedURLException mue) {
                        // empty catch block
                    }
                }
                JDevHelpSystemImpl helpSys = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
                helpSys.showTopic(e.getTopic());
            }
        }

        private HelpNavigatorListener() {
        }

        HelpNavigatorListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class TabCloseAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            CustomTabPage tabPage = (CustomTabPage)e.getSource();
            HelpWindow.mav$_closeTabPage(HelpWindow.this, tabPage);
        }

        private TabCloseAction() {
        }

        TabCloseAction(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class ContextMenuMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._showContextMenu(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._showContextMenu(e);
            }
        }

        private void _showContextMenu(MouseEvent e) {
            JTree jtree;
            TreePath treePath;
            Context context = HelpWindow.this.getContext(e);
            if (HelpWindow.ra$_currentPage(HelpWindow.this) != null && HelpWindow.ra$_currentPage(HelpWindow.this) == HelpWindow.ra$_dynamicLinksPage(HelpWindow.this) && (treePath = (jtree = (JTree)e.getSource()).getPathForLocation(e.getX(), e.getY())) != null) {
                jtree.setSelectionPath(treePath);
            }
            HelpWindow.this.getContextMenu().show(context);
        }

        private ContextMenuMouseListener() {
        }

        ContextMenuMouseListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class TabHierarchyListener
    implements HierarchyListener {
        public void hierarchyChanged(HierarchyEvent e) {
            long cflags = e.getChangeFlags();
            if ((cflags & (long)4) == (long)4) {
                HelpWindow.ra$_switchablePanel(HelpWindow.this).ensureTabVisible();
                HelpWindow.ra$_tabs(HelpWindow.this).removeHierarchyListener((HierarchyListener)this);
            }
        }

        private TabHierarchyListener() {
        }

        TabHierarchyListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    final class NavigatorHolder
    extends JPanel {
        private Navigator _navigator;
        private DefaultCustomTabPage _tabPage;

        public void setTabPage(DefaultCustomTabPage tabPage) {
            this._tabPage = tabPage;
        }

        public Navigator getNavigator() {
            return this._navigator;
        }

        public void setNavigator(Navigator navigator) {
            this._navigator = navigator;
            this.setLayout(new BorderLayout());
            this.add((Component)navigator, "Center");
        }

        public void setVisible(boolean visible) {
            if (visible && this._navigator == null) {
                HelpWindow.mav$_initNavigatorHolder(HelpWindow.this, this._tabPage);
            }
            if (this._navigator != null) {
                this._navigator.setVisible(visible);
            }
            super.setVisible(visible);
        }

        NavigatorHolder() {
        }
    }

    private final class CustomTabMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._showContextMenu(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._showContextMenu(e);
            }
        }

        private void _showContextMenu(MouseEvent e) {
            ContextMenu cm = new ContextMenu();
            cm.addContextMenuListener((ContextMenuListener)new 1());
            Context context = HelpWindow.this.getContext(e);
            cm.show(context);
        }

        private CustomTabMouseListener() {
        }

        CustomTabMouseListener(1 var2_2) {
            this();
        }

        final class 1
        implements ContextMenuListener {
            public void menuWillShow(ContextMenu contextMenu) {
                HelpWindow.mav$_createAndAddTabMenuItems(HelpWindow.this, contextMenu, HelpWindow.mav$_getActionsToToggleTabs(HelpWindow.this), false, 2.0f);
            }

            public void menuWillHide(ContextMenu contextMenu) {
            }

            public boolean handleDefaultAction(Context context) {
                return false;
            }
        }
    }
}

