/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.View;
import oracle.help.library.Library;
import oracle.help.library.LibraryListener;
import oracle.help.navigator.NavigatorException;
import oracle.ide.Context;
import oracle.ide.resource.IdeArb;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.help.CueCardNavigator;
import oracle.jdevimpl.help.CueCardSet;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpUtils;
import oracle.jdevimpl.help.HelpWindow;
import oracle.jdevimpl.help.JDevNavigator;

public final class JDevCueCardNavigator
extends CueCardNavigator
implements JDevNavigator {
    private HelpWindow _helpWindow;

    public JDevCueCardNavigator(HelpWindow helpWindow, Library library, String label) throws NavigatorException {
        this._helpWindow = helpWindow;
        this.label = label;
        this.labelImage = null;
        this.library = library;
        this.filterByLabel = true;
        this.type = "oracle.jdevimpl.help.JDevCueCardNavigator";
        View[] initialViews = null;
        int iter = 0;
        this.listeners = new ListenerManager();
        this.views = new ArrayList();
        if (library != null) {
            this.library.addLibraryListener((LibraryListener)this);
            initialViews = this.filterViewsByLabel(library.getAllViews(), label);
            if (initialViews != null) {
                iter = 0;
                while (iter < initialViews.length) {
                    this.views.add(initialViews[iter]);
                    ++iter;
                }
            }
        }
        this.initNavigator(initialViews);
    }

    protected void addMouseListener(JTree tree) {
        super.addMouseListener(tree);
        JDevCueCardMouseAdapter mouseAdapter = new JDevCueCardMouseAdapter(null);
        tree.addMouseListener(mouseAdapter);
    }

    protected void addTreeCellRenderer(DefaultTreeCellRenderer renderer) {
        super.addTreeCellRenderer(renderer);
        renderer.setLeafIcon(HelpArb.getIcon(49));
        renderer.setOpenIcon(IdeArb.getIcon((int)74));
        renderer.setClosedIcon(OracleIcons.getIcon((String)"folder.png"));
    }

    void selectCueCardSet(CueCardSet cueCardSet) {
        if (cueCardSet != null) {
            this.fireTopicActivated(cueCardSet);
        }
    }

    public void setActive(boolean active) {
        HelpUtils.setNavigatorBorderActive(this, active);
    }

    static HelpWindow ra$_helpWindow(JDevCueCardNavigator jDevCueCardNavigator) {
        return jDevCueCardNavigator._helpWindow;
    }

    private class JDevCueCardMouseAdapter
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._showContextMenu(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._showContextMenu(e);
            }
        }

        private void _showContextMenu(MouseEvent e) {
            Context context = JDevCueCardNavigator.ra$_helpWindow(JDevCueCardNavigator.this).getContext(e);
            JDevCueCardNavigator.ra$_helpWindow(JDevCueCardNavigator.this).getContextMenu().show(context);
        }

        private JDevCueCardMouseAdapter() {
        }

        JDevCueCardMouseAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

