/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import oracle.bali.ewt.dTree.DTreeDeferringParent;
import oracle.bali.ewt.dTree.DTreeDeferringRoot;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemFactory;
import oracle.bali.ewt.dTree.DTreeRootItem;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.java.tree.TopicTreeComponent;
import oracle.help.java.tree.TopicTreeItem;
import oracle.help.java.tree.TopicTreeListener;
import oracle.help.java.tree.TopicTreeModel;
import oracle.help.java.tree.TopicTreePane;
import oracle.help.library.Library;
import oracle.help.library.LibraryListener;
import oracle.help.navigator.NavigatorException;
import oracle.help.navigator.favoritesNavigator.FavoriteBranchItem;
import oracle.help.navigator.favoritesNavigator.FavoriteItemFactory;
import oracle.help.navigator.favoritesNavigator.FavoriteLeafItem;
import oracle.help.navigator.favoritesNavigator.FavoritesActionUtils;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.help.navigator.favoritesNavigator.FavoritesNavigator;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpCenterWindow;
import oracle.jdevimpl.help.HelpNavigatorToolbar;
import oracle.jdevimpl.help.HelpUtils;
import oracle.jdevimpl.help.HelpWindow;
import oracle.jdevimpl.help.JDevHelpSystemImpl;
import oracle.jdevimpl.help.JDevNavigator;

public final class JDevFavoritesNavigator
extends FavoritesNavigator
implements JDevNavigator {
    private HelpWindow _helpWindow;
    private IdeAction _addExternalURLAction;
    private IdeAction _newFavoriteFolderAction;
    private IdeAction _renameFavoriteAction;
    private IdeAction _deleteFavoriteAction;
    private HelpNavigatorToolbar _toolbar;
    private DummyView _dummyView;
    private static FavoritesModel _favoritesModel;
    private static final int ADD_EXTERNAL_URL_CMD_ID;
    private static final int NEW_FAVORITES_FOLDER_CMD_ID;
    private static final int RENAME_FAVORITE_CMD_ID;
    private static final int DELETE_FAVORITE_CMD_ID;

    private void $init$() {
        this._dummyView = new DummyView(null);
    }

    public JDevFavoritesNavigator(HelpWindow helpWindow, Library library, String label) throws NavigatorException {
        HelpSystem helpSys;
        this.$init$();
        this._helpWindow = helpWindow;
        this.label = label;
        this.labelImage = null;
        this.library = library;
        this.filterByLabel = true;
        this.type = "oracle.jdevimpl.help.JDevFavoritesNavigator";
        oracle.help.common.View[] initialViews = null;
        int iter = 0;
        this.listeners = new ListenerManager();
        this.views = new ArrayList();
        if (library != null) {
            this.library.addLibraryListener((LibraryListener)this);
            initialViews = this.filterViewsByLabel(library.getAllViews(), label);
            if (initialViews != null) {
                iter = 0;
                while (iter < initialViews.length) {
                    this.views.add(initialViews[iter]);
                    ++iter;
                }
            }
        }
        if ((helpSys = HelpSystem.getHelpSystem()) != null && helpSys instanceof JDevHelpSystemImpl) {
            _favoritesModel = ((JDevHelpSystemImpl)helpSys).getFavoritesModel();
        }
        this.initNavigator(initialViews);
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public void setActive(boolean active) {
        this._toolbar.setActiveToolbar(active);
        HelpUtils.setNavigatorBorderActive(this, active);
    }

    protected void doInitializationNow() {
        super.doInitializationNow();
        this.setItemFactory();
        Component[] comps = this.getComponents();
        if (comps != null) {
            Component[] componentArray = comps;
            int n = 0;
            while (n < componentArray.length) {
                Component comp = componentArray[n];
                if (comp instanceof TopicTreePane) {
                    ((TopicTreePane)comp).setBorder(BorderFactory.createEmptyBorder());
                    this.remove(comp);
                    this.add(comp, "Center");
                    break;
                }
                ++n;
            }
        }
        this._toolbar = new HelpNavigatorToolbar();
        this._toolbar.add((Component)new ToolButton((Action)this.getNewFavoriteFolderAction()));
        this._toolbar.add((Component)new ToolButton((Action)this.getAddExternalAction()));
        this._toolbar.add((Component)new ToolButton((Action)this.getDeleteFavoriteAction()));
        this.add((Component)((Object)this._toolbar), "North");
        this.setBorder(BorderFactory.createEmptyBorder());
        this.addTopicTreeListener(new JDevFavoritesListener(null));
    }

    private void setItemFactory() {
        Component[] comps;
        Component[] componentArray = comps = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component c = componentArray[n];
            if (c instanceof TopicTreePane) {
                TopicTreePane ttp = (TopicTreePane)c;
                TopicTreeComponent ttc = ttp.getTopicTreeComponent();
                DTreeDeferringRoot root = (DTreeDeferringRoot)ttc.getRoot();
                String label = root.getLabel();
                Icon icon = root.getIcon();
                OneDModel model = root.getModel();
                JDevFavoritesItemFactory factory = new JDevFavoritesItemFactory(this.getFavoritesModel());
                DTreeDeferringRoot newRoot = new DTreeDeferringRoot(label, icon, model, (DTreeItemFactory)factory);
                ttc.setRoot((DTreeRootItem)newRoot);
            }
            ++n;
        }
    }

    IdeAction getAddExternalAction() {
        if (this._addExternalURLAction == null) {
            String label = HelpArb.getString(20);
            this._addExternalURLAction = IdeAction.get((int)ADD_EXTERNAL_URL_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (Icon)HelpArb.getIcon(83), null, (boolean)true);
            this._addExternalURLAction.addController((Controller)new 1());
        }
        return this._addExternalURLAction;
    }

    IdeAction getRenameFavoriteAction() {
        if (this._renameFavoriteAction == null) {
            String label = HelpArb.getString(18);
            this._renameFavoriteAction = IdeAction.get((int)RENAME_FAVORITE_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (Icon)OracleIcons.getIcon((String)"folderNew.png"), null, (boolean)true);
            this._renameFavoriteAction = IdeAction.newLocalAction((int)RENAME_FAVORITE_CMD_ID, (View)this._dummyView);
            this._renameFavoriteAction.addController((Controller)new 2());
        }
        return this._renameFavoriteAction;
    }

    IdeAction getNewFavoriteFolderAction() {
        if (this._newFavoriteFolderAction == null) {
            String label = HelpArb.getString(88);
            this._newFavoriteFolderAction = IdeAction.get((int)NEW_FAVORITES_FOLDER_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (Icon)OracleIcons.getIcon((String)"folderNew.png"), null, (boolean)true);
            this._newFavoriteFolderAction = IdeAction.newLocalAction((int)NEW_FAVORITES_FOLDER_CMD_ID, (View)this._dummyView);
            this._newFavoriteFolderAction.addController((Controller)new 3());
        }
        return this._newFavoriteFolderAction;
    }

    IdeAction getDeleteFavoriteAction() {
        if (this._deleteFavoriteAction == null) {
            String label = HelpArb.getString(32);
            this._deleteFavoriteAction = IdeAction.get((int)DELETE_FAVORITE_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (Icon)OracleIcons.getIcon((String)"delete.png"), null, (boolean)true);
            this._deleteFavoriteAction = IdeAction.newLocalAction((int)DELETE_FAVORITE_CMD_ID, (View)this._dummyView);
            this._deleteFavoriteAction.addController((Controller)new 4());
        }
        return this._deleteFavoriteAction;
    }

    static {
        ADD_EXTERNAL_URL_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.JDevFavoritesNavigator.AddExternalLinkAsFavoriteCmd");
        NEW_FAVORITES_FOLDER_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.NewFavoritesFolderCmd");
        RENAME_FAVORITE_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.RenameFavoriteCmd");
        DELETE_FAVORITE_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.DeleteFavoriteCmd");
    }

    static HelpWindow ra$_helpWindow(JDevFavoritesNavigator jDevFavoritesNavigator) {
        return jDevFavoritesNavigator._helpWindow;
    }

    static IdeAction ra$_deleteFavoriteAction(JDevFavoritesNavigator jDevFavoritesNavigator) {
        return jDevFavoritesNavigator._deleteFavoriteAction;
    }

    static FavoritesModel ra$_favoritesModel() {
        return _favoritesModel;
    }

    final class oracle.jdevimpl.help.JDevFavoritesNavigator$1
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0);
            JLabel label = new JLabel();
            JTextField nameField = new JTextField(50);
            ResourceUtils.resLabel((JLabel)label, (Component)nameField, (String)HelpArb.getString(143));
            panel.add((Component)label, gbc);
            ++gbc.gridy;
            panel.add((Component)nameField, gbc);
            HelpSystem helpSystem = HelpSystem.getHelpSystem();
            helpSystem.registerTopic((JComponent)panel, "f1_idedaddexternallink_html");
            ++gbc.gridy;
            label = new JLabel();
            URLTextField urlField = new URLTextField();
            urlField.setDirectoryOnly(false);
            ResourceUtils.resLabel((JLabel)label, (Component)urlField, (String)HelpArb.getString(124));
            panel.add((Component)label, gbc);
            ++gbc.gridy;
            panel.add((Component)urlField, gbc);
            TopicTreeNode rootTopicTreeNode = JDevFavoritesNavigator.ra$_favoritesModel().getFavoritesRoot().getParent();
            TopicTreeComponent tree = new TopicTreeComponent(rootTopicTreeNode, (DTreeItemFactory)new FavoriteItemFactory(JDevFavoritesNavigator.ra$_favoritesModel()));
            tree.setPreferredItemsOnScreen(5);
            TopicTreePane treePane = new TopicTreePane(tree);
            tree.selectTopicTreeNode(rootTopicTreeNode);
            label = new JLabel();
            ResourceUtils.resLabel((JLabel)label, (Component)tree, (String)HelpArb.getString(102));
            ++gbc.gridy;
            panel.add((Component)label, gbc);
            ++gbc.gridy;
            gbc.gridheight = 4;
            gbc.weighty = 1.0;
            panel.add((Component)treePane, gbc);
            Window window = HelpCenterWindow.getInstance().getWindow();
            JEWTDialog dlg = window instanceof JDialog ? new JEWTDialog((Dialog)((JDialog)window), HelpArb.getString(44), 3) : new JEWTDialog((Frame)((JFrame)window), HelpArb.getString(44), 3);
            dlg.setContent((Component)panel);
            dlg.setInitialFocus((Component)nameField);
            dlg.setDefaultButton(1);
            dlg.addVetoableChangeListener((VetoableChangeListener)new 1(this, nameField, urlField, dlg));
            if (WizardLauncher.runDialog((JDialog)dlg)) {
                TopicTreeNode parentNode = null;
                TopicTreeItem selectedItem = treePane.getSelectedItem();
                if (selectedItem != null) {
                    parentNode = selectedItem.getTopicTreeNode();
                }
                JDevFavoritesNavigator.ra$_favoritesModel().addFavoriteItem(nameField.getText(), null, null, urlField.getText(), parentNode);
            }
            return true;
        }

        public boolean update(IdeAction action, Context context) {
            action.setEnabled(true);
            return true;
        }

        final class 1
        implements VetoableChangeListener {
            private final /* synthetic */ JTextField v$nameField;
            private final /* synthetic */ URLTextField v$urlField;
            private final /* synthetic */ JEWTDialog v$dlg;
            final /* synthetic */ oracle.jdevimpl.help.JDevFavoritesNavigator$1 this$0;

            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    if (!ModelUtil.hasLength((String)this.v$nameField.getText()) || !ModelUtil.hasLength((String)this.v$urlField.getText())) {
                        JOptionPane.showMessageDialog((Component)this.v$dlg, HelpArb.getString(105), HelpArb.getString(130), 0);
                        throw new PropertyVetoException("no", evt);
                    }
                    String urlText = this.v$urlField.getText();
                    if (!urlText.startsWith("http") && !urlText.startsWith("file")) {
                        urlText = "http://" + urlText;
                        this.v$urlField.setText(urlText);
                    }
                    if (this.v$urlField.getURL() == null) {
                        JOptionPane.showMessageDialog((Component)this.v$dlg, HelpArb.getString(133), HelpArb.getString(130), 0);
                        throw new PropertyVetoException("no", evt);
                    }
                    boolean isValid = false;
                    try {
                        isValid = URLFileSystem.canRead((URL)this.v$urlField.getURL());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!isValid) {
                        JOptionPane.showMessageDialog((Component)this.v$dlg, HelpArb.getString(133), HelpArb.getString(130), 0);
                        throw new PropertyVetoException("no", evt);
                    }
                }
            }

            public 1(oracle.jdevimpl.help.JDevFavoritesNavigator$1 var1_1, JTextField jTextField, URLTextField uRLTextField, JEWTDialog jEWTDialog) {
                this.v$dlg = jEWTDialog;
                this.v$urlField = uRLTextField;
                this.v$nameField = jTextField;
                this.this$0 = var1_1;
            }
        }
    }

    final class 2
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            if (JDevFavoritesNavigator.ra$_favoritesModel() != null) {
                FavoritesActionUtils.renameFavoriteItem((Component)((Object)JDevFavoritesNavigator.this), (TopicTreeNode)JDevFavoritesNavigator.this.getCurrentSelectionNode(), (FavoritesModel)JDevFavoritesNavigator.ra$_favoritesModel());
            }
            return true;
        }

        public boolean update(IdeAction action, Context context) {
            TopicTreeNode treeNode = JDevFavoritesNavigator.this.getCurrentSelectionNode();
            action.setEnabled(treeNode != null);
            return true;
        }
    }

    final class 3
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            if (JDevFavoritesNavigator.ra$_favoritesModel() != null) {
                FavoritesActionUtils.createNewFolder((Component)((Object)JDevFavoritesNavigator.this), (TopicTreeNode)JDevFavoritesNavigator.this.getCurrentSelectionNode(), (FavoritesModel)JDevFavoritesNavigator.ra$_favoritesModel());
            }
            return true;
        }

        public boolean update(IdeAction action, Context context) {
            action.setEnabled(true);
            return true;
        }
    }

    final class 4
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            TopicTreeNode treeNode = JDevFavoritesNavigator.this.getCurrentSelectionNode();
            if (treeNode != null && JDevFavoritesNavigator.ra$_favoritesModel() != null) {
                JDevFavoritesNavigator.ra$_favoritesModel().removeFavoriteItem(treeNode);
            }
            return true;
        }

        public boolean update(IdeAction action, Context context) {
            TopicTreeNode treeNode = JDevFavoritesNavigator.this.getCurrentSelectionNode();
            action.setEnabled(treeNode != null);
            return true;
        }
    }

    private class JDevFavoritesListener
    implements TopicTreeListener {
        public void topicActivated(TopicTreeItem item, boolean newWindow) {
        }

        public void topicSelected(TopicTreeItem item) {
            JDevFavoritesNavigator.ra$_deleteFavoriteAction(JDevFavoritesNavigator.this).updateAction();
        }

        public void popupDisplayed(TopicTreeItem item, JPopupMenu popup) {
            int compCount = popup.getComponentCount();
            int i = 0;
            while (i < compCount) {
                popup.remove(0);
                ++i;
            }
            ContextMenu cm = new ContextMenu();
            JMenuItem menuItem = cm.createMenuItem((ToggleAction)JDevFavoritesNavigator.this.getNewFavoriteFolderAction());
            popup.add(menuItem);
            menuItem = cm.createMenuItem((ToggleAction)JDevFavoritesNavigator.this.getAddExternalAction());
            popup.add(menuItem);
            popup.addSeparator();
            menuItem = cm.createMenuItem((ToggleAction)JDevFavoritesNavigator.this.getRenameFavoriteAction());
            popup.add(menuItem);
            menuItem = cm.createMenuItem((ToggleAction)JDevFavoritesNavigator.this.getDeleteFavoriteAction());
            popup.add(menuItem);
            JDevFavoritesNavigator.ra$_helpWindow(JDevFavoritesNavigator.this).addMenuItems(popup, item.getTopic());
        }

        private JDevFavoritesListener() {
        }

        JDevFavoritesListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class JDevFavoritesItemFactory
    extends FavoriteItemFactory {
        private FavoritesModel _model;

        public JDevFavoritesItemFactory(FavoritesModel model) {
            super(model);
            this._model = model;
        }

        public DTreeItem createItem(DTreeDeferringParent parent, int index) {
            OneDModel src = parent.getModel();
            TopicTreeNode node = (TopicTreeNode)src.getData(index);
            JDevFavoriteLeafItem item = null;
            if (node == null) {
                return null;
            }
            item = node.isBranch() ? new FavoriteBranchItem((OneDModel)new TopicTreeModel(node), (DTreeItemFactory)this, this._model) : new JDevFavoriteLeafItem(this._model);
            node.setClientData((Object)item);
            return item;
        }

        private static final class JDevFavoriteLeafItem
        extends FavoriteLeafItem {
            public JDevFavoriteLeafItem(FavoritesModel model) {
                super(model);
            }

            public Icon getIcon() {
                Icon icon = null;
                Topic topic = this.getTopic();
                if (topic != null && topic.hasTarget() && topic.getTarget() instanceof SimpleURLTarget) {
                    SimpleURLTarget urlTarget = (SimpleURLTarget)topic.getTarget();
                    try {
                        if (urlTarget.getURL().getProtocol().startsWith("http")) {
                            icon = HelpArb.getIcon(83);
                        }
                    }
                    catch (MalformedURLException mue) {
                        // empty catch block
                    }
                }
                if (icon != null) {
                    return icon;
                }
                return OracleIcons.getIcon((String)"file.png");
            }
        }
    }

    private class DummyView
    extends View {
        public Component getGUI() {
            return null;
        }

        private DummyView() {
        }

        DummyView(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

