/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ide.extension.Extension;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.util.WindowUtils;
import oracle.help.Help;
import oracle.help.common.IndirectTarget;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.java.util.ImageLoader;
import oracle.help.library.Book;
import oracle.help.library.Library;
import oracle.help.library.LibraryException;
import oracle.help.navigator.favoritesNavigator.DefaultFavoritesModel;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.help.topicDisplay.TopicDisplayException;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.docking.DockStation;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.BrowseSymbolResolver;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.model.Node;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Assert;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.MultiMap;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.ide.view.View;
import oracle.javatools.util.SwingUtils;
import oracle.jdevimpl.help.DynamicLinkTarget;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpCenterWindow;
import oracle.jdevimpl.help.HelpContentPanel;
import oracle.jdevimpl.help.HelpContentWindow;
import oracle.jdevimpl.help.HelpHook;
import oracle.jdevimpl.help.HelpSystemAddin;
import oracle.jdevimpl.help.HelpTopicDocument;
import oracle.jdevimpl.help.HelpTopicEditor;
import oracle.jdevimpl.help.HelpUtils;
import oracle.jdevimpl.help.HelpWindow;
import oracle.jdevimpl.help.JDevHelpSet;
import oracle.jdevimpl.help.JDevImageLoader;
import oracle.jdevimpl.help.JDevLibrary;
import oracle.jdevimpl.help.JavadocBook;
import oracle.jdevimpl.help.ModalHelpContentDialog;
import oracle.jdevimpl.help.MultipleTypeTopic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JDevHelpSystemImpl
extends HelpSystem {
    public static final String LANGUAGE_HELP_BOOK_NAME = "...language-help...";
    private List<HelpJarInfo> _addinHelpSetList;
    private ArrayList _loadErrors;
    private JDevLibrary _library;
    private Dialog _modalOwner;
    private boolean _initialized;
    private static String _lastPrintString;
    private ModalHelpContentDialog _modalDialog;
    private HashMap _topicSubstitutes;
    private FavoritesModel _favoritesModel;
    private List _tipOfDayList;
    private boolean _hooksProcessedForTipJars;
    private boolean _hooksProcessedForHelpSetJars;
    private int[] _supportedNavigators;
    private static List _browseSymbolResolverList;
    private static String _editionDirectory;
    private MultiMap<String, BookContributor> _bookMap;
    private final boolean DEBUG;
    private static final int INITIALIZATION_ERROR = 0;
    private static final int DISPLAY_ERROR = 1;
    private static final String LAYOUT_FILE = "Help.windows";
    private static final String FAVORITES_FILE = "HelpBookmarks.xml";
    private static final String HELPSYSTEM_LAST_TIP_JAR = "JDevHelpSystemImpl.last-tip-jar";
    private static final String HELPSYSTEM_LAST_TIP = "JDevHelpSystemImpl.last-tip";
    private static final String HELPSYSTEM_SHOW_TIP_OF_DAY = "JDevHelpSystemImpl.show-tip";

    private void $init$() {
        this._addinHelpSetList = new ArrayList<HelpJarInfo>();
        this._loadErrors = new ArrayList();
        this._tipOfDayList = new ArrayList();
        this.DEBUG = false;
    }

    public JDevHelpSystemImpl() {
        this.$init$();
    }

    public Library getLibrary() {
        if (this._initialize()) {
            return this._library;
        }
        return null;
    }

    public void loadHelpWindows() {
        DefaultStructuredPropertyAccess dspa = null;
        dspa = this.getLayout();
        if (dspa == null) {
            return;
        }
        Iterator iterator = dspa.getChildNodes();
        while (iterator.hasNext()) {
            DefaultStructuredPropertyAccess childNode = (DefaultStructuredPropertyAccess)iterator.next();
            String nodeName = childNode.getName();
            if (!nodeName.equals("HelpWindow")) continue;
            HelpContentWindow.loadLayout(childNode);
        }
    }

    DefaultStructuredPropertyAccess getLayout() {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        URL url = er.getSystemDirectory(HelpSystemAddin.getExtensionID());
        File file = new File(url.getPath(), LAYOUT_FILE);
        DefaultStructuredPropertyAccess dspa = null;
        try {
            dspa = DefaultStructuredPropertyAccess.loadFromXML((File)file);
        }
        catch (Exception e) {
            // empty catch block
        }
        return dspa;
    }

    public List getErrors() {
        return this._loadErrors;
    }

    public final void showLanguageHelp(Context context, String symbolName) {
        JDevHelpSystemImpl.showLanguageHelpNonOHJ(context, symbolName);
    }

    final FavoritesModel getFavoritesModel() {
        if (this._favoritesModel == null) {
            if (this._library == null) {
                this._initialize();
            }
            if (this._library != null) {
                this._favoritesModel = new DefaultFavoritesModel(this._getHelpbookmarksFile(), (Library)this._library);
            }
        }
        return this._favoritesModel;
    }

    private URL _getHelpbookmarksFile() {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        URL url = er.getSystemDirectory(HelpSystemAddin.getExtensionID());
        return URLFactory.newURL((URL)url, (String)FAVORITES_FILE);
    }

    final void supportsNavigators(int[] supportedNavigators) {
        this._supportedNavigators = supportedNavigators;
    }

    final boolean isNavigatorSupported(int navigator) {
        int i = 0;
        while (i < this._supportedNavigators.length) {
            if (this._supportedNavigators[i] == navigator) {
                return true;
            }
            ++i;
        }
        return false;
    }

    Topic getTopicForString(String topicID) {
        return this.getTopicForString(topicID, true);
    }

    Topic getTopicForString(String topicID, boolean displayError) {
        SimpleTopic topic = null;
        if (topicID != null) {
            URL topicURL = this._library.mapIDToURL(topicID);
            if (topicURL != null) {
                SimpleTopic theTopic;
                SimpleURLTarget theTarget = new SimpleURLTarget(null, topicURL.toString());
                topic = theTopic = new SimpleTopic(null, (Target)theTarget);
            } else if (displayError) {
                this._showHelpError(1, HelpArb.format(30, topicID));
                Assert.println((String)("Cannot Display Topic:: no URL found for helpID=" + topicID));
            }
        } else if (displayError) {
            this._showHelpError(1, HelpArb.getString(52));
            Assert.println((String)"Cannot Display Topic:: Topic ID parameter was null");
        }
        return topic;
    }

    static final void showLanguageHelpNonOHJ(Context context, String symbolName) {
        1 swingWorker = new 1(symbolName, context);
        swingWorker.start();
    }

    public final boolean doesTopicExist(String helpTopic) {
        if (!this._initialize()) {
            this._showHelpError(0, null);
            return false;
        }
        URL helpURL = this._library.mapIDToURL(helpTopic);
        return helpURL != null;
    }

    public final Editor showHelp(URL url) {
        if (url == null) {
            throw new NullPointerException("url is null.");
        }
        HelpTopicDocument doc = new HelpTopicDocument(url);
        String shortLabel = URLFileSystem.getFileName((URL)url);
        doc.setShortLabel(shortLabel);
        Context context = Context.newIdeContext((Node)doc);
        return EditorManager.getEditorManager().openEditorInFrame(HelpTopicEditor.class, context);
    }

    public final void showHelp(JComponent comp) {
        if (Boolean.valueOf(System.getProperty("jdev.skip.help")).booleanValue()) {
            LogManager.getIdeLogWindow().getPage().log((Object)("Help ID: " + oracle.bali.ewt.help.HelpUtils.getHelpID((Component)comp) + "\n"));
            return;
        }
        if (!this._initialize()) {
            this._showHelpError(0, null);
            return;
        }
        2 r = new 2(this, comp);
        Window activeWindow = WindowUtils.getActiveWindow();
        if (activeWindow == null) {
            EventQueue.invokeLater(r);
        } else {
            r.run();
        }
    }

    public final void showHelp(Context ctx) {
        if (!this._initialize()) {
            this._showHelpError(0, null);
            return;
        }
        Context fCtx = ctx;
        3 r = new 3(this, fCtx);
        SwingUtilities.invokeLater(r);
    }

    public final void showHelp(HelpInfo helpInfo) {
        if (helpInfo != null && helpInfo.getHelpType() != 1 && !this._initialize()) {
            this._showHelpError(0, null);
            return;
        }
        HelpInfo fHelpInfo = helpInfo;
        4 r = new 4(this, fHelpInfo);
        SwingUtilities.invokeLater(r);
    }

    public final void registerTopic(JComponent component, String topicID) {
        String subst;
        if (this._topicSubstitutes != null && (subst = (String)this._topicSubstitutes.get(topicID)) != null) {
            topicID = subst;
        }
        oracle.bali.ewt.help.HelpUtils.setHelpID((JComponent)component, (String)topicID);
    }

    public final void registerClientWindow(Window aWindow) {
        Help.registerClientWindow((Window)aWindow);
    }

    public final void unregisterClientWindow(Window aWindow) {
        Help.unregisterClientWindow((Window)aWindow);
    }

    public void registerHelpSetURL(URL url) {
        this.registerHelpSetURL(url, null, -1);
    }

    public void registerHelpSetURL(URL url, String relativeTo, int relativePosition) {
        String origStr = url.toExternalForm();
        String[] splits = origStr.split(".jar!");
        this.registerHelpSetURL(splits[0], 0, url, relativeTo, relativePosition, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBrowseSymbolResolver(String resolverClass) {
        List list = _browseSymbolResolverList;
        synchronized (list) {
            _browseSymbolResolverList.add(resolverClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTipOfDayURL(URL url) {
        List list = this._tipOfDayList;
        synchronized (list) {
            if (URLFileSystem.exists((URL)url)) {
                this._tipOfDayList.add(url);
            }
        }
    }

    public MultiMap<String, BookContributor> getBookMap() {
        if (this._bookMap == null) {
            this._bookMap = new MultiMap();
            this._processManifestForHelpSetJars();
            this._fillBookMap(this._addinHelpSetList);
        }
        return this._bookMap;
    }

    public boolean hasTipOfDayEntries() {
        this._processManifestForTipJars();
        return this._tipOfDayList.size() > 0;
    }

    private Topic getTipOfTheDay(URL currentURL) {
        int numTipJars = this._tipOfDayList.size();
        if (numTipJars == 0) {
            return null;
        }
        Topic topic = null;
        DTCache dtCache = Ide.getDTCache();
        int lastJarNum = dtCache.getInteger(HELPSYSTEM_LAST_TIP_JAR, -1);
        int tipNum = dtCache.getInteger(HELPSYSTEM_LAST_TIP, 0);
        if (++lastJarNum >= this._tipOfDayList.size()) {
            lastJarNum = 0;
            ++tipNum;
        }
        dtCache.putInteger(HELPSYSTEM_LAST_TIP_JAR, lastJarNum);
        dtCache.putInteger(HELPSYSTEM_LAST_TIP, tipNum);
        URL tipJarURL = (URL)this._tipOfDayList.get(lastJarNum);
        try {
            JarIndex jarIndex = JarUtil.getJarIndex((URL)tipJarURL);
            String[] entries = jarIndex.getEntries();
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < entries.length) {
                if (entries[i].endsWith("html")) {
                    list.add(entries[i]);
                }
                ++i;
            }
            int tipsAvail = list.size();
            if (tipsAvail == 0) {
                Assert.println((String)("No .html entries found in tip jar:  " + tipJarURL));
                Topic topic2 = null;
                return topic2;
            }
            if (tipNum >= tipsAvail) {
                tipNum %= tipsAvail;
            }
            String selectedEntry = (String)list.get(tipNum);
            URL entryURL = URLFactory.newJarURL((URL)tipJarURL, (String)selectedEntry);
            if (currentURL != null) {
                String currentPath = currentURL.getPath();
                currentPath = this.replaceEditionString(currentPath);
                String selectedPath = entryURL.getPath();
                if (currentPath.equals(selectedPath = this.replaceEditionString(selectedPath))) {
                    Topic topic3 = this.getTipOfTheDay(currentURL);
                    return topic3;
                }
            }
            HelpTopicDocument helpDocument = new HelpTopicDocument(entryURL);
            topic = helpDocument.getTopic();
        }
        catch (IOException ex) {
            Topic topic4 = null;
            return topic4;
        }
        return topic;
    }

    private String replaceEditionString(String path) {
        String newPath = path;
        newPath = newPath.replace("java_doc", "");
        newPath = newPath.replace("j2ee_doc", "");
        newPath = newPath.replace("studio_doc", "");
        return newPath;
    }

    public static boolean getShowTipOfDayPreference() {
        DTCache dtCache = Ide.getDTCache();
        return dtCache.getBoolean(HELPSYSTEM_SHOW_TIP_OF_DAY, true);
    }

    public void showTipOfTheDay() {
        boolean suppressTip = Boolean.valueOf(System.getProperty("suppressTipOfDay"));
        if (suppressTip) {
            return;
        }
        Topic topic = this.getTipOfTheDay(null);
        if (topic == null) {
            return;
        }
        TipOfDayDialog dialog = new TipOfDayDialog(SwingUtils.getAncestorFrame((Component)Ide.getMainWindow()));
        if (dialog == null) {
            return;
        }
        dialog.getHelpContentPanel().displayTopic(topic);
        dialog.setOKButtonEnabled(true);
        dialog.setInitialFocus((JPanel)dialog.getHelpContentPanel().getTopicPanel());
        dialog.setTitle(HelpArb.getString(36));
        dialog.setButtonMask(16);
        JButton nextTipBtn = new JButton();
        ResourceUtils.resButton((AbstractButton)nextTipBtn, (String)HelpArb.getString(125));
        nextTipBtn.addActionListener(new 5(this, dialog));
        dialog.addCustomButton(nextTipBtn);
        6 runnable = new 6(this, dialog);
        IdeUtil.invokeAfterRepaint((Runnable)runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHelpSetURL(String name, int helpAction, URL controlFileURL, String relativeToName, int relativeLocation, Map<String, String> bookMap) {
        if (name == null) {
            return;
        }
        List<HelpJarInfo> list = this._addinHelpSetList;
        synchronized (list) {
            int locationInList = this._findLocationInList(name, this._addinHelpSetList);
            if (helpAction == 1 && locationInList > -1) {
                this._addinHelpSetList.remove(locationInList);
            } else if (locationInList == -1) {
                this._addinHelpSetList.add(new HelpJarInfo(name, controlFileURL, relativeToName, relativeLocation, bookMap));
            } else {
                HelpJarInfo helpJarInfo = this._addinHelpSetList.get(locationInList);
                helpJarInfo.update(controlFileURL, relativeToName, relativeLocation, bookMap);
            }
        }
    }

    protected void showTopic(Topic topic) {
        if (topic != null) {
            MultipleTypeTopic mTopic;
            if (topic instanceof MultipleTypeTopic && (mTopic = (MultipleTypeTopic)topic).getTopicType() == 4) {
                JDevHelpSystemImpl.showLanguageHelpNonOHJ(Context.newIdeContext(), mTopic.getLanguageString());
                return;
            }
            Context context = HelpUtils.createContext(topic);
            HelpTopicEditor helpTopicEditor = null;
            if (context != null) {
                helpTopicEditor = HelpUtils.createHelpTopicEditor(context, topic);
            }
            if (helpTopicEditor == null) {
                String err = null;
                Target target = topic.getTarget();
                if (target != null) {
                    err = target instanceof DynamicLinkTarget ? ((DynamicLinkTarget)target).getTopicId() : (target instanceof IndirectTarget ? ((IndirectTarget)target).getTargetName() : target.toString());
                }
                Assert.println((String)("Failed opening Editor on " + err));
                JDevHelpSystemImpl.showErrorMessage((Component)Ide.getMainWindow(), HelpArb.format(164, err), HelpArb.getString(7));
            } else {
                try {
                    HelpCenterWindow.getInstance().getWindow().setCursor(Cursor.getPredefinedCursor(3));
                    helpTopicEditor.displayTopic(topic);
                    if (helpTopicEditor.getParent() instanceof HelpCenterWindow) {
                        HelpCenterWindow hcw = (HelpCenterWindow)helpTopicEditor.getParent();
                        hcw.setVisible(true);
                        HelpCenterWindow.getGUI().requestFocus();
                    }
                }
                finally {
                    HelpCenterWindow.getInstance().getWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            JDevHelpSystemImpl.printTopicForDebugging(topic, null, null);
        }
    }

    public final void goTo(String topicID) {
        if (!this._initialize()) {
            this._showHelpError(0, null);
            return;
        }
        SwingUtilities.invokeLater(new 7(this, topicID));
    }

    public void clearHelpSystem() {
        this._dispose();
    }

    public void registerTopicSubstitute(String oldTopicId, String newTopicId) {
        if (this._topicSubstitutes == null) {
            this._topicSubstitutes = new HashMap();
        }
        this._topicSubstitutes.put(oldTopicId, newTopicId);
    }

    static final boolean isDocWriter() {
        return Boolean.valueOf(System.getProperty("docWriter"));
    }

    public static void printTopicForDebugging(Topic topic, String helpID, URL helpURL) {
        if (JDevHelpSystemImpl.isDocWriter()) {
            String helpIdString = null;
            if (helpID != null) {
                helpIdString = "HelpId=" + helpID;
            }
            String helpUrlString = null;
            if (helpURL != null) {
                helpUrlString = "HelpURL=" + helpURL.toString();
            }
            if (topic != null && helpIdString == null) {
                try {
                    Target target;
                    URL topicURL = topic.getTarget().getURL();
                    if (topic.hasTarget() && (target = topic.getTarget()) instanceof IndirectTarget) {
                        IndirectTarget itarget = (IndirectTarget)target;
                        helpIdString = "HelpID=" + itarget.getTargetName();
                    }
                    if (helpUrlString == null) {
                        helpUrlString = "HelpURL=" + topicURL != null ? topicURL.toString() : "unable to map topic to url";
                    }
                }
                catch (MalformedURLException ex) {
                    helpUrlString = "HelpURL= caught MalformedURLException";
                }
            }
            StringBuffer printString = new StringBuffer();
            if (helpIdString != null) {
                printString.append(helpIdString).append(" ");
            }
            if (helpUrlString != null) {
                printString.append(helpUrlString);
            }
            printString.append("\n");
            String pString = printString.toString();
            if (!pString.equals(_lastPrintString)) {
                LogManager.getIdeLogWindow().getPage().log((Object)pString);
                _lastPrintString = pString;
            }
        }
    }

    private boolean _initialize() {
        if (this._initialized) {
            return true;
        }
        this._init();
        return this._initialized;
    }

    private static void _processManifestForBrowseSymbolResolvers() {
        ExtensionRegistry extReg;
        HelpHook hook;
        if (_browseSymbolResolverList.size() == 0 && (hook = (HelpHook)(extReg = ExtensionRegistry.getExtensionRegistry()).getHook(HelpHook.ELEMENT)) != null) {
            hook.registerBrowseSymbolResolvers(_browseSymbolResolverList);
        }
    }

    private void _processManifestForTipJars() {
        if (!this._hooksProcessedForTipJars) {
            ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
            HelpHook hook = (HelpHook)extReg.getHook(HelpHook.ELEMENT);
            if (hook != null) {
                hook.registerHelpTipJars(this);
            }
            this._hooksProcessedForTipJars = true;
        }
    }

    private void _processManifestForHelpSetJars() {
        boolean docReview;
        List<HelpJarInfo> origList = null;
        if (this._addinHelpSetList.size() > 0) {
            origList = this._addinHelpSetList;
            this._addinHelpSetList = new ArrayList<HelpJarInfo>();
        }
        if (!this._hooksProcessedForHelpSetJars) {
            ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
            HelpHook hook = (HelpHook)extReg.getHook(HelpHook.ELEMENT);
            if (hook != null) {
                hook.registerHelpSetJars(this);
            }
            this._hooksProcessedForHelpSetJars = true;
        }
        if (origList != null) {
            this._addinHelpSetList.addAll(origList);
        }
        if (docReview = JDevHelpSystemImpl.isDocReview()) {
            this.convertURLsToDocReview();
        }
        List<HelpJarInfo> sortedHelpJarList = this._sortData();
        this._addinHelpSetList = sortedHelpJarList;
    }

    private synchronized void _init() {
        this._processManifestForHelpSetJars();
        this._library = new JDevLibrary();
        ImageLoader.setDefaultImageLoader((ImageLoader)new JDevImageLoader());
        if (!this._loadHelpSystem()) {
            this._dispose();
            this._initialized = false;
            return;
        }
        this._initialized = true;
    }

    private HelpInfo _findHelpInfoFromContext(Context ctx) {
        if (ctx == null) {
            return HelpInfo.getDefaultHelpInfo();
        }
        HelpInfo hi = this._findHelpInfoFromView(ctx.getView());
        if (hi != null) {
            hi.setContext(ctx);
        }
        return hi;
    }

    private HelpInfo _findHelpInfoFromView(View v) {
        Assert.println((String)("_findHelpInfoFromView: " + v.getClass().toString()));
        if (v == null) {
            return HelpInfo.getDefaultHelpInfo();
        }
        HelpInfo helpInfo = v.getHelpInfo();
        if (helpInfo != null) {
            return helpInfo;
        }
        if (this._isViewOwnerValidAndNotSelf(v)) {
            return this._findHelpInfoFromView(v.owner());
        }
        return HelpInfo.getDefaultHelpInfo();
    }

    private boolean _isViewOwnerValidAndNotSelf(View v) {
        return v != null && v.owner() != null && v.owner() != v;
    }

    private void _showTopic(String topicID) {
        JDevHelpSystemImpl.printTopicForDebugging(null, topicID, null);
        Topic topic = this.getTopicForString(topicID);
        if (topic != null) {
            this.showTopic(topic);
        }
    }

    private final void _fillBookMap(List<HelpJarInfo> sortedHelpJarList) {
        for (HelpJarInfo hjInfo : sortedHelpJarList) {
            Map<String, String> map = hjInfo.getBookMap();
            if (map == null) continue;
            Iterator<String> titleIterator = map.keySet().iterator();
            while (titleIterator.hasNext()) {
                URL controlFileURL = hjInfo.getControlFileURL();
                if (controlFileURL != null && URLFileSystem.exists((URL)controlFileURL)) {
                    String title = titleIterator.next();
                    String label = map.get(title);
                    BookContributor bookContributor = new BookContributor(controlFileURL, label);
                    this._bookMap.add((Object)title, (Object)bookContributor);
                    continue;
                }
                titleIterator.next();
            }
        }
    }

    private final boolean _loadHelpSystem() {
        Assert.startTiming((String)(this.getClass().getName() + "._loadHelpSystem"), null, (boolean)false);
        this._loadErrors.clear();
        for (HelpJarInfo helpJarInfo : this._addinHelpSetList) {
            URL controlFile = helpJarInfo.getControlFileURL();
            if (controlFile == null || !URLFileSystem.exists((URL)controlFile)) continue;
            this._loadHelpFromURL(controlFile);
        }
        this._addinHelpSetList.clear();
        if (this._library == null) {
            return false;
        }
        try {
            this._library.addBook(new JavadocBook());
        }
        catch (LibraryException le) {
            Assert.println((String)"Failed loading the JavadocBook");
        }
        if (this._library.getBookCount() == 0) {
            return false;
        }
        Assert.endTiming((String)(this.getClass().getName() + "._loadHelpSystem"), (String)"Time to load all local helpbooks: ", null, (boolean)false);
        return true;
    }

    private List<HelpJarInfo> _sortData() {
        ArrayList<HelpJarInfo> orderedList = new ArrayList<HelpJarInfo>(this._addinHelpSetList.size());
        ArrayList<HelpJarInfo> removeList = new ArrayList<HelpJarInfo>();
        while (this._addinHelpSetList.size() > 0) {
            for (HelpJarInfo info : this._addinHelpSetList) {
                if (info.getRelativeToName() == null) {
                    orderedList.add(info);
                    removeList.add(info);
                    continue;
                }
                int pos = this._getPos(orderedList, info.getRelativeToName());
                if (pos != -1) {
                    if (info.getRelativeLocation() == 0) {
                        orderedList.add(Math.max(pos, 0), info);
                        removeList.add(info);
                        continue;
                    }
                    if (pos < orderedList.size() - 1) {
                        orderedList.add(pos + 1, info);
                    } else {
                        orderedList.add(info);
                    }
                    removeList.add(info);
                    continue;
                }
                pos = this._getPos(this._addinHelpSetList, info.getRelativeToName());
                if (pos != -1) continue;
                orderedList.add(info);
                removeList.add(info);
            }
            this._addinHelpSetList.removeAll(removeList);
            removeList.clear();
        }
        return orderedList;
    }

    private int _getPos(List<HelpJarInfo> list, String name) {
        int pos = -1;
        int i = 0;
        while (i < list.size()) {
            HelpJarInfo info = list.get(i);
            if (info.getName().equals(name)) {
                pos = i;
                break;
            }
            ++i;
        }
        return pos;
    }

    private int _findLocationInList(String findName, List list) {
        int numBooks = list.size();
        int i = 0;
        while (i < numBooks) {
            HelpJarInfo listHelpJarInfo = (HelpJarInfo)list.get(i);
            if (findName.toLowerCase().equals(listHelpJarInfo.getName().toLowerCase())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private final void _loadHelpFromURL(URL helpUrl) {
        if (helpUrl == null) {
            return;
        }
        try {
            this._library.addBook((Book)new JDevHelpSet(helpUrl));
        }
        catch (Exception ex) {
            this._loadErrors.add(HelpArb.format(75, helpUrl.toString()));
        }
    }

    private final void _showHelpError(int errorType, String errorMsg) {
        if (this._checkModalMode()) {
            String errMsg = errorMsg;
            if (errorType == 0) {
                errMsg = HelpArb.getString(142);
            }
            JDevHelpSystemImpl.showErrorMessage(this._modalOwner, errMsg, HelpArb.getString(22));
        } else {
            HelpWindow hWindow = (HelpWindow)DockStation.getDockStation().getDockable(new ViewId("HelpSystemAddin", "HelpWindow"));
            if (hWindow != null && errorType == 0) {
                hWindow.switchNavigator(4);
                hWindow.show();
            } else {
                JDevHelpSystemImpl.showErrorMessage((Component)Ide.getMainWindow(), errorMsg, HelpArb.getString(22));
            }
        }
    }

    private final void _dispose() {
        this._library = null;
        HelpWindow helpWindow = (HelpWindow)DockStation.getDockStation().getDockable(HelpWindow.getHelpWindowViewId());
        if (helpWindow != null) {
            helpWindow.dispose();
        }
        this._topicSubstitutes = null;
        this._initialized = false;
    }

    static final boolean isDocReview() {
        return Boolean.valueOf(System.getProperty("docReview"));
    }

    static final URL convertURLToDocReview(URL helpURL) {
        URL url = helpURL;
        String urlStr = helpURL.toString();
        if (urlStr.indexOf("ohj") != -1) {
            urlStr = urlStr.replaceFirst("ohj", "hosted");
            url = URLFactory.newURL((String)urlStr);
        }
        return url;
    }

    private final void convertURLsToDocReview() {
        for (HelpJarInfo helpJarInfo : this._addinHelpSetList) {
            Map<String, String> bookMap = helpJarInfo.getBookMap();
            URL controlFileURL = helpJarInfo.getControlFileURL();
            controlFileURL = JDevHelpSystemImpl.convertURLToDocReview(controlFileURL);
            helpJarInfo.update(controlFileURL, null, -1, bookMap);
        }
    }

    protected void clearModalDialog() {
        this._modalDialog = null;
    }

    protected void setModalDialog(ModalHelpContentDialog dialog) {
        this._modalDialog = dialog;
    }

    static String getEditionDirectory() {
        if (_editionDirectory == null) {
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            Extension extension = registry.findExtension("oracle.studio.help");
            _editionDirectory = extension != null ? "studio_doc" : ((extension = registry.findExtension("oracle.j2ee.help")) != null ? "j2ee_doc" : "java_doc");
        }
        return _editionDirectory;
    }

    private Dialog _getActiveModalOwnerDialog() {
        Window aWindow = WindowUtils.getActiveWindow();
        Dialog modalOwner = null;
        while (aWindow != null) {
            Dialog theDialog;
            if (aWindow instanceof Dialog && (theDialog = (Dialog)aWindow).isModal()) {
                modalOwner = theDialog;
                break;
            }
            aWindow = (Window)aWindow.getParent();
        }
        return modalOwner;
    }

    private boolean _checkModalMode() {
        Dialog newModalOwner = this._getActiveModalOwnerDialog();
        boolean modalMode = false;
        boolean aParentIsModal = false;
        if (newModalOwner != null) {
            aParentIsModal = true;
        }
        if (aParentIsModal && !modalMode) {
            modalMode = true;
        } else if (modalMode && !aParentIsModal) {
            modalMode = false;
        }
        this._modalOwner = newModalOwner;
        return modalMode;
    }

    static void showErrorMessage(Component parent, String message, String title) {
        8 r = new 8(parent, message, title);
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    static {
        _browseSymbolResolverList = new ArrayList();
    }

    static void mav$_showHelpError(JDevHelpSystemImpl jDevHelpSystemImpl, int n, String string) {
        jDevHelpSystemImpl._showHelpError(n, string);
    }

    static void mav$_showTopic(JDevHelpSystemImpl jDevHelpSystemImpl, String string) {
        jDevHelpSystemImpl._showTopic(string);
    }

    static Topic mav$getTipOfTheDay(JDevHelpSystemImpl jDevHelpSystemImpl, URL uRL) {
        return jDevHelpSystemImpl.getTipOfTheDay(uRL);
    }

    static HelpInfo mav$_findHelpInfoFromContext(JDevHelpSystemImpl jDevHelpSystemImpl, Context context) {
        return jDevHelpSystemImpl._findHelpInfoFromContext(context);
    }

    static void maS$_processManifestForBrowseSymbolResolvers() {
        JDevHelpSystemImpl._processManifestForBrowseSymbolResolvers();
    }

    static List ra$_browseSymbolResolverList() {
        return _browseSymbolResolverList;
    }

    static final class 1
    extends SwingWorker {
        URL url;
        private final /* synthetic */ String v$symbolName;
        private final /* synthetic */ Context v$context;

        private void $init$() {
            this.url = null;
        }

        public Object construct() {
            block4: {
                try {
                    if (this.v$symbolName == null) break block4;
                    JDevHelpSystemImpl.maS$_processManifestForBrowseSymbolResolvers();
                    int listlen = JDevHelpSystemImpl.ra$_browseSymbolResolverList().size();
                    int i = 0;
                    while (i < listlen) {
                        String browseResolverClass = (String)JDevHelpSystemImpl.ra$_browseSymbolResolverList().get(i);
                        Class<?> resolverClass = Class.forName(browseResolverClass);
                        BrowseSymbolResolver resolver = (BrowseSymbolResolver)resolverClass.newInstance();
                        Class[] params = new Class[]{Context.class, String.class};
                        Method method = resolverClass.getDeclaredMethod("resolveBrowseSymbol", params);
                        this.url = (URL)method.invoke((Object)resolver, this.v$context, this.v$symbolName);
                        if (this.url == null) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    Assert.printStackTrace((Throwable)ex);
                }
            }
            return this.url;
        }

        public void finished() {
            if (this.v$symbolName == null) {
                Assert.println((String)"SymbolName for showLanguageHelp was (null)!");
                HelpSystemAddin.showJavadocException(2, "");
            }
            if (this.url == null) {
                Assert.println((String)("Unable to get URL for [" + this.v$symbolName + "]"));
                return;
            }
            SimpleURLTarget theTarget = new SimpleURLTarget(null, this.url.toString());
            SimpleTopic theTopic = new SimpleTopic(null, (Target)theTarget);
            Context topicContext = HelpUtils.createContext((Topic)theTopic);
            HelpUtils.createHelpTopicEditor(topicContext, (Topic)theTopic);
            HelpCenterWindow hcw = HelpCenterWindow.getInstance();
            hcw.setVisible(true);
            HelpCenterWindow.getGUI().requestFocus();
        }

        public 1(String string, Context context) {
            this.v$context = context;
            this.v$symbolName = string;
            this.$init$();
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ JComponent v$comp;
        final /* synthetic */ JDevHelpSystemImpl this$0;

        public void run() {
            try {
                String topicID = null;
                Book aBook = null;
                if (this.v$comp != null) {
                    topicID = oracle.bali.ewt.help.HelpUtils.getHelpID((Component)this.v$comp);
                    if (topicID == null && this.v$comp instanceof Traversable) {
                        topicID = ((Traversable)this.v$comp).getHelpID();
                    }
                    aBook = (Book)oracle.bali.ewt.help.HelpUtils.getHelpSet((Component)this.v$comp);
                }
                if (topicID == null) {
                    JDevHelpSystemImpl.mav$_showHelpError(this.this$0, 1, HelpArb.getString(52));
                    Assert.println((String)("JDevHelpSystemImpl.goTo() Help locate topic for component" + this.v$comp.toString()));
                } else {
                    JDevHelpSystemImpl.mav$_showTopic(this.this$0, topicID);
                }
            }
            catch (TopicDisplayException tdEx) {
                Assert.println((String)tdEx.toString());
                JDevHelpSystemImpl.showErrorMessage(WindowUtils.getActiveWindow(), HelpArb.getString(52), null);
            }
            catch (Exception ex) {
                Assert.println((String)ex.toString());
            }
        }

        public 2(JDevHelpSystemImpl jDevHelpSystemImpl, JComponent jComponent) {
            this.v$comp = jComponent;
            this.this$0 = jDevHelpSystemImpl;
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ Context v$fCtx;
        final /* synthetic */ JDevHelpSystemImpl this$0;

        public void run() {
            HelpInfo hi = JDevHelpSystemImpl.mav$_findHelpInfoFromContext(this.this$0, this.v$fCtx);
            this.this$0.showHelp(hi);
        }

        public 3(JDevHelpSystemImpl jDevHelpSystemImpl, Context context) {
            this.v$fCtx = context;
            this.this$0 = jDevHelpSystemImpl;
        }
    }

    final class 4
    implements Runnable {
        private final /* synthetic */ HelpInfo v$fHelpInfo;
        final /* synthetic */ JDevHelpSystemImpl this$0;

        public void run() {
            if (this.v$fHelpInfo != null && this.v$fHelpInfo.getHelpType() == 1) {
                Assert.println((String)("Showing Language Help on [" + this.v$fHelpInfo.getHelpTopicID() + "]"));
                this.this$0.showLanguageHelp(this.v$fHelpInfo.getContext(), this.v$fHelpInfo.getHelpTopicID());
            } else {
                this.this$0.goTo(this.v$fHelpInfo != null ? this.v$fHelpInfo.getHelpTopicID() : HelpInfo.getDefaultHelpInfo().getHelpTopicID());
            }
        }

        public 4(JDevHelpSystemImpl jDevHelpSystemImpl, HelpInfo helpInfo) {
            this.v$fHelpInfo = helpInfo;
            this.this$0 = jDevHelpSystemImpl;
        }
    }

    final class 5
    implements ActionListener {
        private final /* synthetic */ TipOfDayDialog v$dialog;
        final /* synthetic */ JDevHelpSystemImpl this$0;

        public void actionPerformed(ActionEvent e) {
            Topic tipTopic = JDevHelpSystemImpl.mav$getTipOfTheDay(this.this$0, this.v$dialog.getHelpContentPanel().getTopicPanel().getCurrentURL());
            if (tipTopic != null) {
                this.v$dialog.getHelpContentPanel().displayTopic(tipTopic);
            }
        }

        public 5(JDevHelpSystemImpl jDevHelpSystemImpl, TipOfDayDialog tipOfDayDialog) {
            this.v$dialog = tipOfDayDialog;
            this.this$0 = jDevHelpSystemImpl;
        }
    }

    final class 6
    implements Runnable {
        private final /* synthetic */ TipOfDayDialog v$dialog;
        final /* synthetic */ JDevHelpSystemImpl this$0;

        public void run() {
            this.v$dialog.runDialog();
            this.v$dialog.toFront();
        }

        public 6(JDevHelpSystemImpl jDevHelpSystemImpl, TipOfDayDialog tipOfDayDialog) {
            this.v$dialog = tipOfDayDialog;
            this.this$0 = jDevHelpSystemImpl;
        }
    }

    final class 7
    implements Runnable {
        private final /* synthetic */ String v$topicID;
        final /* synthetic */ JDevHelpSystemImpl this$0;

        public void run() {
            try {
                if (this.v$topicID == null) {
                    JDevHelpSystemImpl.mav$_showHelpError(this.this$0, 1, HelpArb.getString(52));
                    Assert.println((String)"JDevHelpSystemImpl.goTo() Help topic is null");
                } else {
                    Assert.startTiming((String)(this.getClass().getName() + ".goTo"), null, (boolean)false);
                    JDevHelpSystemImpl.mav$_showTopic(this.this$0, this.v$topicID);
                    Assert.endTiming((String)(this.getClass().getName() + ".goTo"), (String)"Time to show topic: ", null, (boolean)false);
                }
            }
            catch (TopicDisplayException tdEx) {
                Assert.println((String)tdEx.toString());
                JDevHelpSystemImpl.showErrorMessage(WindowUtils.getActiveWindow(), HelpArb.getString(52), null);
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
            }
        }

        public 7(JDevHelpSystemImpl jDevHelpSystemImpl, String string) {
            this.v$topicID = string;
            this.this$0 = jDevHelpSystemImpl;
        }
    }

    static final class 8
    implements Runnable {
        private final /* synthetic */ Component v$parent;
        private final /* synthetic */ String v$message;
        private final /* synthetic */ String v$title;

        public void run() {
            JOptionPane.showMessageDialog(this.v$parent, this.v$message, this.v$title, 0);
        }

        public 8(Component component, String string, String string2) {
            this.v$title = string2;
            this.v$message = string;
            this.v$parent = component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HelpJarInfo {
        private String _name;
        private URL _controlFileURL;
        private String _relativeToName;
        private int _relativeLocation;
        private Map<String, String> _bookMap;

        public HelpJarInfo(String name, URL controlFileURL, String relativeToName, int relativeLocation, Map<String, String> bookMap) {
            this._name = name;
            this._controlFileURL = controlFileURL;
            this._relativeToName = relativeToName;
            this._relativeLocation = relativeLocation;
            this._bookMap = bookMap;
        }

        public String getName() {
            return this._name;
        }

        public URL getControlFileURL() {
            if (this._controlFileURL.toString().indexOf("$edition") > -1) {
                String editionDir = JDevHelpSystemImpl.getEditionDirectory();
                String origPath = this._controlFileURL.getPath();
                String newPath = origPath.replace("$edition", editionDir);
                this._controlFileURL = URLFactory.replacePathPart((URL)this._controlFileURL, (String)newPath);
            }
            return this._controlFileURL;
        }

        public String getRelativeToName() {
            return this._relativeToName;
        }

        public int getRelativeLocation() {
            return this._relativeLocation;
        }

        public Map<String, String> getBookMap() {
            return this._bookMap;
        }

        public void update(URL controlFileURL, String relativeToName, int relativeLocation, Map<String, String> bookMap) {
            if (controlFileURL != null) {
                this._controlFileURL = controlFileURL;
            }
            if (relativeToName != null) {
                this._relativeToName = relativeToName;
            }
            if (relativeLocation != -1) {
                this._relativeLocation = relativeLocation;
            }
            this._bookMap = bookMap;
        }
    }

    static class TipOfDayDialog
    extends JEWTDialog {
        private HelpContentPanel _helpContentPanel;
        private JPanel _panel;
        private JCheckBox _cBox;

        public TipOfDayDialog(Frame frame) {
            super(frame);
            this.setModal(false);
            this.setMinimumSize(450, 375);
            this.setMaximumInitialSize(450, 375);
            this.setPreferredSize(450, 375);
            this.setResizable(true);
            this._panel = new JPanel(new GridBagLayout());
            this._helpContentPanel = new HelpContentPanel(this);
            this._panel.add(this._helpContentPanel.getGUI(), new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this._cBox = new JCheckBox();
            this._cBox.setSelected(JDevHelpSystemImpl.getShowTipOfDayPreference());
            ResourceUtils.resButton((AbstractButton)this._cBox, (String)HelpArb.getString(161));
            this._cBox.addActionListener(new 1());
            this._panel.add((Component)this._cBox, new GridBagConstraints(0, 3, 1, 2, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
            this.setContent(this._panel);
            this.pack();
        }

        public HelpContentPanel getHelpContentPanel() {
            return this._helpContentPanel;
        }

        public JCheckBox getCheckBox() {
            return this._cBox;
        }

        protected void dismissDialog(boolean cancelled) {
            super.dismissDialog(true);
            if (this._helpContentPanel != null) {
                this._helpContentPanel.dispose();
                this._helpContentPanel = null;
            }
            super.dispose();
        }

        static JCheckBox ra$_cBox(TipOfDayDialog tipOfDayDialog) {
            return tipOfDayDialog._cBox;
        }

        final class 1
        implements ActionListener {
            public void actionPerformed(ActionEvent e) {
                DTCache dtCache = Ide.getDTCache();
                dtCache.putBoolean(JDevHelpSystemImpl.HELPSYSTEM_SHOW_TIP_OF_DAY, TipOfDayDialog.ra$_cBox(TipOfDayDialog.this).isSelected());
            }
        }
    }

    public final class BookContributor {
        private URL _url;
        private String _label;

        public BookContributor(URL url, String label) {
            this._url = url;
            this._label = label;
        }

        public URL getURL() {
            return this._url;
        }

        public String getLabel() {
            return this._label;
        }
    }
}

