/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.dTree.DTreeDeferringParent;
import oracle.bali.ewt.dTree.DTreeDeferringRoot;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemFactory;
import oracle.bali.ewt.dTree.DTreeRootItem;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.java.tree.TopicTreeComponent;
import oracle.help.java.tree.TopicTreeItem;
import oracle.help.java.tree.TopicTreeListener;
import oracle.help.java.tree.TopicTreeModel;
import oracle.help.java.tree.TopicTreePane;
import oracle.help.java.util.ImageLoader;
import oracle.help.library.Library;
import oracle.help.library.LibraryListener;
import oracle.help.library.helpset.HelpSet;
import oracle.help.library.helpset.HelpSetParseException;
import oracle.help.navigator.NavigatorException;
import oracle.help.navigator.tocNavigator.TOCBranchItem;
import oracle.help.navigator.tocNavigator.TOCItemFactory;
import oracle.help.navigator.tocNavigator.TOCLeafItem;
import oracle.help.navigator.tocNavigator.TOCNavigator;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.MultiMap;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpNavigatorToolbar;
import oracle.jdevimpl.help.HelpUtils;
import oracle.jdevimpl.help.HelpWindow;
import oracle.jdevimpl.help.JDevHelpSystemImpl;
import oracle.jdevimpl.help.JDevNavigator;
import oracle.jdevimpl.help.MultipleTypeTopic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JDevTOCNavigator
extends TOCNavigator
implements JDevNavigator {
    private HelpWindow _helpWindow;
    private boolean _isInitialized;
    private List<View> _initialViews;
    private MultiMap<String, JDevHelpSystemImpl.BookContributor> _bookMap;
    private DefaultListComboBoxModel _comboBoxModel;
    private HelpNavigatorToolbar _toolbar;
    private static final String MAIN_LIBRARY_TITLE = HelpArb.getString(21);

    private void $init$() {
        this._isInitialized = false;
    }

    public JDevTOCNavigator(HelpWindow helpWindow, Library library, MultiMap<String, JDevHelpSystemImpl.BookContributor> bookMap) throws NavigatorException {
        this.$init$();
        this._helpWindow = helpWindow;
        this.label = "Contents";
        this.labelImage = null;
        this.library = library;
        this.filterByLabel = true;
        this.type = "oracle.jdevimpl.help.JDevTOCNavigator";
        this._bookMap = bookMap;
        View[] initialViews = null;
        int iter = 0;
        this.listeners = new ListenerManager();
        this.views = new ArrayList();
        if (library != null) {
            this.library.addLibraryListener((LibraryListener)this);
            initialViews = this.filterViewsByLabel(library.getAllViews(), this.label);
            if (initialViews != null) {
                iter = 0;
                while (iter < initialViews.length) {
                    this.views.add(initialViews[iter]);
                    ++iter;
                }
            }
        }
        this.initNavigator(initialViews);
        Color transparentColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBackground(transparentColor);
    }

    protected void doInitializationNow() {
        super.initNavigator(this._initialViews.toArray(new View[0]));
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (this._bookMap.keySet().size() > 0) {
            this._toolbar = new HelpNavigatorToolbar();
            this.add((Component)((Object)this._toolbar), "North");
            this._comboBoxModel = new DefaultListComboBoxModel();
            this._comboBoxModel.addElement((Object)MAIN_LIBRARY_TITLE);
            Object[] bookTitles = new String[this._bookMap.keySet().size()];
            bookTitles = this._bookMap.keySet().toArray(bookTitles);
            Arrays.sort(bookTitles);
            Object[] objectArray = bookTitles;
            int n = 0;
            while (n < objectArray.length) {
                Object bookTitle = objectArray[n];
                this._comboBoxModel.addElement(bookTitle);
                ++n;
            }
            JComboBox combobox = new JComboBox(this._comboBoxModel);
            combobox.addItemListener(new 1());
            this._toolbar.setLayout(new BorderLayout());
            this._toolbar.add(combobox, "West");
            this.setItemFactory(true);
            this.getTopicTreePane().setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        }
    }

    protected void addViewNow(View view) {
        super.addView(view);
    }

    protected void removeViewNow(View view) {
        super.removeView(view);
    }

    public void initNavigator(View[] initalViewsArray) {
        if (initalViewsArray != null) {
            this._initialViews = new ArrayList<View>(initalViewsArray.length);
            int i = 0;
            while (i < initalViewsArray.length) {
                this._initialViews.add(initalViewsArray[i]);
                ++i;
            }
        } else {
            this._initialViews = new ArrayList<View>(0);
        }
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            super.setVisible(visible);
        } else {
            if (visible && !this.isInitialized()) {
                this.initializeLazyNavigator();
            }
            super.setVisible(visible);
        }
    }

    public boolean isInitialized() {
        return this._isInitialized;
    }

    public void addView(View view) {
        if (this.isInitialized()) {
            this.addViewNow(view);
        } else {
            this._initialViews.add(view);
        }
    }

    public void removeView(View view) {
        if (this.isInitialized()) {
            this.removeViewNow(view);
        } else {
            this._initialViews.remove(view);
        }
    }

    public void initializeLazyNavigator() {
        this._isInitialized = true;
        this.doInitializationNow();
    }

    protected View[] getInitialViewsArray() {
        if (this._initialViews.size() > 0) {
            View[] initialViewsArray = new View[this._initialViews.size()];
            this._initialViews.toArray(initialViewsArray);
            return initialViewsArray;
        }
        return null;
    }

    protected void addTopicTreeListener(TopicTreePane treePane) {
        JDevTreePaneListener listener = new JDevTreePaneListener(null);
        treePane.addTopicTreeListener((TopicTreeListener)listener);
    }

    private List<JDevHelpSystemImpl.BookContributor> mapStringToContributorList(String selectedLabel) {
        List contributorList = null;
        if (this._bookMap != null) {
            contributorList = this._bookMap.get((Object)selectedLabel);
        }
        return contributorList;
    }

    void setTOCSelection(String bookTitle) {
        if (this._comboBoxModel != null) {
            this._comboBoxModel.setSelectedItem((Object)(bookTitle != null ? bookTitle : MAIN_LIBRARY_TITLE));
        }
    }

    @Override
    public void setActive(boolean active) {
        if (this._toolbar != null) {
            this._toolbar.setActiveToolbar(active);
        }
        HelpUtils.setNavigatorBorderActive(this, active);
    }

    void swapTOCContent(List<JDevHelpSystemImpl.BookContributor> contributorList) {
        View[] newViews = null;
        ArrayList<View> viewList = new ArrayList<View>();
        if (contributorList != null) {
            for (JDevHelpSystemImpl.BookContributor contributor : contributorList) {
                try {
                    HelpSet helpSet = new HelpSet(contributor.getURL());
                    View[] selViews = super.filterViewsByLabel(helpSet.getAllViews(), contributor.getLabel());
                    if (selViews == null) continue;
                    View[] viewArray = selViews;
                    int n = 0;
                    while (n < viewArray.length) {
                        View view = viewArray[n];
                        viewList.add(view);
                        ++n;
                    }
                }
                catch (HelpSetParseException hspe) {
                    // empty catch block
                }
            }
            newViews = viewList.toArray(new View[viewList.size()]);
        } else {
            newViews = this.filterViewsByLabel(this.library.getAllViews(), this.label);
        }
        if (this._initialViews != null) {
            for (View view : this._initialViews) {
                this.removeViewNow(view);
            }
        }
        this._initialViews.clear();
        this.setItemFactory(contributorList == null);
        View[] viewArray = newViews;
        int n = 0;
        while (n < viewArray.length) {
            View view = viewArray[n];
            this.addViewNow(view);
            this._initialViews.add(view);
            ++n;
        }
    }

    private void setItemFactory(boolean isAllNavigator) {
        Component[] comps;
        Component[] componentArray = comps = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component c = componentArray[n];
            if (c instanceof TopicTreePane) {
                TopicTreePane ttp = (TopicTreePane)c;
                TopicTreeComponent ttc = ttp.getTopicTreeComponent();
                DTreeDeferringRoot root = (DTreeDeferringRoot)ttc.getRoot();
                String label = root.getLabel();
                Icon icon = root.getIcon();
                OneDModel model = root.getModel();
                JDevTOCItemFactory factory = null;
                factory = isAllNavigator ? JDevTOCItemFactory.getInstance() : TOCItemFactory.getInstance();
                DTreeDeferringRoot newRoot = new DTreeDeferringRoot(label, icon, model, (DTreeItemFactory)factory);
                ttc.setRoot((DTreeRootItem)newRoot);
            }
            ++n;
        }
    }

    static HelpWindow ra$_helpWindow(JDevTOCNavigator jDevTOCNavigator) {
        return jDevTOCNavigator._helpWindow;
    }

    static void mav$fireTopicSelected(JDevTOCNavigator jDevTOCNavigator, Topic topic) {
        jDevTOCNavigator.fireTopicSelected(topic);
    }

    static void mav$fireTopicActivated(JDevTOCNavigator jDevTOCNavigator, Topic topic, int n) {
        jDevTOCNavigator.fireTopicActivated(topic, n);
    }

    static List mav$mapStringToContributorList(JDevTOCNavigator jDevTOCNavigator, String string) {
        return jDevTOCNavigator.mapStringToContributorList(string);
    }

    final class 1
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                String selLabel = (String)e.getItem();
                List contributorList = JDevTOCNavigator.mav$mapStringToContributorList(JDevTOCNavigator.this, selLabel);
                JDevTOCNavigator.this.swapTOCContent(contributorList);
            }
        }
    }

    private class JDevTreePaneListener
    implements TopicTreeListener {
        public void topicActivated(TopicTreeItem item, boolean newWindow) {
            int mode = newWindow ? 2 : 1;
            JDevTOCNavigator.mav$fireTopicActivated(JDevTOCNavigator.this, item.getTopic(), mode);
        }

        public void topicSelected(TopicTreeItem item) {
            Topic selectedTopic = item == null ? null : item.getTopic();
            JDevTOCNavigator.mav$fireTopicSelected(JDevTOCNavigator.this, selectedTopic);
        }

        public void popupDisplayed(TopicTreeItem item, JPopupMenu popup) {
            JDevTOCNavigator.ra$_helpWindow(JDevTOCNavigator.this).addMenuItems(popup, item.getTopic());
        }

        private JDevTreePaneListener() {
        }

        JDevTreePaneListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class JDevTOCItemFactory
    implements DTreeItemFactory {
        private static JDevTOCItemFactory _sFactory = null;

        private JDevTOCItemFactory() {
        }

        public DTreeItem createItem(DTreeDeferringParent parent, int index) {
            OneDModel src = parent.getModel();
            TopicTreeNode node = (TopicTreeNode)src.getData(index);
            Object item = null;
            if (node == null) {
                return null;
            }
            Topic topic = node.getTopic();
            item = node.isBranch() ? (topic != null && topic instanceof MultipleTypeTopic && ((MultipleTypeTopic)topic).getTopicType() == 8 ? new JDevCueCardBranchItem((OneDModel)new TopicTreeModel(node)) : new JDevBookTOCBranchItem((OneDModel)new TopicTreeModel(node))) : (topic != null && topic instanceof MultipleTypeTopic && ((MultipleTypeTopic)topic).getTopicType() == 7 ? new JDevTOCCueCardLeafItem(null) : new TOCLeafItem());
            node.setClientData(item);
            return item;
        }

        public static JDevTOCItemFactory getInstance() {
            if (_sFactory == null) {
                _sFactory = new JDevTOCItemFactory();
            }
            return _sFactory;
        }
    }

    private static final class JDevTOCCueCardLeafItem
    extends TOCLeafItem {
        public Icon getIcon() {
            return HelpArb.getIcon(49);
        }

        private JDevTOCCueCardLeafItem() {
        }

        JDevTOCCueCardLeafItem(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class JDevBookTOCBranchItem
    extends TOCBranchItem {
        private ImageIcon _collapsedIcon;
        private ImageIcon _expandedIcon;

        private void $init$() {
            this._collapsedIcon = null;
            this._expandedIcon = null;
        }

        public JDevBookTOCBranchItem(OneDModel source) {
            super(source);
            this.$init$();
        }

        protected ImageIcon getCollapsedIcon() {
            if (this._collapsedIcon == null) {
                this._collapsedIcon = this._getCustomIcon();
            }
            return this._collapsedIcon;
        }

        protected ImageIcon getExpandedIcon() {
            if (this._expandedIcon == null) {
                this._expandedIcon = this._getCustomIcon();
            }
            return this._expandedIcon;
        }

        public Icon getIcon() {
            Icon icon = null;
            if (this.isExpanded()) {
                icon = this.getExpandedIcon();
                if (icon == null) {
                    icon = IdeArb.getIcon((int)74);
                }
            } else {
                icon = this.getCollapsedIcon();
                if (icon == null) {
                    icon = OracleIcons.getIcon((String)"folder.png");
                }
            }
            return icon;
        }

        public DTreeItemFactory getItemFactory() {
            return JDevTOCItemFactory.getInstance();
        }

        private ImageIcon _getCustomIcon() {
            Image active;
            ImageIcon resultIcon = null;
            Image resultImage = null;
            if (this.isExpanded() && (active = ImageLoader.loadImage((URL)this.getTopic().getActiveIcon())) != null) {
                resultImage = active;
            }
            if (resultImage == null) {
                resultImage = ImageLoader.loadImage((URL)this.getTopic().getDefaultIcon());
            }
            if (resultImage != null) {
                resultIcon = new ImageIcon(resultImage);
            }
            return resultIcon;
        }
    }

    private static final class JDevCueCardBranchItem
    extends TOCBranchItem {
        public JDevCueCardBranchItem(OneDModel source) {
            super(source);
        }

        protected ImageIcon getCollapsedIcon() {
            return new ImageIcon(HelpArb.getImage(49));
        }

        protected ImageIcon getExpandedIcon() {
            return new ImageIcon(HelpArb.getImage(49));
        }

        public Icon getIcon() {
            Icon icon = null;
            if (this.isExpanded()) {
                icon = HelpArb.getIcon(49);
                if (icon == null) {
                    icon = IdeArb.getIcon((int)74);
                }
            } else {
                icon = HelpArb.getIcon(49);
                if (icon == null) {
                    icon = OracleIcons.getIcon((String)"folder.png");
                }
            }
            return icon;
        }

        public DTreeItemFactory getItemFactory() {
            return JDevTOCItemFactory.getInstance();
        }
    }
}

