/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import oracle.bali.ewt.util.WindowUtils;
import oracle.help.common.Topic;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.library.Library;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.ContextMenu;
import oracle.ide.help.HelpSystem;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpContentPanel;
import oracle.jdevimpl.help.HelpOptions;
import oracle.jdevimpl.help.JDevHelpSystemImpl;

public final class ModalHelpContentDialog
extends JDialog {
    private ModalContentWindowAdapter _windowAdapter;
    private HelpContentPanel _helpContentPanel;
    private ArrayList _ownerList;
    private Library _library;

    private void $init$() {
        this._ownerList = new ArrayList();
    }

    public ModalHelpContentDialog(Dialog owner, Library library, ModalHelpContentDialog modalDialog) {
        super(owner);
        this.$init$();
        this._ownerList.add(owner);
        this._commonInit(owner, library, modalDialog, null);
    }

    public ModalHelpContentDialog(Frame owner, Library library, ModalHelpContentDialog modalDialog) {
        super(owner);
        this.$init$();
        this._commonInit(owner, library, modalDialog, null);
    }

    public ModalHelpContentDialog(Dialog owner, Library library, ModalHelpContentDialog modalDialog, HelpContentPanel helpContentPanel) {
        super(owner);
        this.$init$();
        this._ownerList.add(owner);
        this._commonInit(owner, library, modalDialog, helpContentPanel);
    }

    private void _commonInit(Component owner, Library library, ModalHelpContentDialog modalDialog, HelpContentPanel helpContentPanel) {
        WindowUtils.registerWindow((Window)this);
        this._library = library;
        if (modalDialog == null) {
            this._helpContentPanel = helpContentPanel != null ? helpContentPanel : new HelpContentPanel(library, false, true, this);
            this.setTitle(HelpArb.getString(151));
            IdeSettings settings = Ide.getSettings();
            HelpOptions opts = (HelpOptions)((Object)settings.getData("HelpOptions"));
            int savedHeight = opts.getModalHelpHeight();
            int savedWidth = opts.getModalHelpWidth();
            if (savedHeight == -1 || savedWidth == -1) {
                ResourceBundle defaults = ResourceBundle.getBundle("oracle.help.resource.Defaults", StaticLocaleContext.getLocale());
                String width = defaults.getString("topicwin.width");
                String height = defaults.getString("topicwin.height");
                this.setSize(Integer.parseInt(width), Integer.parseInt(height));
            } else {
                this.setSize(savedWidth, savedHeight);
            }
            int savedX = opts.getModalHelpX();
            int savedY = opts.getModalHelpY();
            if (savedX == -1 || savedY == -1) {
                this.setLocationRelativeTo(owner);
            } else {
                this.setLocation(savedX, savedY);
            }
        } else {
            this._helpContentPanel = modalDialog.getHelpContentPanel();
            modalDialog._clearHelpContentPanel();
            this._ownerList.addAll(modalDialog._getOwnerList());
            WindowUtils.unregisterWindow((Window)modalDialog);
            this.setSize(modalDialog.getSize());
            this.setLocation(modalDialog.getLocation());
            if (modalDialog._getWindowAdapter() != null) {
                modalDialog.removeWindowListener(modalDialog._getWindowAdapter());
            }
            modalDialog.setVisible(false);
            modalDialog.dispose();
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this._helpContentPanel.getGUI(), "Center");
        this._windowAdapter = new ModalContentWindowAdapter(null);
        this.addWindowListener(this._windowAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(Topic topic) {
        HelpContentPanel helpContentPanel = this._helpContentPanel;
        synchronized (helpContentPanel) {
            super.setVisible(true);
            this._helpContentPanel.getTopicPanel().displayTopic(topic);
        }
    }

    HelpContentPanel getHelpContentPanel() {
        return this._helpContentPanel;
    }

    private List _getOwnerList() {
        return this._ownerList;
    }

    private void _clearHelpContentPanel() {
        this._helpContentPanel = null;
    }

    private WindowAdapter _getWindowAdapter() {
        return this._windowAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(boolean userRequestedClose) {
        HelpContentPanel helpContentPanel = this._helpContentPanel;
        synchronized (helpContentPanel) {
            IdeSettings settings = Ide.getSettings();
            HelpOptions opts = (HelpOptions)((Object)settings.getData("HelpOptions"));
            opts.setModalHelpHeight(this.getHeight());
            opts.setModalHelpWidth(this.getWidth());
            opts.setModalHelpX(this.getX());
            opts.setModalHelpY(this.getY());
            WindowUtils.unregisterWindow((Window)this);
            if (this._windowAdapter != null) {
                this.removeWindowListener(this._windowAdapter);
                this._windowAdapter = null;
            }
            boolean destroyWindow = true;
            if (!userRequestedClose) {
                int listSize = this._ownerList.size();
                if (listSize == 1) {
                    destroyWindow = true;
                } else {
                    boolean foundNewOwner = false;
                    int i = 1;
                    while (i < listSize && !foundNewOwner) {
                        Dialog dlg = (Dialog)this._ownerList.get(i);
                        if (dlg.isShowing()) {
                            destroyWindow = false;
                            foundNewOwner = true;
                            this._ownerList.remove(0);
                            this._ownerList.remove(0);
                            ModalHelpContentDialog mcd = new ModalHelpContentDialog(dlg, this._library, this);
                            mcd.setVisible(true);
                            Window currWindow = WindowUtils.getActiveWindow();
                            if (currWindow != null) {
                                currWindow.setVisible(true);
                            }
                            if (HelpSystem.getHelpSystem() instanceof JDevHelpSystemImpl) {
                                JDevHelpSystemImpl helpsys = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
                                helpsys.setModalDialog(mcd);
                            }
                        }
                        ++i;
                    }
                }
            }
            if (destroyWindow) {
                WindowListener[] winListeners = this.getWindowListeners();
                if (winListeners != null) {
                    int i = 0;
                    while (i < winListeners.length) {
                        winListeners[i].windowClosing(new WindowEvent(this, 201));
                        ++i;
                    }
                }
                if (this._helpContentPanel != null) {
                    this._helpContentPanel.dispose();
                }
                if (HelpSystem.getHelpSystem() instanceof JDevHelpSystemImpl) {
                    JDevHelpSystemImpl helpsys = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
                    helpsys.clearModalDialog();
                }
            }
        }
    }

    protected JRootPane createRootPane() {
        ModalHelpContentDialog win = this;
        1 actionListener = new 1(this, win);
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    static HelpContentPanel ra$_helpContentPanel(ModalHelpContentDialog modalHelpContentDialog) {
        return modalHelpContentDialog._helpContentPanel;
    }

    static ModalContentWindowAdapter ra$_windowAdapter(ModalHelpContentDialog modalHelpContentDialog) {
        return modalHelpContentDialog._windowAdapter;
    }

    final class 1
    implements ActionListener {
        private final /* synthetic */ Window v$win;
        final /* synthetic */ ModalHelpContentDialog this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (ModalHelpContentDialog.ra$_helpContentPanel(this.this$0).getActiveContextMenu() != null) {
                ContextMenu activeMenu = ModalHelpContentDialog.ra$_helpContentPanel(this.this$0).getActiveContextMenu();
                Container container = activeMenu.getGUI(false);
                container.setVisible(false);
            } else {
                this.this$0.setVisible(false);
                WindowEvent winEvent = new WindowEvent(this.v$win, 201);
                ModalHelpContentDialog.ra$_windowAdapter(this.this$0).windowClosing(winEvent);
            }
        }

        public 1(ModalHelpContentDialog modalHelpContentDialog, Window window) {
            this.v$win = window;
            this.this$0 = modalHelpContentDialog;
        }
    }

    private static class ModalContentWindowAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            ModalHelpContentDialog dialog = (ModalHelpContentDialog)e.getWindow();
            dialog.cleanup(true);
        }

        public void windowClosed(WindowEvent e) {
            ModalHelpContentDialog dialog = (ModalHelpContentDialog)e.getWindow();
            dialog.cleanup(false);
        }

        private ModalContentWindowAdapter() {
        }

        ModalContentWindowAdapter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

