/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.controls.ButtonKeyController;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpOptions;
import org.jdesktop.animation.timing.TimingController;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.interpolation.ObjectModifier;
import org.jdesktop.animation.timing.interpolation.PropertyRange;

class SearchOptionsPanel
extends JPanel {
    private JCheckBox _matchCase;
    private JRadioButton _allWords;
    private JRadioButton _anyWords;
    private JRadioButton _booleanExpression;
    private JLayeredPane _layeredPane;
    private JCheckBox _includeLocal;
    private JCheckBox _includeOTN;
    private JLabel _tahitiLabel;
    private JCheckBox _includeFusionMiddleware;
    private JCheckBox _includeDatabase;
    private static SearchOptionsPanel _panel;

    private SearchOptionsPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(Color.WHITE);
        this._includeLocal = new JCheckBox();
        this.labelButton(this._includeLocal, HelpArb.getString(89));
        this._matchCase = new JCheckBox();
        this.labelButton(this._matchCase, HelpArb.getString(14));
        this._matchCase.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 5));
        this._allWords = new JRadioButton();
        this.labelButton(this._allWords, HelpArb.getString(4));
        this._allWords.setBorder(BorderFactory.createEmptyBorder(7, 10, 2, 5));
        this._anyWords = new JRadioButton();
        this.labelButton(this._anyWords, HelpArb.getString(56));
        this._anyWords.setBorder(BorderFactory.createEmptyBorder(5, 10, 2, 5));
        this._booleanExpression = new JRadioButton();
        this.labelButton(this._booleanExpression, HelpArb.getString(70));
        this._booleanExpression.setBorder(BorderFactory.createEmptyBorder(5, 10, 7, 5));
        ButtonGroup rbg = new ButtonGroup();
        rbg.add(this._allWords);
        rbg.add(this._anyWords);
        rbg.add(this._booleanExpression);
        this._includeOTN = new JCheckBox();
        this.labelButton(this._includeOTN, HelpArb.getString(35));
        this._includeOTN.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 5));
        this._tahitiLabel = new JLabel(StringUtils.stripMnemonic((String)HelpArb.getString(0)));
        this._includeFusionMiddleware = new JCheckBox();
        this.labelButton(this._includeFusionMiddleware, HelpArb.getString(118));
        this._includeFusionMiddleware.setBorder(BorderFactory.createEmptyBorder(4, 10, 0, 0));
        this._includeDatabase = new JCheckBox();
        this.labelButton(this._includeDatabase, HelpArb.getString(150));
        this._includeDatabase.setBorder(BorderFactory.createEmptyBorder(4, 10, 0, 0));
        this.add(this._includeLocal);
        this.add(this._matchCase);
        this.add(this._allWords);
        this.add(this._anyWords);
        this.add(this._booleanExpression);
        this.add(this._includeOTN);
        this.add(this._tahitiLabel);
        this.add(this._includeFusionMiddleware);
        this.add(this._includeDatabase);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        ButtonKeyController.attach((AbstractButton[])new AbstractButton[]{this._matchCase, this._allWords, this._anyWords, this._booleanExpression, this._includeOTN, this._includeFusionMiddleware, this._includeDatabase});
        this.loadOptions();
        FocusLossListener focusLossListener = new FocusLossListener(null);
        this._includeLocal.addFocusListener(focusLossListener);
        this._matchCase.addFocusListener(focusLossListener);
        this._allWords.addFocusListener(focusLossListener);
        this._anyWords.addFocusListener(focusLossListener);
        this._booleanExpression.addFocusListener(focusLossListener);
        this._includeOTN.addFocusListener(focusLossListener);
        this._tahitiLabel.addFocusListener(focusLossListener);
        this._includeFusionMiddleware.addFocusListener(focusLossListener);
        this._includeDatabase.addFocusListener(focusLossListener);
    }

    public static SearchOptionsPanel getSearchOptionsPanel() {
        if (_panel == null) {
            _panel = new SearchOptionsPanel();
        }
        return _panel;
    }

    void show(Component reference, int x, int y) {
        JRootPane rootPane = SwingUtilities.getRootPane(reference);
        if (rootPane != null) {
            this._layeredPane = rootPane.getLayeredPane();
            this._layeredPane.add((Component)this, JLayeredPane.PALETTE_LAYER);
            this.setVisible(true);
            Dimension preferredSize = this.getPreferredSize();
            Point point = SwingUtilities.convertPoint(reference, x, y, this._layeredPane);
            if (point.x + preferredSize.width > this._layeredPane.getWidth()) {
                point.x = Math.max(0, this._layeredPane.getWidth() - preferredSize.width);
            }
            this.setLocation(point);
            Dimension from = new Dimension(preferredSize.width, 0);
            Dimension to = new Dimension(preferredSize.width, preferredSize.height);
            PropertyRange range = PropertyRange.createPropertyRangeDimension((String)"size", (Dimension[])new Dimension[]{from, to});
            ObjectModifier modifier = new ObjectModifier((Object)this, range);
            1 controller = new 1(100, (TimingTarget)modifier);
            controller.start();
        }
    }

    void dismiss() {
        if (this._layeredPane != null) {
            this.setVisible(false);
            this._layeredPane.remove(this);
        }
        this._layeredPane = null;
    }

    private void labelButton(AbstractButton button, String label) {
        ResourceUtils.resButton((AbstractButton)button, (String)label);
        button.setOpaque(false);
    }

    private void loadOptions() {
        HelpOptions helpOptions = HelpOptions.getInstance();
        this._includeLocal.setSelected(helpOptions.includeLocal());
        this._matchCase.setSelected(helpOptions.getLocalCaseSensitiveSearch());
        switch (helpOptions.getLocalSearchType()) {
            case 0: {
                this._allWords.setSelected(true);
                break;
            }
            case 1: {
                this._anyWords.setSelected(true);
                break;
            }
            case 2: {
                this._booleanExpression.setSelected(true);
                break;
            }
        }
        this._includeOTN.setSelected(helpOptions.includeOTN());
        this._includeFusionMiddleware.setSelected(helpOptions.includeFusionMiddleware());
        this._includeDatabase.setSelected(helpOptions.includeFusionMiddleware());
    }

    void saveOptions() {
        HelpOptions helpOptions = HelpOptions.getInstance();
        helpOptions.setIncludeLocal(this._includeLocal.isSelected());
        helpOptions.setLocalCaseSensitiveSearch(this._matchCase.isSelected());
        int searchType = 0;
        searchType = this._allWords.isSelected() ? 0 : (this._anyWords.isSelected() ? 1 : 2);
        helpOptions.setLocalSearchType(searchType);
        helpOptions.setIncludeOTN(this._includeOTN.isSelected());
        helpOptions.setIncludeFusionMiddleware(this._includeFusionMiddleware.isSelected());
        helpOptions.setIncludeDatabase(this._includeDatabase.isSelected());
    }

    static JCheckBox ra$_matchCase(SearchOptionsPanel searchOptionsPanel) {
        return searchOptionsPanel._matchCase;
    }

    static JRadioButton ra$_allWords(SearchOptionsPanel searchOptionsPanel) {
        return searchOptionsPanel._allWords;
    }

    static JRadioButton ra$_anyWords(SearchOptionsPanel searchOptionsPanel) {
        return searchOptionsPanel._anyWords;
    }

    static JRadioButton ra$_booleanExpression(SearchOptionsPanel searchOptionsPanel) {
        return searchOptionsPanel._booleanExpression;
    }

    static JCheckBox ra$_includeLocal(SearchOptionsPanel searchOptionsPanel) {
        return searchOptionsPanel._includeLocal;
    }

    static JCheckBox ra$_includeOTN(SearchOptionsPanel searchOptionsPanel) {
        return searchOptionsPanel._includeOTN;
    }

    static JLabel ra$_tahitiLabel(SearchOptionsPanel searchOptionsPanel) {
        return searchOptionsPanel._tahitiLabel;
    }

    static JCheckBox ra$_includeFusionMiddleware(SearchOptionsPanel searchOptionsPanel) {
        return searchOptionsPanel._includeFusionMiddleware;
    }

    static JCheckBox ra$_includeDatabase(SearchOptionsPanel searchOptionsPanel) {
        return searchOptionsPanel._includeDatabase;
    }

    final class 1
    extends TimingController {
        public void timingEvent(long l, long l1, float v) {
            super.timingEvent(l, l1, v);
            SearchOptionsPanel.this.revalidate();
            SearchOptionsPanel.this.repaint();
        }

        public void end() {
            KeyboardFocusManager currentKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            FocusTraversalPolicy focusTraversalPolicy = currentKeyboardFocusManager.getDefaultFocusTraversalPolicy();
            Component firstComponent = focusTraversalPolicy.getFirstComponent(SearchOptionsPanel.this);
            if (firstComponent != null) {
                firstComponent.requestFocus();
            }
        }

        public 1(int n, TimingTarget timingTarget) {
            super(n, timingTarget);
        }
    }

    private class FocusLossListener
    extends FocusAdapter {
        public void focusLost(FocusEvent e) {
            if (!(SearchOptionsPanel.ra$_matchCase(SearchOptionsPanel.this).hasFocus() || SearchOptionsPanel.ra$_allWords(SearchOptionsPanel.this).hasFocus() || SearchOptionsPanel.ra$_anyWords(SearchOptionsPanel.this).hasFocus() || SearchOptionsPanel.ra$_booleanExpression(SearchOptionsPanel.this).hasFocus() || SearchOptionsPanel.ra$_includeLocal(SearchOptionsPanel.this).hasFocus() || SearchOptionsPanel.ra$_includeOTN(SearchOptionsPanel.this).hasFocus() || SearchOptionsPanel.ra$_tahitiLabel(SearchOptionsPanel.this).hasFocus() || SearchOptionsPanel.ra$_includeFusionMiddleware(SearchOptionsPanel.this).hasFocus() || SearchOptionsPanel.ra$_includeDatabase(SearchOptionsPanel.this).hasFocus() || e.getOppositeComponent() == SearchOptionsPanel.ra$_matchCase(SearchOptionsPanel.this) || e.getOppositeComponent() == SearchOptionsPanel.ra$_allWords(SearchOptionsPanel.this) || e.getOppositeComponent() == SearchOptionsPanel.ra$_anyWords(SearchOptionsPanel.this) || e.getOppositeComponent() == SearchOptionsPanel.ra$_booleanExpression(SearchOptionsPanel.this) || e.getOppositeComponent() == SearchOptionsPanel.ra$_includeLocal(SearchOptionsPanel.this) || e.getOppositeComponent() == SearchOptionsPanel.ra$_includeOTN(SearchOptionsPanel.this) || e.getOppositeComponent() == SearchOptionsPanel.ra$_tahitiLabel(SearchOptionsPanel.this) || e.getOppositeComponent() == SearchOptionsPanel.ra$_includeFusionMiddleware(SearchOptionsPanel.this) || e.getOppositeComponent() == SearchOptionsPanel.ra$_includeDatabase(SearchOptionsPanel.this))) {
                SearchOptionsPanel.this.saveOptions();
                SearchOptionsPanel.this.dismiss();
            }
        }

        private FocusLossListener() {
        }

        FocusLossListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

